/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.interpreter;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkCredentialsBuilder;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import com.intellij.remote.RemoteSdkCredentialsProducer;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.remote.RemoteSdkPropertiesHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.remote.ext.LanguageCaseCollector;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterDecorator;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.remote.PhpRemoteProcessManager;
import com.jetbrains.php.remote.interpreter.PhpRemoteInterpreterDecorator;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkTypeData;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.settingsSummary.util.PhpCredentialsContribution;
import com.jetbrains.plugins.remotesdk.RemoteSdkCredentialsProducerImpl;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import java.util.Objects;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoteSdkAdditionalData
extends PhpSdkAdditionalData
implements RemoteSdkAdditionalData<RemoteSdkCredentials> {
    private static final Condition<PhpSdkAdditionalData> ourRemoteSdkFilter = data -> data instanceof PhpRemoteSdkAdditionalData;
    private static final String NAME_PREFIX = "Remote ";
    private static final String REMOTE_INTERPRETER = "Remote interpreter path";
    private static final String HELPERS_DIR = ".phpstorm_helpers";
    private final RemoteConnectionCredentialsWrapper myRemoteConnectionCredentialsWrapper;
    private final RemoteSdkPropertiesHolder myRemoteSdkProperties;
    private PhpRemoteSdkTypeData myTypeData;
    private boolean myInitialized;

    public PhpRemoteSdkAdditionalData() {
        this.myRemoteConnectionCredentialsWrapper = new RemoteConnectionCredentialsWrapper();
        this.myRemoteSdkProperties = new RemoteSdkPropertiesHolder(HELPERS_DIR);
        this.myTypeData = null;
    }

    public PhpRemoteSdkAdditionalData(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(0);
        }
        this.myRemoteConnectionCredentialsWrapper = new RemoteConnectionCredentialsWrapper();
        this.myRemoteSdkProperties = new RemoteSdkPropertiesHolder(HELPERS_DIR);
        this.myTypeData = null;
        this.setInterpreterPath(interpreterPath);
    }

    private RemoteSdkCredentialsProducer<RemoteSdkCredentials> getProducer() {
        PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
        if (manager == null) {
            throw new IllegalStateException(PhpRemoteInterpreterManager.getRemoteInterpreterPluginIsDisabledErrorMessage());
        }
        return new RemoteSdkCredentialsProducerImpl(credentials -> this.createPhpRemoteSdkCredentials((RemoteCredentials)credentials), this.myRemoteConnectionCredentialsWrapper, true);
    }

    @NotNull
    public static Condition<PhpSdkAdditionalData> getRemoteSdkFilter() {
        Condition<PhpSdkAdditionalData> condition = ourRemoteSdkFilter;
        if (condition == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(1);
        }
        return condition;
    }

    public RemoteConnectionCredentialsWrapper connectionCredentials() {
        return this.myRemoteConnectionCredentialsWrapper;
    }

    public <C> void setCredentials(Key<C> key, C credentials) {
        this.myRemoteConnectionCredentialsWrapper.setCredentials(key, credentials);
    }

    public CredentialsType getRemoteConnectionType() {
        return this.myRemoteConnectionCredentialsWrapper.getRemoteConnectionType();
    }

    public void switchOnConnectionType(CredentialsCase ... cases) {
        this.myRemoteConnectionCredentialsWrapper.switchType(cases);
    }

    @NotNull
    public String getRemoteConnectionPresentableName() {
        final Ref result = Ref.create();
        this.switchOnConnectionType(new LanguageCaseCollector<PhpCredentialsContribution>(){

            protected void processLanguageContribution(PhpCredentialsContribution languageContribution, Object credentials) {
                result.set((Object)languageContribution.getConnectionPresentableName(credentials));
            }
        }.collectCases(PhpCredentialsContribution.class, new CredentialsCase[0]));
        String string = (String)result.get();
        if (string == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(2);
        }
        return string;
    }

    private RemoteSdkCredentials createPhpRemoteSdkCredentials(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(3);
        }
        RemoteSdkCredentialsHolder res = new RemoteSdkCredentialsHolder(HELPERS_DIR);
        RemoteSdkCredentialsBuilder.copyCredentials((RemoteCredentials)credentials, (MutableRemoteCredentials)res);
        this.myRemoteSdkProperties.copyTo((RemoteSdkProperties)res);
        res.setInitialized(this.isInitialized());
        res.setValid(this.isValid());
        res.setSdkId(this.getSdkId());
        return res;
    }

    @Nullable
    public String getPathToExecutable(String homePath) {
        return this.getInterpreterPath();
    }

    @NotNull
    public String suggestName(final @Nullable PhpInfo phpInfo) {
        final Ref result = Ref.create();
        this.switchOnConnectionType(new LanguageCaseCollector<PhpCredentialsContribution>(){

            protected void processLanguageContribution(PhpCredentialsContribution languageContribution, Object credentials) {
                result.set((Object)languageContribution.suggestName(credentials, phpInfo));
            }
        }.collectCases(PhpCredentialsContribution.class, new CredentialsCase[0]));
        if (!result.isNull()) {
            String string = (String)result.get();
            if (string == null) {
                PhpRemoteSdkAdditionalData.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = NAME_PREFIX + super.suggestName(phpInfo);
        if (string == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(5);
        }
        return string;
    }

    public String getInterpreterPath() {
        return this.myRemoteSdkProperties.getInterpreterPath();
    }

    public void setInterpreterPath(String interpreterPath) {
        this.myRemoteSdkProperties.setInterpreterPath(interpreterPath);
    }

    public String getHelpersPath() {
        return this.myRemoteSdkProperties.getHelpersPath();
    }

    public void setHelpersPath(String helpersPath) {
        this.myRemoteSdkProperties.setHelpersPath(helpersPath);
    }

    public String getDefaultHelpersName() {
        return this.myRemoteSdkProperties.getDefaultHelpersName();
    }

    @NotNull
    public PathMappingSettings getPathMappings() {
        PathMappingSettings pathMappingSettings = this.myRemoteSdkProperties.getPathMappings();
        if (pathMappingSettings == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(6);
        }
        return pathMappingSettings;
    }

    public void setPathMappings(@Nullable PathMappingSettings pathMappings) {
        this.myRemoteSdkProperties.setPathMappings(pathMappings);
    }

    @Nullable
    public PhpRemoteSdkTypeData getTypeData() {
        return this.myTypeData;
    }

    public void setTypeData(@Nullable PhpRemoteSdkTypeData typeData) {
        this.myTypeData = typeData;
    }

    public boolean isHelpersVersionChecked() {
        return this.myRemoteSdkProperties.isHelpersVersionChecked();
    }

    public void setHelpersVersionChecked(boolean helpersVersionChecked) {
        this.myRemoteSdkProperties.setHelpersVersionChecked(helpersVersionChecked);
    }

    public void setSdkId(String sdkId) {
        throw new IllegalStateException("sdkId in this class is constructed based on fields, so it can't be set");
    }

    public String getSdkId() {
        return PhpRemoteSdkAdditionalData.constructSdkID(this.myRemoteConnectionCredentialsWrapper, this.myRemoteSdkProperties);
    }

    private static String constructSdkID(@NotNull RemoteConnectionCredentialsWrapper remoteConnectionCredentialsWrapper, @NotNull RemoteSdkPropertiesHolder properties) {
        if (remoteConnectionCredentialsWrapper == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(7);
        }
        if (properties == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(8);
        }
        return remoteConnectionCredentialsWrapper.getId() + properties.getInterpreterPath();
    }

    @NotNull
    public String constructFullInterpreterPath(@NotNull String exePath) {
        if (exePath == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(9);
        }
        String string = this.myRemoteConnectionCredentialsWrapper.getId() + exePath;
        if (string == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    public void setInitialized(boolean initialized) {
        this.myInitialized = initialized;
    }

    public boolean isValid() {
        return this.myRemoteSdkProperties.isValid();
    }

    public void setValid(boolean valid) {
        this.myRemoteSdkProperties.setValid(valid);
    }

    public boolean isRunAsRootViaSudo() {
        return this.myRemoteSdkProperties.isRunAsRootViaSudo();
    }

    public void setRunAsRootViaSudo(boolean runAsRootViaSudo) {
        this.myRemoteSdkProperties.setRunAsRootViaSudo(runAsRootViaSudo);
    }

    @Deprecated
    public RemoteSdkCredentials getRemoteSdkCredentials() throws InterruptedException, ExecutionException {
        return this.getProducer().getRemoteSdkCredentials();
    }

    public RemoteSdkCredentials getRemoteSdkCredentials(@Nullable Project project, boolean allowSynchronousInteraction) throws InterruptedException, ExecutionException {
        return this.getProducer().getRemoteSdkCredentials(project, allowSynchronousInteraction);
    }

    public RemoteSdkCredentials getRemoteSdkCredentials(boolean allowSynchronousInteraction) throws InterruptedException, ExecutionException {
        return this.getProducer().getRemoteSdkCredentials(allowSynchronousInteraction);
    }

    public boolean connectionEquals(PhpRemoteSdkAdditionalData data) {
        return this.myRemoteConnectionCredentialsWrapper.equals((Object)data.myRemoteConnectionCredentialsWrapper);
    }

    public Object getRemoteSdkDataKey() {
        return this.myRemoteConnectionCredentialsWrapper.getConnectionKey();
    }

    public void produceRemoteSdkCredentials(Consumer<? super RemoteSdkCredentials> remoteSdkCredentialsConsumer) {
        this.getProducer().produceRemoteSdkCredentials(remoteSdkCredentialsConsumer);
    }

    public void produceRemoteSdkCredentials(boolean allowSynchronousInteraction, Consumer<? super RemoteSdkCredentials> remoteSdkCredentialsConsumer) {
        this.getProducer().produceRemoteSdkCredentials(allowSynchronousInteraction, remoteSdkCredentialsConsumer);
    }

    public void produceRemoteSdkCredentials(@Nullable Project project, boolean allowSynchronousInteraction, Consumer<? super RemoteSdkCredentials> remoteSdkCredentialsConsumer) {
        this.getProducer().produceRemoteSdkCredentials(project, allowSynchronousInteraction, remoteSdkCredentialsConsumer);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    @NlsContexts.DialogMessage
    public String validate(final @Nullable Project project, @Nullable JComponent parent) {
        final @Nls Ref error = new Ref(null);
        this.myRemoteConnectionCredentialsWrapper.switchType(new LanguageCaseCollector<PhpCredentialsContribution>(){

            protected void processLanguageContribution(PhpCredentialsContribution languageContribution, Object credentials) {
                error.set((Object)languageContribution.validate(project, credentials));
            }
        }.collectCases(PhpCredentialsContribution.class, new CredentialsCase[0]));
        if (StringUtil.isNotEmpty((String)((String)error.get()))) {
            return (String)error.get();
        }
        if (StringUtil.isEmpty((String)this.getInterpreterPath())) {
            return PhpBundle.message((String)"validation.value.is.not.specified.or.invalid", (Object[])new Object[]{REMOTE_INTERPRETER});
        }
        return super.validate(project, parent);
    }

    @NotNull
    public PhpInterpreterDecorator getDecorator() {
        PhpRemoteInterpreterDecorator phpRemoteInterpreterDecorator = PhpRemoteInterpreterDecorator.INSTANCE;
        if (phpRemoteInterpreterDecorator == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(11);
        }
        return phpRemoteInterpreterDecorator;
    }

    public void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(12);
        }
        super.save(rootElement);
        Element data = new Element("remote_data");
        this.myRemoteSdkProperties.save(data);
        PhpRemoteSdkAdditionalData.saveTypeData(this, data);
        rootElement.addContent(data);
        this.myRemoteConnectionCredentialsWrapper.save(data);
    }

    @NotNull
    public static PhpRemoteSdkAdditionalData loadRemote(@NotNull PhpInterpreter interpreter, @Nullable Element element, @Nullable Project project) {
        if (interpreter == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(13);
        }
        String path = interpreter.getHomePath();
        assert (path != null);
        PhpRemoteSdkAdditionalData data = new PhpRemoteSdkAdditionalData(RemoteSdkCredentialsHolder.getInterpreterPathFromFullPath((String)path));
        PhpRemoteSdkAdditionalData.load((PhpSdkAdditionalData)data, (Element)element);
        if (element != null) {
            Element child = element.getChild("remote_data");
            CredentialsManager.getInstance().loadCredentials(path, child, (RemoteSdkAdditionalData)data);
            CredentialsManager.updateOutdatedSdk((RemoteSdkAdditionalData)data, (Project)project);
            RemoteSdkUtil.fullyLoadCredentials((SdkAdditionalData)data, (Project)project);
            if (child != null) {
                data.myRemoteSdkProperties.load(child);
                data.myTypeData = PhpRemoteSdkAdditionalData.loadTypeData(data, child);
            }
        }
        PhpRemoteSdkAdditionalData phpRemoteSdkAdditionalData = data;
        if (phpRemoteSdkAdditionalData == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(14);
        }
        return phpRemoteSdkAdditionalData;
    }

    private static void saveTypeData(@NotNull PhpRemoteSdkAdditionalData data, @NotNull Element element) {
        if (data == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(15);
        }
        if (element == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(16);
        }
        try {
            Element type = PhpRemoteProcessManager.getInstance(data).saveDataType("type_data", data);
            if (type != null) {
                element.addContent(type);
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Nullable
    private static PhpRemoteSdkTypeData loadTypeData(@NotNull PhpRemoteSdkAdditionalData data, @NotNull Element element) {
        if (data == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(17);
        }
        if (element == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(18);
        }
        try {
            Element type = element.getChild("type_data");
            return PhpRemoteProcessManager.getInstance(data).loadDataType(data, type);
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    @NotNull
    public PhpRemoteSdkAdditionalData copy() {
        PhpRemoteSdkAdditionalData copy = new PhpRemoteSdkAdditionalData();
        this.copyToRemote(copy);
        PhpRemoteSdkAdditionalData phpRemoteSdkAdditionalData = copy;
        if (phpRemoteSdkAdditionalData == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(19);
        }
        return phpRemoteSdkAdditionalData;
    }

    public void copyToRemote(@NotNull PhpRemoteSdkAdditionalData copy) {
        if (copy == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(20);
        }
        this.copyTo(copy);
        copy.myInitialized = this.myInitialized;
        this.myRemoteSdkProperties.copyTo((RemoteSdkProperties)copy.myRemoteSdkProperties);
        copy.setCredentials(this.myRemoteConnectionCredentialsWrapper.getRemoteConnectionType().getCredentialsKey(), this.myRemoteConnectionCredentialsWrapper.getCredentials());
        copy.setTypeData(this.getTypeData());
    }

    public String toPresentablePath() {
        return "[" + this.myRemoteConnectionCredentialsWrapper.getId() + "]:" + this.myRemoteSdkProperties.getInterpreterPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PhpRemoteSdkAdditionalData data = (PhpRemoteSdkAdditionalData)((Object)o);
        return Objects.equals(this.myRemoteConnectionCredentialsWrapper, data.myRemoteConnectionCredentialsWrapper) && Objects.equals(this.myRemoteSdkProperties, data.myRemoteSdkProperties) && Objects.equals(this.myTypeData, data.myTypeData);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myRemoteConnectionCredentialsWrapper, this.myRemoteSdkProperties, this.myTypeData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/interpreter/PhpRemoteSdkAdditionalData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteConnectionCredentialsWrapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/interpreter/PhpRemoteSdkAdditionalData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSdkFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteConnectionPresentableName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMappings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "constructFullInterpreterPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecorator";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRemote";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 19: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPhpRemoteSdkCredentials";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "constructSdkID";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "constructFullInterpreterPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadRemote";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "saveTypeData";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadTypeData";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "copyToRemote";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

