/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.interpreter;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkFactoryImpl;
import com.intellij.remote.ui.CredentialsEditorProvider;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpretersConfigurable;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkType;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.phpInfo.PhpInfoUtil;
import com.jetbrains.php.remote.PhpRemoteTransfer;
import com.jetbrains.php.remote.interpreter.PhpRemoteInterpreterPathDetector;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.interpreter.ui.PhpCreateRemoteSdkForm;
import com.jetbrains.plugins.remotesdk.SshCredentialsUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoteInterpreterFactory
extends RemoteSdkFactoryImpl<PhpRemoteSdkAdditionalData> {
    private static final Logger LOG = Logger.getInstance(PhpRemoteInterpreterFactory.class);

    @Nullable
    protected String getSdkVersion(@Nullable Project project, @NotNull PhpRemoteSdkAdditionalData data) throws RemoteSdkException {
        if (data == null) {
            PhpRemoteInterpreterFactory.$$$reportNull$$$0(0);
        }
        return null;
    }

    @NotNull
    protected ProjectJdkImpl createSdk(@NotNull Collection<Sdk> existingSdks, @NotNull SdkType sdkType, @NotNull PhpRemoteSdkAdditionalData data, @Nullable String sdkName) {
        if (existingSdks == null) {
            PhpRemoteInterpreterFactory.$$$reportNull$$$0(1);
        }
        if (sdkType == null) {
            PhpRemoteInterpreterFactory.$$$reportNull$$$0(2);
        }
        if (data == null) {
            PhpRemoteInterpreterFactory.$$$reportNull$$$0(3);
        }
        ProjectJdkImpl projectJdkImpl = SdkConfigurationUtil.createSdk(existingSdks, (String)this.generateSdkHomePath(data), (SdkType)sdkType, (SdkAdditionalData)data, (String)sdkName);
        if (projectJdkImpl == null) {
            PhpRemoteInterpreterFactory.$$$reportNull$$$0(4);
        }
        return projectJdkImpl;
    }

    public String getDefaultUnfinishedName() {
        return PhpRemoteInterpreterFactory.getDefaultUnfinishedInterpreterName((String)this.sdkName());
    }

    @NotNull
    public String sdkName() {
        String string = PhpBundle.message((String)"PhpInterpreter.php.sdk.type", (Object[])new Object[0]);
        if (string == null) {
            PhpRemoteInterpreterFactory.$$$reportNull$$$0(5);
        }
        return string;
    }

    public String generateSdkHomePath(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteInterpreterFactory.$$$reportNull$$$0(6);
        }
        return data.constructFullInterpreterPath(data.getInterpreterPath());
    }

    @NotNull
    protected SdkType getSdkType(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteInterpreterFactory.$$$reportNull$$$0(7);
        }
        PhpSdkType phpSdkType = PhpSdkType.getInstance();
        if (phpSdkType == null) {
            PhpRemoteInterpreterFactory.$$$reportNull$$$0(8);
        }
        return phpSdkType;
    }

    public boolean canSaveUnfinished() {
        return true;
    }

    @NotNull
    protected String getSdkName(@NotNull PhpRemoteSdkAdditionalData data, @Nullable String version) {
        if (data == null) {
            PhpRemoteInterpreterFactory.$$$reportNull$$$0(9);
        }
        if (version == null) {
            version = " unknown interpreter";
        }
        String string = "Remote " + version + "(" + data.getSdkId() + ")";
        if (string == null) {
            PhpRemoteInterpreterFactory.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void initSdk(@NotNull Sdk sdk, @Nullable Project project, @Nullable Component ownerComponent) {
        if (sdk == null) {
            PhpRemoteInterpreterFactory.$$$reportNull$$$0(11);
        }
        PhpRemoteSdkAdditionalData remoteSdkData = (PhpRemoteSdkAdditionalData)sdk.getSdkAdditionalData();
        assert (remoteSdkData != null);
        PhpRemoteInterpreterFactory.initSdkPath(project, remoteSdkData);
        PhpRemoteInterpreterFactory.initHelpers(project, ownerComponent, remoteSdkData);
    }

    private static void initHelpers(@Nullable Project project, @Nullable Component ownerComponent, @NotNull PhpRemoteSdkAdditionalData remoteSdkData) {
        if (remoteSdkData == null) {
            PhpRemoteInterpreterFactory.$$$reportNull$$$0(12);
        }
        if (SshCredentialsUtil.producesSshSdkCredentials((RemoteSdkAdditionalData)remoteSdkData)) {
            try {
                RemoteSdkCredentials remoteSdkCredentials = remoteSdkData.getRemoteSdkCredentials(project, true);
                PhpRemoteTransfer transfer = new PhpRemoteTransfer(project, ownerComponent, remoteSdkCredentials);
                transfer.setTransferTaskModal(true);
                transfer.uploadHelpers();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static void initSdkPath(@Nullable Project project, @NotNull PhpRemoteSdkAdditionalData remoteSdkData) {
        boolean isValid;
        if (remoteSdkData == null) {
            PhpRemoteInterpreterFactory.$$$reportNull$$$0(13);
        }
        if (project != null && PhpRemoteInterpreterFactory.isDefaultPathToPhp(remoteSdkData) && !(isValid = PhpRemoteInterpreterFactory.isPhpExecutableValid(project, remoteSdkData))) {
            PhpRemoteInterpreterPathDetector detector = new PhpRemoteInterpreterPathDetector(project, null);
            try {
                remoteSdkData.setInterpreterPath(detector.findInterpreterPath(remoteSdkData));
            }
            catch (ExecutionException | InterruptedException e) {
                LOG.warn("Failed detecting path to PHP for new interpreter");
            }
        }
    }

    private static boolean isPhpExecutableValid(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData data) {
        if (project == null) {
            PhpRemoteInterpreterFactory.$$$reportNull$$$0(14);
        }
        if (data == null) {
            PhpRemoteInterpreterFactory.$$$reportNull$$$0(15);
        }
        try {
            PhpInfo phpInfo = PhpInfoUtil.getPhpInfo((Project)project, (String)data.getInterpreterPath(), (PhpSdkAdditionalData)data, Collections.emptyList(), null);
            PhpInterpretersPhpInfoCacheImpl.getInstance((Project)project).setPhpInfo(PhpInterpretersConfigurable.INTERPRETER_INITIALIZATION_NAME, phpInfo);
            return true;
        }
        catch (ExecutionException | InterruptedException e) {
            return false;
        }
    }

    private static boolean isDefaultPathToPhp(@NotNull PhpRemoteSdkAdditionalData data) {
        CredentialsEditorProvider editorProvider;
        if (data == null) {
            PhpRemoteInterpreterFactory.$$$reportNull$$$0(16);
        }
        String defaultPath = (editorProvider = (CredentialsEditorProvider)ObjectUtils.tryCast((Object)data.getRemoteConnectionType(), CredentialsEditorProvider.class)) != null ? editorProvider.getDefaultInterpreterPath(PhpCreateRemoteSdkForm.BUNDLE_ACCESSOR) : null;
        return StringUtil.isNotEmpty((String)defaultPath) && StringUtil.equals((CharSequence)defaultPath, (CharSequence)data.getInterpreterPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/interpreter/PhpRemoteInterpreterFactory";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSdkData";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/interpreter/PhpRemoteInterpreterFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSdk";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sdkName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSdkVersion";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSdk";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateSdkHomePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSdkType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSdkName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "initSdk";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "initHelpers";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "initSdkPath";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isPhpExecutableValid";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultPathToPhp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

