/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteConnectionType;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkCredentialsBuilder;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import com.intellij.util.Consumer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.remote.PhpRemoteSdkConnector;
import com.jetbrains.plugins.remotesdk.SshConnectionProvider;
import com.jetbrains.plugins.remotesdk.console.RemoteDataProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSshConnectionProvider
implements SshConnectionProvider {
    private static String getId(RemoteSdkCredentials data) {
        return data.getFullInterpreterPath();
    }

    @NotNull
    public Collection<? extends RemoteConnector> collectRemoteConnectors() {
        List<RemoteConnector> list = PhpSshConnectionProvider.collectRemoteInterpreters();
        if (list == null) {
            PhpSshConnectionProvider.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static List<RemoteConnector> collectRemoteInterpreters() {
        ArrayList<RemoteConnector> result = new ArrayList<RemoteConnector>();
        for (PhpInterpreter interpreter : PhpSshConnectionProvider.getAllInterpreters()) {
            PhpSdkAdditionalData additionalData = interpreter.getPhpSdkAdditionalData();
            if (!(additionalData instanceof RemoteSdkCredentials)) continue;
            result.add(new RemoteInterpreterConnector((RemoteSdkCredentials)additionalData));
        }
        return result;
    }

    @NotNull
    private static List<PhpInterpreter> getAllInterpreters() {
        ArrayList<PhpInterpreter> result = new ArrayList<PhpInterpreter>();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            PhpInterpretersManagerImpl.getInstance((Project)project).getInterpreters().forEach(interpreter -> {
                if (interpreter.isProjectLevel()) {
                    result.add((PhpInterpreter)interpreter);
                }
            });
        }
        PhpInterpretersManagerImpl.getInstance(null).getInterpreters().forEach(interpreter -> {
            if (!interpreter.isProjectLevel()) {
                result.add((PhpInterpreter)interpreter);
            }
        });
        ArrayList<PhpInterpreter> arrayList = result;
        if (arrayList == null) {
            PhpSshConnectionProvider.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    public RemoteConnector getRemoteConnector(RemoteConnectionType type, @Nullable String id, Project project, Module module) {
        if (type == RemoteConnectionType.DEFAULT_SDK && project != null) {
            PhpSdkAdditionalData data;
            PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance((Project)project).getInterpreter();
            PhpSdkAdditionalData phpSdkAdditionalData = data = interpreter != null ? interpreter.getPhpSdkAdditionalData() : null;
            if (data instanceof RemoteSdkCredentials) {
                return new PhpRemoteSdkConnector((RemoteSdkCredentials)data);
            }
            if (data != null) {
                String warning = PhpBundle.message((String)"remote.connection.settings.interpreter.is.not.remote", (Object[])new Object[0]);
                Messages.showWarningDialog((Project)project, (String)warning, (String)((String)RemoteDataProducer.NO_HOST_TO_CONNECT_SUPPLIER.get()));
            }
        } else if (type == RemoteConnectionType.REMOTE_SDK) {
            for (PhpInterpreter interpreter : PhpSshConnectionProvider.getAllInterpreters()) {
                PhpSdkAdditionalData data = interpreter.getPhpSdkAdditionalData();
                if (!(data instanceof RemoteSdkCredentials) || !StringUtil.equals((CharSequence)id, (CharSequence)PhpSshConnectionProvider.getId((RemoteSdkCredentials)data))) continue;
                return new RemoteInterpreterConnector((RemoteSdkCredentials)data);
            }
        }
        return null;
    }

    @Nls
    @NotNull
    public String getRadioButtonDescription() {
        String string = PhpBundle.message((String)"remote.connection.settings.default.remote.interpreter", (Object[])new Object[0]);
        if (string == null) {
            PhpSshConnectionProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public RemoteConnectionType getTypeForConfigurable() {
        RemoteConnectionType remoteConnectionType = RemoteConnectionType.DEFAULT_SDK;
        if (remoteConnectionType == null) {
            PhpSshConnectionProvider.$$$reportNull$$$0(3);
        }
        return remoteConnectionType;
    }

    @Nullable
    @Nls
    public String getSettingCreationDescription() {
        return PhpRemoteSdkBundle.message("add.php.remote.interpreter", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/remote/PhpSshConnectionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRemoteConnectors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInterpreters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRadioButtonDescription";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeForConfigurable";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class RemoteInterpreterConnector
    implements RemoteConnector {
        private final RemoteSdkCredentials myRemoteData = new RemoteSdkCredentialsHolder("");

        RemoteInterpreterConnector(RemoteSdkCredentials data) {
            RemoteSdkCredentialsBuilder.copyRemoteSdkCredentials((RemoteSdkCredentials)data, (RemoteSdkCredentials)this.myRemoteData);
        }

        public String getId() {
            return PhpSshConnectionProvider.getId(this.myRemoteData);
        }

        @NlsSafe
        @NotNull
        public String getName() {
            String string = this.myRemoteData.getHost() + ":" + this.myRemoteData.getPort() + " (Remote interpreter)";
            if (string == null) {
                RemoteInterpreterConnector.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public RemoteConnectionType getType() {
            RemoteConnectionType remoteConnectionType = RemoteConnectionType.REMOTE_SDK;
            if (remoteConnectionType == null) {
                RemoteInterpreterConnector.$$$reportNull$$$0(1);
            }
            return remoteConnectionType;
        }

        public void produceRemoteCredentials(Consumer<? super RemoteCredentials> remoteCredentialsConsumer) {
            remoteCredentialsConsumer.consume((Object)this.myRemoteData);
        }

        @NonNls
        @NotNull
        public Object getConnectorKey() {
            String string = this.myRemoteData.getHost() + ":" + this.myRemoteData.getPort();
            if (string == null) {
                RemoteInterpreterConnector.$$$reportNull$$$0(2);
            }
            return string;
        }

        public String toString() {
            return this.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/php/remote/PhpSshConnectionProvider$RemoteInterpreterConnector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConnectorKey";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

