/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.remote.PhpHelperScriptProvider;
import com.jetbrains.php.remote.PhpRemoteFileTransferTask;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.CredentialsDeployable;
import com.jetbrains.plugins.remotesdk.RemoteTransfer;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.remoteEdit.EditRemoteFileAction;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import one.util.streamex.StreamEx;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpRemoteTransfer
extends RemoteTransfer {
    private static final Logger LOG = Logger.getInstance(PhpRemoteTransfer.class);
    private static final ExecutorService myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)"PHP remote transfer");
    private static final String PHPSTORM_HELPERS = "phpstorm-helpers";

    public PhpRemoteTransfer(@Nullable Project project, @Nullable Component component, @NotNull RemoteSdkCredentials data) {
        if (data == null) {
            PhpRemoteTransfer.$$$reportNull$$$0(0);
        }
        super(project, component, data);
    }

    public void editRemoteFile(final @NotNull String webServerName, final @NotNull String remoteFilePath) throws com.intellij.execution.ExecutionException {
        Project project;
        if (webServerName == null) {
            PhpRemoteTransfer.$$$reportNull$$$0(1);
        }
        if (remoteFilePath == null) {
            PhpRemoteTransfer.$$$reportNull$$$0(2);
        }
        if ((project = this.getProject()) == null || project.isDisposed()) {
            throw new com.intellij.execution.ExecutionException(PhpRemoteSdkBundle.message("remote.interpreter.transfer.task.project.is.not.defined", new Object[0]));
        }
        final CredentialsDeployable deployable = this.createWebServer("EditRemoteFile");
        deployable.setName(webServerName);
        final String title = PhpRemoteSdkBundle.message("remote.interpreter.transfer.task.open.connection.title", new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Modal(project, title, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    RemoteConnection connection = PhpRemoteTransfer.this.openConnection(title, (Deployable)deployable, indicator);
                    RemoteTransfer.RemoteSdkExecutionContext context = PhpRemoteTransfer.this.getRemoteSdkExecutionContext(indicator, connection, (Deployable)deployable);
                    FileObject remoteFile = context.findRemoteFile(new WebServerConfig.RemotePath(remoteFilePath), true);
                    if (remoteFile == null) {
                        LOG.error(PhpRemoteSdkBundle.message("remote.interpreter.transfer.task.can.not.find.file", remoteFilePath));
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(() -> EditRemoteFileAction.editRemoteFile((Deployable)deployable, (Project)project, (FileObject)remoteFile, (RemoteConnection)connection, (String)webServerName));
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/remote/PhpRemoteTransfer$1", "run"));
            }
        });
    }

    public String createFile(@NotNull String remoteRelativePath, final @NotNull String fileContent, int timeout) throws com.intellij.execution.ExecutionException {
        Project project;
        if (remoteRelativePath == null) {
            PhpRemoteTransfer.$$$reportNull$$$0(3);
        }
        if (fileContent == null) {
            PhpRemoteTransfer.$$$reportNull$$$0(4);
        }
        if ((project = this.getProject()) == null || project.isDisposed()) {
            throw new com.intellij.execution.ExecutionException(PhpRemoteSdkBundle.message("remote.interpreter.transfer.task.project.is.not.defined", new Object[0]));
        }
        String helpersPath = this.getHelpersTransferConfig().getHelpersPath();
        if (StringUtil.isEmpty((String)helpersPath)) {
            throw new com.intellij.execution.ExecutionException(PhpRemoteSdkBundle.message("remote.interpreter.transfer.interpreter.is.not.initialized", new Object[0]));
        }
        final String targetPath = helpersPath + "/" + remoteRelativePath;
        final CredentialsDeployable deployable = this.createWebServer();
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        Ref exceptionRef = new Ref(null);
        try {
            myExecutorService.submit(() -> {
                try {
                    String title = PhpRemoteSdkBundle.message("remote.interpreter.uploading.files.title", new Object[0]);
                    new PhpRemoteFileTransferTask(project, (Deployable)deployable, publishConfig, title, timeout, true){

                        @Override
                        protected TransferOperation createTransferOperation(@NotNull ExecutionContext context, @NotNull RemoteConnection connection) throws FileSystemException {
                            if (context == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            if (connection == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            FileObject remoteFile = context.findRemoteFile(new WebServerConfig.RemotePath(targetPath), false);
                            return new TransferOperation.CreateRemoteFile(fileContent, remoteFile);
                        }

                        @Override
                        protected ExecutionContext createExecutionContext(@NotNull ExecutionContextBase context, @NotNull RemoteConnection connection) {
                            if (context == null) {
                                2.$$$reportNull$$$0(2);
                            }
                            if (connection == null) {
                                2.$$$reportNull$$$0(3);
                            }
                            return PhpRemoteTransfer.this.getRemoteSdkExecutionContext(context.getProgressIndicator(), connection, (Deployable)deployable);
                        }

                        @Override
                        @Nls
                        protected String defaultErrorMessage() {
                            return PhpRemoteSdkBundle.message("remote.interpreter.transfer.failed.to.upload.file", new Object[0]);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "context";
                                    break;
                                }
                                case 1: 
                                case 3: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "connection";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/jetbrains/php/remote/PhpRemoteTransfer$2";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "createTransferOperation";
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "createExecutionContext";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }.execute();
                }
                catch (com.intellij.execution.ExecutionException e) {
                    exceptionRef.set((Object)e);
                }
            }).get();
        }
        catch (InterruptedException e) {
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
        if (!exceptionRef.isNull()) {
            throw (com.intellij.execution.ExecutionException)((Object)exceptionRef.get());
        }
        return targetPath;
    }

    public void deleteFromRemote(final @NotNull String remotePath, final boolean isDirectory, int timeout) throws com.intellij.execution.ExecutionException {
        Project project;
        if (remotePath == null) {
            PhpRemoteTransfer.$$$reportNull$$$0(5);
        }
        if ((project = this.getProject()) == null || project.isDisposed()) {
            throw new com.intellij.execution.ExecutionException(PhpRemoteSdkBundle.message("remote.interpreter.transfer.task.project.is.not.defined", new Object[0]));
        }
        final CredentialsDeployable deployable = this.createWebServer();
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        Ref exceptionRef = new Ref(null);
        try {
            myExecutorService.submit(() -> {
                try {
                    String title = PhpRemoteSdkBundle.message("remote.interpreter.delete.files.title", new Object[0]);
                    new PhpRemoteFileTransferTask(project, (Deployable)deployable, publishConfig, title, timeout, true){

                        @Override
                        protected TransferOperation createTransferOperation(@NotNull ExecutionContext context, @NotNull RemoteConnection connection) {
                            if (context == null) {
                                3.$$$reportNull$$$0(0);
                            }
                            if (connection == null) {
                                3.$$$reportNull$$$0(1);
                            }
                            return new TransferOperation.Delete(new WebServerConfig.RemotePath(remotePath), isDirectory, false);
                        }

                        @Override
                        protected ExecutionContext createExecutionContext(@NotNull ExecutionContextBase context, @NotNull RemoteConnection connection) {
                            if (context == null) {
                                3.$$$reportNull$$$0(2);
                            }
                            if (connection == null) {
                                3.$$$reportNull$$$0(3);
                            }
                            RemoteTransfer.RemoteSdkExecutionContext overwrite = PhpRemoteTransfer.this.getRemoteSdkExecutionContext(context.getProgressIndicator(), connection, (Deployable)deployable);
                            overwrite.setPromptForOverwrite(true);
                            return overwrite;
                        }

                        @Override
                        @Nls
                        protected String defaultErrorMessage() {
                            return PhpRemoteSdkBundle.message("remote.interpreter.transfer.failed.to.delete.file", new Object[0]);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "context";
                                    break;
                                }
                                case 1: 
                                case 3: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "connection";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/jetbrains/php/remote/PhpRemoteTransfer$3";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "createTransferOperation";
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "createExecutionContext";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }.execute();
                }
                catch (com.intellij.execution.ExecutionException e) {
                    exceptionRef.set((Object)e);
                }
            }).get();
        }
        catch (InterruptedException e) {
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
        if (!exceptionRef.isNull()) {
            throw (com.intellij.execution.ExecutionException)((Object)exceptionRef.get());
        }
    }

    @NotNull
    private CredentialsDeployable createWebServer() {
        return this.createWebServer("PhpRemoteTransfer");
    }

    @NotNull
    private CredentialsDeployable createWebServer(@NotNull String prefixId) {
        if (prefixId == null) {
            PhpRemoteTransfer.$$$reportNull$$$0(6);
        }
        CredentialsDeployable deployable = new CredentialsDeployable();
        deployable.setId(prefixId + deployable);
        this.getHelpersTransferConfig().createFileTransferConfig(deployable);
        CredentialsDeployable credentialsDeployable = deployable;
        if (credentialsDeployable == null) {
            PhpRemoteTransfer.$$$reportNull$$$0(7);
        }
        return credentialsDeployable;
    }

    public void uploadHelpers(boolean uploadOnSnapshot) {
        try {
            VirtualFile root = PhpRemoteTransfer.getHelpersRoot();
            Set<String> localHelpersPath = Collections.singleton(root.getPath());
            String helpersPath = this.getHelpersTransferConfig().getHelpersPath();
            this.uploadHelpers(uploadOnSnapshot, localHelpersPath, helpersPath, PhpRemoteSdkBundle.message("remote.interpreter.cheking.helpers.version", new Object[0]));
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
    }

    @NotNull
    public static VirtualFile createLocalHelperScriptDir(@NotNull List<PhpHelperScriptProvider> scripts) throws IOException {
        String scriptsPath;
        if (scripts == null) {
            PhpRemoteTransfer.$$$reportNull$$$0(8);
        }
        if ((scriptsPath = System.getProperty("php.scripts.path")) != null) {
            String absoluteScriptsPath = new File(scriptsPath).getAbsolutePath();
            VirtualFile scriptsDirectory = LocalFileSystem.getInstance().findFileByPath(absoluteScriptsPath);
            LOG.assertTrue(scriptsDirectory != null);
            VirtualFile virtualFile = scriptsDirectory;
            if (virtualFile == null) {
                PhpRemoteTransfer.$$$reportNull$$$0(9);
            }
            return virtualFile;
        }
        return PhpRemoteTransfer.createLocalScriptDir(StreamEx.of(scripts).toFlatList(PhpHelperScriptProvider::getHelperScripts));
    }

    public static VirtualFile getHelpersRoot() throws IOException {
        return PhpRemoteTransfer.createLocalHelperScriptDir(PhpHelperScriptProvider.getInstances());
    }

    @NotNull
    public static VirtualFile createLocalScriptDir(@NotNull List<PhpHelperScriptProvider.PhpHelpersScript> scripts) throws IOException {
        if (scripts == null) {
            PhpRemoteTransfer.$$$reportNull$$$0(10);
        }
        Ref error = new Ref();
        Ref scriptVirtualFile = new Ref();
        Runnable runnable = () -> {
            VirtualFile tempDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.getTempDirectory());
            LOG.assertTrue(tempDir != null);
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    VirtualFile helpers = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.getTempDirectory() + File.separator + PHPSTORM_HELPERS);
                    int index = 0;
                    while (helpers != null && !helpers.isDirectory()) {
                        helpers = tempDir.findChild(PHPSTORM_HELPERS + ++index);
                    }
                    String helpersName = PHPSTORM_HELPERS + (Serializable)(index == 0 ? "" : Integer.valueOf(index));
                    if (helpers == null) {
                        helpers = tempDir.createChildDirectory(PhpRemoteTransfer.class, helpersName);
                    }
                    for (PhpHelperScriptProvider.PhpHelpersScript script : scripts) {
                        VirtualFile file = helpers.findOrCreateChildData(PhpRemoteTransfer.class, script.getName());
                        VfsUtil.saveText((VirtualFile)file, (String)script.loadText());
                    }
                    scriptVirtualFile.set((Object)helpers);
                }
                catch (IOException e) {
                    error.set((Object)e);
                }
            });
        };
        ApplicationManager.getApplication().invokeAndWait(runnable);
        if (!error.isNull()) {
            throw (IOException)error.get();
        }
        VirtualFile file = (VirtualFile)scriptVirtualFile.get();
        LOG.assertTrue(file != null);
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            PhpRemoteTransfer.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    public void downloadFromRemote(final @NotNull List<PathMappingSettings.PathMapping> mappings) {
        Project project;
        if (mappings == null) {
            PhpRemoteTransfer.$$$reportNull$$$0(12);
        }
        if ((project = this.getProject()) == null || project.isDisposed()) {
            LOG.warn("Can not download files from server: project is already disposed");
            return;
        }
        Task.Modal process = new Task.Modal(project, PhpRemoteSdkBundle.message("remote.interpreter.copy.remote.files.title", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                CredentialsDeployable deployable = new CredentialsDeployable();
                deployable.setId("CopyFromRemote" + deployable);
                PhpRemoteTransfer.this.getHelpersTransferConfig().createFileTransferConfig(deployable);
                try {
                    RemoteConnection connection = PhpRemoteTransfer.this.openConnection(this.myTitle, (Deployable)deployable, indicator);
                    RemoteTransfer.RemoteSdkExecutionContext context = PhpRemoteTransfer.this.getRemoteSdkExecutionContext(indicator, connection, (Deployable)deployable);
                    context.setServerSideModification(false);
                    ArrayList<TransferOperation.Copy> operations = new ArrayList<TransferOperation.Copy>();
                    for (PathMappingSettings.PathMapping pathMapping : mappings) {
                        FileObject source = connection.resolveFile(pathMapping.getRemoteRoot());
                        FileObject target = DeploymentPathUtils.getLocalFile((String)pathMapping.getLocalRoot());
                        operations.add(new TransferOperation.Copy(source, target));
                    }
                    for (TransferOperation transferOperation : operations) {
                        context.getProgressIndicator().checkCanceled();
                        context.getProgressIndicator().setText(transferOperation.getProgressText((ExecutionContext)context));
                        transferOperation.execute((ExecutionContext)context);
                    }
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                    PublishUtils.showLoginDialogAfterAuthFail((Throwable)e, (Deployable)deployable);
                }
                PhpRemoteTransfer.this.getHelpersTransferConfig().setHelpersVersionChecked(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/remote/PhpRemoteTransfer$4", "run"));
            }
        };
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            UIUtil.invokeAndWaitIfNeeded(() -> ProgressManager.getInstance().run((Task)process));
        } else {
            process.run(ProgressManager.getInstance().getProgressIndicator());
        }
    }

    public void uploadHelpers() {
        this.uploadHelpers(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webServerName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRelativePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixId";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/PhpRemoteTransfer";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scripts";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/PhpRemoteTransfer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createWebServer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalHelperScriptDir";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalScriptDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "editRemoteFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deleteFromRemote";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createWebServer";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createLocalHelperScriptDir";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLocalScriptDir";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "downloadFromRemote";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

