/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.interpreters.PhpSdkFileTransfer;
import com.jetbrains.php.config.interpreters.PhpSdkHelpersManager;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.debug.PhpDebugErrorDetector;
import com.jetbrains.php.phpunit.coverage.PhpCoverageResultManager;
import com.jetbrains.php.remote.PhpRemoteProcessManager;
import com.jetbrains.php.remote.PhpRemoteProcessRunner;
import com.jetbrains.php.remote.PhpRemoteSshFileTransfer;
import com.jetbrains.php.remote.PhpRemoteSshHelpersManager;
import com.jetbrains.php.remote.PhpRemoteSshProcessRunner;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.phpunit.coverage.PhpSshCoverageResultManager;
import com.jetbrains.plugins.remotesdk.SshCredentialsType;
import com.jetbrains.plugins.remotesdk.SshCredentialsUtil;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsType;
import com.jetbrains.plugins.remotesdk.WebDeploymentCredentialsType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoteSshProcessManager
extends PhpRemoteProcessManager {
    @Override
    public boolean accepts(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteSshProcessManager.$$$reportNull$$$0(0);
        }
        return SshCredentialsUtil.producesSshSdkCredentials((RemoteSdkAdditionalData)data);
    }

    @Override
    @NotNull
    public PhpRemoteProcessRunner getRemoteProcessRunner(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteSshProcessManager.$$$reportNull$$$0(1);
        }
        PhpRemoteProcessRunner phpRemoteProcessRunner = PhpRemoteSshProcessRunner.getInstance();
        if (phpRemoteProcessRunner == null) {
            PhpRemoteSshProcessManager.$$$reportNull$$$0(2);
        }
        return phpRemoteProcessRunner;
    }

    @Override
    @NotNull
    public PhpSdkHelpersManager getSdkHelpersManager(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteSshProcessManager.$$$reportNull$$$0(3);
        }
        return new PhpRemoteSshHelpersManager(data);
    }

    @Override
    @NotNull
    public PhpCoverageResultManager getCoverageResultManager(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteSshProcessManager.$$$reportNull$$$0(4);
        }
        return new PhpSshCoverageResultManager(data);
    }

    @Override
    @NotNull
    public PhpSdkFileTransfer getSdkFileTransfer(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteSshProcessManager.$$$reportNull$$$0(5);
        }
        return new PhpRemoteSshFileTransfer(data);
    }

    @Override
    @Nullable
    public PhpDebugErrorDetector newErrorDetector(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData data) {
        if (project == null) {
            PhpRemoteSshProcessManager.$$$reportNull$$$0(6);
        }
        if (data == null) {
            PhpRemoteSshProcessManager.$$$reportNull$$$0(7);
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, String> getSdkProperties(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteSshProcessManager.$$$reportNull$$$0(8);
        }
        final HashMap<String, String> keyToPattern = new HashMap<String, String>();
        data.switchOnConnectionType(new CredentialsCase<RemoteCredentialsHolder>(){

            public CredentialsType<RemoteCredentialsHolder> getType() {
                return SshCredentialsType.getInstance();
            }

            public void process(RemoteCredentialsHolder credentials) {
                ContainerUtil.putIfNotNull((Object)"host", (Object)StringUtil.nullize((String)credentials.getHost()), (Map)keyToPattern);
                ContainerUtil.putIfNotNull((Object)"username", (Object)StringUtil.nullize((String)credentials.getUserName()), (Map)keyToPattern);
            }
        }, CredentialsCase.create((CredentialsType)WebDeploymentCredentialsType.getInstance(), credentials -> ContainerUtil.putIfNotNull((Object)"server-name", (Object)StringUtil.nullize((String)credentials.getWebServerConfigName()), (Map)keyToPattern)), CredentialsCase.create((CredentialsType)VagrantCredentialsType.getInstance(), credentials -> {
            ContainerUtil.putIfNotNull((Object)"machine-name", (Object)StringUtil.nullize((String)credentials.getMachineName()), (Map)keyToPattern);
            String folder = credentials.getVagrantFolder();
            if (StringUtil.isNotEmpty((String)folder)) {
                ContainerUtil.putIfNotNull((Object)"folder", (Object)StringUtil.nullize((String)PathUtil.getFileName((String)folder)), (Map)keyToPattern);
            }
        }));
        HashMap<String, String> hashMap = keyToPattern;
        if (hashMap == null) {
            PhpRemoteSshProcessManager.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    @Override
    @NotNull
    public String getRemoteHost(@NotNull Project project, @NotNull String interpreterName, @NotNull PhpRemoteSdkAdditionalData data) {
        PhpInfo phpInfo;
        if (project == null) {
            PhpRemoteSshProcessManager.$$$reportNull$$$0(10);
        }
        if (interpreterName == null) {
            PhpRemoteSshProcessManager.$$$reportNull$$$0(11);
        }
        if (data == null) {
            PhpRemoteSshProcessManager.$$$reportNull$$$0(12);
        }
        String ssh = (phpInfo = PhpInterpretersPhpInfoCacheImpl.getInstance((Project)project).getPhpInfo(interpreterName)) == null ? null : phpInfo.getRemoteHost();
        return StringUtil.isNotEmpty((String)ssh) ? ssh : "127.0.0.1";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/PhpRemoteSshProcessManager";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/PhpRemoteSshProcessManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteProcessRunner";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteProcessRunner";
                break;
            }
            case 2: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSdkHelpersManager";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCoverageResultManager";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSdkFileTransfer";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newErrorDetector";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSdkProperties";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteHost";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

