/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.remote.PathMappingProvider;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteMappingsManager;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.util.AsyncProducer;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterComponent;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkFileTransfer;
import com.jetbrains.php.config.interpreters.PhpSdkHelpersManager;
import com.jetbrains.php.debug.PhpDebugErrorDetector;
import com.jetbrains.php.phpunit.coverage.PhpCoverageResultManager;
import com.jetbrains.php.remote.PhpRemoteCommandLinePathProcessor;
import com.jetbrains.php.remote.PhpRemoteCredentialsProducer;
import com.jetbrains.php.remote.PhpRemoteProcessManager;
import com.jetbrains.php.remote.PhpRemoteProcessRunner;
import com.jetbrains.php.remote.PhpRemoteTransfer;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.interpreter.ui.PhpCreateRemoteInterpreterDialog;
import com.jetbrains.php.remote.interpreter.ui.PhpRemoteInterpreterComponent;
import com.jetbrains.php.remote.tools.quality.QualityRemoteToolProcessHandler;
import com.jetbrains.php.run.deploymentAware.PhpRemoteBrowserUtil;
import com.jetbrains.php.run.remote.PhpInvalidSdkTypeException;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import com.jetbrains.php.tools.quality.QualityToolProcessHandler;
import com.jetbrains.plugins.remotesdk.CredentialsDeployable;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.SshCredentialsUtil;
import com.jetbrains.plugins.remotesdk.ui.RemoteBrowseActionListener;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoteInterpreterManagerImpl
extends PhpRemoteInterpreterManager {
    private static final Logger LOG = Logger.getInstance(PhpRemoteInterpreterManagerImpl.class);
    public static final String PHP_PREFIX = "php";

    @Nullable
    public PhpInterpreter addRemoteSdk(@NotNull Project project, @NotNull Supplier<PhpInterpreter> producer) {
        PhpCreateRemoteInterpreterDialog dialog;
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(0);
        }
        if (producer == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(1);
        }
        if ((dialog = new PhpCreateRemoteInterpreterDialog(project)).showAndGet()) {
            Sdk sdk = dialog.getSdk();
            SdkAdditionalData data = sdk.getSdkAdditionalData();
            if (!(data instanceof PhpRemoteSdkAdditionalData)) {
                LOG.warn(PhpRemoteInterpreterManagerImpl.getRemoteInterpreterPluginIsDisabledErrorMessage());
                return null;
            }
            PhpRemoteSdkAdditionalData remoteData = (PhpRemoteSdkAdditionalData)data;
            PhpInterpreter interpreter = producer.get();
            interpreter.setPhpSdkAdditionalData((PhpSdkAdditionalData)remoteData);
            interpreter.setHomePath(remoteData.getSdkId());
            interpreter.setIsProjectLevel(true);
            return interpreter;
        }
        return null;
    }

    public boolean producesSshSdkCredentials(@NotNull PhpSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(2);
        }
        if (data instanceof PhpRemoteSdkAdditionalData) {
            return SshCredentialsUtil.producesSshSdkCredentials((RemoteSdkAdditionalData)((PhpRemoteSdkAdditionalData)data));
        }
        return false;
    }

    @NotNull
    public PhpSdkAdditionalData loadRemote(@Nullable Project project, @Nullable Element element, @NotNull PhpInterpreter interpreter) {
        if (interpreter == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(3);
        }
        PhpRemoteSdkAdditionalData phpRemoteSdkAdditionalData = PhpRemoteSdkAdditionalData.loadRemote(interpreter, element, project);
        if (phpRemoteSdkAdditionalData == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(4);
        }
        return phpRemoteSdkAdditionalData;
    }

    public PhpInterpreterComponent createRemoteInterpreterEditor(@NotNull Project project, @NotNull String interpreterName, @NotNull PhpSdkAdditionalData data) {
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(5);
        }
        if (interpreterName == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(6);
        }
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(7);
        }
        return new PhpRemoteInterpreterComponent(project, PhpRemoteInterpreterManagerImpl.getRemoteData(data), interpreterName);
    }

    @NotNull
    public ProcessOutput getProcessOutput(@NotNull Project project, @NotNull PhpSdkAdditionalData data, @NotNull GeneralCommandLine commandLine, @NotNull @NlsContexts.ProgressTitle String title, @Nullable JComponent parent) throws ExecutionException, InterruptedException {
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(8);
        }
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(9);
        }
        if (commandLine == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(10);
        }
        if (title == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(11);
        }
        Ref exception = new Ref(null);
        Ref outputRef = new Ref(null);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                PhpRemoteSdkAdditionalData remoteData = PhpRemoteInterpreterManagerImpl.getRemoteData(data);
                PhpRemoteProcessRunner runner = PhpRemoteProcessManager.getInstance(remoteData).getRemoteProcessRunner(remoteData);
                outputRef.set((Object)runner.getProcessOutput(project, remoteData, commandLine, title, parent));
            }
            catch (ExecutionException e) {
                exception.set((Object)e);
            }
            catch (InterruptedException | RuntimeException e) {
                exception.set((Object)new ExecutionException((Throwable)e));
            }
        }, title, true, project, parent);
        if (!exception.isNull()) {
            throw (ExecutionException)((Object)exception.get());
        }
        if (outputRef.isNull()) {
            throw new InterruptedException("process was interrupted");
        }
        ProcessOutput processOutput = (ProcessOutput)outputRef.get();
        if (processOutput == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(12);
        }
        return processOutput;
    }

    @NotNull
    public PhpCommandLinePathProcessor createPathMapper(@NotNull Project project, @NotNull PhpSdkAdditionalData data) {
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(13);
        }
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(14);
        }
        PhpRemoteSdkAdditionalData remoteData = PhpRemoteInterpreterManagerImpl.getRemoteData(data);
        return new PhpRemoteCommandLinePathProcessor(remoteData, this.createPathMappings(project, data));
    }

    @NotNull
    public PhpCommandSettings createPhpCommand(@NotNull Project project, @NotNull PhpSdkAdditionalData data) throws ExecutionException {
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(15);
        }
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(16);
        }
        PhpRemoteSdkAdditionalData remoteData = PhpRemoteInterpreterManagerImpl.getRemoteData(data);
        String path = remoteData.getInterpreterPath();
        String validate = remoteData.validate(project, null);
        if (StringUtil.isNotEmpty((String)validate)) {
            throw new ExecutionException(validate);
        }
        PhpRemoteCommandLinePathProcessor pathProcessor = new PhpRemoteCommandLinePathProcessor(remoteData, this.createPathMappings(project, data));
        PhpCommandSettings phpCommandSettings = PhpCommandSettingsBuilder.create((String)path, (PhpCommandLinePathProcessor)pathProcessor, (PhpSdkAdditionalData)data);
        if (phpCommandSettings == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(17);
        }
        return phpCommandSettings;
    }

    @NotNull
    public ProcessHandler getRemoteProcessHandler(@NotNull Project project, @NotNull PhpSdkAdditionalData data, @NotNull GeneralCommandLine commandLine, boolean verbose, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException, InterruptedException {
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(18);
        }
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(19);
        }
        if (commandLine == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(20);
        }
        if (additionalMappings == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(21);
        }
        PhpRemoteSdkAdditionalData remoteData = PhpRemoteInterpreterManagerImpl.getRemoteData(data);
        PhpRemoteProcessRunner runner = PhpRemoteProcessManager.getInstance(remoteData).getRemoteProcessRunner(remoteData);
        Process process = runner.getRemoteProcess(project, remoteData, commandLine, additionalMappings);
        String commandTitle = commandLine.getCommandLineString(remoteData.toPresentablePath());
        Charset charset = EncodingProjectManager.getInstance((Project)project).getDefaultCharset();
        ProcessHandler processHandler = runner.createRemoteProcessHandler(process, commandTitle, charset, remoteData, verbose);
        if (processHandler == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(22);
        }
        return processHandler;
    }

    public boolean canRunBackgroundTool(@NotNull Project project, @NotNull PhpSdkAdditionalData data) {
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(23);
        }
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(24);
        }
        try {
            PhpRemoteSdkAdditionalData remoteData = PhpRemoteInterpreterManagerImpl.getRemoteData(data);
            PhpRemoteProcessRunner runner = PhpRemoteProcessManager.getInstance(remoteData).getRemoteProcessRunner(remoteData);
            return runner.canRunBackgroundProcess(project, remoteData);
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    @NotNull
    public ProcessHandler getRemoteToolProcessHandler(@NotNull Project project, @NotNull QualityToolMessageProcessor messageProcessor, @NotNull PhpSdkAdditionalData data, @NotNull GeneralCommandLine commandLine, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException {
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(25);
        }
        if (messageProcessor == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(26);
        }
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(27);
        }
        if (commandLine == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(28);
        }
        if (additionalMappings == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(29);
        }
        try {
            PhpRemoteSdkAdditionalData remoteData = PhpRemoteInterpreterManagerImpl.getRemoteData(data);
            PhpRemoteProcessRunner runner = PhpRemoteProcessManager.getInstance(remoteData).getRemoteProcessRunner(remoteData);
            Process process = runner.getRemoteBackgroundProcess(project, remoteData, commandLine, additionalMappings);
            String commandTitle = commandLine.getCommandLineString(remoteData.constructFullInterpreterPath(commandLine.getExePath()));
            if (!(process instanceof RemoteProcess)) {
                return new QualityToolProcessHandler(process, messageProcessor, commandTitle);
            }
            return new QualityRemoteToolProcessHandler((RemoteProcess)process, messageProcessor, commandTitle);
        }
        catch (RemoteSdkException e) {
            throw new ExecutionException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new ExecutionException(e.getMessage());
        }
    }

    @NotNull
    public PathMappingSettings createPathMappings(@Nullable Project project, @NotNull PhpSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(30);
        }
        PhpRemoteSdkAdditionalData remoteData = PhpRemoteInterpreterManagerImpl.getRemoteData(data);
        PathMappingSettings newMappingSettings = new PathMappingSettings();
        if (project != null) {
            RemoteMappingsManager.Mappings mappings = RemoteMappingsManager.getInstance((Project)project).getForServer(PHP_PREFIX, data.getInterpreterId());
            if (mappings != null) {
                newMappingSettings.addAll(mappings.getSettings());
            }
            for (PathMappingProvider mappingProvider : PathMappingProvider.getSuitableMappingProviders((RemoteSdkAdditionalData)remoteData)) {
                PathMappingSettings settings = mappingProvider.getPathMappingSettings(project, (RemoteSdkAdditionalData)remoteData);
                newMappingSettings.addAll(settings);
            }
        }
        PathMappingSettings pathMappingSettings = newMappingSettings;
        if (pathMappingSettings == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(31);
        }
        return pathMappingSettings;
    }

    @NotNull
    public String getPathMappingsSource(@NotNull PhpSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(32);
        }
        PhpRemoteSdkAdditionalData remoteData = PhpRemoteInterpreterManagerImpl.getRemoteData(data);
        SmartList locations = new SmartList();
        for (PathMappingProvider mappingProvider : PathMappingProvider.getSuitableMappingProviders((RemoteSdkAdditionalData)remoteData)) {
            locations.add(mappingProvider.getProviderPresentableName((RemoteSdkAdditionalData)remoteData));
        }
        String string = StringUtil.join((Collection)locations, (String)" or ");
        if (string == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    private static PhpRemoteSdkAdditionalData getRemoteData(@NotNull PhpSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(34);
        }
        assert (data instanceof PhpRemoteSdkAdditionalData) : "Remote Interpreter data expected instead of: " + data.getClass();
        PhpRemoteSdkAdditionalData phpRemoteSdkAdditionalData = (PhpRemoteSdkAdditionalData)data;
        if (phpRemoteSdkAdditionalData == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(35);
        }
        return phpRemoteSdkAdditionalData;
    }

    public static boolean supportRemoteBrowseAction(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(36);
        }
        try {
            return SshCredentialsUtil.producesSshSdkCredentials((RemoteSdkAdditionalData)data);
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @NotNull
    public ActionListener createRemoteBrowserAction(@Nullable Project project, @NotNull PhpSdkAdditionalData data, @NotNull @NlsContexts.DialogTitle String title, @NotNull JTextField textField, boolean withFoldersOnly) throws PhpInvalidSdkTypeException {
        PhpRemoteSdkAdditionalData remoteData;
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(37);
        }
        if (title == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(38);
        }
        if (textField == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(39);
        }
        if (!SshCredentialsUtil.producesSshSdkCredentials((RemoteSdkAdditionalData)(remoteData = PhpRemoteInterpreterManagerImpl.getRemoteData(data)))) {
            throw new PhpInvalidSdkTypeException(PhpBundle.message((String)"remote.interpreter.browse.action.is.not.supported.for.docker", (Object[])new Object[0]));
        }
        PhpRemoteCredentialsProducer producer = new PhpRemoteCredentialsProducer(project, PhpRemoteInterpreterManagerImpl.getRemoteData(data));
        RemoteBrowseActionListener remoteBrowseActionListener = new RemoteBrowseActionListener(textField, title, (AsyncProducer)producer).withFoldersOnly(withFoldersOnly);
        if (remoteBrowseActionListener == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(40);
        }
        return remoteBrowseActionListener;
    }

    public void openRemoteFileChooser(@NotNull Project project, @NotNull PhpSdkAdditionalData data, @Nullable String initial, @NotNull @NlsContexts.DialogTitle String title, @NotNull JComponent parent, @NotNull Consumer<Pair<String, VirtualFile>> selectedFileProcessor) throws PhpInvalidSdkTypeException {
        PhpRemoteSdkAdditionalData remoteData;
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(41);
        }
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(42);
        }
        if (title == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(43);
        }
        if (parent == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(44);
        }
        if (selectedFileProcessor == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(45);
        }
        if (!SshCredentialsUtil.producesSshSdkCredentials((RemoteSdkAdditionalData)(remoteData = PhpRemoteInterpreterManagerImpl.getRemoteData(data)))) {
            throw new PhpInvalidSdkTypeException(PhpBundle.message((String)"remote.interpreter.browse.action.is.not.supported.for.docker", (Object[])new Object[0]));
        }
        Consumer consumer = data1 -> {
            if (RemoteSdkUtil.testConnection((Component)parent, (RemoteCredentials)data1, (boolean)false)) {
                WebServerConfig.RemotePath path;
                CredentialsDeployable deployable = RemoteSdkUtil.createDeployable((RemoteCredentials)data1);
                String initialPath = StringUtil.notNullize((String)initial);
                ServerBrowserDialog d = PhpRemoteBrowserUtil.showBrowseRemoteDialog((String)title, (JComponent)parent, (String)initialPath, (boolean)false, (Deployable)deployable);
                if (d.isOK() && (path = d.getPath()) != null) {
                    String localFilePath = FileUtil.join((String[])new String[]{FileUtil.getTempDirectory(), PathUtil.getFileName((String)path.path)});
                    SmartList mappings = new SmartList((Object)new PathMappingSettings.PathMapping(localFilePath, path.path));
                    try {
                        new PhpRemoteTransfer(project, null, remoteData.getRemoteSdkCredentials(project, false)).downloadFromRemote((List<PathMappingSettings.PathMapping>)mappings);
                        VirtualFile localFile = LocalFileSystem.getInstance().findFileByPath(localFilePath);
                        if (localFile != null) {
                            selectedFileProcessor.consume((Object)Pair.create((Object)path.path, (Object)localFile));
                        } else {
                            LOG.warn("Can not find local file by path: " + localFilePath);
                        }
                    }
                    catch (ExecutionException e) {
                        LOG.warn("Failed to download remote file", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("File download was interrupted", (Throwable)e);
                    }
                }
            }
        };
        new PhpRemoteCredentialsProducer(project, PhpRemoteInterpreterManagerImpl.getRemoteData(data)).produce((Consumer<? super RemoteCredentials>)consumer);
    }

    public String getRemoteHost(@NotNull Project project, @NotNull String interpreterName, @NotNull PhpSdkAdditionalData data) {
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(46);
        }
        if (interpreterName == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(47);
        }
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(48);
        }
        if (data instanceof PhpRemoteSdkAdditionalData) {
            PhpRemoteSdkAdditionalData remote = (PhpRemoteSdkAdditionalData)data;
            try {
                return PhpRemoteProcessManager.getInstance(remote).getRemoteHost(project, interpreterName, remote);
            }
            catch (ExecutionException e) {
                LOG.warn((Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public PhpSdkHelpersManager getHelpersManager(@NotNull PhpSdkAdditionalData data) throws ExecutionException {
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(49);
        }
        if (data instanceof PhpRemoteSdkAdditionalData) {
            PhpRemoteSdkAdditionalData remote = (PhpRemoteSdkAdditionalData)data;
            return PhpRemoteProcessManager.getInstance(remote).getSdkHelpersManager(remote);
        }
        return null;
    }

    @Nullable
    public PhpCoverageResultManager getCoverageResultManager(@NotNull PhpSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(50);
        }
        if (data instanceof PhpRemoteSdkAdditionalData) {
            PhpRemoteSdkAdditionalData remote = (PhpRemoteSdkAdditionalData)data;
            try {
                return PhpRemoteProcessManager.getInstance(remote).getCoverageResultManager(remote);
            }
            catch (ExecutionException e) {
                LOG.warn((Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public PhpSdkFileTransfer getSdkFileTransfer(@NotNull PhpSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(51);
        }
        if (data instanceof PhpRemoteSdkAdditionalData) {
            PhpRemoteSdkAdditionalData remote = (PhpRemoteSdkAdditionalData)data;
            try {
                return PhpRemoteProcessManager.getInstance(remote).getSdkFileTransfer(remote);
            }
            catch (ExecutionException e) {
                LOG.warn((Throwable)e);
            }
        }
        return null;
    }

    public void replaceWithPhpDbg(@NotNull PhpSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(52);
        }
        if (data instanceof PhpRemoteSdkAdditionalData) {
            String path = ((PhpRemoteSdkAdditionalData)data).getInterpreterPath();
            String parentPath = PathUtil.getParentPath((String)path);
            ((PhpRemoteSdkAdditionalData)data).setInterpreterPath((String)(StringUtil.isEmpty((String)parentPath) ? "" : parentPath + "/") + PathUtil.getFileName((String)path).replace(PHP_PREFIX, "phpdbg"));
        }
    }

    public String escape(@NotNull PhpSdkAdditionalData data, @NotNull String path) {
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(53);
        }
        if (path == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(54);
        }
        if (data instanceof PhpRemoteSdkAdditionalData) {
            PhpRemoteSdkAdditionalData remote = (PhpRemoteSdkAdditionalData)data;
            try {
                return PhpRemoteProcessManager.getInstance(remote).escape(path);
            }
            catch (ExecutionException e) {
                LOG.warn((Throwable)e);
            }
        }
        return StringUtil.escapeBackSlashes((String)path);
    }

    @NotNull
    public Map<String, String> getSdkProperties(@NotNull PhpSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(55);
        }
        if (data instanceof PhpRemoteSdkAdditionalData) {
            Map<String, String> map;
            PhpRemoteSdkAdditionalData remote = (PhpRemoteSdkAdditionalData)data;
            try {
                map = PhpRemoteProcessManager.getInstance(remote).getSdkProperties(remote);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            if (map == null) {
                PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(56);
            }
            return map;
        }
        Map<String, String> map = Collections.emptyMap();
        if (map == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(57);
        }
        return map;
    }

    @Nullable
    public PhpDebugErrorDetector newErrorDetector(@NotNull Project project, @NotNull PhpSdkAdditionalData data) {
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(58);
        }
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(59);
        }
        if (data instanceof PhpRemoteSdkAdditionalData) {
            PhpRemoteSdkAdditionalData remote = (PhpRemoteSdkAdditionalData)data;
            try {
                return PhpRemoteProcessManager.getInstance(remote).newErrorDetector(project, remote);
            }
            catch (ExecutionException e) {
                LOG.warn((Throwable)e);
            }
        }
        return null;
    }

    public void updateSshConfigData(@Nullable PhpSdkAdditionalData additionalData, @NotNull SshConfigManager manager) {
        if (manager == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(60);
        }
        RemoteSdkUtil.updateSshConfigData((SdkAdditionalData)additionalData, (SshConfigManager)manager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: 
            case 17: 
            case 22: 
            case 31: 
            case 33: 
            case 35: 
            case 40: 
            case 56: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 12: 
            case 17: 
            case 22: 
            case 31: 
            case 33: 
            case 35: 
            case 40: 
            case 56: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 14: 
            case 16: 
            case 19: 
            case 24: 
            case 27: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 4: 
            case 12: 
            case 17: 
            case 22: 
            case 31: 
            case 33: 
            case 35: 
            case 40: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/PhpRemoteInterpreterManagerImpl";
                break;
            }
            case 6: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterName";
                break;
            }
            case 10: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 11: 
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalMappings";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageProcessor";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFileProcessor";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/PhpRemoteInterpreterManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRemote";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createPhpCommand";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteProcessHandler";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathMappings";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMappingsSource";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteData";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteBrowserAction";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addRemoteSdk";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "producesSshSdkCredentials";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadRemote";
                break;
            }
            case 4: 
            case 12: 
            case 17: 
            case 22: 
            case 31: 
            case 33: 
            case 35: 
            case 40: 
            case 56: 
            case 57: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteInterpreterEditor";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createPathMapper";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createPhpCommand";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteProcessHandler";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "canRunBackgroundTool";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteToolProcessHandler";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createPathMappings";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getPathMappingsSource";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteData";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "supportRemoteBrowseAction";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteBrowserAction";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "openRemoteFileChooser";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteHost";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getHelpersManager";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getCoverageResultManager";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getSdkFileTransfer";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithPhpDbg";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getSdkProperties";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "newErrorDetector";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "updateSshConfigData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 12: 
            case 17: 
            case 22: 
            case 31: 
            case 33: 
            case 35: 
            case 40: 
            case 56: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

