/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.NoRepositoryLayoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class DefaultRepositoryLayoutProvider
implements RepositoryLayoutProvider,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRepositoryLayoutProvider.class);
    private Collection<RepositoryLayoutFactory> factories = new ArrayList<RepositoryLayoutFactory>();

    public DefaultRepositoryLayoutProvider() {
    }

    @Inject
    DefaultRepositoryLayoutProvider(Set<RepositoryLayoutFactory> layoutFactories) {
        this.setRepositoryLayoutFactories(layoutFactories);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setRepositoryLayoutFactories(locator.getServices(RepositoryLayoutFactory.class));
    }

    public DefaultRepositoryLayoutProvider addRepositoryLayoutFactory(RepositoryLayoutFactory factory) {
        this.factories.add(Objects.requireNonNull(factory, "layout factory cannot be null"));
        return this;
    }

    public DefaultRepositoryLayoutProvider setRepositoryLayoutFactories(Collection<RepositoryLayoutFactory> factories) {
        this.factories = factories == null ? new ArrayList<RepositoryLayoutFactory>() : factories;
        return this;
    }

    @Override
    public RepositoryLayout newRepositoryLayout(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryLayoutException {
        Objects.requireNonNull(repository, "remote repository cannot be null");
        PrioritizedComponents<RepositoryLayoutFactory> factories = new PrioritizedComponents<RepositoryLayoutFactory>(session);
        for (RepositoryLayoutFactory factory : this.factories) {
            factories.add(factory, factory.getPriority());
        }
        ArrayList<NoRepositoryLayoutException> errors = new ArrayList<NoRepositoryLayoutException>();
        for (PrioritizedComponent factory : factories.getEnabled()) {
            try {
                return ((RepositoryLayoutFactory)factory.getComponent()).newInstance(session, repository);
            }
            catch (NoRepositoryLayoutException noRepositoryLayoutException) {
                errors.add(noRepositoryLayoutException);
            }
        }
        if (LOGGER.isDebugEnabled() && errors.size() > 1) {
            String msg = "Could not obtain layout factory for " + repository;
            for (Exception exception : errors) {
                LOGGER.debug(msg, (Throwable)exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("No layout factories registered");
        } else {
            buffer.append("Cannot access ").append(repository.getUrl());
            buffer.append(" with type ").append(repository.getContentType());
            buffer.append(" using the available layout factories: ");
            factories.list(buffer);
        }
        throw new NoRepositoryLayoutException(repository, buffer.toString(), errors.size() == 1 ? (NoRepositoryLayoutException)errors.get(0) : null);
    }
}

