/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.hosting.GitHostingUrlUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryPath;

public final class GithubUrlUtil {
    @NlsSafe
    @NotNull
    private static String removeTrailingSlash(@NotNull String s) {
        if (s == null) {
            GithubUrlUtil.$$$reportNull$$$0(0);
        }
        if (s.endsWith("/")) {
            String string = s.substring(0, s.length() - 1);
            if (string == null) {
                GithubUrlUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            GithubUrlUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public static GHRepositoryPath getUserAndRepositoryFromRemoteUrl(@NotNull String remoteUrl) {
        int index1;
        if (remoteUrl == null) {
            GithubUrlUtil.$$$reportNull$$$0(3);
        }
        if ((index1 = (remoteUrl = GitHostingUrlUtil.removeProtocolPrefix((String)GithubUrlUtil.removeEndingDotGit(remoteUrl))).lastIndexOf(47)) == -1) {
            return null;
        }
        String url = remoteUrl.substring(0, index1);
        int index2 = Math.max(url.lastIndexOf(47), url.lastIndexOf(58));
        if (index2 == -1) {
            return null;
        }
        String username = remoteUrl.substring(index2 + 1, index1);
        String reponame = remoteUrl.substring(index1 + 1);
        if (username.isEmpty() || reponame.isEmpty()) {
            return null;
        }
        return new GHRepositoryPath(username, reponame);
    }

    @NlsSafe
    @NotNull
    private static String removeEndingDotGit(@NotNull String url) {
        if (url == null) {
            GithubUrlUtil.$$$reportNull$$$0(4);
        }
        url = GithubUrlUtil.removeTrailingSlash(url);
        String DOT_GIT = ".git";
        if (url.endsWith(".git")) {
            String string = url.substring(0, url.length() - ".git".length());
            if (string == null) {
                GithubUrlUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = url;
        if (string == null) {
            GithubUrlUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static String getHostFromUrl(@NotNull String url) {
        String path;
        int index;
        if (url == null) {
            GithubUrlUtil.$$$reportNull$$$0(7);
        }
        if ((index = (path = GitHostingUrlUtil.removeProtocolPrefix((String)url).replace(':', '/')).indexOf(47)) == -1) {
            String string = path;
            if (string == null) {
                GithubUrlUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = path.substring(0, index);
        if (string == null) {
            GithubUrlUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public static String makeGithubRepoUrlFromRemoteUrl(@NotNull String remoteUrl, @NotNull String host) {
        GHRepositoryPath repo;
        if (remoteUrl == null) {
            GithubUrlUtil.$$$reportNull$$$0(10);
        }
        if (host == null) {
            GithubUrlUtil.$$$reportNull$$$0(11);
        }
        if ((repo = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remoteUrl)) == null) {
            return null;
        }
        return host + "/" + repo.getOwner() + "/" + repo.getRepository();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/util/GithubUrlUtil";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrl";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/util/GithubUrlUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "removeTrailingSlash";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "removeEndingDotGit";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostFromUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeTrailingSlash";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUserAndRepositoryFromRemoteUrl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeEndingDotGit";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHostFromUrl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "makeGithubRepoUrlFromRemoteUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

