/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ(\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00040\u000e\"\u0004\b\u0000\u0010\u00042\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\u000e0\u0010H\u0007J0\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u00042\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\u000e0\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00040\u000eH\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/util/GithubAsyncUtil;", "", "()V", "awaitFuture", "T", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "future", "Ljava/util/concurrent/Future;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/util/concurrent/Future;)Ljava/lang/Object;", "extractError", "", "error", "futureOfMutable", "Ljava/util/concurrent/CompletableFuture;", "futureSupplier", "Lkotlin/Function0;", "handleToOtherIfCancelled", "", "other", "isCancellation", "", "intellij.vcs.github"})
public final class GithubAsyncUtil {
    @NotNull
    public static final GithubAsyncUtil INSTANCE;

    @JvmStatic
    public static final <T> T awaitFuture(@NotNull ProgressIndicator progressIndicator, @NotNull Future<T> future2) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter(future2, (String)"future");
        T result = null;
        while (true) {
            try {
                result = future2.get(50L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                progressIndicator.checkCanceled();
                continue;
            }
            catch (Exception e) {
                if (INSTANCE.isCancellation(e)) {
                    throw (Throwable)new ProcessCanceledException();
                }
                if (e instanceof ExecutionException) {
                    Throwable throwable = e.getCause();
                    if (throwable == null) {
                        throwable = e;
                    }
                    throw throwable;
                }
                throw (Throwable)e;
            }
            break;
        }
        return result;
    }

    @Deprecated(message="Background process value now always drops on PCE")
    @JvmStatic
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static final <T> CompletableFuture<T> futureOfMutable(@NotNull Function0<? extends CompletableFuture<T>> futureSupplier) {
        Intrinsics.checkNotNullParameter(futureSupplier, (String)"futureSupplier");
        CompletableFuture result = new CompletableFuture();
        INSTANCE.handleToOtherIfCancelled(futureSupplier, result);
        return result;
    }

    private final <T> void handleToOtherIfCancelled(Function0<? extends CompletableFuture<T>> futureSupplier, CompletableFuture<T> other) {
        ((CompletableFuture)futureSupplier.invoke()).handle(new BiFunction<T, Throwable, Boolean>(futureSupplier, other){
            final /* synthetic */ Function0 $futureSupplier;
            final /* synthetic */ CompletableFuture $other;

            public final Boolean apply(T result, Throwable error) {
                if (error != null) {
                    if (GithubAsyncUtil.INSTANCE.isCancellation(error)) {
                        GithubAsyncUtil.access$handleToOtherIfCancelled(GithubAsyncUtil.INSTANCE, this.$futureSupplier, this.$other);
                    }
                    this.$other.completeExceptionally(error.getCause());
                }
                return this.$other.complete(result);
            }
            {
                this.$futureSupplier = function0;
                this.$other = completableFuture;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isCancellation(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (error instanceof ProcessCanceledException) return true;
        if (error instanceof CancellationException) return true;
        if (error instanceof InterruptedException) return true;
        Throwable throwable = error.getCause();
        if (throwable == null) return false;
        Throwable throwable2 = throwable;
        GithubAsyncUtil githubAsyncUtil = this;
        boolean bl = false;
        boolean bl2 = false;
        Throwable p1 = throwable2;
        boolean bl3 = false;
        boolean bl4 = githubAsyncUtil.isCancellation(p1);
        if (!bl4) return false;
        return true;
    }

    @NotNull
    public final Throwable extractError(@NotNull Throwable error) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Throwable throwable2 = error;
        if (throwable2 instanceof CompletionException) {
            Throwable throwable3 = error.getCause();
            Intrinsics.checkNotNull((Object)throwable3);
            throwable = this.extractError(throwable3);
        } else if (throwable2 instanceof ExecutionException) {
            Throwable throwable4 = error.getCause();
            Intrinsics.checkNotNull((Object)throwable4);
            throwable = this.extractError(throwable4);
        } else {
            throwable = error;
        }
        return throwable;
    }

    private GithubAsyncUtil() {
    }

    static {
        GithubAsyncUtil githubAsyncUtil;
        INSTANCE = githubAsyncUtil = new GithubAsyncUtil();
    }

    public static final /* synthetic */ void access$handleToOtherIfCancelled(GithubAsyncUtil $this, Function0 futureSupplier, CompletableFuture other) {
        $this.handleToOtherIfCancelled(futureSupplier, other);
    }
}

