/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.util.DelayedTaskScheduler$sam$java_lang_Runnable$0;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\bH\u0007J\b\u0010\r\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/util/DelayedTaskScheduler;", "", "delaySeconds", "", "disposable", "Lcom/intellij/openapi/Disposable;", "task", "Lkotlin/Function0;", "", "(JLcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function0;)V", "scheduler", "Ljava/util/concurrent/ScheduledFuture;", "start", "stop", "intellij.vcs.github"})
public final class DelayedTaskScheduler {
    private ScheduledFuture<?> scheduler;
    private final long delaySeconds;
    private final Disposable disposable;
    private final Function0<Unit> task;

    @RequiresEdt
    public final void start() {
        if (Disposer.isDisposed((Disposable)this.disposable)) {
            String string = "Already disposed";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (this.scheduler == null) {
            EdtScheduledExecutorService edtScheduledExecutorService = EdtScheduledExecutorService.getInstance();
            Object object = this.task;
            if (object != null) {
                Function0<Unit> function0 = object;
                object = new DelayedTaskScheduler$sam$java_lang_Runnable$0(function0);
            }
            this.scheduler = edtScheduledExecutorService.scheduleWithFixedDelay((Runnable)object, this.delaySeconds, this.delaySeconds, TimeUnit.SECONDS);
        }
    }

    @RequiresEdt
    public final void stop() {
        ScheduledFuture<?> scheduledFuture = this.scheduler;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        this.scheduler = null;
    }

    public DelayedTaskScheduler(long delaySeconds, @NotNull Disposable disposable, @NotNull Function0<Unit> task2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        this.delaySeconds = delaySeconds;
        this.disposable = disposable;
        this.task = task2;
        Disposer.register((Disposable)this.disposable, (Disposable)new Disposable(){

            public final void dispose() {
                this.stop();
            }
        });
    }
}

