/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.ImageLoader;
import java.awt.Image;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.util.CachingGHUserAvatarLoader;
import org.jetbrains.plugins.github.util.GithubAsyncUtilKt;
import org.jetbrains.plugins.github.util.ProgressIndicatorsProvider;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\bR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rn\u0010\u0006\u001ab\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u000b \t*\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\n0\n \t*0\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u000b \t*\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\n0\n\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/util/CachingGHUserAvatarLoader;", "Lcom/intellij/openapi/Disposable;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "avatarCache", "Lcom/google/common/cache/Cache;", "", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/CompletableFuture;", "Ljava/awt/Image;", "indicatorProvider", "Lorg/jetbrains/plugins/github/util/ProgressIndicatorsProvider;", "dispose", "", "loadAndDownscale", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "url", "maximumSize", "", "requestAvatar", "Companion", "intellij.vcs.github"})
public final class CachingGHUserAvatarLoader
implements Disposable {
    private final Logger LOG;
    private final ProgressIndicatorsProvider indicatorProvider;
    private final Cache<String, CompletableFuture<Image>> avatarCache;
    private static final int MAXIMUM_ICON_SIZE = 40;
    private static final int STORED_IMAGE_SIZE = 240;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final CompletableFuture<Image> requestAvatar(@NotNull GithubApiRequestExecutor requestExecutor, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object object = this.avatarCache.get((Object)url, (Callable)new Callable<CompletableFuture<Image>>(this, requestExecutor, url){
            final /* synthetic */ CachingGHUserAvatarLoader this$0;
            final /* synthetic */ GithubApiRequestExecutor $requestExecutor;
            final /* synthetic */ String $url;

            public final CompletableFuture<Image> call() {
                ProgressManager progressManager = ProgressManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                return GithubAsyncUtilKt.submitIOTask(progressManager, CachingGHUserAvatarLoader.access$getIndicatorProvider$p(this.this$0), (Function1)new Function1<ProgressIndicator, Image>(this){
                    final /* synthetic */ requestAvatar.1 this$0;

                    @Nullable
                    public final Image invoke(@NotNull ProgressIndicator it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return CachingGHUserAvatarLoader.access$loadAndDownscale(this.this$0.this$0, this.this$0.$requestExecutor, it, this.this$0.$url, 240);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = cachingGHUserAvatarLoader;
                this.$requestExecutor = githubApiRequestExecutor;
                this.$url = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"avatarCache.get(url) {\n \u2026 STORED_IMAGE_SIZE) }\n  }");
        return (CompletableFuture)object;
    }

    private final Image loadAndDownscale(GithubApiRequestExecutor requestExecutor, ProgressIndicator indicator, String url, int maximumSize) {
        try {
            Image image = requestExecutor.execute(indicator, GithubApiRequests.CurrentUser.getAvatar(url));
            return image.getWidth(null) <= maximumSize && image.getHeight(null) <= maximumSize ? image : ImageLoader.scaleImage((Image)image, (int)maximumSize);
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        catch (Exception e) {
            this.LOG.debug("Error loading image from " + url, (Throwable)e);
            return null;
        }
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    public CachingGHUserAvatarLoader() {
        void it;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CachingGHUserAvatarLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        this.LOG = logger;
        ProgressIndicatorsProvider progressIndicatorsProvider = new ProgressIndicatorsProvider();
        boolean bl = false;
        boolean bl2 = false;
        ProgressIndicatorsProvider progressIndicatorsProvider2 = progressIndicatorsProvider;
        CachingGHUserAvatarLoader cachingGHUserAvatarLoader = this;
        boolean bl3 = false;
        Disposer.register((Disposable)this, (Disposable)((Disposable)it));
        Unit unit = Unit.INSTANCE;
        cachingGHUserAvatarLoader.indicatorProvider = progressIndicatorsProvider;
        this.avatarCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
        LowMemoryWatcher.register((Runnable)new Runnable(){

            @Override
            public final void run() {
                avatarCache.invalidateAll();
            }
        }, (Disposable)this);
    }

    public static final /* synthetic */ ProgressIndicatorsProvider access$getIndicatorProvider$p(CachingGHUserAvatarLoader $this) {
        return $this.indicatorProvider;
    }

    public static final /* synthetic */ Image access$loadAndDownscale(CachingGHUserAvatarLoader $this, GithubApiRequestExecutor requestExecutor, ProgressIndicator indicator, String url, int maximumSize) {
        return $this.loadAndDownscale(requestExecutor, indicator, url, maximumSize);
    }

    @JvmStatic
    @NotNull
    public static final CachingGHUserAvatarLoader getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/util/CachingGHUserAvatarLoader$Companion;", "", "()V", "MAXIMUM_ICON_SIZE", "", "STORED_IMAGE_SIZE", "getInstance", "Lorg/jetbrains/plugins/github/util/CachingGHUserAvatarLoader;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final CachingGHUserAvatarLoader getInstance() {
            boolean $i$f$service = false;
            Class<CachingGHUserAvatarLoader> serviceClass$iv = CachingGHUserAvatarLoader.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (CachingGHUserAvatarLoader)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

