/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineEvent;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0013\u001a\u00020\u0014H&R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineMergedEvents;", "T", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent;", "()V", "actor", "Lorg/jetbrains/plugins/github/api/data/GHActor;", "getActor", "()Lorg/jetbrains/plugins/github/api/data/GHActor;", "createdAt", "Ljava/util/Date;", "getCreatedAt", "()Ljava/util/Date;", "events", "", "add", "", "event", "(Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent;)V", "addNonMergedEvent", "hasAnyChanges", "", "intellij.vcs.github"})
public abstract class GHPRTimelineMergedEvents<T extends GHPRTimelineEvent>
implements GHPRTimelineEvent {
    private final List<T> events;

    @Override
    @Nullable
    public GHActor getActor() {
        return ((GHPRTimelineEvent)CollectionsKt.last(this.events)).getActor();
    }

    @Override
    @NotNull
    public Date getCreatedAt() {
        return ((GHPRTimelineEvent)CollectionsKt.last(this.events)).getCreatedAt();
    }

    public final void add(@NotNull T event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        this.events.add(event);
        if (event instanceof GHPRTimelineMergedEvents) {
            Iterator<T> iterator = ((GHPRTimelineMergedEvents)event).events.iterator();
            while (iterator.hasNext()) {
                GHPRTimelineEvent evt;
                GHPRTimelineEvent gHPRTimelineEvent = evt = (GHPRTimelineEvent)iterator.next();
                if (gHPRTimelineEvent == null) {
                    throw new NullPointerException("null cannot be cast to non-null type T");
                }
                this.add(gHPRTimelineEvent);
            }
        } else {
            this.addNonMergedEvent(event);
        }
    }

    protected abstract void addNonMergedEvent(@NotNull T var1);

    public abstract boolean hasAnyChanges();

    public GHPRTimelineMergedEvents() {
        boolean bl = false;
        this.events = new ArrayList();
    }
}

