/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details;

import com.intellij.openapi.progress.ProgressIndicator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHRepositoryPermissionLevel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewRequest;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRSecurityService;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRMetadataModelBase;
import org.jetbrains.plugins.github.ui.util.SingleValueModel;
import org.jetbrains.plugins.github.util.CollectionDelta;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dH\u0016J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0#H\u0016J$\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150#H\u0016J$\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180#H\u0016J\n\u0010&\u001a\u0004\u0018\u00010\u000eH\u0014R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0010R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRMetadataModelImpl;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRMetadataModelBase;", "valueModel", "Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequest;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "repositoryDataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "detailsDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "(Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;)V", "assignees", "", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "getAssignees", "()Ljava/util/List;", "isEditingAllowed", "", "()Z", "labels", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "getLabels", "reviewers", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "getReviewers", "addAndInvokeChangesListener", "", "listener", "Lkotlin/Function0;", "adjustAssignees", "Ljava/util/concurrent/CompletableFuture;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "delta", "Lorg/jetbrains/plugins/github/util/CollectionDelta;", "adjustLabels", "adjustReviewers", "getAuthor", "intellij.vcs.github"})
public final class GHPRMetadataModelImpl
extends GHPRMetadataModelBase {
    private final boolean isEditingAllowed;
    private final SingleValueModel<GHPullRequest> valueModel;
    private final GHPRDetailsDataProvider detailsDataProvider;

    @Override
    @NotNull
    public List<GHUser> getAssignees() {
        return this.valueModel.getValue().getAssignees();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<GHPullRequestRequestedReviewer> getReviewers() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.valueModel.getValue().getReviewRequests();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GHPullRequestRequestedReviewer gHPullRequestRequestedReviewer;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GHPullRequestReviewRequest it = (GHPullRequestReviewRequest)element$iv$iv;
            boolean bl2 = false;
            if (it.getRequestedReviewer() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            GHPullRequestRequestedReviewer it$iv$iv = gHPullRequestRequestedReviewer;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<GHLabel> getLabels() {
        return this.valueModel.getValue().getLabels();
    }

    @Override
    @Nullable
    protected GHUser getAuthor() {
        GHActor gHActor = this.valueModel.getValue().getAuthor();
        if (!(gHActor instanceof GHUser)) {
            gHActor = null;
        }
        return (GHUser)gHActor;
    }

    @Override
    public boolean isEditingAllowed() {
        return this.isEditingAllowed;
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> adjustReviewers(@NotNull ProgressIndicator indicator, @NotNull CollectionDelta<? extends GHPullRequestRequestedReviewer> delta) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(delta, (String)"delta");
        return this.detailsDataProvider.adjustReviewers(indicator, delta);
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> adjustAssignees(@NotNull ProgressIndicator indicator, @NotNull CollectionDelta<GHUser> delta) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(delta, (String)"delta");
        return this.detailsDataProvider.adjustAssignees(indicator, delta);
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> adjustLabels(@NotNull ProgressIndicator indicator, @NotNull CollectionDelta<GHLabel> delta) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(delta, (String)"delta");
        return this.detailsDataProvider.adjustLabels(indicator, delta);
    }

    @Override
    public void addAndInvokeChangesListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.valueModel.addAndInvokeValueChangedListener(listener);
    }

    public GHPRMetadataModelImpl(@NotNull SingleValueModel<GHPullRequest> valueModel, @NotNull GHPRSecurityService securityService, @NotNull GHPRRepositoryDataService repositoryDataService, @NotNull GHPRDetailsDataProvider detailsDataProvider) {
        Intrinsics.checkNotNullParameter(valueModel, (String)"valueModel");
        Intrinsics.checkNotNullParameter((Object)securityService, (String)"securityService");
        Intrinsics.checkNotNullParameter((Object)repositoryDataService, (String)"repositoryDataService");
        Intrinsics.checkNotNullParameter((Object)detailsDataProvider, (String)"detailsDataProvider");
        super(repositoryDataService);
        this.valueModel = valueModel;
        this.detailsDataProvider = detailsDataProvider;
        this.isEditingAllowed = securityService.currentUserHasPermissionLevel(GHRepositoryPermissionLevel.TRIAGE);
    }
}

