/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffRequestModel;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineVirtualFile;
import org.jetbrains.plugins.github.pullrequest.data.GHListLoader;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataProviderRepository;
import org.jetbrains.plugins.github.pullrequest.data.GHPRFilesManager;
import org.jetbrains.plugins.github.pullrequest.data.GHPRListUpdatesChecker;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRCreationService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRDetailsService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRSecurityService;
import org.jetbrains.plugins.github.pullrequest.search.GHPRSearchQueryHolder;
import org.jetbrains.plugins.github.ui.avatars.GHAvatarIconsProvider;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\b\u00102\u001a\u000203H\u0016R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0013\u0010(\u001a\u00070\u0001\u00a2\u0006\u0002\b)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101\u00a8\u00064"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;", "Lcom/intellij/openapi/Disposable;", "searchHolder", "Lorg/jetbrains/plugins/github/pullrequest/search/GHPRSearchQueryHolder;", "listLoader", "Lorg/jetbrains/plugins/github/pullrequest/data/GHListLoader;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "listUpdatesChecker", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListUpdatesChecker;", "dataProviderRepository", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProviderRepository;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "repositoryDataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "creationService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRCreationService;", "detailsService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsService;", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "filesManager", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;", "newPRDiffModel", "Lorg/jetbrains/plugins/github/pullrequest/GHPRDiffRequestModel;", "(Lorg/jetbrains/plugins/github/pullrequest/search/GHPRSearchQueryHolder;Lorg/jetbrains/plugins/github/pullrequest/data/GHListLoader;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListUpdatesChecker;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProviderRepository;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRCreationService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsService;Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;Lorg/jetbrains/plugins/github/pullrequest/GHPRDiffRequestModel;)V", "getAvatarIconsProvider", "()Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "getCreationService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRCreationService;", "getDataProviderRepository", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProviderRepository;", "getDetailsService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsService;", "getFilesManager", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;", "getListLoader", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHListLoader;", "getListUpdatesChecker", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListUpdatesChecker;", "listenersDisposable", "Lorg/jetbrains/annotations/NotNull;", "getNewPRDiffModel", "()Lorg/jetbrains/plugins/github/pullrequest/GHPRDiffRequestModel;", "getRepositoryDataService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "getSearchHolder", "()Lorg/jetbrains/plugins/github/pullrequest/search/GHPRSearchQueryHolder;", "getSecurityService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "dispose", "", "intellij.vcs.github"})
public final class GHPRDataContext
implements Disposable {
    private final Disposable listenersDisposable;
    @NotNull
    private final GHPRSearchQueryHolder searchHolder;
    @NotNull
    private final GHListLoader<GHPullRequestShort> listLoader;
    @NotNull
    private final GHPRListUpdatesChecker listUpdatesChecker;
    @NotNull
    private final GHPRDataProviderRepository dataProviderRepository;
    @NotNull
    private final GHPRSecurityService securityService;
    @NotNull
    private final GHPRRepositoryDataService repositoryDataService;
    @NotNull
    private final GHPRCreationService creationService;
    @NotNull
    private final GHPRDetailsService detailsService;
    @NotNull
    private final GHAvatarIconsProvider avatarIconsProvider;
    @NotNull
    private final GHPRFilesManager filesManager;
    @NotNull
    private final GHPRDiffRequestModel newPRDiffModel;

    public void dispose() {
        Disposer.dispose((Disposable)this.filesManager);
        Disposer.dispose((Disposable)this.listenersDisposable);
        Disposer.dispose((Disposable)this.dataProviderRepository);
        Disposer.dispose((Disposable)this.listLoader);
        Disposer.dispose((Disposable)this.listUpdatesChecker);
        Disposer.dispose((Disposable)this.repositoryDataService);
    }

    @NotNull
    public final GHPRSearchQueryHolder getSearchHolder() {
        return this.searchHolder;
    }

    @NotNull
    public final GHListLoader<GHPullRequestShort> getListLoader() {
        return this.listLoader;
    }

    @NotNull
    public final GHPRListUpdatesChecker getListUpdatesChecker() {
        return this.listUpdatesChecker;
    }

    @NotNull
    public final GHPRDataProviderRepository getDataProviderRepository() {
        return this.dataProviderRepository;
    }

    @NotNull
    public final GHPRSecurityService getSecurityService() {
        return this.securityService;
    }

    @NotNull
    public final GHPRRepositoryDataService getRepositoryDataService() {
        return this.repositoryDataService;
    }

    @NotNull
    public final GHPRCreationService getCreationService() {
        return this.creationService;
    }

    @NotNull
    public final GHPRDetailsService getDetailsService() {
        return this.detailsService;
    }

    @NotNull
    public final GHAvatarIconsProvider getAvatarIconsProvider() {
        return this.avatarIconsProvider;
    }

    @NotNull
    public final GHPRFilesManager getFilesManager() {
        return this.filesManager;
    }

    @NotNull
    public final GHPRDiffRequestModel getNewPRDiffModel() {
        return this.newPRDiffModel;
    }

    public GHPRDataContext(@NotNull GHPRSearchQueryHolder searchHolder, @NotNull GHListLoader<GHPullRequestShort> listLoader2, @NotNull GHPRListUpdatesChecker listUpdatesChecker, @NotNull GHPRDataProviderRepository dataProviderRepository2, @NotNull GHPRSecurityService securityService, @NotNull GHPRRepositoryDataService repositoryDataService, @NotNull GHPRCreationService creationService, @NotNull GHPRDetailsService detailsService, @NotNull GHAvatarIconsProvider avatarIconsProvider, @NotNull GHPRFilesManager filesManager, @NotNull GHPRDiffRequestModel newPRDiffModel) {
        Intrinsics.checkNotNullParameter((Object)searchHolder, (String)"searchHolder");
        Intrinsics.checkNotNullParameter(listLoader2, (String)"listLoader");
        Intrinsics.checkNotNullParameter((Object)listUpdatesChecker, (String)"listUpdatesChecker");
        Intrinsics.checkNotNullParameter((Object)dataProviderRepository2, (String)"dataProviderRepository");
        Intrinsics.checkNotNullParameter((Object)securityService, (String)"securityService");
        Intrinsics.checkNotNullParameter((Object)repositoryDataService, (String)"repositoryDataService");
        Intrinsics.checkNotNullParameter((Object)creationService, (String)"creationService");
        Intrinsics.checkNotNullParameter((Object)detailsService, (String)"detailsService");
        Intrinsics.checkNotNullParameter((Object)((Object)avatarIconsProvider), (String)"avatarIconsProvider");
        Intrinsics.checkNotNullParameter((Object)filesManager, (String)"filesManager");
        Intrinsics.checkNotNullParameter((Object)newPRDiffModel, (String)"newPRDiffModel");
        this.searchHolder = searchHolder;
        this.listLoader = listLoader2;
        this.listUpdatesChecker = listUpdatesChecker;
        this.dataProviderRepository = dataProviderRepository2;
        this.securityService = securityService;
        this.repositoryDataService = repositoryDataService;
        this.creationService = creationService;
        this.detailsService = detailsService;
        this.avatarIconsProvider = avatarIconsProvider;
        this.filesManager = filesManager;
        this.newPRDiffModel = newPRDiffModel;
        Disposable disposable = Disposer.newDisposable((String)"GH PR context listeners disposable");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"Disposer.newDisposable(\"\u2026xt listeners disposable\")");
        this.listenersDisposable = disposable;
        this.searchHolder.addQueryChangeListener(this.listenersDisposable, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.getListLoader().reset();
            }
        }));
        this.listLoader.addDataListener(this.listenersDisposable, new GHListLoader.ListDataListener(){

            @Override
            public void onDataAdded(int startIdx) {
                this.getListUpdatesChecker().start();
            }

            @Override
            public void onAllDataRemoved() {
                this.getListUpdatesChecker().stop();
            }

            @Override
            public void onDataUpdated(int idx) {
                GHListLoader.ListDataListener.DefaultImpls.onDataUpdated(this, idx);
            }

            @Override
            public void onDataRemoved(@NotNull Object data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                GHListLoader.ListDataListener.DefaultImpls.onDataRemoved(this, data);
            }
        });
        this.dataProviderRepository.addDetailsLoadedListener(this.listenersDisposable, (Function1<? super GHPullRequest, Unit>)((Function1)new Function1<GHPullRequest, Unit>(){

            public final void invoke(@NotNull GHPullRequest details2) {
                Intrinsics.checkNotNullParameter((Object)details2, (String)"details");
                this.getListLoader().updateData(details2);
                this.getFilesManager().updateTimelineFilePresentation(details2);
            }
        }));
        this.filesManager.addBeforeTimelineFileOpenedListener(this.listenersDisposable, (Function1<? super GHPRTimelineVirtualFile, Unit>)((Function1)new Function1<GHPRTimelineVirtualFile, Unit>(){

            public final void invoke(@NotNull GHPRTimelineVirtualFile file) {
                GHPullRequestShort details2;
                GHPullRequestShort gHPullRequestShort;
                Object v0;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
                    Iterable iterable = this.getListLoader().getLoadedData();
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (Object t : iterable2) {
                        GHPullRequestShort it = (GHPullRequestShort)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)file.getPullRequest().getId())) continue;
                        v0 = t;
                        break block3;
                    }
                    v0 = null;
                }
                if ((gHPullRequestShort = (GHPullRequestShort)v0) == null) {
                    Object object = this.getDataProviderRepository().findDataProvider(file.getPullRequest());
                    gHPullRequestShort = details2 = (GHPullRequestShort)(object != null && (object = object.getDetailsData()) != null ? object.getLoadedDetails() : null);
                }
                if (details2 != null) {
                    this.getFilesManager().updateTimelineFilePresentation(details2);
                }
            }
        }));
    }
}

