/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment.action;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.ui.codereview.diff.AddCommentGutterIconRenderer;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/action/GHPRCreateDiffCommentAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findRendererActionUnderCaret", "Lcom/intellij/openapi/actionSystem/AnAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isEnabledAndVisible", "", "update", "intellij.vcs.github"})
public final class GHPRCreateDiffCommentAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabledAndVisible(this.isEnabledAndVisible(e));
    }

    private final boolean isEnabledAndVisible(AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"e.getData(CommonDataKeys.EDITOR) ?: return false");
        Editor editor2 = editor;
        return this.findRendererActionUnderCaret(editor2) != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getRequiredData(CommonDataKeys.EDITOR);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(CommonDataKeys.EDITOR)");
        Editor editor = (Editor)object;
        AnAction anAction = this.findRendererActionUnderCaret(editor);
        if (anAction == null) {
            return;
        }
        AnAction action2 = anAction;
        ScrollingModel scrollingModel = editor.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModel, (String)"editor.scrollingModel");
        ScrollingModel scrollingModel2 = scrollingModel;
        scrollingModel2.scrollToCaret(ScrollType.MAKE_VISIBLE);
        scrollingModel2.runActionOnScrollingFinished(new Runnable(action2, editor, scrollingModel2, e){
            final /* synthetic */ AnAction $action;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ ScrollingModel $scrollingModel;
            final /* synthetic */ AnActionEvent $e;

            public final void run() {
                if (this.$action instanceof ActionGroup) {
                    CaretModel caretModel = this.$editor.getCaretModel();
                    Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                    Point point = this.$editor.visualPositionToXY(caretModel.getVisualPosition());
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"editor.visualPositionToX\u2026aretModel.visualPosition)");
                    Point point2 = point;
                    ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("ICON_NAVIGATION_SECONDARY_BUTTON", (ActionGroup)this.$action);
                    Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"ActionManager.getInstanc\u2026TOR_GUTTER_POPUP, action)");
                    actionPopupMenu.getComponent().show(this.$editor.getComponent(), point2.x, point2.y - this.$scrollingModel.getVerticalScrollOffset());
                } else {
                    ActionUtil.invokeAction((AnAction)this.$action, (Component)this.$editor.getComponent(), (String)"ICON_NAVIGATION", (InputEvent)this.$e.getInputEvent(), null);
                }
            }
            {
                this.$action = anAction;
                this.$editor = editor;
                this.$scrollingModel = scrollingModel;
                this.$e = anActionEvent;
            }
        });
    }

    private final AnAction findRendererActionUnderCaret(Editor editor) {
        EditorEx editorEx;
        Editor editor2 = editor;
        if (!(editor2 instanceof EditorEx)) {
            editor2 = null;
        }
        if ((editorEx = (EditorEx)editor2) == null || (editorEx = editorEx.getMarkupModel()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"(editor as? EditorEx)?.markupModel ?: return null");
        EditorEx markupModel = editorEx;
        CaretModel caretModel = ((EditorEx)editor).getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        LogicalPosition logicalPosition = caretModel.getLogicalPosition();
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"editor.caretModel.logicalPosition");
        LogicalPosition logicalPosition2 = logicalPosition;
        int line = logicalPosition2.line;
        int offset = editor.logicalPositionToOffset(logicalPosition2);
        CommonProcessors.FindProcessor<RangeHighlighterEx> findProcessor2 = new CommonProcessors.FindProcessor<RangeHighlighterEx>(line){
            final /* synthetic */ int $line;

            protected boolean accept(@NotNull RangeHighlighterEx t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                GutterIconRenderer gutterIconRenderer = t.getGutterIconRenderer();
                return gutterIconRenderer instanceof AddCommentGutterIconRenderer && ((AddCommentGutterIconRenderer)gutterIconRenderer).getLine() == this.$line;
            }
            {
                this.$line = $captured_local_variable$0;
            }
        };
        markupModel.processRangeHighlightersOverlappingWith(offset, offset, (Processor)findProcessor2);
        RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)findProcessor2.getFoundValue();
        if (rangeHighlighterEx == null || (rangeHighlighterEx = rangeHighlighterEx.getGutterIconRenderer()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"findProcessor.foundValue\u2026onRenderer ?: return null");
        RangeHighlighterEx renderer = rangeHighlighterEx;
        AnAction anAction = renderer.getClickAction();
        if (anAction == null) {
            anAction = (AnAction)renderer.getPopupMenuActions();
        }
        return anAction;
    }
}

