/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.accounts;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.authentication.accounts.AccountTokenChangedListener;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0007RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider;", "", "()V", "informationCache", "Lcom/google/common/cache/Cache;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;", "getInformation", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "account", "AccountTokenListener", "Companion", "intellij.vcs.github"})
public final class GithubAccountInformationProvider {
    private final Cache<GithubAccount, GithubAuthenticatedUser> informationCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();
    @NotNull
    public static final Companion Companion = new Companion(null);

    @RequiresBackgroundThread
    @NotNull
    public final GithubAuthenticatedUser getInformation(@NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator, @NotNull GithubAccount account) throws IOException {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Object object = this.informationCache.get((Object)account, (Callable)new Callable<GithubAuthenticatedUser>(executor, indicator, account){
            final /* synthetic */ GithubApiRequestExecutor $executor;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ GithubAccount $account;

            public final GithubAuthenticatedUser call() {
                GithubServerPath githubServerPath = this.$account.getServer();
                Intrinsics.checkNotNullExpressionValue((Object)githubServerPath, (String)"account.server");
                return this.$executor.execute(this.$indicator, GithubApiRequests.CurrentUser.get(githubServerPath));
            }
            {
                this.$executor = githubApiRequestExecutor;
                this.$indicator = progressIndicator;
                this.$account = githubAccount;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"informationCache.get(acc\u2026er.get(account.server)) }");
        return (GithubAuthenticatedUser)object;
    }

    @JvmStatic
    @NotNull
    public static final GithubAccountInformationProvider getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider$AccountTokenListener;", "Lorg/jetbrains/plugins/github/authentication/accounts/AccountTokenChangedListener;", "()V", "tokenChanged", "", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "intellij.vcs.github"})
    public static final class AccountTokenListener
    implements AccountTokenChangedListener {
        @Override
        public void tokenChanged(@NotNull GithubAccount account) {
            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
            Companion.getInstance().informationCache.invalidate((Object)account);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final GithubAccountInformationProvider getInstance() {
            boolean $i$f$service = false;
            Class<GithubAccountInformationProvider> serviceClass$iv = GithubAccountInformationProvider.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (GithubAccountInformationProvider)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

