/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import java.awt.Image;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubApiResponse;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHBranchProtectionRules;
import org.jetbrains.plugins.github.api.data.GHCommitsCompareResult;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubAuthorization;
import org.jetbrains.plugins.github.api.data.GithubBranch;
import org.jetbrains.plugins.github.api.data.GithubGist;
import org.jetbrains.plugins.github.api.data.GithubIssue;
import org.jetbrains.plugins.github.api.data.GithubIssueCommentWithHtml;
import org.jetbrains.plugins.github.api.data.GithubIssueLabel;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.data.GithubOrg;
import org.jetbrains.plugins.github.api.data.GithubPullRequestDetailed;
import org.jetbrains.plugins.github.api.data.GithubPullRequestMergeMethod;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.api.data.GithubResponsePage;
import org.jetbrains.plugins.github.api.data.GithubSearchedIssue;
import org.jetbrains.plugins.github.api.data.GithubUser;
import org.jetbrains.plugins.github.api.data.GithubUserWithPermissions;
import org.jetbrains.plugins.github.api.data.request.Affiliation;
import org.jetbrains.plugins.github.api.data.request.GithubAssigneesCollectionRequest;
import org.jetbrains.plugins.github.api.data.request.GithubAuthorizationCreateRequest;
import org.jetbrains.plugins.github.api.data.request.GithubChangeIssueStateRequest;
import org.jetbrains.plugins.github.api.data.request.GithubCreateIssueCommentRequest;
import org.jetbrains.plugins.github.api.data.request.GithubCreateIssueRequest;
import org.jetbrains.plugins.github.api.data.request.GithubGistRequest;
import org.jetbrains.plugins.github.api.data.request.GithubLabelsCollectionRequest;
import org.jetbrains.plugins.github.api.data.request.GithubPullRequestMergeRebaseRequest;
import org.jetbrains.plugins.github.api.data.request.GithubPullRequestMergeRequest;
import org.jetbrains.plugins.github.api.data.request.GithubPullRequestRequest;
import org.jetbrains.plugins.github.api.data.request.GithubPullUpdateRequest;
import org.jetbrains.plugins.github.api.data.request.GithubRepoRequest;
import org.jetbrains.plugins.github.api.data.request.GithubRequestPagination;
import org.jetbrains.plugins.github.api.data.request.GithubReviewersCollectionRequest;
import org.jetbrains.plugins.github.api.data.request.Type;
import org.jetbrains.plugins.github.api.data.request.Visibility;
import org.jetbrains.plugins.github.api.util.GHSchemaPreview;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.api.util.GithubApiSearchQueryBuilder;
import org.jetbrains.plugins.github.api.util.GithubApiUrlQueryBuilder;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0007\u0011\u0012\u0013\u0014\u0015\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\"\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0007J)\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\"\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\fJ'\u0010\b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\"\u00020\u0004\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests;", "", "()V", "getQuery", "", "queryParts", "", "([Ljava/lang/String;)Ljava/lang/String;", "getUrl", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "suffixes", "(Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;[Ljava/lang/String;)Ljava/lang/String;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "(Lorg/jetbrains/plugins/github/api/GithubServerPath;[Ljava/lang/String;)Ljava/lang/String;", "suffix", "Auth", "CurrentUser", "Entity", "Gists", "Organisations", "Repos", "Search", "intellij.vcs.github"})
public final class GithubApiRequests {
    @NotNull
    public static final GithubApiRequests INSTANCE;

    private final String getUrl(GithubServerPath server, String suffix) {
        return server.toApiUrl() + suffix;
    }

    private final String getUrl(GHRepositoryCoordinates repository, String ... suffixes) {
        GithubServerPath githubServerPath = repository.getServerPath();
        SpreadBuilder spreadBuilder = new SpreadBuilder(4);
        spreadBuilder.add((Object)Repos.INSTANCE.getUrlSuffix());
        spreadBuilder.add((Object)"/");
        spreadBuilder.add((Object)repository.getRepositoryPath().toString());
        spreadBuilder.addSpread((Object)suffixes);
        return this.getUrl(githubServerPath, (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
    }

    @NotNull
    public final String getUrl(@NotNull GithubServerPath server, String ... suffixes) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)suffixes, (String)"suffixes");
        String string = StringsKt.append((StringBuilder)new StringBuilder(server.toApiUrl()), (String[])Arrays.copyOf(suffixes, suffixes.length)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(server.toA\u2026end(*suffixes).toString()");
        return string;
    }

    private final String getQuery(String ... queryParts) {
        StringBuilder builder = new StringBuilder();
        for (String part : queryParts) {
            CharSequence charSequence = part;
            boolean bl = false;
            if (charSequence.length() == 0) continue;
            charSequence = builder;
            bl = false;
            if (charSequence.length() == 0) {
                builder.append("?");
            } else {
                builder.append("&");
            }
            builder.append(part);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private GithubApiRequests() {
    }

    static {
        GithubApiRequests githubApiRequests;
        INSTANCE = githubApiRequests = new GithubApiRequests();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\f\r\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$CurrentUser;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;", "url", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "getAvatar", "Ljava/awt/Image;", "Orgs", "RepoSubs", "Repos", "intellij.vcs.github"})
    public static final class CurrentUser
    extends Entity {
        @NotNull
        public static final CurrentUser INSTANCE;

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubAuthenticatedUser> get(@NotNull GithubServerPath server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            return CurrentUser.get(INSTANCE.getUrl(server, CurrentUser.INSTANCE.getUrlSuffix()));
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubAuthenticatedUser> get(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
            String acceptMimeType$iv = null;
            boolean $i$f$json = false;
            return ((GithubApiRequest.Get)new GithubApiRequest.Get.Json<GithubAuthenticatedUser>(url, GithubAuthenticatedUser.class, acceptMimeType$iv)).withOperationName("get profile information");
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<Image> getAvatar(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new GithubApiRequest.Get<Image>(url, url){
                final /* synthetic */ String $url;

                @NotNull
                public Image extractResult(@NotNull GithubApiResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    T t = response.handleBody(getAvatar.extractResult.1.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue(t, (String)"response.handleBody(Thro\u2026.loadImage(it)\n        })");
                    return (Image)t;
                }
                {
                    this.$url = $captured_local_variable$0;
                    super($super_call_param$1, null, 2, null);
                }
            }.withOperationName("get profile avatar");
        }

        private CurrentUser() {
            super("/user");
        }

        static {
            CurrentUser currentUser;
            INSTANCE = currentUser = new CurrentUser();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J?\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\fH\u0007\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00100\u00042\u0006\u0010\u0011\u001a\u00020\tH\u0007JF\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00100\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007J@\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$CurrentUser$Repos;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubRepo;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "name", "", "description", "private", "", "autoInit", "(Lorg/jetbrains/plugins/github/api/GithubServerPath;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/Boolean;)Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "get", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "url", "type", "Lorg/jetbrains/plugins/github/api/data/request/Type;", "visibility", "Lorg/jetbrains/plugins/github/api/data/request/Visibility;", "affiliation", "Lorg/jetbrains/plugins/github/api/data/request/Affiliation;", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
        public static final class Repos
        extends Entity {
            @NotNull
            public static final Repos INSTANCE;

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server, @NotNull Type type, @NotNull Visibility visibility, @NotNull Affiliation affiliation, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                Intrinsics.checkNotNullParameter((Object)((Object)visibility), (String)"visibility");
                Intrinsics.checkNotNullParameter((Object)affiliation, (String)"affiliation");
                return new GithubApiPagesLoader.Request<GithubRepo>(Repos.get(server, type, visibility, affiliation, pagination), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubRepo>>>(INSTANCE){

                    @NotNull
                    public final GithubApiRequest<GithubResponsePage<GithubRepo>> invoke(@NotNull String p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        Repos cfr_ignored_0 = (Repos)this.receiver;
                        return Repos.get(p1);
                    }
                });
            }

            public static /* synthetic */ GithubApiPagesLoader.Request pages$default(GithubServerPath githubServerPath, Type type, Visibility visibility, Affiliation affiliation, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 2) != 0) {
                    type = Type.Companion.getDEFAULT();
                }
                if ((n & 4) != 0) {
                    visibility = Visibility.Companion.getDEFAULT();
                }
                if ((n & 8) != 0) {
                    affiliation = Affiliation.Companion.getDEFAULT();
                }
                if ((n & 0x10) != 0) {
                    githubRequestPagination = null;
                }
                return Repos.pages(githubServerPath, type, visibility, affiliation, githubRequestPagination);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server, @NotNull Type type, @NotNull Visibility visibility, @NotNull Affiliation affiliation) {
                return Repos.pages$default(server, type, visibility, affiliation, null, 16, null);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server, @NotNull Type type, @NotNull Visibility visibility) {
                return Repos.pages$default(server, type, visibility, null, null, 24, null);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server, @NotNull Type type) {
                return Repos.pages$default(server, type, null, null, null, 28, null);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server) {
                return Repos.pages$default(server, null, null, null, null, 30, null);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @NotNull Type type, @NotNull Visibility visibility, @NotNull Affiliation affiliation, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                Intrinsics.checkNotNullParameter((Object)((Object)visibility), (String)"visibility");
                Intrinsics.checkNotNullParameter((Object)affiliation, (String)"affiliation");
                if (type != Type.Companion.getDEFAULT() && (visibility != Visibility.Companion.getDEFAULT() || Intrinsics.areEqual((Object)affiliation, (Object)Affiliation.Companion.getDEFAULT()) ^ true)) {
                    throw (Throwable)new IllegalArgumentException("Param 'type' should not be used together with 'visibility' or 'affiliation'");
                }
                String[] stringArray = new String[3];
                stringArray[0] = INSTANCE.getUrlSuffix();
                stringArray[1] = INSTANCE.getUrlSuffix();
                String[] stringArray2 = new String[4];
                stringArray2[0] = type.toString();
                stringArray2[1] = visibility.toString();
                stringArray2[2] = affiliation.toString();
                GithubRequestPagination githubRequestPagination = pagination;
                String string = githubRequestPagination != null ? githubRequestPagination.toString() : null;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                stringArray2[3] = string2;
                stringArray[2] = GithubApiRequests.INSTANCE.getQuery(stringArray2);
                return Repos.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, Type type, Visibility visibility, Affiliation affiliation, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 2) != 0) {
                    type = Type.Companion.getDEFAULT();
                }
                if ((n & 4) != 0) {
                    visibility = Visibility.Companion.getDEFAULT();
                }
                if ((n & 8) != 0) {
                    affiliation = Affiliation.Companion.getDEFAULT();
                }
                if ((n & 0x10) != 0) {
                    githubRequestPagination = null;
                }
                return Repos.get(githubServerPath, type, visibility, affiliation, githubRequestPagination);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @NotNull Type type, @NotNull Visibility visibility, @NotNull Affiliation affiliation) {
                return Repos.get$default(server, type, visibility, affiliation, null, 16, null);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @NotNull Type type, @NotNull Visibility visibility) {
                return Repos.get$default(server, type, visibility, null, null, 24, null);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @NotNull Type type) {
                return Repos.get$default(server, type, null, null, null, 28, null);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server) {
                return Repos.get$default(server, null, null, null, null, 30, null);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubRepo>(url, GithubRepo.class, acceptMimeType$iv)).withOperationName("get user repositories");
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubRepo> create(@NotNull GithubServerPath server, @NotNull String name, @NotNull String description, boolean bl, @Nullable Boolean autoInit) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                GithubApiRequest.Post.Companion companion = GithubApiRequest.Post.Companion;
                String string = GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), INSTANCE.getUrlSuffix());
                GithubRepoRequest githubRepoRequest = new GithubRepoRequest(name, description, bl, autoInit);
                String acceptMimeType$iv = null;
                boolean $i$f$json = false;
                return ((GithubApiRequest.Post)new GithubApiRequest.Post.Json<GithubRepo>((String)url$iv, body$iv, GithubRepo.class, acceptMimeType$iv)).withOperationName("create user repository");
            }

            public static /* synthetic */ GithubApiRequest create$default(GithubServerPath githubServerPath, String string, String string2, boolean bl, Boolean bl2, int n, Object object) {
                if ((n & 0x10) != 0) {
                    bl2 = null;
                }
                return Repos.create(githubServerPath, string, string2, bl, bl2);
            }

            private Repos() {
                super("/repos");
            }

            static {
                Repos repos;
                INSTANCE = repos = new Repos();
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$CurrentUser$Orgs;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "Lorg/jetbrains/plugins/github/api/data/GithubOrg;", "url", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
        public static final class Orgs
        extends Entity {
            @NotNull
            public static final Orgs INSTANCE;

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubOrg> pages(@NotNull GithubServerPath server, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return new GithubApiPagesLoader.Request<GithubOrg>(INSTANCE.get(server, pagination), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubOrg>>>(INSTANCE){

                    @NotNull
                    public final GithubApiRequest<GithubResponsePage<GithubOrg>> invoke(@NotNull String p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return ((Orgs)this.receiver).get(p1);
                    }
                });
            }

            public static /* synthetic */ GithubApiPagesLoader.Request pages$default(GithubServerPath githubServerPath, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 2) != 0) {
                    githubRequestPagination = null;
                }
                return Orgs.pages(githubServerPath, githubRequestPagination);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubOrg> pages(@NotNull GithubServerPath server) {
                return Orgs.pages$default(server, null, 2, null);
            }

            @NotNull
            public final GithubApiRequest<GithubResponsePage<GithubOrg>> get(@NotNull GithubServerPath server, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                String[] stringArray = new String[3];
                stringArray[0] = INSTANCE.getUrlSuffix();
                stringArray[1] = this.getUrlSuffix();
                String[] stringArray2 = new String[1];
                GithubRequestPagination githubRequestPagination = pagination;
                String string = githubRequestPagination != null ? githubRequestPagination.toString() : null;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                stringArray2[0] = string2;
                stringArray[2] = GithubApiRequests.INSTANCE.getQuery(stringArray2);
                return this.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(Orgs orgs, GithubServerPath githubServerPath, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 2) != 0) {
                    githubRequestPagination = null;
                }
                return orgs.get(githubServerPath, githubRequestPagination);
            }

            @NotNull
            public final GithubApiRequest<GithubResponsePage<GithubOrg>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubOrg>(url, GithubOrg.class, acceptMimeType$iv)).withOperationName("get user organizations");
            }

            private Orgs() {
                super("/orgs");
            }

            static {
                Orgs orgs;
                INSTANCE = orgs = new Orgs();
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J(\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$CurrentUser$RepoSubs;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "Lorg/jetbrains/plugins/github/api/data/GithubRepo;", "url", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
        public static final class RepoSubs
        extends Entity {
            @NotNull
            public static final RepoSubs INSTANCE;

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return new GithubApiPagesLoader.Request<GithubRepo>(RepoSubs.get$default(server, null, 2, null), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubRepo>>>(INSTANCE){

                    @NotNull
                    public final GithubApiRequest<GithubResponsePage<GithubRepo>> invoke(@NotNull String p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        RepoSubs cfr_ignored_0 = (RepoSubs)this.receiver;
                        return RepoSubs.get(p1);
                    }
                });
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                String[] stringArray = new String[3];
                stringArray[0] = INSTANCE.getUrlSuffix();
                stringArray[1] = INSTANCE.getUrlSuffix();
                String[] stringArray2 = new String[1];
                GithubRequestPagination githubRequestPagination = pagination;
                String string = githubRequestPagination != null ? githubRequestPagination.toString() : null;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                stringArray2[0] = string2;
                stringArray[2] = GithubApiRequests.INSTANCE.getQuery(stringArray2);
                return RepoSubs.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 2) != 0) {
                    githubRequestPagination = null;
                }
                return RepoSubs.get(githubServerPath, githubRequestPagination);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server) {
                return RepoSubs.get$default(server, null, 2, null);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubRepo>(url, GithubRepo.class, acceptMimeType$iv)).withOperationName("get repository subscriptions");
            }

            private RepoSubs() {
                super("/subscriptions");
            }

            static {
                RepoSubs repoSubs;
                INSTANCE = repoSubs = new RepoSubs();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Organisations;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "Repos", "intellij.vcs.github"})
    public static final class Organisations
    extends Entity {
        @NotNull
        public static final Organisations INSTANCE;

        private Organisations() {
            super("/orgs");
        }

        static {
            Organisations organisations;
            INSTANCE = organisations = new Organisations();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0007J\u001c\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000f0\u00042\u0006\u0010\u0010\u001a\u00020\tH\u0007J0\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J*\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Organisations$Repos;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubRepo;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "organisation", "", "name", "description", "private", "", "get", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "url", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
        public static final class Repos
        extends Entity {
            @NotNull
            public static final Repos INSTANCE;

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server, @NotNull String organisation, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)organisation, (String)"organisation");
                return new GithubApiPagesLoader.Request<GithubRepo>(Repos.get(server, organisation, pagination), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubRepo>>>(INSTANCE){

                    @NotNull
                    public final GithubApiRequest<GithubResponsePage<GithubRepo>> invoke(@NotNull String p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        Repos cfr_ignored_0 = (Repos)this.receiver;
                        return Repos.get(p1);
                    }
                });
            }

            public static /* synthetic */ GithubApiPagesLoader.Request pages$default(GithubServerPath githubServerPath, String string, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 4) != 0) {
                    githubRequestPagination = null;
                }
                return Repos.pages(githubServerPath, string, githubRequestPagination);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @NotNull String organisation, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)organisation, (String)"organisation");
                String[] stringArray = new String[5];
                stringArray[0] = INSTANCE.getUrlSuffix();
                stringArray[1] = "/";
                stringArray[2] = organisation;
                stringArray[3] = INSTANCE.getUrlSuffix();
                String[] stringArray2 = new String[1];
                GithubRequestPagination githubRequestPagination = pagination;
                String string = githubRequestPagination != null ? githubRequestPagination.toString() : null;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                stringArray2[0] = string2;
                stringArray[4] = GithubApiRequests.INSTANCE.getQuery(stringArray2);
                return Repos.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 4) != 0) {
                    githubRequestPagination = null;
                }
                return Repos.get(githubServerPath, string, githubRequestPagination);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @NotNull String organisation) {
                return Repos.get$default(server, organisation, null, 4, null);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubRepo>(url, GithubRepo.class, acceptMimeType$iv)).withOperationName("get organisation repositories");
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubRepo> create(@NotNull GithubServerPath server, @NotNull String organisation, @NotNull String name, @NotNull String description, boolean bl) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)organisation, (String)"organisation");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                GithubApiRequest.Post.Companion companion = GithubApiRequest.Post.Companion;
                String string = GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), "/", organisation, INSTANCE.getUrlSuffix());
                GithubRepoRequest githubRepoRequest = new GithubRepoRequest(name, description, bl, null);
                String acceptMimeType$iv = null;
                boolean $i$f$json = false;
                return ((GithubApiRequest.Post)new GithubApiRequest.Post.Json<GithubRepo>((String)url$iv, body$iv, GithubRepo.class, acceptMimeType$iv)).withOperationName("create organisation repository");
            }

            private Repos() {
                super("/repos");
            }

            static {
                Repos repos;
                INSTANCE = repos = new Repos();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\b\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0007J(\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "delete", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "", "url", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "repoName", "get", "Lorg/jetbrains/plugins/github/api/data/GithubRepoDetailed;", "Assignees", "Branches", "Collaborators", "Commits", "Forks", "Issues", "Labels", "PullRequests", "intellij.vcs.github"})
    public static final class Repos
    extends Entity {
        @NotNull
        public static final Repos INSTANCE;

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubRepoDetailed> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
            GithubApiRequest.Get.Optional.Companion companion = GithubApiRequest.Get.Optional.Companion;
            String url$iv = INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName);
            String acceptMimeType$iv = null;
            boolean $i$f$json = false;
            return ((GithubApiRequest.Get.Optional)new GithubApiRequest.Get.Optional.Json<GithubRepoDetailed>(url$iv, GithubRepoDetailed.class, acceptMimeType$iv)).withOperationName("get information for repository " + username + '/' + repoName);
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<Unit> delete(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
            return Repos.delete(INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName)).withOperationName("delete repository " + username + '/' + repoName);
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<Unit> delete(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            GithubApiRequest.Delete.Companion this_$iv = GithubApiRequest.Delete.Companion;
            Object body$iv = null;
            boolean $i$f$json = false;
            return ((GithubApiRequest.Delete)new GithubApiRequest.Delete.Json<Unit>(url, body$iv, Unit.class)).withOperationName("delete repository at " + url);
        }

        private Repos() {
            super("/repos");
        }

        static {
            Repos repos;
            INSTANCE = repos = new Repos();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J8\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0007J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Branches;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "Lorg/jetbrains/plugins/github/api/data/GithubBranch;", "url", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "repoName", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "getProtection", "Lorg/jetbrains/plugins/github/api/data/GHBranchProtectionRules;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "branchName", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
        public static final class Branches
        extends Entity {
            @NotNull
            public static final Branches INSTANCE;

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubBranch> pages(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return new GithubApiPagesLoader.Request<GithubBranch>(Branches.get$default(server, username, repoName, null, 8, null), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubBranch>>>(INSTANCE){

                    @NotNull
                    public final GithubApiRequest<GithubResponsePage<GithubBranch>> invoke(@NotNull String p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        Branches cfr_ignored_0 = (Branches)this.receiver;
                        return Branches.get(p1);
                    }
                });
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubBranch>> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                String[] stringArray = new String[4];
                stringArray[0] = INSTANCE.getUrlSuffix();
                stringArray[1] = '/' + username + '/' + repoName;
                stringArray[2] = INSTANCE.getUrlSuffix();
                String[] stringArray2 = new String[1];
                GithubRequestPagination githubRequestPagination = pagination;
                String string = githubRequestPagination != null ? githubRequestPagination.toString() : null;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                stringArray2[0] = string2;
                stringArray[3] = GithubApiRequests.INSTANCE.getQuery(stringArray2);
                return Branches.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 8) != 0) {
                    githubRequestPagination = null;
                }
                return Branches.get(githubServerPath, string, string2, githubRequestPagination);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubBranch>> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
                return Branches.get$default(server, username, repoName, null, 8, null);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubBranch>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubBranch>(url, GithubBranch.class, acceptMimeType$iv)).withOperationName("get branches");
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GHBranchProtectionRules> getProtection(@NotNull GHRepositoryCoordinates repository, @NotNull String branchName) {
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
                GithubApiRequest.Get.Companion companion = GithubApiRequest.Get.Companion;
                String string = GithubApiRequests.INSTANCE.getUrl(repository, Branches.INSTANCE.getUrlSuffix());
                String acceptMimeType$iv = GHSchemaPreview.BRANCH_PROTECTION.getMimeType();
                boolean $i$f$json = false;
                return new GithubApiRequest.Get.Json<GHBranchProtectionRules>((String)url$iv, GHBranchProtectionRules.class, acceptMimeType$iv);
            }

            private Branches() {
                super("/branches");
            }

            static {
                Branches branches;
                INSTANCE = branches = new Branches();
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0007J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Commits;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "compare", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GHCommitsCompareResult;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "refA", "", "refB", "getDiff", "ref", "intellij.vcs.github"})
        public static final class Commits
        extends Entity {
            @NotNull
            public static final Commits INSTANCE;

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GHCommitsCompareResult> compare(@NotNull GHRepositoryCoordinates repository, @NotNull String refA, @NotNull String refB) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Intrinsics.checkNotNullParameter((Object)refA, (String)"refA");
                Intrinsics.checkNotNullParameter((Object)refB, (String)"refB");
                GithubApiRequest.Get.Companion companion = GithubApiRequest.Get.Companion;
                String url$iv = GithubApiRequests.INSTANCE.getUrl(repository, "/compare/" + refA + "..." + refB);
                String acceptMimeType$iv = null;
                boolean $i$f$json = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.Json<GHCommitsCompareResult>(url$iv, GHCommitsCompareResult.class, acceptMimeType$iv)).withOperationName("compare refs");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<String> getDiff(@NotNull GHRepositoryCoordinates repository, @NotNull String ref) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                return new GithubApiRequest.Get<String>(INSTANCE, repository, ref, GithubApiRequests.INSTANCE.getUrl(repository, Commits.INSTANCE.getUrlSuffix()), "application/vnd.github.v3.diff+json"){
                    final /* synthetic */ Commits this$0;
                    final /* synthetic */ GHRepositoryCoordinates $repository;
                    final /* synthetic */ String $ref;

                    @NotNull
                    public String extractResult(@NotNull GithubApiResponse response) {
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        T t = response.handleBody(getDiff.extractResult.1.INSTANCE);
                        Intrinsics.checkNotNullExpressionValue(t, (String)"response.handleBody(Thro\u2026adText() }\n            })");
                        return (String)t;
                    }
                    {
                        this.this$0 = this$0;
                        this.$repository = $captured_local_variable$1;
                        this.$ref = $captured_local_variable$2;
                        super($super_call_param$3, $super_call_param$4);
                    }
                }.withOperationName("get diff for ref");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<String> getDiff(@NotNull GHRepositoryCoordinates repository, @NotNull String refA, @NotNull String refB) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Intrinsics.checkNotNullParameter((Object)refA, (String)"refA");
                Intrinsics.checkNotNullParameter((Object)refB, (String)"refB");
                return new GithubApiRequest.Get<String>(repository, refA, refB, GithubApiRequests.INSTANCE.getUrl(repository, "/compare/" + refA + "..." + refB), "application/vnd.github.v3.diff+json"){
                    final /* synthetic */ GHRepositoryCoordinates $repository;
                    final /* synthetic */ String $refA;
                    final /* synthetic */ String $refB;

                    @NotNull
                    public String extractResult(@NotNull GithubApiResponse response) {
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        T t = response.handleBody(Repos.Commits.getDiff.extractResult.1.INSTANCE);
                        Intrinsics.checkNotNullExpressionValue(t, (String)"response.handleBody(Thro\u2026adText() }\n            })");
                        return (String)t;
                    }
                    {
                        this.$repository = $captured_local_variable$0;
                        this.$refA = $captured_local_variable$1;
                        this.$refB = $captured_local_variable$2;
                        super($super_call_param$3, $super_call_param$4);
                    }
                }.withOperationName("get diff between refs");
            }

            private Commits() {
                super("/commits");
            }

            static {
                Commits commits;
                INSTANCE = commits = new Commits();
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J\u001c\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\f0\u00042\u0006\u0010\r\u001a\u00020\tH\u0007J8\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Forks;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubRepo;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "get", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "url", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
        public static final class Forks
        extends Entity {
            @NotNull
            public static final Forks INSTANCE;

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubRepo> create(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                GithubApiRequest.Post.Companion companion = GithubApiRequest.Post.Companion;
                String string = GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix());
                Object body$iv = new Object();
                String acceptMimeType$iv = null;
                boolean $i$f$json = false;
                return ((GithubApiRequest.Post)new GithubApiRequest.Post.Json<GithubRepo>((String)url$iv, body$iv, GithubRepo.class, acceptMimeType$iv)).withOperationName("fork repository " + username + '/' + repoName + " for cuurent user");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return new GithubApiPagesLoader.Request<GithubRepo>(Forks.get$default(server, username, repoName, null, 8, null), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubRepo>>>(INSTANCE){

                    @NotNull
                    public final GithubApiRequest<GithubResponsePage<GithubRepo>> invoke(@NotNull String p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        Forks cfr_ignored_0 = (Forks)this.receiver;
                        return Forks.get(p1);
                    }
                });
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                String[] stringArray = new String[4];
                stringArray[0] = INSTANCE.getUrlSuffix();
                stringArray[1] = '/' + username + '/' + repoName;
                stringArray[2] = INSTANCE.getUrlSuffix();
                String[] stringArray2 = new String[1];
                GithubRequestPagination githubRequestPagination = pagination;
                String string = githubRequestPagination != null ? githubRequestPagination.toString() : null;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                stringArray2[0] = string2;
                stringArray[3] = GithubApiRequests.INSTANCE.getQuery(stringArray2);
                return Forks.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 8) != 0) {
                    githubRequestPagination = null;
                }
                return Forks.get(githubServerPath, string, string2, githubRequestPagination);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
                return Forks.get$default(server, username, repoName, null, 8, null);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubRepo>(url, GithubRepo.class, acceptMimeType$iv)).withOperationName("get forks");
            }

            private Forks() {
                super("/forks");
            }

            static {
                Forks forks;
                INSTANCE = forks = new Forks();
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J8\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Assignees;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "Lorg/jetbrains/plugins/github/api/data/GithubUser;", "url", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "repoName", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
        public static final class Assignees
        extends Entity {
            @NotNull
            public static final Assignees INSTANCE;

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubUser> pages(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return new GithubApiPagesLoader.Request<GithubUser>(Assignees.get$default(server, username, repoName, null, 8, null), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubUser>>>(INSTANCE){

                    @NotNull
                    public final GithubApiRequest<GithubResponsePage<GithubUser>> invoke(@NotNull String p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        Assignees cfr_ignored_0 = (Assignees)this.receiver;
                        return Assignees.get(p1);
                    }
                });
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubUser>> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                String[] stringArray = new String[4];
                stringArray[0] = INSTANCE.getUrlSuffix();
                stringArray[1] = '/' + username + '/' + repoName;
                stringArray[2] = INSTANCE.getUrlSuffix();
                String[] stringArray2 = new String[1];
                GithubRequestPagination githubRequestPagination = pagination;
                String string = githubRequestPagination != null ? githubRequestPagination.toString() : null;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                stringArray2[0] = string2;
                stringArray[3] = GithubApiRequests.INSTANCE.getQuery(stringArray2);
                return Assignees.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 8) != 0) {
                    githubRequestPagination = null;
                }
                return Assignees.get(githubServerPath, string, string2, githubRequestPagination);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubUser>> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
                return Assignees.get$default(server, username, repoName, null, 8, null);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubUser>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubUser>(url, GithubUser.class, acceptMimeType$iv)).withOperationName("get assignees");
            }

            private Assignees() {
                super("/assignees");
            }

            static {
                Assignees assignees;
                INSTANCE = assignees = new Assignees();
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J8\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Labels;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "Lorg/jetbrains/plugins/github/api/data/GithubIssueLabel;", "url", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "repoName", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
        public static final class Labels
        extends Entity {
            @NotNull
            public static final Labels INSTANCE;

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubIssueLabel> pages(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return new GithubApiPagesLoader.Request<GithubIssueLabel>(Labels.get$default(server, username, repoName, null, 8, null), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubIssueLabel>>>(INSTANCE){

                    @NotNull
                    public final GithubApiRequest<GithubResponsePage<GithubIssueLabel>> invoke(@NotNull String p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        Labels cfr_ignored_0 = (Labels)this.receiver;
                        return Labels.get(p1);
                    }
                });
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubIssueLabel>> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                String[] stringArray = new String[4];
                stringArray[0] = INSTANCE.getUrlSuffix();
                stringArray[1] = '/' + username + '/' + repoName;
                stringArray[2] = INSTANCE.getUrlSuffix();
                String[] stringArray2 = new String[1];
                GithubRequestPagination githubRequestPagination = pagination;
                String string = githubRequestPagination != null ? githubRequestPagination.toString() : null;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                stringArray2[0] = string2;
                stringArray[3] = GithubApiRequests.INSTANCE.getQuery(stringArray2);
                return Labels.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 8) != 0) {
                    githubRequestPagination = null;
                }
                return Labels.get(githubServerPath, string, string2, githubRequestPagination);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubIssueLabel>> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
                return Labels.get$default(server, username, repoName, null, 8, null);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubIssueLabel>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubIssueLabel>(url, GithubIssueLabel.class, acceptMimeType$iv)).withOperationName("get assignees");
            }

            private Labels() {
                super("/labels");
            }

            static {
                Labels labels;
                INSTANCE = labels = new Labels();
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0007J\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\tH\u0007J8\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Collaborators;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "add", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put;", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "collaborator", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "Lorg/jetbrains/plugins/github/api/data/GithubUserWithPermissions;", "url", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
        public static final class Collaborators
        extends Entity {
            @NotNull
            public static final Collaborators INSTANCE;

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubUserWithPermissions> pages(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return new GithubApiPagesLoader.Request<GithubUserWithPermissions>(Collaborators.get$default(server, username, repoName, null, 8, null), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubUserWithPermissions>>>(INSTANCE){

                    @NotNull
                    public final GithubApiRequest<GithubResponsePage<GithubUserWithPermissions>> invoke(@NotNull String p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        Collaborators cfr_ignored_0 = (Collaborators)this.receiver;
                        return Collaborators.get(p1);
                    }
                });
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubUserWithPermissions>> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                String[] stringArray = new String[4];
                stringArray[0] = INSTANCE.getUrlSuffix();
                stringArray[1] = '/' + username + '/' + repoName;
                stringArray[2] = INSTANCE.getUrlSuffix();
                String[] stringArray2 = new String[1];
                GithubRequestPagination githubRequestPagination = pagination;
                String string = githubRequestPagination != null ? githubRequestPagination.toString() : null;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                stringArray2[0] = string2;
                stringArray[3] = GithubApiRequests.INSTANCE.getQuery(stringArray2);
                return Collaborators.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 8) != 0) {
                    githubRequestPagination = null;
                }
                return Collaborators.get(githubServerPath, string, string2, githubRequestPagination);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubUserWithPermissions>> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName) {
                return Collaborators.get$default(server, username, repoName, null, 8, null);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubUserWithPermissions>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubUserWithPermissions>(url, GithubUserWithPermissions.class, acceptMimeType$iv)).withOperationName("get collaborators");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest.Put<Unit> add(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @NotNull String collaborator) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                Intrinsics.checkNotNullParameter((Object)collaborator, (String)"collaborator");
                GithubApiRequest.Put.Companion companion = GithubApiRequest.Put.Companion;
                String url$iv = GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix(), "/", collaborator);
                Object body$iv = null;
                boolean $i$f$json = false;
                return new GithubApiRequest.Put.Json<Unit>(url$iv, body$iv, Unit.class);
            }

            private Collaborators() {
                super("/collaborators");
            }

            static {
                Collaborators collaborators2;
                INSTANCE = collaborators2 = new Collaborators();
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002$%B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jo\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0010\b\u0002\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00102\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0010H\u0007\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00150\u00142\u0006\u0010\u0016\u001a\u00020\tH\u0007J.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0007JP\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00150\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0007J>\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\tH\u0007J<\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0 H\u0007J6\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0007\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Issues;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "Lorg/jetbrains/plugins/github/api/data/GithubIssue;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "title", "body", "milestone", "", "labels", "", "assignees", "(Lorg/jetbrains/plugins/github/api/GithubServerPath;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/util/List;Ljava/util/List;)Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "url", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional;", "id", "state", "assignee", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "updateAssignees", "", "updateState", "open", "", "Comments", "Labels", "intellij.vcs.github"})
        public static final class Issues
        extends Entity {
            @NotNull
            public static final Issues INSTANCE;

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest.Post<GithubIssue> create(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @NotNull String title, @Nullable String body2, @Nullable Long milestone, @Nullable List<String> labels, @Nullable List<String> assignees) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                GithubApiRequest.Post.Companion companion = GithubApiRequest.Post.Companion;
                String string = GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix());
                GithubCreateIssueRequest githubCreateIssueRequest = new GithubCreateIssueRequest(title, body2, milestone, labels, assignees);
                String acceptMimeType$iv = null;
                boolean $i$f$json = false;
                return new GithubApiRequest.Post.Json<GithubIssue>((String)url$iv, body$iv, GithubIssue.class, acceptMimeType$iv);
            }

            public static /* synthetic */ GithubApiRequest.Post create$default(GithubServerPath githubServerPath, String string, String string2, String string3, String string4, Long l, List list2, List list3, int n, Object object) {
                if ((n & 0x10) != 0) {
                    string4 = null;
                }
                if ((n & 0x20) != 0) {
                    l = null;
                }
                if ((n & 0x40) != 0) {
                    list2 = null;
                }
                if ((n & 0x80) != 0) {
                    list3 = null;
                }
                return Issues.create(githubServerPath, string, string2, string3, string4, l, list2, list3);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubIssue> pages(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @Nullable String state2, @Nullable String assignee2) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return new GithubApiPagesLoader.Request<GithubIssue>(Issues.get$default(server, username, repoName, state2, assignee2, null, 32, null), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubIssue>>>(INSTANCE){

                    @NotNull
                    public final GithubApiRequest<GithubResponsePage<GithubIssue>> invoke(@NotNull String p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        Issues cfr_ignored_0 = (Issues)this.receiver;
                        return Issues.get(p1);
                    }
                });
            }

            public static /* synthetic */ GithubApiPagesLoader.Request pages$default(GithubServerPath githubServerPath, String string, String string2, String string3, String string4, int n, Object object) {
                if ((n & 8) != 0) {
                    string3 = null;
                }
                if ((n & 0x10) != 0) {
                    string4 = null;
                }
                return Issues.pages(githubServerPath, string, string2, string3, string4);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubIssue>> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @Nullable String state2, @Nullable String assignee2, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return Issues.get(GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)new Function1<GithubApiUrlQueryBuilder, Unit>(state2, assignee2, pagination){
                    final /* synthetic */ String $state;
                    final /* synthetic */ String $assignee;
                    final /* synthetic */ GithubRequestPagination $pagination;

                    public final void invoke(@NotNull GithubApiUrlQueryBuilder $this$urlQuery) {
                        Intrinsics.checkNotNullParameter((Object)$this$urlQuery, (String)"$receiver");
                        $this$urlQuery.param("state", this.$state);
                        $this$urlQuery.param("assignee", this.$assignee);
                        $this$urlQuery.param(this.$pagination);
                    }
                    {
                        this.$state = string;
                        this.$assignee = string2;
                        this.$pagination = githubRequestPagination;
                        super(1);
                    }
                }))));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, String string3, String string4, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 8) != 0) {
                    string3 = null;
                }
                if ((n & 0x10) != 0) {
                    string4 = null;
                }
                if ((n & 0x20) != 0) {
                    githubRequestPagination = null;
                }
                return Issues.get(githubServerPath, string, string2, string3, string4, githubRequestPagination);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubIssue>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubIssue>(url, GithubIssue.class, acceptMimeType$iv)).withOperationName("get issues in repository");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest.Get.Optional<GithubIssue> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @NotNull String id) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                GithubApiRequest.Get.Optional.Companion companion = GithubApiRequest.Get.Optional.Companion;
                String url$iv = GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix(), "/", id);
                String acceptMimeType$iv = null;
                boolean $i$f$json = false;
                return new GithubApiRequest.Get.Optional.Json<GithubIssue>(url$iv, GithubIssue.class, acceptMimeType$iv);
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest.Post<GithubIssue> updateState(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @NotNull String id, boolean open) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                GithubApiRequest.Patch.Companion companion = GithubApiRequest.Patch.Companion;
                String string = GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix(), "/", id);
                GithubChangeIssueStateRequest githubChangeIssueStateRequest = new GithubChangeIssueStateRequest(open ? "open" : "closed");
                boolean $i$f$json = false;
                return new GithubApiRequest.Patch.Json<GithubIssue>((String)url$iv, body$iv, GithubIssue.class);
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest.Post<GithubIssue> updateAssignees(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @NotNull String id, @NotNull Collection<String> assignees) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter(assignees, (String)"assignees");
                GithubApiRequest.Patch.Companion companion = GithubApiRequest.Patch.Companion;
                String string = GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix(), "/", id);
                GithubAssigneesCollectionRequest githubAssigneesCollectionRequest = new GithubAssigneesCollectionRequest(assignees);
                boolean $i$f$json = false;
                return new GithubApiRequest.Patch.Json<GithubIssue>((String)url$iv, body$iv, GithubIssue.class);
            }

            private Issues() {
                super("/issues");
            }

            static {
                Issues issues;
                INSTANCE = issues = new Issues();
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J6\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u000bH\u0007J@\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00120\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000b2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u0013\u001a\u00020\u000bH\u0007J.\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000bH\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Issues$Comments;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "Lorg/jetbrains/plugins/github/api/data/GithubIssueCommentWithHtml;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "issueId", "", "body", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "repoName", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "url", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
            public static final class Comments
            extends Entity {
                @NotNull
                public static final Comments INSTANCE;

                @JvmStatic
                @NotNull
                public static final GithubApiRequest.Post<GithubIssueCommentWithHtml> create(@NotNull GHRepositoryCoordinates repository, long issueId, @NotNull String body2) {
                    Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                    Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                    return Comments.create(repository.getServerPath(), repository.getRepositoryPath().getOwner(), repository.getRepositoryPath().getRepository(), String.valueOf(issueId), body2);
                }

                /*
                 * WARNING - void declaration
                 */
                @JvmStatic
                @NotNull
                public static final GithubApiRequest.Post<GithubIssueCommentWithHtml> create(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @NotNull String issueId, @NotNull String body2) {
                    void acceptMimeType$iv;
                    void body$iv;
                    void url$iv;
                    Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                    Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                    Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                    Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
                    Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                    GithubApiRequest.Post.Companion companion = GithubApiRequest.Post.Companion;
                    String string = GithubApiRequests.INSTANCE.getUrl(server, Repos.INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix(), "/", issueId, INSTANCE.getUrlSuffix());
                    GithubCreateIssueCommentRequest githubCreateIssueCommentRequest = new GithubCreateIssueCommentRequest(body2);
                    String string2 = "application/vnd.github.v3.html+json";
                    boolean $i$f$json = false;
                    return new GithubApiRequest.Post.Json<GithubIssueCommentWithHtml>((String)url$iv, body$iv, GithubIssueCommentWithHtml.class, (String)acceptMimeType$iv);
                }

                @JvmStatic
                @NotNull
                public static final GithubApiPagesLoader.Request<GithubIssueCommentWithHtml> pages(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @NotNull String issueId) {
                    Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                    Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                    Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                    Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
                    return new GithubApiPagesLoader.Request<GithubIssueCommentWithHtml>(Comments.get$default(server, username, repoName, issueId, null, 16, null), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubIssueCommentWithHtml>>>(INSTANCE){

                        @NotNull
                        public final GithubApiRequest<GithubResponsePage<GithubIssueCommentWithHtml>> invoke(@NotNull String p1) {
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Comments cfr_ignored_0 = (Comments)this.receiver;
                            return Comments.get(p1);
                        }
                    });
                }

                @JvmStatic
                @NotNull
                public static final GithubApiPagesLoader.Request<GithubIssueCommentWithHtml> pages(@NotNull String url) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    return new GithubApiPagesLoader.Request<GithubIssueCommentWithHtml>(Comments.get(url), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubIssueCommentWithHtml>>>(INSTANCE){

                        @NotNull
                        public final GithubApiRequest<GithubResponsePage<GithubIssueCommentWithHtml>> invoke(@NotNull String p1) {
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Comments cfr_ignored_0 = (Comments)this.receiver;
                            return Comments.get(p1);
                        }
                    });
                }

                @JvmStatic
                @NotNull
                public static final GithubApiRequest<GithubResponsePage<GithubIssueCommentWithHtml>> get(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @NotNull String issueId, @Nullable GithubRequestPagination pagination) {
                    Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                    Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                    Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                    Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
                    return Comments.get(GithubApiRequests.INSTANCE.getUrl(server, Repos.INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix(), "/", issueId, INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)new Function1<GithubApiUrlQueryBuilder, Unit>(pagination){
                        final /* synthetic */ GithubRequestPagination $pagination;

                        public final void invoke(@NotNull GithubApiUrlQueryBuilder $this$urlQuery) {
                            Intrinsics.checkNotNullParameter((Object)$this$urlQuery, (String)"$receiver");
                            $this$urlQuery.param(this.$pagination);
                        }
                        {
                            this.$pagination = githubRequestPagination;
                            super(1);
                        }
                    }))));
                }

                public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, String string3, GithubRequestPagination githubRequestPagination, int n, Object object) {
                    if ((n & 0x10) != 0) {
                        githubRequestPagination = null;
                    }
                    return Comments.get(githubServerPath, string, string2, string3, githubRequestPagination);
                }

                @JvmStatic
                @NotNull
                public static final GithubApiRequest<GithubResponsePage<GithubIssueCommentWithHtml>> get(@NotNull String url) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    GithubApiRequest.Get.Companion companion = GithubApiRequest.Get.Companion;
                    String acceptMimeType$iv = "application/vnd.github.v3.html+json";
                    boolean $i$f$jsonPage = false;
                    return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubIssueCommentWithHtml>(url, GithubIssueCommentWithHtml.class, acceptMimeType$iv)).withOperationName("get comments for issue");
                }

                private Comments() {
                    super("/comments");
                }

                static {
                    Comments comments;
                    INSTANCE = comments = new Comments();
                }
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Issues$Labels;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "replace", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put;", "", "Lorg/jetbrains/plugins/github/api/data/GithubIssueLabel;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "issueId", "labels", "", "intellij.vcs.github"})
            public static final class Labels
            extends Entity {
                @NotNull
                public static final Labels INSTANCE;

                /*
                 * WARNING - void declaration
                 */
                @JvmStatic
                @NotNull
                public static final GithubApiRequest.Put<List<GithubIssueLabel>> replace(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @NotNull String issueId, @NotNull Collection<String> labels) {
                    void body$iv;
                    void url$iv;
                    Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                    Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                    Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                    Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
                    Intrinsics.checkNotNullParameter(labels, (String)"labels");
                    GithubApiRequest.Put.Companion companion = GithubApiRequest.Put.Companion;
                    String string = GithubApiRequests.INSTANCE.getUrl(server, Repos.INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix(), "/", issueId, INSTANCE.getUrlSuffix());
                    GithubLabelsCollectionRequest githubLabelsCollectionRequest = new GithubLabelsCollectionRequest(labels);
                    boolean $i$f$jsonList = false;
                    return new GithubApiRequest.Put.JsonList<GithubIssueLabel>((String)url$iv, body$iv, GithubIssueLabel.class);
                }

                private Labels() {
                    super("/labels");
                }

                static {
                    Labels labels;
                    INSTANCE = labels = new Labels();
                }
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001%B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0007J \u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J>\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0007J.\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\tH\u0007J>\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0007JW\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001c\u001a\u00020\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!H\u0007\u00a2\u0006\u0002\u0010\"Jo\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010#\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!H\u0007\u00a2\u0006\u0002\u0010$\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$PullRequests;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubPullRequestDetailed;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "title", "description", "head", "base", "getListETag", "repoPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "merge", "", "number", "", "commitSubject", "commitBody", "headSha", "rebaseMerge", "squashMerge", "update", "url", "body", "state", "Lorg/jetbrains/plugins/github/api/data/GithubIssueState;", "maintainerCanModify", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/github/api/data/GithubIssueState;Ljava/lang/String;Ljava/lang/Boolean;)Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "serverPath", "(Lorg/jetbrains/plugins/github/api/GithubServerPath;Ljava/lang/String;Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/github/api/data/GithubIssueState;Ljava/lang/String;Ljava/lang/Boolean;)Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Reviewers", "intellij.vcs.github"})
        public static final class PullRequests
        extends Entity {
            @NotNull
            public static final PullRequests INSTANCE;

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubPullRequestDetailed> create(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, @NotNull String title, @NotNull String description, @NotNull String head, @NotNull String base) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                Intrinsics.checkNotNullParameter((Object)head, (String)"head");
                Intrinsics.checkNotNullParameter((Object)base, (String)"base");
                GithubApiRequest.Post.Companion companion = GithubApiRequest.Post.Companion;
                String string = GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix());
                GithubPullRequestRequest githubPullRequestRequest = new GithubPullRequestRequest(title, description, head, base);
                String acceptMimeType$iv = null;
                boolean $i$f$json = false;
                return ((GithubApiRequest.Post)new GithubApiRequest.Post.Json<GithubPullRequestDetailed>((String)url$iv, body$iv, GithubPullRequestDetailed.class, acceptMimeType$iv)).withOperationName("create pull request in " + username + '/' + repoName);
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubPullRequestDetailed> update(@NotNull GithubServerPath serverPath, @NotNull String username, @NotNull String repoName, long number, @Nullable String title, @Nullable String body2, @Nullable GithubIssueState state2, @Nullable String base, @Nullable Boolean maintainerCanModify) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                GithubApiRequest.Patch.Companion companion = GithubApiRequest.Patch.Companion;
                String string = GithubApiRequests.INSTANCE.getUrl(serverPath, INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix(), "" + '/' + number);
                GithubPullUpdateRequest githubPullUpdateRequest = new GithubPullUpdateRequest(title, body2, state2, base, maintainerCanModify);
                boolean $i$f$json = false;
                return ((GithubApiRequest.Post)new GithubApiRequest.Patch.Json<GithubPullRequestDetailed>((String)url$iv, body$iv, GithubPullRequestDetailed.class)).withOperationName("update pull request " + number);
            }

            public static /* synthetic */ GithubApiRequest update$default(GithubServerPath githubServerPath, String string, String string2, long l, String string3, String string4, GithubIssueState githubIssueState, String string5, Boolean bl, int n, Object object) {
                if ((n & 0x10) != 0) {
                    string3 = null;
                }
                if ((n & 0x20) != 0) {
                    string4 = null;
                }
                if ((n & 0x40) != 0) {
                    githubIssueState = null;
                }
                if ((n & 0x80) != 0) {
                    string5 = null;
                }
                if ((n & 0x100) != 0) {
                    bl = null;
                }
                return PullRequests.update(githubServerPath, string, string2, l, string3, string4, githubIssueState, string5, bl);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubPullRequestDetailed> update(@NotNull String url, @Nullable String title, @Nullable String body2, @Nullable GithubIssueState state2, @Nullable String base, @Nullable Boolean maintainerCanModify) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Patch.Companion companion = GithubApiRequest.Patch.Companion;
                GithubPullUpdateRequest body$iv = new GithubPullUpdateRequest(title, body2, state2, base, maintainerCanModify);
                boolean $i$f$json = false;
                return ((GithubApiRequest.Post)new GithubApiRequest.Patch.Json<GithubPullRequestDetailed>(url, body$iv, GithubPullRequestDetailed.class)).withOperationName("update pull request");
            }

            public static /* synthetic */ GithubApiRequest update$default(String string, String string2, String string3, GithubIssueState githubIssueState, String string4, Boolean bl, int n, Object object) {
                if ((n & 2) != 0) {
                    string2 = null;
                }
                if ((n & 4) != 0) {
                    string3 = null;
                }
                if ((n & 8) != 0) {
                    githubIssueState = null;
                }
                if ((n & 0x10) != 0) {
                    string4 = null;
                }
                if ((n & 0x20) != 0) {
                    bl = null;
                }
                return PullRequests.update(string, string2, string3, githubIssueState, string4, bl);
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<Unit> merge(@NotNull GithubServerPath server, @NotNull GHRepositoryPath repoPath, long number, @NotNull String commitSubject, @NotNull String commitBody, @NotNull String headSha) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)repoPath, (String)"repoPath");
                Intrinsics.checkNotNullParameter((Object)commitSubject, (String)"commitSubject");
                Intrinsics.checkNotNullParameter((Object)commitBody, (String)"commitBody");
                Intrinsics.checkNotNullParameter((Object)headSha, (String)"headSha");
                GithubApiRequest.Put.Companion companion = GithubApiRequest.Put.Companion;
                String string = GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), "" + '/' + repoPath, INSTANCE.getUrlSuffix(), "" + '/' + number, "/merge");
                GithubPullRequestMergeRequest githubPullRequestMergeRequest = new GithubPullRequestMergeRequest(commitSubject, commitBody, headSha, GithubPullRequestMergeMethod.merge);
                boolean $i$f$json = false;
                return ((GithubApiRequest.Put)new GithubApiRequest.Put.Json<Unit>((String)url$iv, body$iv, Unit.class)).withOperationName("merge pull request " + number);
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<Unit> squashMerge(@NotNull GithubServerPath server, @NotNull GHRepositoryPath repoPath, long number, @NotNull String commitSubject, @NotNull String commitBody, @NotNull String headSha) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)repoPath, (String)"repoPath");
                Intrinsics.checkNotNullParameter((Object)commitSubject, (String)"commitSubject");
                Intrinsics.checkNotNullParameter((Object)commitBody, (String)"commitBody");
                Intrinsics.checkNotNullParameter((Object)headSha, (String)"headSha");
                GithubApiRequest.Put.Companion companion = GithubApiRequest.Put.Companion;
                String string = GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), "" + '/' + repoPath, INSTANCE.getUrlSuffix(), "" + '/' + number, "/merge");
                GithubPullRequestMergeRequest githubPullRequestMergeRequest = new GithubPullRequestMergeRequest(commitSubject, commitBody, headSha, GithubPullRequestMergeMethod.squash);
                boolean $i$f$json = false;
                return ((GithubApiRequest.Put)new GithubApiRequest.Put.Json<Unit>((String)url$iv, body$iv, Unit.class)).withOperationName("squash and merge pull request " + number);
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<Unit> rebaseMerge(@NotNull GithubServerPath server, @NotNull GHRepositoryPath repoPath, long number, @NotNull String headSha) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)repoPath, (String)"repoPath");
                Intrinsics.checkNotNullParameter((Object)headSha, (String)"headSha");
                GithubApiRequest.Put.Companion companion = GithubApiRequest.Put.Companion;
                String string = GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), "" + '/' + repoPath, INSTANCE.getUrlSuffix(), "" + '/' + number, "/merge");
                GithubPullRequestMergeRebaseRequest githubPullRequestMergeRebaseRequest = new GithubPullRequestMergeRebaseRequest(headSha);
                boolean $i$f$json = false;
                return ((GithubApiRequest.Put)new GithubApiRequest.Put.Json<Unit>((String)url$iv, body$iv, Unit.class)).withOperationName("rebase and merge pull request " + number);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<String> getListETag(@NotNull GithubServerPath server, @NotNull GHRepositoryPath repoPath) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)repoPath, (String)"repoPath");
                return new GithubApiRequest.Get<String>(INSTANCE, server, repoPath, GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), "" + '/' + repoPath, INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)getListETag.2.INSTANCE)))){
                    final /* synthetic */ PullRequests this$0;
                    final /* synthetic */ GithubServerPath $server;
                    final /* synthetic */ GHRepositoryPath $repoPath;

                    @Nullable
                    public String extractResult(@NotNull GithubApiResponse response) {
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        return response.findHeader("ETag");
                    }
                    {
                        this.this$0 = this$0;
                        this.$server = $captured_local_variable$1;
                        this.$repoPath = $captured_local_variable$2;
                        super($super_call_param$3, null, 2, null);
                    }
                }.withOperationName("get pull request list ETag");
            }

            private PullRequests() {
                super("/pulls");
            }

            static {
                PullRequests pullRequests;
                INSTANCE = pullRequests = new PullRequests();
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0007JJ\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$PullRequests$Reviewers;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "add", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "number", "", "reviewers", "", "teamReviewers", "", "remove", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Delete;", "intellij.vcs.github"})
            public static final class Reviewers
            extends Entity {
                @NotNull
                public static final Reviewers INSTANCE;

                /*
                 * WARNING - void declaration
                 */
                @JvmStatic
                @NotNull
                public static final GithubApiRequest.Post<Unit> add(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, long number, @NotNull Collection<String> reviewers, @NotNull List<String> teamReviewers) {
                    void body$iv;
                    void url$iv;
                    Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                    Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                    Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                    Intrinsics.checkNotNullParameter(reviewers, (String)"reviewers");
                    Intrinsics.checkNotNullParameter(teamReviewers, (String)"teamReviewers");
                    GithubApiRequest.Post.Companion companion = GithubApiRequest.Post.Companion;
                    String string = GithubApiRequests.INSTANCE.getUrl(server, Repos.INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix(), "" + '/' + number, INSTANCE.getUrlSuffix());
                    GithubReviewersCollectionRequest githubReviewersCollectionRequest = new GithubReviewersCollectionRequest(reviewers, (Collection<String>)teamReviewers);
                    String acceptMimeType$iv = null;
                    boolean $i$f$json = false;
                    return new GithubApiRequest.Post.Json<Unit>((String)url$iv, body$iv, Unit.class, acceptMimeType$iv);
                }

                /*
                 * WARNING - void declaration
                 */
                @JvmStatic
                @NotNull
                public static final GithubApiRequest.Delete<Unit> remove(@NotNull GithubServerPath server, @NotNull String username, @NotNull String repoName, long number, @NotNull Collection<String> reviewers, @NotNull List<String> teamReviewers) {
                    void body$iv;
                    void url$iv;
                    Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                    Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                    Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                    Intrinsics.checkNotNullParameter(reviewers, (String)"reviewers");
                    Intrinsics.checkNotNullParameter(teamReviewers, (String)"teamReviewers");
                    GithubApiRequest.Delete.Companion companion = GithubApiRequest.Delete.Companion;
                    String string = GithubApiRequests.INSTANCE.getUrl(server, Repos.INSTANCE.getUrlSuffix(), '/' + username + '/' + repoName, INSTANCE.getUrlSuffix(), "" + '/' + number, INSTANCE.getUrlSuffix());
                    GithubReviewersCollectionRequest githubReviewersCollectionRequest = new GithubReviewersCollectionRequest(reviewers, (Collection<String>)teamReviewers);
                    boolean $i$f$json = false;
                    return new GithubApiRequest.Delete.Json<Unit>((String)url$iv, body$iv, Unit.class);
                }

                private Reviewers() {
                    super("/requested_reviewers");
                }

                static {
                    Reviewers reviewers;
                    INSTANCE = reviewers = new Reviewers();
                }
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\fH\u0007J \u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\fH\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Gists;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubGist;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "contents", "", "Lorg/jetbrains/plugins/github/api/data/request/GithubGistRequest$FileContent;", "description", "", "public", "", "delete", "", "id", "get", "intellij.vcs.github"})
    public static final class Gists
    extends Entity {
        @NotNull
        public static final Gists INSTANCE;

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubGist> create(@NotNull GithubServerPath server, @NotNull List<? extends GithubGistRequest.FileContent> contents, @NotNull String description, boolean bl) {
            void body$iv;
            void url$iv;
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter(contents, (String)"contents");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            GithubApiRequest.Post.Companion companion = GithubApiRequest.Post.Companion;
            String string = INSTANCE.getUrl(server, Gists.INSTANCE.getUrlSuffix());
            GithubGistRequest githubGistRequest = new GithubGistRequest(contents, description, bl);
            String acceptMimeType$iv = null;
            boolean $i$f$json = false;
            return ((GithubApiRequest.Post)new GithubApiRequest.Post.Json<GithubGist>((String)url$iv, body$iv, GithubGist.class, acceptMimeType$iv)).withOperationName("create gist");
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubGist> get(@NotNull GithubServerPath server, @NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            GithubApiRequest.Get.Optional.Companion companion = GithubApiRequest.Get.Optional.Companion;
            String url$iv = INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + id);
            String acceptMimeType$iv = null;
            boolean $i$f$json = false;
            return ((GithubApiRequest.Get.Optional)new GithubApiRequest.Get.Optional.Json<GithubGist>(url$iv, GithubGist.class, acceptMimeType$iv)).withOperationName("get gist " + id);
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<Unit> delete(@NotNull GithubServerPath server, @NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            GithubApiRequest.Delete.Companion companion = GithubApiRequest.Delete.Companion;
            String url$iv = INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), '/' + id);
            Object body$iv = null;
            boolean $i$f$json = false;
            return ((GithubApiRequest.Delete)new GithubApiRequest.Delete.Json<Unit>(url$iv, body$iv, Unit.class)).withOperationName("delete gist " + id);
        }

        private Gists() {
            super("/gists");
        }

        static {
            Gists gists;
            INSTANCE = gists = new Gists();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Search;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "Issues", "intellij.vcs.github"})
    public static final class Search
    extends Entity {
        @NotNull
        public static final Search INSTANCE;

        private Search() {
            super("/search");
        }

        static {
            Search search;
            INSTANCE = search = new Search();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J0\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007JP\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J>\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Search$Issues;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "Lorg/jetbrains/plugins/github/api/data/GithubSearchedIssue;", "url", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "query", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "repoPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "state", "assignee", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
        public static final class Issues
        extends Entity {
            @NotNull
            public static final Issues INSTANCE;

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubSearchedIssue> pages(@NotNull GithubServerPath server, @Nullable GHRepositoryPath repoPath, @Nullable String state2, @Nullable String assignee2, @Nullable String query) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return new GithubApiPagesLoader.Request<GithubSearchedIssue>(Issues.get$default(server, repoPath, state2, assignee2, query, null, 32, null), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubSearchedIssue>>>(INSTANCE){

                    @NotNull
                    public final GithubApiRequest<GithubResponsePage<GithubSearchedIssue>> invoke(@NotNull String p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        Issues cfr_ignored_0 = (Issues)this.receiver;
                        return Issues.get(p1);
                    }
                });
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubSearchedIssue>> get(@NotNull GithubServerPath server, @Nullable GHRepositoryPath repoPath, @Nullable String state2, @Nullable String assignee2, @Nullable String query, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return Issues.get(GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)new Function1<GithubApiUrlQueryBuilder, Unit>(repoPath, state2, assignee2, query, pagination){
                    final /* synthetic */ GHRepositoryPath $repoPath;
                    final /* synthetic */ String $state;
                    final /* synthetic */ String $assignee;
                    final /* synthetic */ String $query;
                    final /* synthetic */ GithubRequestPagination $pagination;

                    public final void invoke(@NotNull GithubApiUrlQueryBuilder $this$urlQuery) {
                        Intrinsics.checkNotNullParameter((Object)$this$urlQuery, (String)"$receiver");
                        $this$urlQuery.param("q", GithubApiSearchQueryBuilder.Companion.searchQuery((Function1<? super GithubApiSearchQueryBuilder, Unit>)((Function1)new Function1<GithubApiSearchQueryBuilder, Unit>(this){
                            final /* synthetic */ get.1 this$0;

                            public final void invoke(@NotNull GithubApiSearchQueryBuilder $this$searchQuery) {
                                Intrinsics.checkNotNullParameter((Object)$this$searchQuery, (String)"$receiver");
                                GHRepositoryPath gHRepositoryPath = this.this$0.$repoPath;
                                String string = gHRepositoryPath != null ? gHRepositoryPath.toString() : null;
                                boolean bl = false;
                                String string2 = string;
                                if (string2 == null) {
                                    string2 = "";
                                }
                                $this$searchQuery.qualifier("repo", string2);
                                $this$searchQuery.qualifier("state", this.this$0.$state);
                                $this$searchQuery.qualifier("assignee", this.this$0.$assignee);
                                $this$searchQuery.query(this.this$0.$query);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        })));
                        $this$urlQuery.param(this.$pagination);
                    }
                    {
                        this.$repoPath = gHRepositoryPath;
                        this.$state = string;
                        this.$assignee = string2;
                        this.$query = string3;
                        this.$pagination = githubRequestPagination;
                        super(1);
                    }
                }))));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, GHRepositoryPath gHRepositoryPath, String string, String string2, String string3, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 0x20) != 0) {
                    githubRequestPagination = null;
                }
                return Issues.get(githubServerPath, gHRepositoryPath, string, string2, string3, githubRequestPagination);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubSearchedIssue>> get(@NotNull GithubServerPath server, @NotNull String query, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)query, (String)"query");
                return Issues.get(GithubApiRequests.INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)new Function1<GithubApiUrlQueryBuilder, Unit>(query, pagination){
                    final /* synthetic */ String $query;
                    final /* synthetic */ GithubRequestPagination $pagination;

                    public final void invoke(@NotNull GithubApiUrlQueryBuilder $this$urlQuery) {
                        Intrinsics.checkNotNullParameter((Object)$this$urlQuery, (String)"$receiver");
                        $this$urlQuery.param("q", this.$query);
                        $this$urlQuery.param(this.$pagination);
                    }
                    {
                        this.$query = string;
                        this.$pagination = githubRequestPagination;
                        super(1);
                    }
                }))));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 4) != 0) {
                    githubRequestPagination = null;
                }
                return Issues.get(githubServerPath, string, githubRequestPagination);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubSearchedIssue>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonSearchPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonSearchPage<GithubSearchedIssue>(url, GithubSearchedIssue.class, acceptMimeType$iv)).withOperationName("search issues in repository");
            }

            private Issues() {
                super("/issues");
            }

            static {
                Issues issues;
                INSTANCE = issues = new Issues();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0007J\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\r0\u00042\u0006\u0010\u000e\u001a\u00020\nH\u0007J(\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\r0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Auth;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubAuthorization;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "scopes", "", "", "note", "get", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "url", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "intellij.vcs.github"})
    public static final class Auth
    extends Entity {
        @NotNull
        public static final Auth INSTANCE;

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubAuthorization> create(@NotNull GithubServerPath server, @NotNull List<String> scopes, @NotNull String note) {
            void body$iv;
            void url$iv;
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
            Intrinsics.checkNotNullParameter((Object)note, (String)"note");
            GithubApiRequest.Post.Companion companion = GithubApiRequest.Post.Companion;
            String string = INSTANCE.getUrl(server, Auth.INSTANCE.getUrlSuffix());
            GithubAuthorizationCreateRequest githubAuthorizationCreateRequest = new GithubAuthorizationCreateRequest(scopes, note, null);
            String acceptMimeType$iv = null;
            boolean $i$f$json = false;
            return ((GithubApiRequest.Post)new GithubApiRequest.Post.Json<GithubAuthorization>((String)url$iv, body$iv, GithubAuthorization.class, acceptMimeType$iv)).withOperationName("create authorization " + note);
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubResponsePage<GithubAuthorization>> get(@NotNull GithubServerPath server, @Nullable GithubRequestPagination pagination) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            return Auth.get(INSTANCE.getUrl(server, INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)new Function1<GithubApiUrlQueryBuilder, Unit>(pagination){
                final /* synthetic */ GithubRequestPagination $pagination;

                public final void invoke(@NotNull GithubApiUrlQueryBuilder $this$urlQuery) {
                    Intrinsics.checkNotNullParameter((Object)$this$urlQuery, (String)"$receiver");
                    $this$urlQuery.param(this.$pagination);
                }
                {
                    this.$pagination = githubRequestPagination;
                    super(1);
                }
            }))));
        }

        public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, GithubRequestPagination githubRequestPagination, int n, Object object) {
            if ((n & 2) != 0) {
                githubRequestPagination = null;
            }
            return Auth.get(githubServerPath, githubRequestPagination);
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubResponsePage<GithubAuthorization>> get(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            GithubApiRequest.Get.Companion this_$iv = GithubApiRequest.Get.Companion;
            String acceptMimeType$iv = null;
            boolean $i$f$jsonPage = false;
            return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubAuthorization>(url, GithubAuthorization.class, acceptMimeType$iv)).withOperationName("get authorizations");
        }

        @JvmStatic
        @NotNull
        public static final GithubApiPagesLoader.Request<GithubAuthorization> pages(@NotNull GithubServerPath server, @Nullable GithubRequestPagination pagination) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            return new GithubApiPagesLoader.Request<GithubAuthorization>(Auth.get(server, pagination), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubAuthorization>>>(INSTANCE){

                @NotNull
                public final GithubApiRequest<GithubResponsePage<GithubAuthorization>> invoke(@NotNull String p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Auth cfr_ignored_0 = (Auth)this.receiver;
                    return Auth.get(p1);
                }
            });
        }

        public static /* synthetic */ GithubApiPagesLoader.Request pages$default(GithubServerPath githubServerPath, GithubRequestPagination githubRequestPagination, int n, Object object) {
            if ((n & 2) != 0) {
                githubRequestPagination = null;
            }
            return Auth.pages(githubServerPath, githubRequestPagination);
        }

        private Auth() {
            super("/authorizations");
        }

        static {
            Auth auth;
            INSTANCE = auth = new Auth();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "", "urlSuffix", "", "(Ljava/lang/String;)V", "getUrlSuffix", "()Ljava/lang/String;", "intellij.vcs.github"})
    public static abstract class Entity {
        @NotNull
        private final String urlSuffix;

        @NotNull
        public final String getUrlSuffix() {
            return this.urlSuffix;
        }

        public Entity(@NotNull String urlSuffix) {
            Intrinsics.checkNotNullParameter((Object)urlSuffix, (String)"urlSuffix");
            this.urlSuffix = urlSuffix;
        }
    }
}

