/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.util.ThrowableConvertor;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHGQLQueryLoader;
import org.jetbrains.plugins.github.api.GithubApiContentHelper;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiResponse;
import org.jetbrains.plugins.github.api.data.GithubResponsePage;
import org.jetbrains.plugins.github.api.data.GithubSearchResult;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLQueryRequest;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLResponse;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLSyntaxError;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubConfusingException;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001e*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\b\u001e\u001f !\"#$%B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001aH&\u00a2\u0006\u0002\u0010\u001bJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001d\u001a\u00020\u0004R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\b\"\u0004\b\u0012\u0010\u0005R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\b\u0082\u0001\u0003&'(\u00a8\u0006)"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "T", "", "url", "", "(Ljava/lang/String;)V", "acceptMimeType", "getAcceptMimeType", "()Ljava/lang/String;", "additionalHeaders", "", "getAdditionalHeaders", "()Ljava/util/Map;", "headers", "", "getHeaders", "operationName", "getOperationName", "setOperationName", "tokenHeaderType", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$TokenHeaderType;", "getTokenHeaderType", "()Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$TokenHeaderType;", "getUrl", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "withOperationName", "name", "Companion", "Delete", "Get", "Head", "Patch", "Post", "Put", "WithBody", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Head;", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$WithBody;", "intellij.vcs.github"})
public abstract class GithubApiRequest<T> {
    @Nullable
    private String operationName;
    @NotNull
    private final GithubApiRequestExecutor.TokenHeaderType tokenHeaderType;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private final String url;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getOperationName() {
        return this.operationName;
    }

    public final void setOperationName(@Nullable String string) {
        this.operationName = string;
    }

    @Nullable
    public abstract String getAcceptMimeType();

    @NotNull
    public GithubApiRequestExecutor.TokenHeaderType getTokenHeaderType() {
        return this.tokenHeaderType;
    }

    @NotNull
    protected final Map<String, String> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Map<String, String> getAdditionalHeaders() {
        return this.headers;
    }

    public abstract T extractResult(@NotNull GithubApiResponse var1) throws IOException;

    @NotNull
    public final GithubApiRequest<T> withOperationName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.operationName = name;
        return this;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    private GithubApiRequest(String url) {
        this.url = url;
        this.tokenHeaderType = GithubApiRequestExecutor.TokenHeaderType.TOKEN;
        boolean bl = false;
        this.headers = new LinkedHashMap();
    }

    public /* synthetic */ GithubApiRequest(String url, DefaultConstructorMarker $constructor_marker) {
        this(url);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b&\u0018\u0000 \t*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0006\t\n\u000b\f\r\u000eB\u001b\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "url", "", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/String;)V", "getAcceptMimeType", "()Ljava/lang/String;", "Companion", "Json", "JsonList", "JsonPage", "JsonSearchPage", "Optional", "intellij.vcs.github"})
    public static abstract class Get<T>
    extends GithubApiRequest<T> {
        @Nullable
        private final String acceptMimeType;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Override
        @Nullable
        public String getAcceptMimeType() {
            return this.acceptMimeType;
        }

        @JvmOverloads
        public Get(@NotNull String url, @Nullable String acceptMimeType) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(url, null);
            this.acceptMimeType = acceptMimeType;
        }

        public /* synthetic */ Get(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        @JvmOverloads
        public Get(@NotNull String url) {
            this(url, null, 2, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u0000 \u0007*\u0004\b\u0002\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002:\u0002\u0007\bB\u001b\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "url", "", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/String;)V", "Companion", "Json", "intellij.vcs.github"})
        public static abstract class Optional<T>
        extends Get<T> {
            @NotNull
            public static final Companion Companion = new Companion(null);

            @JvmOverloads
            public Optional(@NotNull String url, @Nullable String acceptMimeType) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                super(url, acceptMimeType);
            }

            public /* synthetic */ Optional(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    string2 = null;
                }
                this(string, string2);
            }

            @JvmOverloads
            public Optional(@NotNull String url) {
                this(url, null, 2, null);
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0003\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00030\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\t\u001a\u00028\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional$Json;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional;", "url", "", "clazz", "Ljava/lang/Class;", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;)V", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
            public static class Json<T>
            extends Optional<T> {
                private final Class<T> clazz;

                @Override
                public T extractResult(@NotNull GithubApiResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    return (T)GithubApiRequest.Companion.parseJsonObject(response, this.clazz);
                }

                public Json(@NotNull String url, @NotNull Class<T> clazz, @Nullable String acceptMimeType) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                    super(url, acceptMimeType);
                    this.clazz = clazz;
                }

                public /* synthetic */ Json(String string, Class clazz, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 4) != 0) {
                        string2 = "application/vnd.github.v3+json";
                    }
                    this(string, clazz, string2);
                }
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0006\b\u0003\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0086\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional$Companion;", "", "()V", "json", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional;", "T", "url", "", "acceptMimeType", "intellij.vcs.github"})
            public static final class Companion {
                public final /* synthetic */ <T> Optional<T> json(String url, String acceptMimeType) {
                    int $i$f$json = 0;
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                    return new Json<Object>(url, Object.class, acceptMimeType);
                }

                public static /* synthetic */ Optional json$default(Companion this_, String url, String acceptMimeType, int n, Object object) {
                    if ((n & 2) != 0) {
                        acceptMimeType = null;
                    }
                    boolean $i$f$json = false;
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                    return new Json<Object>(url, Object.class, acceptMimeType);
                }

                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\t\u001a\u00028\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Json;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "url", "", "clazz", "Ljava/lang/Class;", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;)V", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
        public static class Json<T>
        extends Get<T> {
            private final Class<T> clazz;

            @Override
            public T extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return (T)GithubApiRequest.Companion.parseJsonObject(response, this.clazz);
            }

            public Json(@NotNull String url, @NotNull Class<T> clazz, @Nullable String acceptMimeType) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                super(url, acceptMimeType);
                this.clazz = clazz;
            }

            public /* synthetic */ Json(String string, Class clazz, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    string2 = "application/vnd.github.v3+json";
                }
                this(string, clazz, string2);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$JsonList;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "", "url", "", "clazz", "Ljava/lang/Class;", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;)V", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "intellij.vcs.github"})
        public static class JsonList<T>
        extends Get<List<? extends T>> {
            private final Class<T> clazz;

            @Override
            @NotNull
            public List<T> extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return GithubApiRequest.Companion.parseJsonList(response, this.clazz);
            }

            public JsonList(@NotNull String url, @NotNull Class<T> clazz, @Nullable String acceptMimeType) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                super(url, acceptMimeType);
                this.clazz = clazz;
            }

            public /* synthetic */ JsonList(String string, Class clazz, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    string2 = "application/vnd.github.v3+json";
                }
                this(string, clazz, string2);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$JsonPage;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "url", "", "clazz", "Ljava/lang/Class;", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;)V", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "intellij.vcs.github"})
        public static class JsonPage<T>
        extends Get<GithubResponsePage<T>> {
            private final Class<T> clazz;

            @Override
            @NotNull
            public GithubResponsePage<T> extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return GithubResponsePage.Companion.parseFromHeader(GithubApiRequest.Companion.parseJsonList(response, this.clazz), response.findHeader("Link"));
            }

            public JsonPage(@NotNull String url, @NotNull Class<T> clazz, @Nullable String acceptMimeType) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                super(url, acceptMimeType);
                this.clazz = clazz;
            }

            public /* synthetic */ JsonPage(String string, Class clazz, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    string2 = "application/vnd.github.v3+json";
                }
                this(string, clazz, string2);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$JsonSearchPage;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "url", "", "clazz", "Ljava/lang/Class;", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;)V", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "intellij.vcs.github"})
        public static class JsonSearchPage<T>
        extends Get<GithubResponsePage<T>> {
            private final Class<T> clazz;

            @Override
            @NotNull
            public GithubResponsePage<T> extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                List list2 = GithubApiRequest.Companion.parseJsonSearchPage(response, this.clazz).getItems();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"parseJsonSearchPage(response, clazz).items");
                return GithubResponsePage.Companion.parseFromHeader(list2, response.findHeader("Link"));
            }

            public JsonSearchPage(@NotNull String url, @NotNull Class<T> clazz, @Nullable String acceptMimeType) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                super(url, acceptMimeType);
                this.clazz = clazz;
            }

            public /* synthetic */ JsonSearchPage(String string, Class clazz, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    string2 = "application/vnd.github.v3+json";
                }
                this(string, clazz, string2);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0006\b\u0002\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0086\bJ1\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\n0\u0004\"\u0006\b\u0002\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0086\bJ1\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\n0\u0004\"\u0006\b\u0002\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0086\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion;", "", "()V", "json", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "T", "url", "", "acceptMimeType", "jsonPage", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "jsonSearchPage", "intellij.vcs.github"})
        public static final class Companion {
            public final /* synthetic */ <T> Get<T> json(String url, String acceptMimeType) {
                int $i$f$json = 0;
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, Object.class, acceptMimeType);
            }

            public static /* synthetic */ Get json$default(Companion this_, String url, String acceptMimeType, int n, Object object) {
                if ((n & 2) != 0) {
                    acceptMimeType = null;
                }
                boolean $i$f$json = false;
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, Object.class, acceptMimeType);
            }

            public final /* synthetic */ <T> Get<GithubResponsePage<T>> jsonPage(String url, String acceptMimeType) {
                int $i$f$jsonPage = 0;
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new JsonPage<Object>(url, Object.class, acceptMimeType);
            }

            public static /* synthetic */ Get jsonPage$default(Companion this_, String url, String acceptMimeType, int n, Object object) {
                if ((n & 2) != 0) {
                    acceptMimeType = null;
                }
                boolean $i$f$jsonPage = false;
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new JsonPage<Object>(url, Object.class, acceptMimeType);
            }

            public final /* synthetic */ <T> Get<GithubResponsePage<T>> jsonSearchPage(String url, String acceptMimeType) {
                int $i$f$jsonSearchPage = 0;
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new JsonSearchPage<Object>(url, Object.class, acceptMimeType);
            }

            public static /* synthetic */ Get jsonSearchPage$default(Companion this_, String url, String acceptMimeType, int n, Object object) {
                if ((n & 2) != 0) {
                    acceptMimeType = null;
                }
                boolean $i$f$jsonSearchPage = false;
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new JsonSearchPage<Object>(url, Object.class, acceptMimeType);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Head;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "url", "", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/String;)V", "getAcceptMimeType", "()Ljava/lang/String;", "intellij.vcs.github"})
    public static abstract class Head<T>
    extends GithubApiRequest<T> {
        @Nullable
        private final String acceptMimeType;

        @Override
        @Nullable
        public String getAcceptMimeType() {
            return this.acceptMimeType;
        }

        @JvmOverloads
        public Head(@NotNull String url, @Nullable String acceptMimeType) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(url, null);
            this.acceptMimeType = acceptMimeType;
        }

        public /* synthetic */ Head(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        @JvmOverloads
        public Head(@NotNull String url) {
            this(url, null, 2, null);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b&\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$WithBody;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "url", "", "(Ljava/lang/String;)V", "body", "getBody", "()Ljava/lang/String;", "bodyMimeType", "getBodyMimeType", "intellij.vcs.github"})
    public static abstract class WithBody<T>
    extends GithubApiRequest<T> {
        @Nullable
        public abstract String getBody();

        @NotNull
        public abstract String getBodyMimeType();

        public WithBody(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(url, null);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b&\u0018\u0000 \r*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003\r\u000e\u000fB#\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0007R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$WithBody;", "bodyMimeType", "", "url", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAcceptMimeType", "()Ljava/lang/String;", "setAcceptMimeType", "(Ljava/lang/String;)V", "getBodyMimeType", "Companion", "GQLQuery", "Json", "intellij.vcs.github"})
    public static abstract class Post<T>
    extends WithBody<T> {
        @NotNull
        private final String bodyMimeType;
        @Nullable
        private String acceptMimeType;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public String getBodyMimeType() {
            return this.bodyMimeType;
        }

        @Override
        @Nullable
        public String getAcceptMimeType() {
            return this.acceptMimeType;
        }

        public void setAcceptMimeType(@Nullable String string) {
            this.acceptMimeType = string;
        }

        @JvmOverloads
        public Post(@NotNull String bodyMimeType, @NotNull String url, @Nullable String acceptMimeType) {
            Intrinsics.checkNotNullParameter((Object)bodyMimeType, (String)"bodyMimeType");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(url);
            this.bodyMimeType = bodyMimeType;
            this.acceptMimeType = acceptMimeType;
        }

        public /* synthetic */ Post(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @JvmOverloads
        public Post(@NotNull String bodyMimeType, @NotNull String url) {
            this(bodyMimeType, url, null, 4, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000e\u001a\u00028\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u000b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$Json;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "url", "", "bodyObject", "", "clazz", "Ljava/lang/Class;", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;Ljava/lang/String;)V", "body", "getBody", "()Ljava/lang/String;", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
        public static class Json<T>
        extends Post<T> {
            private final Object bodyObject;
            private final Class<T> clazz;

            @Override
            @NotNull
            public String getBody() {
                return GithubApiContentHelper.toJson$default(this.bodyObject, false, 2, null);
            }

            @Override
            public T extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return (T)GithubApiRequest.Companion.parseJsonObject(response, this.clazz);
            }

            public Json(@NotNull String url, @NotNull Object bodyObject, @NotNull Class<T> clazz, @Nullable String acceptMimeType) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)bodyObject, (String)"bodyObject");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                super("application/json", url, acceptMimeType);
                this.bodyObject = bodyObject;
                this.clazz = clazz;
            }

            public /* synthetic */ Json(String string, Object object, Class clazz, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 8) != 0) {
                    string2 = "application/vnd.github.v3+json";
                }
                this(string, object, clazz, string2);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0006\b\u0002\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003\u001e\u001f B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ=\u0010\u0010\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0003\u0010\u00012\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0016H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0004R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "url", "", "queryName", "variablesObject", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", "body", "getBody", "()Ljava/lang/String;", "tokenHeaderType", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$TokenHeaderType;", "getTokenHeaderType", "()Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$TokenHeaderType;", "parseResponse", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "clazz", "Ljava/lang/Class;", "pathFromData", "", "parseResponse$intellij_vcs_github", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;Ljava/lang/Class;[Ljava/lang/String;)Ljava/lang/Object;", "throwException", "", "errors", "", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLSyntaxError;", "OptionalTraversedParsed", "Parsed", "TraversedParsed", "intellij.vcs.github"})
        public static abstract class GQLQuery<T>
        extends Post<T> {
            @NotNull
            private final GithubApiRequestExecutor.TokenHeaderType tokenHeaderType;
            private final String queryName;
            private final Object variablesObject;

            @Override
            @NotNull
            public GithubApiRequestExecutor.TokenHeaderType getTokenHeaderType() {
                return this.tokenHeaderType;
            }

            @Override
            @NotNull
            public String getBody() {
                String query = GHGQLQueryLoader.INSTANCE.loadQuery(this.queryName);
                GHGQLQueryRequest request = new GHGQLQueryRequest(query, this.variablesObject);
                return GithubApiContentHelper.toJson(request, true);
            }

            @NotNull
            protected final Void throwException(@NotNull List<GHGQLSyntaxError> errors) {
                boolean bl;
                block5: {
                    Intrinsics.checkNotNullParameter(errors, (String)"errors");
                    Iterable $this$any$iv = errors;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            GHGQLSyntaxError it = (GHGQLSyntaxError)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.equals((String)it.getType(), (String)"INSUFFICIENT_SCOPES", (boolean)true)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    throw (Throwable)new GithubAuthenticationException("Access token has not been granted the required scopes.");
                }
                if (errors.size() == 1) {
                    throw (Throwable)new GithubConfusingException(((GHGQLSyntaxError)CollectionsKt.single(errors)).toString());
                }
                throw (Throwable)new GithubConfusingException(errors.toString());
            }

            @Nullable
            public final <T> T parseResponse$intellij_vcs_github(@NotNull GithubApiResponse response, @NotNull Class<T> clazz, @NotNull String[] pathFromData) {
                List<GHGQLSyntaxError> errors;
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                Intrinsics.checkNotNullParameter((Object)pathFromData, (String)"pathFromData");
                GHGQLResponse result = GithubApiRequest.Companion.parseGQLResponse(response, JsonNode.class);
                JsonNode data = (JsonNode)result.getData();
                if (data != null && !data.isNull()) {
                    JsonNode node = data;
                    for (String path : pathFromData) {
                        if (node.get(path) != null) continue;
                        break;
                    }
                    if (!node.isNull()) {
                        String string = node.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.toString()");
                        return GithubApiContentHelper.fromJson(string, clazz, true);
                    }
                }
                if ((errors = result.getErrors()) == null) {
                    return null;
                }
                Void void_ = this.throwException(errors);
                throw new KotlinNothingValueException();
            }

            public GQLQuery(@NotNull String url, @NotNull String queryName, @NotNull Object variablesObject) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)queryName, (String)"queryName");
                Intrinsics.checkNotNullParameter((Object)variablesObject, (String)"variablesObject");
                super("application/json", url, null, 4, null);
                this.queryName = queryName;
                this.variablesObject = variablesObject;
                this.tokenHeaderType = GithubApiRequestExecutor.TokenHeaderType.BEARER;
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0006\b\u0003\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00030\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00032\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00030\tX\u0088\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery$Parsed;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "url", "", "requestFilePath", "variablesObject", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)V", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
            public static final class Parsed<T>
            extends GQLQuery<T> {
                private final Class<T> clazz;

                @Override
                public T extractResult(@NotNull GithubApiResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    GHGQLResponse result = GithubApiRequest.Companion.parseGQLResponse(response, this.clazz);
                    Object data = result.getData();
                    if (data != null) {
                        return data;
                    }
                    List<GHGQLSyntaxError> errors = result.getErrors();
                    if (errors == null) {
                        String string = "Undefined request state - both result and errors are null";
                        boolean bl = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    Void void_ = this.throwException(errors);
                    throw new KotlinNothingValueException();
                }

                public Parsed(@NotNull String url, @NotNull String requestFilePath, @NotNull Object variablesObject, @NotNull Class<T> clazz) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.checkNotNullParameter((Object)requestFilePath, (String)"requestFilePath");
                    Intrinsics.checkNotNullParameter((Object)variablesObject, (String)"variablesObject");
                    Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                    super(url, requestFilePath, variablesObject);
                    this.clazz = clazz;
                }
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\n\b\u0003\u0010\u0001 \u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BA\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00030\t\u0012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u000b\"\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u000e\u001a\u00028\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0016\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery$TraversedParsed;", "T", "", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "url", "", "requestFilePath", "variablesObject", "clazz", "Ljava/lang/Class;", "pathFromData", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;[Ljava/lang/String;)V", "[Ljava/lang/String;", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
            public static final class TraversedParsed<T>
            extends GQLQuery<T> {
                private final Class<? extends T> clazz;
                private final String[] pathFromData;

                @Override
                @NotNull
                public T extractResult(@NotNull GithubApiResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    T t = this.parseResponse$intellij_vcs_github(response, this.clazz, this.pathFromData);
                    if (t == null) {
                        throw (Throwable)new GithubJsonException("Non-nullable entity is null or entity path is invalid");
                    }
                    return t;
                }

                public TraversedParsed(@NotNull String url, @NotNull String requestFilePath, @NotNull Object variablesObject, @NotNull Class<? extends T> clazz, String ... pathFromData) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.checkNotNullParameter((Object)requestFilePath, (String)"requestFilePath");
                    Intrinsics.checkNotNullParameter((Object)variablesObject, (String)"variablesObject");
                    Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                    Intrinsics.checkNotNullParameter((Object)pathFromData, (String)"pathFromData");
                    super(url, requestFilePath, variablesObject);
                    this.clazz = clazz;
                    this.pathFromData = pathFromData;
                }
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0003\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00030\t\u0012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000b\"\u00020\u0004\u00a2\u0006\u0002\u0010\fJ\u0017\u0010\u000e\u001a\u0004\u0018\u00018\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery$OptionalTraversedParsed;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "url", "", "requestFilePath", "variablesObject", "", "clazz", "Ljava/lang/Class;", "pathFromData", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;[Ljava/lang/String;)V", "[Ljava/lang/String;", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
            public static final class OptionalTraversedParsed<T>
            extends GQLQuery<T> {
                private final Class<T> clazz;
                private final String[] pathFromData;

                @Override
                @Nullable
                public T extractResult(@NotNull GithubApiResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    return this.parseResponse$intellij_vcs_github(response, this.clazz, this.pathFromData);
                }

                public OptionalTraversedParsed(@NotNull String url, @NotNull String requestFilePath, @NotNull Object variablesObject, @NotNull Class<T> clazz, String ... pathFromData) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.checkNotNullParameter((Object)requestFilePath, (String)"requestFilePath");
                    Intrinsics.checkNotNullParameter((Object)variablesObject, (String)"variablesObject");
                    Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                    Intrinsics.checkNotNullParameter((Object)pathFromData, (String)"pathFromData");
                    super(url, requestFilePath, variablesObject);
                    this.clazz = clazz;
                    this.pathFromData = pathFromData;
                }
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0006\b\u0002\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0086\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$Companion;", "", "()V", "json", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "T", "url", "", "body", "acceptMimeType", "intellij.vcs.github"})
        public static final class Companion {
            public final /* synthetic */ <T> Post<T> json(String url, Object body2, String acceptMimeType) {
                int $i$f$json = 0;
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body2, Object.class, acceptMimeType);
            }

            public static /* synthetic */ Post json$default(Companion this_, String url, Object body2, String acceptMimeType, int n, Object object) {
                if ((n & 4) != 0) {
                    acceptMimeType = null;
                }
                boolean $i$f$json = false;
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body2, Object.class, acceptMimeType);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b&\u0018\u0000 \u000b*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003\u000b\f\rB#\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0007R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$WithBody;", "bodyMimeType", "", "url", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAcceptMimeType", "()Ljava/lang/String;", "getBodyMimeType", "Companion", "Json", "JsonList", "intellij.vcs.github"})
    public static abstract class Put<T>
    extends WithBody<T> {
        @NotNull
        private final String bodyMimeType;
        @Nullable
        private final String acceptMimeType;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public String getBodyMimeType() {
            return this.bodyMimeType;
        }

        @Override
        @Nullable
        public String getAcceptMimeType() {
            return this.acceptMimeType;
        }

        @JvmOverloads
        public Put(@NotNull String bodyMimeType, @NotNull String url, @Nullable String acceptMimeType) {
            Intrinsics.checkNotNullParameter((Object)bodyMimeType, (String)"bodyMimeType");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(url);
            this.bodyMimeType = bodyMimeType;
            this.acceptMimeType = acceptMimeType;
        }

        public /* synthetic */ Put(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @JvmOverloads
        public Put(@NotNull String bodyMimeType, @NotNull String url) {
            this(bodyMimeType, url, null, 4, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\r\u001a\u00028\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u0016\u0010\n\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put$Json;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put;", "url", "", "bodyObject", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)V", "body", "getBody", "()Ljava/lang/String;", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
        public static class Json<T>
        extends Put<T> {
            private final Object bodyObject;
            private final Class<T> clazz;

            @Override
            @Nullable
            public String getBody() {
                String string;
                Object object = this.bodyObject;
                if (object != null) {
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    string = GithubApiContentHelper.toJson$default(it, false, 2, null);
                } else {
                    string = null;
                }
                return string;
            }

            @Override
            public T extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return (T)GithubApiRequest.Companion.parseJsonObject(response, this.clazz);
            }

            public Json(@NotNull String url, @Nullable Object bodyObject, @NotNull Class<T> clazz) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                super("application/json", url, "application/vnd.github.v3+json");
                this.bodyObject = bodyObject;
                this.clazz = clazz;
                if (this.bodyObject == null) {
                    this.getHeaders().put("Content-Length", "0");
                }
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put$JsonList;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put;", "", "url", "", "bodyObject", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)V", "body", "getBody", "()Ljava/lang/String;", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "intellij.vcs.github"})
        public static class JsonList<T>
        extends Put<List<? extends T>> {
            private final Object bodyObject;
            private final Class<T> clazz;

            @Override
            @Nullable
            public String getBody() {
                String string;
                Object object = this.bodyObject;
                if (object != null) {
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    string = GithubApiContentHelper.toJson$default(it, false, 2, null);
                } else {
                    string = null;
                }
                return string;
            }

            @Override
            @NotNull
            public List<T> extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return GithubApiRequest.Companion.parseJsonList(response, this.clazz);
            }

            public JsonList(@NotNull String url, @Nullable Object bodyObject, @NotNull Class<T> clazz) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                super("application/json", url, "application/vnd.github.v3+json");
                this.bodyObject = bodyObject;
                this.clazz = clazz;
                if (this.bodyObject == null) {
                    this.getHeaders().put("Content-Length", "0");
                }
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0006\b\u0002\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0086\bJ-\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\n0\u0004\"\u0006\b\u0002\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0086\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put$Companion;", "", "()V", "json", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put;", "T", "url", "", "body", "jsonList", "", "intellij.vcs.github"})
        public static final class Companion {
            public final /* synthetic */ <T> Put<T> json(String url, Object body2) {
                int $i$f$json = 0;
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body2, Object.class);
            }

            public static /* synthetic */ Put json$default(Companion this_, String url, Object body2, int n, Object object) {
                if ((n & 2) != 0) {
                    body2 = null;
                }
                boolean $i$f$json = false;
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body2, Object.class);
            }

            public final /* synthetic */ <T> Put<List<T>> jsonList(String url, Object body2) {
                int $i$f$jsonList = 0;
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new JsonList<Object>(url, body2, Object.class);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b&\u0018\u0000 \r*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\r\u000eB#\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0007R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Patch;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "bodyMimeType", "", "url", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAcceptMimeType", "()Ljava/lang/String;", "setAcceptMimeType", "(Ljava/lang/String;)V", "getBodyMimeType", "Companion", "Json", "intellij.vcs.github"})
    public static abstract class Patch<T>
    extends Post<T> {
        @NotNull
        private final String bodyMimeType;
        @Nullable
        private String acceptMimeType;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public String getBodyMimeType() {
            return this.bodyMimeType;
        }

        @Override
        @Nullable
        public String getAcceptMimeType() {
            return this.acceptMimeType;
        }

        @Override
        public void setAcceptMimeType(@Nullable String string) {
            this.acceptMimeType = string;
        }

        @JvmOverloads
        public Patch(@NotNull String bodyMimeType, @NotNull String url, @Nullable String acceptMimeType) {
            Intrinsics.checkNotNullParameter((Object)bodyMimeType, (String)"bodyMimeType");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(bodyMimeType, url, acceptMimeType);
            this.bodyMimeType = bodyMimeType;
            this.acceptMimeType = acceptMimeType;
        }

        public /* synthetic */ Patch(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @JvmOverloads
        public Patch(@NotNull String bodyMimeType, @NotNull String url) {
            this(bodyMimeType, url, null, 4, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Patch$Json;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$Json;", "url", "", "bodyObject", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)V", "intellij.vcs.github"})
        public static class Json<T>
        extends Post.Json<T> {
            public Json(@NotNull String url, @NotNull Object bodyObject, @NotNull Class<T> clazz) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)bodyObject, (String)"bodyObject");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                super(url, bodyObject, clazz, null, 8, null);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0006\b\u0002\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0086\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Patch$Companion;", "", "()V", "json", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "T", "url", "", "body", "intellij.vcs.github"})
        public static final class Companion {
            public final /* synthetic */ <T> Post<T> json(String url, Object body2) {
                int $i$f$json = 0;
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body2, Object.class);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b&\u0018\u0000 \u000b*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\u000b\fB#\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0007R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Delete;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$WithBody;", "bodyMimeType", "", "url", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAcceptMimeType", "()Ljava/lang/String;", "getBodyMimeType", "Companion", "Json", "intellij.vcs.github"})
    public static abstract class Delete<T>
    extends WithBody<T> {
        @NotNull
        private final String bodyMimeType;
        @Nullable
        private final String acceptMimeType;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public String getBodyMimeType() {
            return this.bodyMimeType;
        }

        @Override
        @Nullable
        public String getAcceptMimeType() {
            return this.acceptMimeType;
        }

        @JvmOverloads
        public Delete(@NotNull String bodyMimeType, @NotNull String url, @Nullable String acceptMimeType) {
            Intrinsics.checkNotNullParameter((Object)bodyMimeType, (String)"bodyMimeType");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(url);
            this.bodyMimeType = bodyMimeType;
            this.acceptMimeType = acceptMimeType;
        }

        public /* synthetic */ Delete(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @JvmOverloads
        public Delete(@NotNull String bodyMimeType, @NotNull String url) {
            this(bodyMimeType, url, null, 4, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\r\u001a\u00028\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u0016\u0010\n\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Delete$Json;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Delete;", "url", "", "bodyObject", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)V", "body", "getBody", "()Ljava/lang/String;", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
        public static class Json<T>
        extends Delete<T> {
            private final Object bodyObject;
            private final Class<T> clazz;

            @Override
            @Nullable
            public String getBody() {
                String string;
                Object object = this.bodyObject;
                if (object != null) {
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    string = GithubApiContentHelper.toJson$default(it, false, 2, null);
                } else {
                    string = null;
                }
                return string;
            }

            @Override
            public T extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return (T)GithubApiRequest.Companion.parseJsonObject(response, this.clazz);
            }

            public Json(@NotNull String url, @Nullable Object bodyObject, @NotNull Class<T> clazz) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                super("application/json", url, "application/vnd.github.v3+json");
                this.bodyObject = bodyObject;
                this.clazz = clazz;
                if (this.bodyObject == null) {
                    this.getHeaders().put("Content-Length", "0");
                }
            }

            public /* synthetic */ Json(String string, Object object, Class clazz, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    object = null;
                }
                this(string, object, clazz);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0006\b\u0002\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0086\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Delete$Companion;", "", "()V", "json", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Delete;", "T", "url", "", "body", "intellij.vcs.github"})
        public static final class Companion {
            public final /* synthetic */ <T> Delete<T> json(String url, Object body2) {
                int $i$f$json = 0;
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body2, Object.class);
            }

            public static /* synthetic */ Delete json$default(Companion this_, String url, Object body2, int n, Object object) {
                if ((n & 2) != 0) {
                    body2 = null;
                }
                boolean $i$f$json = false;
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body2, Object.class);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\tH\u0002J*\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000b\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0002J)\u0010\f\u001a\u0002H\u0005\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0002\u00a2\u0006\u0002\u0010\rJ*\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000f\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Companion;", "", "()V", "parseGQLResponse", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLResponse;", "T", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "clazz", "Ljava/lang/Class;", "parseJsonList", "", "parseJsonObject", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;Ljava/lang/Class;)Ljava/lang/Object;", "parseJsonSearchPage", "Lorg/jetbrains/plugins/github/api/data/GithubSearchResult;", "intellij.vcs.github"})
    public static final class Companion {
        private final <T> T parseJsonObject(GithubApiResponse response, Class<T> clazz) {
            return response.readBody((ThrowableConvertor)new ThrowableConvertor<Reader, T, IOException>(clazz){
                final /* synthetic */ Class $clazz;

                public final T convert(Reader it) {
                    Reader reader = it;
                    Intrinsics.checkNotNullExpressionValue((Object)reader, (String)"it");
                    return (T)GithubApiContentHelper.readJsonObject$default(reader, this.$clazz, new Class[0], false, 8, null);
                }
                {
                    this.$clazz = clazz;
                }
            });
        }

        private final <T> List<T> parseJsonList(GithubApiResponse response, Class<T> clazz) {
            Object t = response.readBody((ThrowableConvertor)new ThrowableConvertor<Reader, List<? extends T>, IOException>(clazz){
                final /* synthetic */ Class $clazz;

                public final List<T> convert(Reader it) {
                    Reader reader = it;
                    Intrinsics.checkNotNullExpressionValue((Object)reader, (String)"it");
                    return GithubApiContentHelper.readJsonList(reader, this.$clazz);
                }
                {
                    this.$clazz = clazz;
                }
            });
            Intrinsics.checkNotNullExpressionValue(t, (String)"response.readBody(Throwa\u2026eadJsonList(it, clazz) })");
            return (List)t;
        }

        private final <T> GithubSearchResult<T> parseJsonSearchPage(GithubApiResponse response, Class<T> clazz) {
            Object t = response.readBody((ThrowableConvertor)new ThrowableConvertor<Reader, GithubSearchResult<T>, IOException>(clazz){
                final /* synthetic */ Class $clazz;

                public final GithubSearchResult<T> convert(Reader it) {
                    Reader reader = it;
                    Intrinsics.checkNotNullExpressionValue((Object)reader, (String)"it");
                    Object object = GithubApiContentHelper.readJsonObject$default(reader, GithubSearchResult.class, new Class[]{this.$clazz}, false, 8, null);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.plugins.github.api.data.GithubSearchResult<T>");
                    }
                    return (GithubSearchResult)object;
                }
                {
                    this.$clazz = clazz;
                }
            });
            Intrinsics.checkNotNullExpressionValue(t, (String)"response.readBody(Throwa\u2026bSearchResult<T>\n      })");
            return (GithubSearchResult)t;
        }

        private final <T> GHGQLResponse<? extends T> parseGQLResponse(GithubApiResponse response, Class<? extends T> clazz) {
            Object t = response.readBody((ThrowableConvertor)new ThrowableConvertor<Reader, GHGQLResponse<T>, IOException>(clazz){
                final /* synthetic */ Class $clazz;

                public final GHGQLResponse<T> convert(Reader it) {
                    Reader reader = it;
                    Intrinsics.checkNotNullExpressionValue((Object)reader, (String)"it");
                    GHGQLResponse gHGQLResponse = GithubApiContentHelper.readJsonObject(reader, GHGQLResponse.class, new Class[]{this.$clazz}, true);
                    if (gHGQLResponse == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.plugins.github.api.data.graphql.GHGQLResponse<T>");
                    }
                    return gHGQLResponse;
                }
                {
                    this.$clazz = clazz;
                }
            });
            Intrinsics.checkNotNullExpressionValue(t, (String)"response.readBody(Throwa\u2026GHGQLResponse<T>\n      })");
            return (GHGQLResponse)t;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

