/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.diff.util.Side;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHBranchProtectionRule;
import org.jetbrains.plugins.github.api.data.GHComment;
import org.jetbrains.plugins.github.api.data.GHConnection;
import org.jetbrains.plugins.github.api.data.GHNodes;
import org.jetbrains.plugins.github.api.data.GHPullRequestReviewEvent;
import org.jetbrains.plugins.github.api.data.GHRepository;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLPageInfo;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLPagedRequestResponse;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLRequestPagination;
import org.jetbrains.plugins.github.api.data.graphql.query.GHGQLSearchQueryResponse;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestCommit;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestMergeabilityData;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestPendingReview;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReview;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewComment;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewCommentWithPendingReview;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewThread;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.api.data.pullrequest.GHTeam;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem;
import org.jetbrains.plugins.github.api.data.request.GHPullRequestDraftReviewComment;
import org.jetbrains.plugins.github.api.data.request.GHPullRequestDraftReviewThread;
import org.jetbrains.plugins.github.api.util.GHSchemaPreview;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests;", "", "()V", "Comment", "Organization", "PullRequest", "Repo", "intellij.vcs.github"})
public final class GHGQLRequests {
    @NotNull
    public static final GHGQLRequests INSTANCE;

    private GHGQLRequests() {
    }

    static {
        GHGQLRequests gHGQLRequests;
        INSTANCE = gHGQLRequests = new GHGQLRequests();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$Organization;", "", "()V", "Team", "intellij.vcs.github"})
    public static final class Organization {
        @NotNull
        public static final Organization INSTANCE;

        private Organization() {
        }

        static {
            Organization organization;
            INSTANCE = organization = new Organization();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ<\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$Organization$Team;", "", "()V", "findAll", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLPagedRequestResponse;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHTeam;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "organization", "", "pagination", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLRequestPagination;", "findByUserLogins", "logins", "", "TeamsConnection", "intellij.vcs.github"})
        public static final class Team {
            @NotNull
            public static final Team INSTANCE;

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHGQLPagedRequestResponse<GHTeam>> findAll(@NotNull GithubServerPath server, @NotNull String organization, @Nullable GHGQLRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)organization, (String)"organization");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
                Pair[] pairArray = new Pair[3];
                pairArray[0] = TuplesKt.to((Object)"organization", (Object)organization);
                GHGQLRequestPagination gHGQLRequestPagination = pagination;
                pairArray[1] = TuplesKt.to((Object)"pageSize", (Object)(gHGQLRequestPagination != null ? Integer.valueOf(gHGQLRequestPagination.getPageSize()) : null));
                GHGQLRequestPagination gHGQLRequestPagination2 = pagination;
                pairArray[2] = TuplesKt.to((Object)"cursor", (Object)(gHGQLRequestPagination2 != null ? gHGQLRequestPagination2.getAfterCursor() : null));
                return new GithubApiRequest.Post.GQLQuery.TraversedParsed<TeamsConnection>(string, "findOrganizationTeams", MapsKt.mapOf((Pair[])pairArray), TeamsConnection.class, "organization", "teams");
            }

            public static /* synthetic */ GithubApiRequest.Post.GQLQuery findAll$default(Team team, GithubServerPath githubServerPath, String string, GHGQLRequestPagination gHGQLRequestPagination, int n, Object object) {
                if ((n & 4) != 0) {
                    gHGQLRequestPagination = null;
                }
                return team.findAll(githubServerPath, string, gHGQLRequestPagination);
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHGQLPagedRequestResponse<GHTeam>> findByUserLogins(@NotNull GithubServerPath server, @NotNull String organization, @NotNull List<String> logins, @Nullable GHGQLRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)organization, (String)"organization");
                Intrinsics.checkNotNullParameter(logins, (String)"logins");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
                Pair[] pairArray = new Pair[4];
                pairArray[0] = TuplesKt.to((Object)"organization", (Object)organization);
                pairArray[1] = TuplesKt.to((Object)"logins", logins);
                GHGQLRequestPagination gHGQLRequestPagination = pagination;
                pairArray[2] = TuplesKt.to((Object)"pageSize", (Object)(gHGQLRequestPagination != null ? Integer.valueOf(gHGQLRequestPagination.getPageSize()) : null));
                GHGQLRequestPagination gHGQLRequestPagination2 = pagination;
                pairArray[3] = TuplesKt.to((Object)"cursor", (Object)(gHGQLRequestPagination2 != null ? gHGQLRequestPagination2.getAfterCursor() : null));
                return new GithubApiRequest.Post.GQLQuery.TraversedParsed<TeamsConnection>(string, "findOrganizationTeams", MapsKt.mapOf((Pair[])pairArray), TeamsConnection.class, "organization", "teams");
            }

            public static /* synthetic */ GithubApiRequest.Post.GQLQuery findByUserLogins$default(Team team, GithubServerPath githubServerPath, String string, List list2, GHGQLRequestPagination gHGQLRequestPagination, int n, Object object) {
                if ((n & 8) != 0) {
                    gHGQLRequestPagination = null;
                }
                return team.findByUserLogins(githubServerPath, string, list2, gHGQLRequestPagination);
            }

            private Team() {
            }

            static {
                Team team;
                INSTANCE = team = new Team();
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$Organization$Team$TeamsConnection;", "Lorg/jetbrains/plugins/github/api/data/GHConnection;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHTeam;", "pageInfo", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLPageInfo;", "nodes", "", "(Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLPageInfo;Ljava/util/List;)V", "intellij.vcs.github"})
            private static final class TeamsConnection
            extends GHConnection<GHTeam> {
                public TeamsConnection(@NotNull GHGQLPageInfo pageInfo, @NotNull List<GHTeam> nodes) {
                    Intrinsics.checkNotNullParameter((Object)pageInfo, (String)"pageInfo");
                    Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                    super(pageInfo, nodes);
                }
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$Repo;", "", "()V", "find", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "Lorg/jetbrains/plugins/github/api/data/GHRepository;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "getProtectionRules", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLPagedRequestResponse;", "Lorg/jetbrains/plugins/github/api/data/GHBranchProtectionRule;", "pagination", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLRequestPagination;", "ProtectedRulesConnection", "intellij.vcs.github"})
    public static final class Repo {
        @NotNull
        public static final Repo INSTANCE;

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHRepository> find(@NotNull GHRepositoryCoordinates repository) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repository.serverPath.toGraphQLUrl()");
            return new GithubApiRequest.Post.GQLQuery.OptionalTraversedParsed<GHRepository>(string, "findRepository", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"repoOwner", (Object)repository.getRepositoryPath().getOwner()), TuplesKt.to((Object)"repoName", (Object)repository.getRepositoryPath().getRepository())}), GHRepository.class, "repository");
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHGQLPagedRequestResponse<GHBranchProtectionRule>> getProtectionRules(@NotNull GHRepositoryCoordinates repository, @Nullable GHGQLRequestPagination pagination) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repository.serverPath.toGraphQLUrl()");
            Pair[] pairArray = new Pair[4];
            pairArray[0] = TuplesKt.to((Object)"repoOwner", (Object)repository.getRepositoryPath().getOwner());
            pairArray[1] = TuplesKt.to((Object)"repoName", (Object)repository.getRepositoryPath().getRepository());
            GHGQLRequestPagination gHGQLRequestPagination = pagination;
            pairArray[2] = TuplesKt.to((Object)"pageSize", (Object)(gHGQLRequestPagination != null ? Integer.valueOf(gHGQLRequestPagination.getPageSize()) : null));
            GHGQLRequestPagination gHGQLRequestPagination2 = pagination;
            pairArray[3] = TuplesKt.to((Object)"cursor", (Object)(gHGQLRequestPagination2 != null ? gHGQLRequestPagination2.getAfterCursor() : null));
            return new GithubApiRequest.Post.GQLQuery.TraversedParsed<ProtectedRulesConnection>(string, "getProtectionRules", MapsKt.mapOf((Pair[])pairArray), ProtectedRulesConnection.class, "repository", "branchProtectionRules");
        }

        public static /* synthetic */ GithubApiRequest.Post.GQLQuery getProtectionRules$default(Repo repo, GHRepositoryCoordinates gHRepositoryCoordinates, GHGQLRequestPagination gHGQLRequestPagination, int n, Object object) {
            if ((n & 2) != 0) {
                gHGQLRequestPagination = null;
            }
            return repo.getProtectionRules(gHRepositoryCoordinates, gHGQLRequestPagination);
        }

        private Repo() {
        }

        static {
            Repo repo;
            INSTANCE = repo = new Repo();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$Repo$ProtectedRulesConnection;", "Lorg/jetbrains/plugins/github/api/data/GHConnection;", "Lorg/jetbrains/plugins/github/api/data/GHBranchProtectionRule;", "pageInfo", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLPageInfo;", "nodes", "", "(Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLPageInfo;Ljava/util/List;)V", "intellij.vcs.github"})
        private static final class ProtectedRulesConnection
        extends GHConnection<GHBranchProtectionRule> {
            public ProtectedRulesConnection(@NotNull GHGQLPageInfo pageInfo, @NotNull List<GHBranchProtectionRule> nodes) {
                Intrinsics.checkNotNullParameter((Object)pageInfo, (String)"pageInfo");
                Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                super(pageInfo, nodes);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$Comment;", "", "()V", "deleteComment", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "commentId", "", "getCommentBody", "updateComment", "Lorg/jetbrains/plugins/github/api/data/GHComment;", "newText", "intellij.vcs.github"})
    public static final class Comment {
        @NotNull
        public static final Comment INSTANCE;

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<String> getCommentBody(@NotNull GithubServerPath server, @NotNull String commentId) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
            String string = server.toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
            return new GithubApiRequest.Post.GQLQuery.TraversedParsed<String>(string, "commentBody", MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)commentId)), String.class, "node", "body");
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHComment> updateComment(@NotNull GithubServerPath server, @NotNull String commentId, @NotNull String newText) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
            String string = server.toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
            return new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHComment>(string, "updateIssueComment", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"id", (Object)commentId), TuplesKt.to((Object)"body", (Object)newText)}), GHComment.class, "updateIssueComment", "issueComment");
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<Object> deleteComment(@NotNull GithubServerPath server, @NotNull String commentId) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
            String string = server.toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
            return new GithubApiRequest.Post.GQLQuery.TraversedParsed<Object>(string, "deleteIssueComment", MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)commentId)), Object.class, new String[0]);
        }

        private Comment() {
        }

        static {
            Comment comment;
            INSTANCE = comment = new Comment();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006*+,-./B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJQ\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010\u0017J*\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010J\u001e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0010J\u001e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ.\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ.\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0$0\u00042\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00102\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ0\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00102\b\u0010)\u001a\u0004\u0018\u00010\u0010\u00a8\u00060"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$PullRequest;", "", "()V", "commits", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLPagedRequestResponse;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestCommit;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "number", "", "pagination", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLRequestPagination;", "create", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "repositoryId", "", "baseRefName", "headRefName", "title", "body", "draft", "", "(Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;)Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "findByBranches", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequest;", "baseBranch", "headBranch", "findOne", "markReadyForReview", "pullRequestId", "mergeabilityData", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestMergeabilityData;", "reviewThreads", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewThread;", "search", "Lorg/jetbrains/plugins/github/api/data/graphql/query/GHGQLSearchQueryResponse;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "query", "update", "description", "CommitsConnection", "PRSearch", "PullRequestsConnection", "Review", "ThreadsConnection", "Timeline", "intellij.vcs.github"})
    public static final class PullRequest {
        @NotNull
        public static final PullRequest INSTANCE;

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHPullRequestShort> create(@NotNull GHRepositoryCoordinates repository, @NotNull String repositoryId, @NotNull String baseRefName, @NotNull String headRefName, @NotNull String title, @Nullable String body2, @Nullable Boolean draft) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"repositoryId");
            Intrinsics.checkNotNullParameter((Object)baseRefName, (String)"baseRefName");
            Intrinsics.checkNotNullParameter((Object)headRefName, (String)"headRefName");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repository.serverPath.toGraphQLUrl()");
            GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestShort> traversedParsed = new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestShort>(string, "createPullRequest", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"repositoryId", (Object)repositoryId), TuplesKt.to((Object)"baseRefName", (Object)baseRefName), TuplesKt.to((Object)"headRefName", (Object)headRefName), TuplesKt.to((Object)"title", (Object)title), TuplesKt.to((Object)"body", (Object)body2), TuplesKt.to((Object)"draft", (Object)draft)}), GHPullRequestShort.class, "createPullRequest", "pullRequest");
            boolean bl = false;
            boolean bl2 = false;
            GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestShort> $this$apply = traversedParsed;
            boolean bl3 = false;
            $this$apply.setAcceptMimeType(GHSchemaPreview.PR_DRAFT.getMimeType());
            return traversedParsed;
        }

        public static /* synthetic */ GithubApiRequest.Post.GQLQuery create$default(PullRequest pullRequest, GHRepositoryCoordinates gHRepositoryCoordinates, String string, String string2, String string3, String string4, String string5, Boolean bl, int n, Object object) {
            if ((n & 0x20) != 0) {
                string5 = null;
            }
            if ((n & 0x40) != 0) {
                bl = false;
            }
            return pullRequest.create(gHRepositoryCoordinates, string, string2, string3, string4, string5, bl);
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHPullRequest> findOne(@NotNull GHRepositoryCoordinates repository, long number) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repository.serverPath.toGraphQLUrl()");
            GithubApiRequest.Post.GQLQuery.OptionalTraversedParsed<GHPullRequest> optionalTraversedParsed = new GithubApiRequest.Post.GQLQuery.OptionalTraversedParsed<GHPullRequest>(string, "findPullRequest", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"repoOwner", (Object)repository.getRepositoryPath().getOwner()), TuplesKt.to((Object)"repoName", (Object)repository.getRepositoryPath().getRepository()), TuplesKt.to((Object)"number", (Object)number)}), GHPullRequest.class, "repository", "pullRequest");
            boolean bl = false;
            boolean bl2 = false;
            GithubApiRequest.Post.GQLQuery.OptionalTraversedParsed<GHPullRequest> $this$apply = optionalTraversedParsed;
            boolean bl3 = false;
            $this$apply.setAcceptMimeType(GHSchemaPreview.PR_DRAFT.getMimeType());
            return optionalTraversedParsed;
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHGQLPagedRequestResponse<GHPullRequest>> findByBranches(@NotNull GHRepositoryCoordinates repository, @NotNull String baseBranch, @NotNull String headBranch) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)baseBranch, (String)"baseBranch");
            Intrinsics.checkNotNullParameter((Object)headBranch, (String)"headBranch");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repository.serverPath.toGraphQLUrl()");
            GithubApiRequest.Post.GQLQuery.TraversedParsed<PullRequestsConnection> traversedParsed = new GithubApiRequest.Post.GQLQuery.TraversedParsed<PullRequestsConnection>(string, "findOpenPullRequestsByBranches", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"repoOwner", (Object)repository.getRepositoryPath().getOwner()), TuplesKt.to((Object)"repoName", (Object)repository.getRepositoryPath().getRepository()), TuplesKt.to((Object)"baseBranch", (Object)baseBranch), TuplesKt.to((Object)"headBranch", (Object)headBranch)}), PullRequestsConnection.class, "repository", "pullRequests");
            boolean bl = false;
            boolean bl2 = false;
            GithubApiRequest.Post.GQLQuery.TraversedParsed<PullRequestsConnection> $this$apply = traversedParsed;
            boolean bl3 = false;
            $this$apply.setAcceptMimeType(GHSchemaPreview.PR_DRAFT.getMimeType());
            return traversedParsed;
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHPullRequest> update(@NotNull GHRepositoryCoordinates repository, @NotNull String pullRequestId, @Nullable String title, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
            Map parameters = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"pullRequestId", (Object)pullRequestId)});
            if (title != null) {
                parameters.put("title", title);
            }
            if (description != null) {
                parameters.put("body", description);
            }
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repository.serverPath.toGraphQLUrl()");
            GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequest> traversedParsed = new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequest>(string, "updatePullRequest", parameters, GHPullRequest.class, "updatePullRequest", "pullRequest");
            boolean bl = false;
            boolean bl2 = false;
            GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequest> $this$apply = traversedParsed;
            boolean bl3 = false;
            $this$apply.setAcceptMimeType(GHSchemaPreview.PR_DRAFT.getMimeType());
            return traversedParsed;
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<Object> markReadyForReview(@NotNull GHRepositoryCoordinates repository, @NotNull String pullRequestId) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repository.serverPath.toGraphQLUrl()");
            GithubApiRequest.Post.GQLQuery.Parsed<Object> parsed = new GithubApiRequest.Post.GQLQuery.Parsed<Object>(string, "markPullRequestReadyForReview", MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"pullRequestId", (Object)pullRequestId)}), Object.class);
            boolean bl = false;
            boolean bl2 = false;
            GithubApiRequest.Post.GQLQuery.Parsed<Object> $this$apply = parsed;
            boolean bl3 = false;
            $this$apply.setAcceptMimeType(GHSchemaPreview.PR_DRAFT.getMimeType());
            return parsed;
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHPullRequestMergeabilityData> mergeabilityData(@NotNull GHRepositoryCoordinates repository, long number) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repository.serverPath.toGraphQLUrl()");
            GithubApiRequest.Post.GQLQuery.OptionalTraversedParsed<GHPullRequestMergeabilityData> optionalTraversedParsed = new GithubApiRequest.Post.GQLQuery.OptionalTraversedParsed<GHPullRequestMergeabilityData>(string, "findPullRequestMergeability", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"repoOwner", (Object)repository.getRepositoryPath().getOwner()), TuplesKt.to((Object)"repoName", (Object)repository.getRepositoryPath().getRepository()), TuplesKt.to((Object)"number", (Object)number)}), GHPullRequestMergeabilityData.class, "repository", "pullRequest");
            boolean bl = false;
            boolean bl2 = false;
            GithubApiRequest.Post.GQLQuery.OptionalTraversedParsed<GHPullRequestMergeabilityData> $this$apply = optionalTraversedParsed;
            boolean bl3 = false;
            $this$apply.setAcceptMimeType(GHSchemaPreview.CHECKS.getMimeType() + ',' + GHSchemaPreview.PR_MERGE_INFO.getMimeType());
            return optionalTraversedParsed;
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHGQLSearchQueryResponse<GHPullRequestShort>> search(@NotNull GithubServerPath server, @NotNull String query, @Nullable GHGQLRequestPagination pagination) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            String string = server.toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
            Pair[] pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to((Object)"query", (Object)query);
            GHGQLRequestPagination gHGQLRequestPagination = pagination;
            pairArray[1] = TuplesKt.to((Object)"pageSize", (Object)(gHGQLRequestPagination != null ? Integer.valueOf(gHGQLRequestPagination.getPageSize()) : null));
            GHGQLRequestPagination gHGQLRequestPagination2 = pagination;
            pairArray[2] = TuplesKt.to((Object)"cursor", (Object)(gHGQLRequestPagination2 != null ? gHGQLRequestPagination2.getAfterCursor() : null));
            GithubApiRequest.Post.GQLQuery.Parsed<PRSearch> parsed = new GithubApiRequest.Post.GQLQuery.Parsed<PRSearch>(string, "issueSearch", MapsKt.mapOf((Pair[])pairArray), PRSearch.class);
            boolean bl = false;
            boolean bl2 = false;
            GithubApiRequest.Post.GQLQuery.Parsed<PRSearch> $this$apply = parsed;
            boolean bl3 = false;
            $this$apply.setAcceptMimeType(GHSchemaPreview.PR_DRAFT.getMimeType());
            return parsed;
        }

        public static /* synthetic */ GithubApiRequest.Post.GQLQuery search$default(PullRequest pullRequest, GithubServerPath githubServerPath, String string, GHGQLRequestPagination gHGQLRequestPagination, int n, Object object) {
            if ((n & 4) != 0) {
                gHGQLRequestPagination = null;
            }
            return pullRequest.search(githubServerPath, string, gHGQLRequestPagination);
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHGQLPagedRequestResponse<GHPullRequestReviewThread>> reviewThreads(@NotNull GHRepositoryCoordinates repository, long number, @Nullable GHGQLRequestPagination pagination) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repository.serverPath.toGraphQLUrl()");
            Pair[] pairArray = new Pair[5];
            pairArray[0] = TuplesKt.to((Object)"repoOwner", (Object)repository.getRepositoryPath().getOwner());
            pairArray[1] = TuplesKt.to((Object)"repoName", (Object)repository.getRepositoryPath().getRepository());
            pairArray[2] = TuplesKt.to((Object)"number", (Object)number);
            GHGQLRequestPagination gHGQLRequestPagination = pagination;
            pairArray[3] = TuplesKt.to((Object)"pageSize", (Object)(gHGQLRequestPagination != null ? Integer.valueOf(gHGQLRequestPagination.getPageSize()) : null));
            GHGQLRequestPagination gHGQLRequestPagination2 = pagination;
            pairArray[4] = TuplesKt.to((Object)"cursor", (Object)(gHGQLRequestPagination2 != null ? gHGQLRequestPagination2.getAfterCursor() : null));
            return new GithubApiRequest.Post.GQLQuery.TraversedParsed<ThreadsConnection>(string, "pullRequestReviewThreads", MapsKt.mapOf((Pair[])pairArray), ThreadsConnection.class, "repository", "pullRequest", "reviewThreads");
        }

        public static /* synthetic */ GithubApiRequest.Post.GQLQuery reviewThreads$default(PullRequest pullRequest, GHRepositoryCoordinates gHRepositoryCoordinates, long l, GHGQLRequestPagination gHGQLRequestPagination, int n, Object object) {
            if ((n & 4) != 0) {
                gHGQLRequestPagination = null;
            }
            return pullRequest.reviewThreads(gHRepositoryCoordinates, l, gHGQLRequestPagination);
        }

        @NotNull
        public final GithubApiRequest.Post.GQLQuery<GHGQLPagedRequestResponse<GHPullRequestCommit>> commits(@NotNull GHRepositoryCoordinates repository, long number, @Nullable GHGQLRequestPagination pagination) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            String string = repository.getServerPath().toGraphQLUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repository.serverPath.toGraphQLUrl()");
            Pair[] pairArray = new Pair[5];
            pairArray[0] = TuplesKt.to((Object)"repoOwner", (Object)repository.getRepositoryPath().getOwner());
            pairArray[1] = TuplesKt.to((Object)"repoName", (Object)repository.getRepositoryPath().getRepository());
            pairArray[2] = TuplesKt.to((Object)"number", (Object)number);
            GHGQLRequestPagination gHGQLRequestPagination = pagination;
            pairArray[3] = TuplesKt.to((Object)"pageSize", (Object)(gHGQLRequestPagination != null ? Integer.valueOf(gHGQLRequestPagination.getPageSize()) : null));
            GHGQLRequestPagination gHGQLRequestPagination2 = pagination;
            pairArray[4] = TuplesKt.to((Object)"cursor", (Object)(gHGQLRequestPagination2 != null ? gHGQLRequestPagination2.getAfterCursor() : null));
            return new GithubApiRequest.Post.GQLQuery.TraversedParsed<CommitsConnection>(string, "pullRequestCommits", MapsKt.mapOf((Pair[])pairArray), CommitsConnection.class, "repository", "pullRequest", "commits");
        }

        public static /* synthetic */ GithubApiRequest.Post.GQLQuery commits$default(PullRequest pullRequest, GHRepositoryCoordinates gHRepositoryCoordinates, long l, GHGQLRequestPagination gHGQLRequestPagination, int n, Object object) {
            if ((n & 4) != 0) {
                gHGQLRequestPagination = null;
            }
            return pullRequest.commits(gHRepositoryCoordinates, l, gHGQLRequestPagination);
        }

        private PullRequest() {
        }

        static {
            PullRequest pullRequest;
            INSTANCE = pullRequest = new PullRequest();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$PullRequest$PullRequestsConnection;", "Lorg/jetbrains/plugins/github/api/data/GHConnection;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequest;", "pageInfo", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLPageInfo;", "nodes", "", "(Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLPageInfo;Ljava/util/List;)V", "intellij.vcs.github"})
        private static final class PullRequestsConnection
        extends GHConnection<GHPullRequest> {
            public PullRequestsConnection(@NotNull GHGQLPageInfo pageInfo, @NotNull List<GHPullRequest> nodes) {
                Intrinsics.checkNotNullParameter((Object)pageInfo, (String)"pageInfo");
                Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                super(pageInfo, nodes);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$PullRequest$PRSearch;", "Lorg/jetbrains/plugins/github/api/data/graphql/query/GHGQLSearchQueryResponse;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "search", "Lorg/jetbrains/plugins/github/api/data/graphql/query/GHGQLSearchQueryResponse$SearchConnection;", "(Lorg/jetbrains/plugins/github/api/data/graphql/query/GHGQLSearchQueryResponse$SearchConnection;)V", "intellij.vcs.github"})
        private static final class PRSearch
        extends GHGQLSearchQueryResponse<GHPullRequestShort> {
            public PRSearch(@NotNull GHGQLSearchQueryResponse.SearchConnection<GHPullRequestShort> search) {
                Intrinsics.checkNotNullParameter(search, (String)"search");
                super(search);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$PullRequest$ThreadsConnection;", "Lorg/jetbrains/plugins/github/api/data/GHConnection;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewThread;", "pageInfo", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLPageInfo;", "nodes", "", "(Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLPageInfo;Ljava/util/List;)V", "intellij.vcs.github"})
        private static final class ThreadsConnection
        extends GHConnection<GHPullRequestReviewThread> {
            public ThreadsConnection(@NotNull GHGQLPageInfo pageInfo, @NotNull List<GHPullRequestReviewThread> nodes) {
                Intrinsics.checkNotNullParameter((Object)pageInfo, (String)"pageInfo");
                Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                super(pageInfo, nodes);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$PullRequest$CommitsConnection;", "Lorg/jetbrains/plugins/github/api/data/GHConnection;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestCommit;", "pageInfo", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLPageInfo;", "nodes", "", "(Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLPageInfo;Ljava/util/List;)V", "intellij.vcs.github"})
        private static final class CommitsConnection
        extends GHConnection<GHPullRequestCommit> {
            public CommitsConnection(@NotNull GHGQLPageInfo pageInfo, @NotNull List<GHPullRequestCommit> nodes) {
                Intrinsics.checkNotNullParameter((Object)pageInfo, (String)"pageInfo");
                Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                super(pageInfo, nodes);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$PullRequest$Timeline;", "", "()V", "items", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLPagedRequestResponse;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineItem;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "repoOwner", "", "repoName", "number", "", "pagination", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLRequestPagination;", "TimelineConnection", "intellij.vcs.github"})
        public static final class Timeline {
            @NotNull
            public static final Timeline INSTANCE;

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHGQLPagedRequestResponse<GHPRTimelineItem>> items(@NotNull GithubServerPath server, @NotNull String repoOwner, @NotNull String repoName, long number, @Nullable GHGQLRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)repoOwner, (String)"repoOwner");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
                Pair[] pairArray = new Pair[6];
                pairArray[0] = TuplesKt.to((Object)"repoOwner", (Object)repoOwner);
                pairArray[1] = TuplesKt.to((Object)"repoName", (Object)repoName);
                pairArray[2] = TuplesKt.to((Object)"number", (Object)number);
                GHGQLRequestPagination gHGQLRequestPagination = pagination;
                pairArray[3] = TuplesKt.to((Object)"pageSize", (Object)(gHGQLRequestPagination != null ? Integer.valueOf(gHGQLRequestPagination.getPageSize()) : null));
                GHGQLRequestPagination gHGQLRequestPagination2 = pagination;
                pairArray[4] = TuplesKt.to((Object)"cursor", (Object)(gHGQLRequestPagination2 != null ? gHGQLRequestPagination2.getAfterCursor() : null));
                GHGQLRequestPagination gHGQLRequestPagination3 = pagination;
                pairArray[5] = TuplesKt.to((Object)"since", (Object)(gHGQLRequestPagination3 != null ? gHGQLRequestPagination3.getSince() : null));
                GithubApiRequest.Post.GQLQuery.TraversedParsed<TimelineConnection> traversedParsed = new GithubApiRequest.Post.GQLQuery.TraversedParsed<TimelineConnection>(string, "pullRequestTimeline", MapsKt.mapOf((Pair[])pairArray), TimelineConnection.class, "repository", "pullRequest", "timelineItems");
                boolean bl = false;
                boolean bl2 = false;
                GithubApiRequest.Post.GQLQuery.TraversedParsed<TimelineConnection> $this$apply = traversedParsed;
                boolean bl3 = false;
                $this$apply.setAcceptMimeType(GHSchemaPreview.PR_DRAFT.getMimeType());
                return traversedParsed;
            }

            public static /* synthetic */ GithubApiRequest.Post.GQLQuery items$default(Timeline timeline, GithubServerPath githubServerPath, String string, String string2, long l, GHGQLRequestPagination gHGQLRequestPagination, int n, Object object) {
                if ((n & 0x10) != 0) {
                    gHGQLRequestPagination = null;
                }
                return timeline.items(githubServerPath, string, string2, l, gHGQLRequestPagination);
            }

            private Timeline() {
            }

            static {
                Timeline timeline;
                INSTANCE = timeline = new Timeline();
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$PullRequest$Timeline$TimelineConnection;", "Lorg/jetbrains/plugins/github/api/data/GHConnection;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineItem;", "pageInfo", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLPageInfo;", "nodes", "", "(Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLPageInfo;Ljava/util/List;)V", "intellij.vcs.github"})
            private static final class TimelineConnection
            extends GHConnection<GHPRTimelineItem> {
                public TimelineConnection(@NotNull GHGQLPageInfo pageInfo, @NotNull List<? extends GHPRTimelineItem> nodes) {
                    Intrinsics.checkNotNullParameter((Object)pageInfo, (String)"pageInfo");
                    Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                    super(pageInfo, nodes);
                }
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001.B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ<\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJD\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\tJZ\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\t2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c2\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001cJ\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\tJ\"\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170$0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\tJ\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\tJ.\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u000b\u001a\u0004\u0018\u00010\tJ\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\tJ$\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tJ$\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t\u00a8\u0006/"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$PullRequest$Review;", "", "()V", "addComment", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewCommentWithPendingReview;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "reviewId", "", "inReplyTo", "body", "commitSha", "fileName", "diffLine", "", "addThread", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewThread;", "line", "side", "Lcom/intellij/diff/util/Side;", "startLine", "create", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestPendingReview;", "pullRequestId", "event", "Lorg/jetbrains/plugins/github/api/data/GHPullRequestReviewEvent;", "comments", "", "Lorg/jetbrains/plugins/github/api/data/request/GHPullRequestDraftReviewComment;", "threads", "Lorg/jetbrains/plugins/github/api/data/request/GHPullRequestDraftReviewThread;", "delete", "deleteComment", "commentId", "pendingReviews", "Lorg/jetbrains/plugins/github/api/data/GHNodes;", "resolveThread", "threadId", "submit", "unresolveThread", "updateBody", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReview;", "newText", "updateComment", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewComment;", "PendingReviewNodes", "intellij.vcs.github"})
        public static final class Review {
            @NotNull
            public static final Review INSTANCE;

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHPullRequestPendingReview> create(@NotNull GithubServerPath server, @NotNull String pullRequestId, @Nullable GHPullRequestReviewEvent event, @Nullable String body2, @Nullable String commitSha, @Nullable List<GHPullRequestDraftReviewComment> comments, @Nullable List<GHPullRequestDraftReviewThread> threads) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
                return new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestPendingReview>(string, "createReview", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"pullRequestId", (Object)pullRequestId), TuplesKt.to((Object)"event", (Object)((Object)event)), TuplesKt.to((Object)"commitOid", (Object)commitSha), TuplesKt.to((Object)"comments", comments), TuplesKt.to((Object)"threads", threads), TuplesKt.to((Object)"body", (Object)body2)}), GHPullRequestPendingReview.class, "addPullRequestReview", "pullRequestReview");
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<Object> submit(@NotNull GithubServerPath server, @NotNull String reviewId, @NotNull GHPullRequestReviewEvent event, @Nullable String body2) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
                Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
                return new GithubApiRequest.Post.GQLQuery.TraversedParsed<Object>(string, "submitReview", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"reviewId", (Object)reviewId), TuplesKt.to((Object)"event", (Object)((Object)event)), TuplesKt.to((Object)"body", (Object)body2)}), Object.class, new String[0]);
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHPullRequestReview> updateBody(@NotNull GithubServerPath server, @NotNull String reviewId, @NotNull String newText) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
                Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
                return new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestReview>(string, "updateReview", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"reviewId", (Object)reviewId), TuplesKt.to((Object)"body", (Object)newText)}), GHPullRequestReview.class, "updatePullRequestReview", "pullRequestReview");
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<Object> delete(@NotNull GithubServerPath server, @NotNull String reviewId) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
                return new GithubApiRequest.Post.GQLQuery.TraversedParsed<Object>(string, "deleteReview", MapsKt.mapOf((Pair)TuplesKt.to((Object)"reviewId", (Object)reviewId)), Object.class, new String[0]);
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHNodes<GHPullRequestPendingReview>> pendingReviews(@NotNull GithubServerPath server, @NotNull String pullRequestId) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
                return new GithubApiRequest.Post.GQLQuery.TraversedParsed<PendingReviewNodes>(string, "findPendingReview", MapsKt.mapOf((Pair)TuplesKt.to((Object)"pullRequestId", (Object)pullRequestId)), PendingReviewNodes.class, "node", "reviews");
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHPullRequestReviewCommentWithPendingReview> addComment(@NotNull GithubServerPath server, @NotNull String reviewId, @NotNull String body2, @NotNull String commitSha, @NotNull String fileName, int diffLine) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
                Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
                Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
                return new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestReviewCommentWithPendingReview>(string, "addReviewComment", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"reviewId", (Object)reviewId), TuplesKt.to((Object)"body", (Object)body2), TuplesKt.to((Object)"commit", (Object)commitSha), TuplesKt.to((Object)"file", (Object)fileName), TuplesKt.to((Object)"position", (Object)diffLine)}), GHPullRequestReviewCommentWithPendingReview.class, "addPullRequestReviewComment", "comment");
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHPullRequestReviewCommentWithPendingReview> addComment(@NotNull GithubServerPath server, @NotNull String reviewId, @NotNull String inReplyTo, @NotNull String body2) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
                Intrinsics.checkNotNullParameter((Object)inReplyTo, (String)"inReplyTo");
                Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
                return new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestReviewCommentWithPendingReview>(string, "addReviewComment", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"reviewId", (Object)reviewId), TuplesKt.to((Object)"inReplyTo", (Object)inReplyTo), TuplesKt.to((Object)"body", (Object)body2)}), GHPullRequestReviewCommentWithPendingReview.class, "addPullRequestReviewComment", "comment");
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHPullRequestPendingReview> deleteComment(@NotNull GithubServerPath server, @NotNull String commentId) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
                return new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestPendingReview>(string, "deleteReviewComment", MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)commentId)), GHPullRequestPendingReview.class, "deletePullRequestReviewComment", "pullRequestReview");
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHPullRequestReviewComment> updateComment(@NotNull GithubServerPath server, @NotNull String commentId, @NotNull String newText) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
                Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
                return new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestReviewComment>(string, "updateReviewComment", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"id", (Object)commentId), TuplesKt.to((Object)"body", (Object)newText)}), GHPullRequestReviewComment.class, "updatePullRequestReviewComment", "pullRequestReviewComment");
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHPullRequestReviewThread> addThread(@NotNull GithubServerPath server, @NotNull String reviewId, @NotNull String body2, int line, @NotNull Side side, int startLine, @NotNull String fileName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
                Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                Intrinsics.checkNotNullParameter((Object)side, (String)"side");
                Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
                return new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestReviewThread>(string, "addPullRequestReviewThread", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"body", (Object)body2), TuplesKt.to((Object)"line", (Object)line), TuplesKt.to((Object)"path", (Object)fileName), TuplesKt.to((Object)"pullRequestReviewId", (Object)reviewId), TuplesKt.to((Object)"side", (Object)side.name()), TuplesKt.to((Object)"startSide", (Object)side.name()), TuplesKt.to((Object)"startLine", (Object)startLine)}), GHPullRequestReviewThread.class, "addPullRequestReviewThread", "thread");
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHPullRequestReviewThread> resolveThread(@NotNull GithubServerPath server, @NotNull String threadId) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)threadId, (String)"threadId");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
                return new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestReviewThread>(string, "resolveReviewThread", MapsKt.mapOf((Pair)TuplesKt.to((Object)"threadId", (Object)threadId)), GHPullRequestReviewThread.class, "resolveReviewThread", "thread");
            }

            @NotNull
            public final GithubApiRequest.Post.GQLQuery<GHPullRequestReviewThread> unresolveThread(@NotNull GithubServerPath server, @NotNull String threadId) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)threadId, (String)"threadId");
                String string = server.toGraphQLUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toGraphQLUrl()");
                return new GithubApiRequest.Post.GQLQuery.TraversedParsed<GHPullRequestReviewThread>(string, "unresolveReviewThread", MapsKt.mapOf((Pair)TuplesKt.to((Object)"threadId", (Object)threadId)), GHPullRequestReviewThread.class, "unresolveReviewThread", "thread");
            }

            private Review() {
            }

            static {
                Review review;
                INSTANCE = review = new Review();
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLRequests$PullRequest$Review$PendingReviewNodes;", "Lorg/jetbrains/plugins/github/api/data/GHNodes;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestPendingReview;", "nodes", "", "(Ljava/util/List;)V", "intellij.vcs.github"})
            private static final class PendingReviewNodes
            extends GHNodes<GHPullRequestPendingReview> {
                public PendingReviewNodes(@NotNull List<? extends GHPullRequestPendingReview> nodes) {
                    Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                    super(nodes, null, 2, null);
                }
            }
        }
    }
}

