/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.DialogManager;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.actions.GitInit;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.github.GithubShareAction;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.request.Type;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountInformationProvider;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.GithubShareDialog;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GHProjectRepositoriesManager;
import org.jetbrains.plugins.github.util.GithubAccountsMigrationHelper;
import org.jetbrains.plugins.github.util.GithubGitHelper;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUtil;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \b2\u00020\u0001:\u0003\b\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/GithubShareAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "GithubExistingRemotesDialog", "GithubUntrackedFilesDialog", "intellij.vcs.github"})
public final class GithubShareAction
extends DumbAwareAction {
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabledAndVisible(project != null && !project.isDefault());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDisposed()) {
            return;
        }
        Companion.shareProjectOnGithub(project, file);
    }

    public GithubShareAction() {
        super(GithubBundle.messagePointer("share.action", new Object[0]), GithubBundle.messagePointer("share.action.description", new Object[0]), AllIcons.Vcs.Vendors.Github);
    }

    static {
        Companion = new Companion(null);
        LOG = GithubUtil.LOG;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @JvmStatic
    public static final void shareProjectOnGithub(@NotNull Project project, @Nullable VirtualFile file) {
        Companion.shareProjectOnGithub(project, file);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/GithubShareAction$GithubExistingRemotesDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "remotes", "", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "createCenterPanel", "Ljavax/swing/JComponent;", "intellij.vcs.github"})
    @TestOnly
    public static final class GithubExistingRemotesDialog
    extends DialogWrapper {
        private final List<String> remotes;

        @Nullable
        protected JComponent createCenterPanel() {
            JBLabel mainText = new JBLabel(this.remotes.size() == 1 ? GithubBundle.message("share.action.remote.is.on.github", new Object[0]) : GithubBundle.message("share.action.remotes.are.on.github", new Object[0]));
            JPanel jPanel = new JPanel();
            boolean bl = false;
            boolean bl2 = false;
            JPanel $this$apply = jPanel;
            boolean bl3 = false;
            $this$apply.setLayout(new BoxLayout($this$apply, 1));
            JPanel remotesPanel = jPanel;
            for (String remote : this.remotes) {
                remotesPanel.add((Component)new BrowserLink(remote, remote));
            }
            BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((int)10, (int)4).addToTop((Component)mainText).addToCenter((Component)remotesPanel);
            Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"JBUI.Panels.simplePanel(\u2026addToCenter(remotesPanel)");
            BorderLayoutPanel messagesPanel = borderLayoutPanel;
            Container container = new Container();
            boolean bl4 = false;
            boolean bl5 = false;
            Container $this$apply2 = container;
            boolean bl6 = false;
            $this$apply2.setLayout(new BorderLayout());
            $this$apply2.add((Component)new JLabel(Messages.getQuestionIcon()), "North");
            Container iconContainer = container;
            container = JBUI.Panels.simplePanel((int)10, (int)4).addToCenter((Component)messagesPanel).addToLeft((Component)iconContainer);
            bl4 = false;
            bl5 = false;
            $this$apply2 = container;
            boolean bl7 = false;
            $this$apply2.setBorder((Border)JBUI.Borders.emptyBottom((int)12));
            return (JComponent)container;
        }

        public GithubExistingRemotesDialog(@NotNull Project project, @NotNull List<String> remotes) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(remotes, (String)"remotes");
            super(project);
            this.remotes = remotes;
            this.setTitle(GithubBundle.message("share.error.project.is.on.github", new Object[0]));
            this.setOKButtonText(GithubBundle.message("share.anyway.button", new Object[0]));
            this.init();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0014J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0001\u0010\u0014\u001a\u00020\nH\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0014R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/GithubShareAction$GithubUntrackedFilesDialog;", "Lcom/intellij/openapi/vcs/changes/ui/SelectFilesDialog;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "myProject", "Lcom/intellij/openapi/project/Project;", "untrackedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "commitMessage", "", "getCommitMessage", "()Ljava/lang/String;", "myCommitMessagePanel", "Lcom/intellij/openapi/vcs/ui/CommitMessage;", "createCenterPanel", "Ljavax/swing/JComponent;", "createNorthPanel", "getData", "", "dataId", "getDimensionServiceKey", "intellij.vcs.github"})
    @TestOnly
    public static final class GithubUntrackedFilesDialog
    extends SelectFilesDialog
    implements DataProvider {
        private CommitMessage myCommitMessagePanel;
        private final Project myProject;

        @NotNull
        public final String getCommitMessage() {
            CommitMessage commitMessage = this.myCommitMessagePanel;
            Intrinsics.checkNotNull((Object)commitMessage);
            String string = commitMessage.getComment();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myCommitMessagePanel!!.comment");
            return string;
        }

        @Nullable
        protected JComponent createNorthPanel() {
            return null;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JComponent tree2 = super.createCenterPanel();
            CommitMessage commitMessage = new CommitMessage(this.myProject);
            Disposer.register((Disposable)this.getDisposable(), (Disposable)((Disposable)commitMessage));
            commitMessage.setCommitMessage("Initial commit");
            this.myCommitMessagePanel = commitMessage;
            Splitter splitter = new Splitter(true);
            splitter.setHonorComponentsMinimumSize(true);
            splitter.setFirstComponent(tree2);
            splitter.setSecondComponent((JComponent)this.myCommitMessagePanel);
            splitter.setProportion(0.7f);
            return (JComponent)splitter;
        }

        @Nullable
        public Object getData(@NonNls @NotNull String dataId) {
            Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
            return VcsDataKeys.COMMIT_MESSAGE_CONTROL.is(dataId) ? this.myCommitMessagePanel : null;
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return "Github.UntrackedFilesDialog";
        }

        public GithubUntrackedFilesDialog(@NotNull Project myProject, @NotNull List<? extends VirtualFile> untrackedFiles) {
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            Intrinsics.checkNotNullParameter(untrackedFiles, (String)"untrackedFiles");
            super(myProject, untrackedFiles, null, null, true, false);
            this.myProject = myProject;
            this.setTitle(GithubBundle.message("untracked.files.dialog.title", new Object[0]));
            this.setOKButtonText(CommonBundle.getAddButtonText());
            this.setCancelButtonText(CommonBundle.getCancelButtonText());
            this.init();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/GithubShareAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "shareProjectOnGithub", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vcs.github"})
    public static final class Companion {
        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @JvmStatic
        public final void shareProjectOnGithub(@NotNull Project project, @Nullable VirtualFile file) {
            block21: {
                block20: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    FileDocumentManager.getInstance().saveAllDocuments();
                    gitRepository = GithubGitHelper.Companion.findGitRepository(project, file);
                    v0 /* !! */  = gitRepository;
                    if (v0 /* !! */  == null) ** GOTO lbl-1000
                    var5_4 /* !! */  = v0 /* !! */ ;
                    $this$service$iv /* !! */  = project;
                    $i$f$service = false;
                    v1 = $this$service$iv /* !! */ .getService(GHProjectRepositoriesManager.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getService(T::class.java)");
                    $this$service$iv /* !! */  = v1;
                    $i$f$service = false;
                    var8_18 = false;
                    p1 = var5_4 /* !! */ ;
                    $i$a$-unknown-GithubShareAction$Companion$shareProjectOnGithub$possibleRemotes$1 = false;
                    v0 /* !! */  = ((GHProjectRepositoriesManager)$this$service$iv /* !! */ ).findKnownRepositories(p1);
                    if (v0 /* !! */  != null) {
                        var5_4 /* !! */  = (Iterable)v0 /* !! */ ;
                        $i$f$map = false;
                        $i$f$service = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var12_36 = (GHGitRepositoryMapping)item$iv$iv;
                            var22_40 = destination$iv$iv;
                            $i$a$-map-GithubShareAction$Companion$shareProjectOnGithub$possibleRemotes$2 = false;
                            var23_41 = it.getGitRemote().getUrl();
                            var22_40.add(var23_41);
                        }
                        v2 = (List)destination$iv$iv;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = null;
                    }
                    $this$map$iv = v2;
                    $i$f$map = false;
                    v3 /* !! */  = $this$map$iv;
                    if (v3 /* !! */  == null) {
                        v3 /* !! */  = CollectionsKt.emptyList();
                    }
                    possibleRemotes = v3 /* !! */ ;
                    $this$map$iv = possibleRemotes;
                    $i$f$map = false;
                    if ($this$map$iv.isEmpty() == false) {
                        existingRemotesDialog = new GithubExistingRemotesDialog(project, possibleRemotes);
                        DialogManager.show((DialogWrapper)existingRemotesDialog);
                        if (!existingRemotesDialog.isOK()) {
                            return;
                        }
                    }
                    $i$f$service = false;
                    serviceClass$iv = GithubAccountsMigrationHelper.class;
                    v4 = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (v4 == null) {
                        throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                    }
                    if (!GithubAccountsMigrationHelper.migrate$default((GithubAccountsMigrationHelper)v4, project, null, 2, null)) {
                        return;
                    }
                    $i$f$service = false;
                    serviceClass$iv = GithubAuthenticationManager.class;
                    v5 = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (v5 == null) {
                        throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                    }
                    authManager = (GithubAuthenticationManager)v5;
                    $i$f$service = false;
                    serviceClass$iv = ProgressManager.class;
                    v6 = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (v6 == null) {
                        throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                    }
                    progressManager = (ProgressManager)v6;
                    $i$f$service = false;
                    serviceClass$iv = GithubApiRequestExecutorManager.class;
                    v7 = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (v7 == null) {
                        throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                    }
                    requestExecutorManager = (GithubApiRequestExecutorManager)v7;
                    $i$f$service = false;
                    serviceClass$iv = GithubAccountInformationProvider.class;
                    v8 = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (v8 == null) {
                        throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                    }
                    accountInformationProvider = (GithubAccountInformationProvider)v8;
                    $i$f$service = false;
                    serviceClass$iv = GithubGitHelper.class;
                    v9 = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (v9 == null) {
                        throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                    }
                    gitHelper = (GithubGitHelper)v9;
                    $i$f$service = false;
                    serviceClass$iv = Git.class;
                    v10 = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (v10 == null) {
                        throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                    }
                    git = (Git)v10;
                    accountInformationLoader = new Function2<GithubAccount, Component, Pair<? extends Boolean, ? extends Set<? extends String>>>(requestExecutorManager, progressManager, project){
                        private final Map<GithubAccount, Pair<Boolean, Set<String>>> loadedInfo;
                        final /* synthetic */ GithubApiRequestExecutorManager $requestExecutorManager;
                        final /* synthetic */ ProgressManager $progressManager;
                        final /* synthetic */ Project $project;

                        @NotNull
                        public Pair<Boolean, Set<String>> invoke(@NotNull GithubAccount account, @NotNull Component parentComponent) throws IOException {
                            Pair pair;
                            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
                            Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
                            Map<GithubAccount, Pair<Boolean, Set<String>>> $this$getOrPut$iv = this.loadedInfo;
                            boolean $i$f$getOrPut = false;
                            Pair value$iv = $this$getOrPut$iv.get(account);
                            if (value$iv == null) {
                                boolean bl = false;
                                GithubApiRequestExecutor.WithTokenAuth withTokenAuth = this.$requestExecutorManager.getExecutor(account, parentComponent);
                                if (withTokenAuth == null) {
                                    throw (Throwable)new ProcessCanceledException();
                                }
                                GithubApiRequestExecutor.WithTokenAuth requestExecutor = withTokenAuth;
                                Object object = this.$progressManager.runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Pair<? extends Boolean, ? extends Set<? extends String>>, IOException>(requestExecutor, this, account, parentComponent){
                                    final /* synthetic */ GithubApiRequestExecutor.WithTokenAuth $requestExecutor;
                                    final /* synthetic */ shareProjectOnGithub.accountInformationLoader.1 this$0;
                                    final /* synthetic */ GithubAccount $account$inlined;
                                    final /* synthetic */ Component $parentComponent$inlined;
                                    {
                                        this.$requestExecutor = withTokenAuth;
                                        this.this$0 = var2_2;
                                        this.$account$inlined = githubAccount;
                                        this.$parentComponent$inlined = component2;
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final Pair<Boolean, Set<String>> compute() {
                                        Set set;
                                        void size$iv;
                                        ProgressIndicator progressIndicator = this.this$0.$progressManager.getProgressIndicator();
                                        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"progressManager.progressIndicator");
                                        GithubServerPath githubServerPath = this.$account$inlined.getServer();
                                        Intrinsics.checkNotNullExpressionValue((Object)githubServerPath, (String)"account.server");
                                        GithubAuthenticatedUser user = this.$requestExecutor.execute(progressIndicator, GithubApiRequests.CurrentUser.get(githubServerPath));
                                        GithubApiRequestExecutor githubApiRequestExecutor = this.$requestExecutor;
                                        ProgressIndicator progressIndicator2 = this.this$0.$progressManager.getProgressIndicator();
                                        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator2, (String)"progressManager.progressIndicator");
                                        GithubServerPath githubServerPath2 = this.$account$inlined.getServer();
                                        Intrinsics.checkNotNullExpressionValue((Object)githubServerPath2, (String)"account.server");
                                        Collection $this$mapSmartSet$iv = GithubApiPagesLoader.loadAll(githubApiRequestExecutor, progressIndicator2, GithubApiRequests.CurrentUser.Repos.pages$default(githubServerPath2, Type.OWNER, null, null, null, 28, null));
                                        boolean $i$f$mapSmartSet = false;
                                        int n = $this$mapSmartSet$iv.size();
                                        switch (size$iv) {
                                            case 1: {
                                                GithubRepo it = (GithubRepo)CollectionsKt.first((Iterable)$this$mapSmartSet$iv);
                                                boolean bl = false;
                                                Set set2 = Collections.singleton(it.getName());
                                                set = set2;
                                                Intrinsics.checkNotNullExpressionValue(set2, (String)"Collections.singleton(transform(first()))");
                                                break;
                                            }
                                            case 0: {
                                                set = SetsKt.emptySet();
                                                break;
                                            }
                                            default: {
                                                void $this$mapTo$iv$iv;
                                                Iterable iterable = $this$mapSmartSet$iv;
                                                Collection destination$iv$iv = (Collection)new com.intellij.util.containers.HashSet((int)size$iv);
                                                boolean $i$f$mapTo = false;
                                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                    void it;
                                                    GithubRepo githubRepo = (GithubRepo)item$iv$iv;
                                                    Collection collection = destination$iv$iv;
                                                    boolean bl = false;
                                                    String string = it.getName();
                                                    collection.add(string);
                                                }
                                                set = (Set)destination$iv$iv;
                                            }
                                        }
                                        Set names = set;
                                        return TuplesKt.to((Object)user.canCreatePrivateRepo(), (Object)names);
                                    }
                                }, GithubBundle.message("share.process.loading.account.info", account), true, this.$project);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"progressManager.runProce\u2026 account), true, project)");
                                Pair answer$iv = (Pair)object;
                                $this$getOrPut$iv.put(account, (Pair<Boolean, Set<String>>)answer$iv);
                                pair = answer$iv;
                            } else {
                                pair = value$iv;
                            }
                            return pair;
                        }
                        {
                            this.$requestExecutorManager = $captured_local_variable$0;
                            this.$progressManager = $captured_local_variable$1;
                            this.$project = $captured_local_variable$2;
                            boolean bl = false;
                            this.loadedInfo = new LinkedHashMap<K, V>();
                        }
                    };
                    v11 = project;
                    v12 = authManager.getAccounts();
                    v13 = authManager.getDefaultAccount(project);
                    v14 /* !! */  = gitRepository;
                    if (v14 /* !! */  == null || (v14 /* !! */  = v14 /* !! */ .getRemotes()) == null) break block20;
                    $i$a$-map-GithubShareAction$Companion$shareProjectOnGithub$possibleRemotes$2 = (Iterable)v14 /* !! */ ;
                    var26_43 = v13;
                    var25_44 = v12;
                    var24_45 = v11;
                    $i$f$map = false;
                    var15_47 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var20_53 = (GitRemote)item$iv$iv;
                        var27_55 = destination$iv$iv;
                        $i$a$-map-GithubShareAction$Companion$shareProjectOnGithub$shareDialog$1 = false;
                        v15 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"it");
                        var28_56 = v15.getName();
                        var27_55.add(var28_56);
                    }
                    var27_55 = (List)destination$iv$iv;
                    v11 = var24_45;
                    v12 = var25_44;
                    v13 = var26_43;
                    v14 /* !! */  = CollectionsKt.toSet((Iterable)var27_55);
                    if (v14 /* !! */  != null) break block21;
                }
                v14 /* !! */  = SetsKt.emptySet();
            }
            var29_57 = (Function2)accountInformationLoader;
            var30_58 /* !! */  = v14 /* !! */ ;
            var31_59 = v13;
            var32_60 = v12;
            var33_61 = v11;
            shareDialog = new GithubShareDialog(var33_61, var32_60, var31_59, (Set<String>)var30_58 /* !! */ , (Function2<? super GithubAccount, ? super Component, ? extends Pair<Boolean, ? extends Set<String>>>)var29_57);
            DialogManager.show((DialogWrapper)shareDialog);
            if (!shareDialog.isOK()) {
                return;
            }
            name = shareDialog.getRepositoryName();
            isPrivate = shareDialog.isPrivate();
            remoteName = shareDialog.getRemoteName();
            description = shareDialog.getDescription();
            v16 = shareDialog.getAccount();
            Intrinsics.checkNotNull((Object)v16);
            account = v16;
            v17 = requestExecutorManager.getExecutor(account, project);
            if (v17 == null) {
                return;
            }
            requestExecutor = v17;
            new Task.Backgroundable(requestExecutor, account, name, description, isPrivate, gitRepository, project, accountInformationProvider, gitHelper, git, remoteName, project, GithubBundle.message("share.process", new Object[0])){
                private String url;
                final /* synthetic */ GithubApiRequestExecutor.WithTokenAuth $requestExecutor;
                final /* synthetic */ GithubAccount $account;
                final /* synthetic */ String $name;
                final /* synthetic */ String $description;
                final /* synthetic */ boolean $isPrivate;
                final /* synthetic */ GitRepository $gitRepository;
                final /* synthetic */ Project $project;
                final /* synthetic */ GithubAccountInformationProvider $accountInformationProvider;
                final /* synthetic */ GithubGitHelper $gitHelper;
                final /* synthetic */ Git $git;
                final /* synthetic */ String $remoteName;

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    GithubShareAction.access$getLOG$cp().info("Creating GitHub repository");
                    indicator.setText(GithubBundle.message("share.process.creating.repository", new Object[0]));
                    GithubServerPath githubServerPath = this.$account.getServer();
                    Intrinsics.checkNotNullExpressionValue((Object)githubServerPath, (String)"account.server");
                    String string = ((GithubRepo)this.$requestExecutor.execute(indicator, GithubApiRequests.CurrentUser.Repos.create$default(githubServerPath, this.$name, this.$description, this.$isPrivate, null, 16, null))).getHtmlUrl();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"requestExecutor\n        \u2026tion, isPrivate)).htmlUrl");
                    this.url = string;
                    GithubShareAction.access$getLOG$cp().info("Successfully created GitHub repository");
                    GitRepository gitRepository = this.$gitRepository;
                    if (gitRepository == null || (gitRepository = gitRepository.getRoot()) == null) {
                        gitRepository = this.$project.getBaseDir();
                    }
                    GitRepository root = gitRepository;
                    GithubShareAction.access$getLOG$cp().info("Binding local project with GitHub");
                    if (this.$gitRepository == null) {
                        GithubShareAction.access$getLOG$cp().info("No git detected, creating empty git repo");
                        indicator.setText(GithubBundle.message("share.process.creating.git.repository", new Object[0]));
                        GitRepository gitRepository2 = root;
                        Intrinsics.checkNotNullExpressionValue((Object)gitRepository2, (String)"root");
                        if (!this.createEmptyGitRepository(this.$project, (VirtualFile)gitRepository2)) {
                            return;
                        }
                    }
                    GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager((Project)this.$project);
                    Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryManager, (String)"GitUtil.getRepositoryManager(project)");
                    GitRepositoryManager repositoryManager = gitRepositoryManager;
                    GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRoot((VirtualFile)root);
                    if (repository == null) {
                        GithubNotifications.showError(this.$project, "github.share.cannot.find.git.repo", GithubBundle.message("share.error.failed.to.create.repo", new Object[0]), GithubBundle.message("cannot.find.git.repo", new Object[0]));
                        return;
                    }
                    indicator.setText(GithubBundle.message("share.process.retrieving.username", new Object[0]));
                    String string2 = this.$accountInformationProvider.getInformation(this.$requestExecutor, indicator, this.$account).getLogin();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"accountInformationProvid\u2026indicator, account).login");
                    String username = string2;
                    GithubServerPath githubServerPath2 = this.$account.getServer();
                    Intrinsics.checkNotNullExpressionValue((Object)githubServerPath2, (String)"account.server");
                    String remoteUrl = this.$gitHelper.getRemoteUrl(githubServerPath2, username, this.$name);
                    GithubShareAction.access$getLOG$cp().info("Adding GitHub as a remote host");
                    indicator.setText(GithubBundle.message("share.process.adding.gh.as.remote.host", new Object[0]));
                    this.$git.addRemote(repository, this.$remoteName, remoteUrl).throwOnError(new int[0]);
                    repository.update();
                    GitRepository gitRepository3 = root;
                    Intrinsics.checkNotNullExpressionValue((Object)gitRepository3, (String)"root");
                    String string3 = this.url;
                    if (string3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"url");
                    }
                    if (!this.performFirstCommitIfRequired(this.$project, (VirtualFile)gitRepository3, repository, indicator, this.$name, string3)) {
                        return;
                    }
                    GithubShareAction.access$getLOG$cp().info("Pushing to github master");
                    indicator.setText(GithubBundle.message("share.process.pushing.to.github.master", new Object[0]));
                    String string4 = this.url;
                    if (string4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"url");
                    }
                    if (!this.pushCurrentBranch(this.$project, repository, this.$remoteName, remoteUrl, this.$name, string4)) {
                        return;
                    }
                    String string5 = GithubBundle.message("share.process.successfully.shared", new Object[0]);
                    String string6 = this.url;
                    if (string6 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"url");
                    }
                    GithubNotifications.showInfoURL(this.$project, "github.share.project.successfully.shared", string5, this.$name, string6);
                }

                private final boolean createEmptyGitRepository(Project project, VirtualFile root) {
                    GitCommandResult gitCommandResult = Git.getInstance().init(project, root, new GitLineHandlerListener[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"Git.getInstance().init(project, root)");
                    GitCommandResult result = gitCommandResult;
                    if (!result.success()) {
                        VcsNotifier.getInstance((Project)project).notifyError("github.git.repo.init.error", GitBundle.message((String)"initializing.title", (Object[])new Object[0]), result.getErrorOutputAsHtmlString());
                        GithubShareAction.access$getLOG$cp().info("Failed to create empty git repo: " + result.getErrorOutputAsJoinedString());
                        return false;
                    }
                    GitInit.refreshAndConfigureVcsMappings((Project)project, (VirtualFile)root, (String)root.getPath());
                    GitUtil.generateGitignoreFileIfNeeded((Project)project, (VirtualFile)root);
                    return true;
                }

                /*
                 * WARNING - void declaration
                 */
                private final boolean performFirstCommitIfRequired(Project project, VirtualFile root, GitRepository repository, ProgressIndicator indicator, @NlsSafe String name, String url) {
                    if (!repository.isFresh()) {
                        return true;
                    }
                    GithubShareAction.access$getLOG$cp().info("Trying to commit");
                    try {
                        void $this$mapNotNullTo$iv$iv;
                        void $this$mapNotNull$iv;
                        GithubShareAction.access$getLOG$cp().info("Adding files for commit");
                        indicator.setText(GithubBundle.message("share.process.adding.files", new Object[0]));
                        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
                        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
                        List list2 = changeListManager.getAffectedFiles();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ChangeListManager.getIns\u2026ce(project).affectedFiles");
                        List trackedFiles = list2;
                        Collection collection = repository.getUntrackedFilesHolder().retrieveUntrackedFilePaths();
                        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"repository.untrackedFile\u2026rieveUntrackedFilePaths()");
                        Iterable iterable = collection;
                        Project project2 = project;
                        shareProjectOnGithub.1 var27_11 = this;
                        boolean $i$f$mapNotNull = false;
                        void var11_14 = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            VirtualFile virtualFile;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            FilePath p1 = (FilePath)element$iv$iv;
                            boolean bl2 = false;
                            if (p1.getVirtualFile() == null) continue;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            VirtualFile it$iv$iv = virtualFile;
                            boolean bl5 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List list3 = (List)destination$iv$iv;
                        Collection<VirtualFile> untrackedFiles = var27_11.filterOutIgnored(project2, list3);
                        trackedFiles.removeAll(untrackedFiles);
                        ArrayList<VirtualFile> allFiles = new ArrayList<VirtualFile>();
                        allFiles.addAll(trackedFiles);
                        allFiles.addAll(untrackedFiles);
                        GithubUntrackedFilesDialog dialog2 = (GithubUntrackedFilesDialog)((Object)ActionsKt.invokeAndWaitIfNeeded((ModalityState)indicator.getModalityState(), (Function0)((Function0)new Function0<GithubUntrackedFilesDialog>(project, allFiles, trackedFiles){
                            final /* synthetic */ Project $project;
                            final /* synthetic */ ArrayList $allFiles;
                            final /* synthetic */ List $trackedFiles;

                            @NotNull
                            public final GithubUntrackedFilesDialog invoke() {
                                GithubUntrackedFilesDialog githubUntrackedFilesDialog = new GithubUntrackedFilesDialog(this.$project, this.$allFiles);
                                boolean bl = false;
                                boolean bl2 = false;
                                GithubUntrackedFilesDialog $this$apply = githubUntrackedFilesDialog;
                                boolean bl3 = false;
                                if (!this.$trackedFiles.isEmpty()) {
                                    $this$apply.setSelectedFiles(this.$trackedFiles);
                                }
                                DialogManager.show((DialogWrapper)((DialogWrapper)$this$apply));
                                return githubUntrackedFilesDialog;
                            }
                            {
                                this.$project = project;
                                this.$allFiles = arrayList;
                                this.$trackedFiles = list2;
                                super(0);
                            }
                        })));
                        Collection files2commit = dialog2.getSelectedFiles();
                        if (!dialog2.isOK() || files2commit.isEmpty()) {
                            GithubNotifications.showInfoURL(project, "github.share.empty.repo.created", GithubBundle.message("share.process.empty.project.created", new Object[0]), name, url);
                            return false;
                        }
                        Collection collection2 = ContainerUtil.intersection(untrackedFiles, (Collection)files2commit);
                        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"ContainerUtil.intersecti\u2026ackedFiles, files2commit)");
                        Collection files2add = collection2;
                        Collection collection3 = ContainerUtil.subtract((Collection)trackedFiles, (Collection)files2commit);
                        Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"ContainerUtil.subtract(trackedFiles, files2commit)");
                        Collection files2rm = collection3;
                        HashSet<E> modified = new HashSet<E>(trackedFiles);
                        modified.addAll(files2commit);
                        GitFileUtils.addFiles((Project)project, (VirtualFile)root, (Collection)files2add);
                        GitFileUtils.deleteFilesFromCache((Project)project, (VirtualFile)root, (Collection)files2rm);
                        GithubShareAction.access$getLOG$cp().info("Performing commit");
                        indicator.setText(GithubBundle.message("share.process.performing.commit", new Object[0]));
                        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.COMMIT);
                        handler.setStdoutSuppressed(false);
                        handler.addParameters(new String[]{"-m", dialog2.getCommitMessage()});
                        handler.endOptions();
                        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
                        VcsFileUtil.markFilesDirty((Project)project, (Collection)modified);
                    }
                    catch (VcsException e) {
                        GithubShareAction.access$getLOG$cp().warn((Throwable)e);
                        GithubNotifications.showErrorURL(project, "github.share.project.created.init.commit.failed", GithubBundle.message("share.error.cannot.finish", new Object[0]), GithubBundle.message("share.error.created.project", new Object[0]), " '" + name + "' ", GithubBundle.message("share.error.init.commit.failed", new Object[0]) + GithubUtil.getErrorTextFromException(e), url);
                        return false;
                    }
                    GithubShareAction.access$getLOG$cp().info("Successfully created initial commit");
                    return true;
                }

                private final Collection<VirtualFile> filterOutIgnored(Project project, Collection<? extends VirtualFile> files) {
                    ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
                    Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
                    ChangeListManager changeListManager2 = changeListManager;
                    ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
                    List list2 = ContainerUtil.filter(files, (Condition)((Condition)new Condition<VirtualFile>(changeListManager2, vcsManager){
                        final /* synthetic */ ChangeListManager $changeListManager;
                        final /* synthetic */ ProjectLevelVcsManager $vcsManager;

                        public final boolean value(VirtualFile file) {
                            return !this.$changeListManager.isIgnoredFile(file) && !this.$vcsManager.isIgnored(file);
                        }
                        {
                            this.$changeListManager = changeListManager;
                            this.$vcsManager = projectLevelVcsManager;
                        }
                    }));
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ContainerUtil.filter(fil\u2026Manager.isIgnored(file) }");
                    return list2;
                }

                private final boolean pushCurrentBranch(Project project, GitRepository repository, String remoteName, String remoteUrl, String name, String url) {
                    GitLocalBranch currentBranch = repository.getCurrentBranch();
                    if (currentBranch == null) {
                        GithubNotifications.showErrorURL(project, "github.share.init.push.failed", GithubBundle.message("share.error.cannot.finish", new Object[0]), GithubBundle.message("share.error.created.project", new Object[0]), " '" + name + "' ", GithubBundle.message("share.error.push.no.current.branch", new Object[0]), url);
                        return false;
                    }
                    GitCommandResult gitCommandResult = this.$git.push(repository, remoteName, remoteUrl, currentBranch.getName(), true, new GitLineHandlerListener[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"git.push(repository, rem\u2026currentBranch.name, true)");
                    GitCommandResult result = gitCommandResult;
                    if (!result.success()) {
                        GithubNotifications.showErrorURL(project, "github.share.init.push.failed", GithubBundle.message("share.error.cannot.finish", new Object[0]), GithubBundle.message("share.error.created.project", new Object[0]), " '" + name + "' ", GithubBundle.message("share.error.push.failed", result.getErrorOutputAsHtmlString()), url);
                        return false;
                    }
                    return true;
                }

                public void onThrowable(@NotNull Throwable error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    GithubNotifications.showError(this.$project, "github.share.cannot.create.repo", GithubBundle.message("share.error.failed.to.create.repo", new Object[0]), error);
                }
                {
                    this.$requestExecutor = $captured_local_variable$0;
                    this.$account = $captured_local_variable$1;
                    this.$name = $captured_local_variable$2;
                    this.$description = $captured_local_variable$3;
                    this.$isPrivate = $captured_local_variable$4;
                    this.$gitRepository = $captured_local_variable$5;
                    this.$project = $captured_local_variable$6;
                    this.$accountInformationProvider = $captured_local_variable$7;
                    this.$gitHelper = $captured_local_variable$8;
                    this.$git = $captured_local_variable$9;
                    this.$remoteName = $captured_local_variable$10;
                    super($super_call_param$11, $super_call_param$12);
                }
            }.queue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

