/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.git.AddFile;
import org.jetbrains.settingsRepository.git.CommitMessageFormatter;
import org.jetbrains.settingsRepository.git.DirCacheEditorKt;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.IdeaCommitMessageFormatter;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0003\u001a0\u0010\f\u001a\u00020\r*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0001H\u0002\u001a(\u0010\u0014\u001a\u00020\r*\u00060\u000ej\u0002`\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0002\u00a8\u0006\u0015"}, d2={"commit", "", "repository", "Lorg/eclipse/jgit/lib/Repository;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "commitMessageFormatter", "Lorg/jetbrains/settingsRepository/git/CommitMessageFormatter;", "indexDiffToString", "", "diff", "Lorg/eclipse/jgit/lib/IndexDiff;", "addList", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "name", "list", "", "compact", "appendCompactList", "intellij.settingsRepository"})
public final class CommitKt {
    public static final boolean commit(@NotNull Repository repository2, @Nullable ProgressIndicator indicator, @NotNull CommitMessageFormatter commitMessageFormatter) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commitMessageFormatter, (String)"commitMessageFormatter");
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        IndexDiff diff = GitExKt.computeIndexDiff(repository2);
        ProgressIndicator progressIndicator2 = indicator;
        boolean changed = diff.diff((ProgressMonitor)(progressIndicator2 != null ? JGitProgressMonitorKt.asProgressMonitor(progressIndicator2) : null), 0, 0, IcsBundleKt.icsMessage("operation.progress.committing", new Object[0]));
        if (!changed || diff.getAdded().isEmpty() && diff.getChanged().isEmpty() && diff.getRemoved().isEmpty()) {
            if (diff.getModified().isEmpty() && diff.getMissing().isEmpty()) {
                IcsManagerKt.getLOG().debug("Nothing to commit");
                return false;
            }
            List edits = null;
            Iterator iterator = diff.getModified().iterator();
            while (iterator.hasNext()) {
                String path;
                String string = path = (String)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
                if (StringsKt.startsWith$default((String)string, (String)"_projects/", (boolean)false, (int)2, null)) continue;
                if (edits == null) {
                    edits = (List)new SmartList();
                }
                edits.add(new AddFile(path));
            }
            for (String path : diff.getMissing()) {
                if (edits == null) {
                    edits = (List)new SmartList();
                }
                String string = path;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
                edits.add(DirCacheEditorKt.DeleteFile(string));
            }
            if (edits != null) {
                DirCacheEditorKt.edit(repository2, edits);
            }
        }
        Logger $this$debug$iv = IcsManagerKt.getLOG();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = CommitKt.indexDiffToString(diff);
            logger.debug(string, (Throwable)e$iv);
        }
        ProgressIndicator progressIndicator3 = indicator;
        if (progressIndicator3 != null) {
            progressIndicator3.checkCanceled();
        }
        StringBuilder builder = CommitMessageFormatter.DefaultImpls.prependMessage$default(commitMessageFormatter, null, 1, null);
        Set set = diff.getChanged();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"diff.changed");
        CommitKt.appendCompactList(builder, "Update", set);
        Set set2 = diff.getAdded();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"diff.added");
        CommitKt.appendCompactList(builder, "Create", set2);
        Set set3 = diff.getRemoved();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"diff.removed");
        CommitKt.appendCompactList(builder, "Delete", set3);
        GitExKt.commit$default(repository2, builder.toString(), null, null, null, 14, null);
        return true;
    }

    public static /* synthetic */ boolean commit$default(Repository repository2, ProgressIndicator progressIndicator, CommitMessageFormatter commitMessageFormatter, int n, Object object) {
        if ((n & 4) != 0) {
            commitMessageFormatter = new IdeaCommitMessageFormatter();
        }
        return CommitKt.commit(repository2, progressIndicator, commitMessageFormatter);
    }

    @NonNls
    private static final String indexDiffToString(IndexDiff diff) {
        StringBuilder builder = new StringBuilder();
        builder.append("To commit:");
        Set set = diff.getAdded();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"diff.added");
        CommitKt.addList$default(builder, "Added", set, false, 4, null);
        Set set2 = diff.getChanged();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"diff.changed");
        CommitKt.addList$default(builder, "Changed", set2, false, 4, null);
        Set set3 = diff.getRemoved();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"diff.removed");
        CommitKt.addList$default(builder, "Deleted", set3, false, 4, null);
        Set set4 = diff.getModified();
        Intrinsics.checkNotNullExpressionValue((Object)set4, (String)"diff.modified");
        CommitKt.addList$default(builder, "Modified on disk relative to the index", set4, false, 4, null);
        Set set5 = diff.getUntracked();
        Intrinsics.checkNotNullExpressionValue((Object)set5, (String)"diff.untracked");
        CommitKt.addList$default(builder, "Untracked files", set5, false, 4, null);
        Set set6 = diff.getUntrackedFolders();
        Intrinsics.checkNotNullExpressionValue((Object)set6, (String)"diff.untrackedFolders");
        CommitKt.addList$default(builder, "Untracked folders", set6, false, 4, null);
        Set set7 = diff.getMissing();
        Intrinsics.checkNotNullExpressionValue((Object)set7, (String)"diff.missing");
        CommitKt.addList$default(builder, "Missing", set7, false, 4, null);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private static final void appendCompactList(StringBuilder $this$appendCompactList, @NonNls String name, Collection<String> list) {
        CommitKt.addList($this$appendCompactList, name, list, true);
    }

    private static final void addList(StringBuilder $this$addList, String name, Collection<String> list, boolean compact) {
        if (list.isEmpty()) {
            return;
        }
        if (compact) {
            if ($this$addList.length() != 0 && $this$addList.charAt($this$addList.length() - 1) != ' ') {
                $this$addList.append('\t');
            }
            $this$addList.append(name);
        } else {
            $this$addList.append('\t').append(name).append(':');
        }
        $this$addList.append(' ');
        boolean isNotFirst = false;
        for (String path : list) {
            if (isNotFirst) {
                $this$addList.append(',').append(' ');
            } else {
                isNotFirst = true;
            }
            $this$addList.append(compact ? PathUtilRt.getFileName((String)path) : path);
        }
    }

    static /* synthetic */ void addList$default(StringBuilder stringBuilder, String string, Collection collection, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        CommitKt.addList(stringBuilder, string, collection, bl);
    }
}

