/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.MyPrettyPrinter;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"DEFAULT_COMMIT_DELAY", "", "loadSettings", "Lorg/jetbrains/settingsRepository/IcsSettings;", "settingsFile", "Ljava/nio/file/Path;", "saveSettings", "", "settings", "intellij.settingsRepository"})
public final class IcsSettingsKt {
    private static final int DEFAULT_COMMIT_DELAY = 600000;

    public static final void saveSettings(@NotNull IcsSettings settings, @NotNull Path settingsFile) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)settingsFile, (String)"settingsFile");
        byte[] serialized = new ObjectMapper().writer((PrettyPrinter)new MyPrettyPrinter()).writeValueAsBytes((Object)settings);
        if (serialized.length <= 2) {
            PathKt.delete$default((Path)settingsFile, (boolean)false, (int)1, null);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)serialized, (String)"serialized");
            PathKt.write$default((Path)settingsFile, (byte[])serialized, (int)0, (int)0, (int)6, null);
        }
    }

    @NotNull
    public static final IcsSettings loadSettings(@NotNull Path settingsFile) {
        Intrinsics.checkNotNullParameter((Object)settingsFile, (String)"settingsFile");
        if (!PathKt.exists((Path)settingsFile)) {
            return new IcsSettings();
        }
        IcsSettings settings = (IcsSettings)new ObjectMapper().readValue(settingsFile.toFile(), IcsSettings.class);
        if (settings.getCommitDelay() <= 0) {
            settings.setCommitDelay(600000);
        }
        IcsSettings icsSettings = settings;
        Intrinsics.checkNotNullExpressionValue((Object)icsSettings, (String)"settings");
        return icsSettings;
    }
}

