/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.ide.ApplicationLoadListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.util.io.FileUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.AutoSyncManager;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsUrlBuilderKt;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.git.GitRepositoryManager;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R+\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/settingsRepository/IcsApplicationLoadListener;", "Lcom/intellij/ide/ApplicationLoadListener;", "()V", "<set-?>", "Lorg/jetbrains/settingsRepository/IcsManager;", "icsManager", "getIcsManager", "()Lorg/jetbrains/settingsRepository/IcsManager;", "setIcsManager", "(Lorg/jetbrains/settingsRepository/IcsManager;)V", "icsManager$delegate", "Lkotlin/properties/ReadWriteProperty;", "beforeApplicationLoaded", "", "application", "Lcom/intellij/openapi/application/Application;", "configPath", "Ljava/nio/file/Path;", "intellij.settingsRepository"})
public final class IcsApplicationLoadListener
implements ApplicationLoadListener {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final ReadWriteProperty icsManager$delegate = Delegates.INSTANCE.notNull();

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(IcsApplicationLoadListener.class, "icsManager", "getIcsManager()Lorg/jetbrains/settingsRepository/IcsManager;", 0))};
    }

    @NotNull
    public final IcsManager getIcsManager() {
        return (IcsManager)this.icsManager$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setIcsManager(IcsManager icsManager2) {
        this.icsManager$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)icsManager2);
    }

    public void beforeApplicationLoaded(@NotNull Application application, @NotNull Path configPath) {
        Path pluginSystemDir;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        if (application.isUnitTestMode()) {
            return;
        }
        String customPath = System.getProperty("ics.settingsRepository");
        Path path = pluginSystemDir = customPath == null ? configPath.resolve("settingsRepository") : Paths.get(FileUtil.expandUserHome((String)customPath), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"pluginSystemDir");
        this.setIcsManager(new IcsManager(path, (Disposable)application, null, 4, null));
        RepositoryManager repositoryManager = this.getIcsManager().getRepositoryManager();
        if (repositoryManager.isRepositoryExists() && repositoryManager instanceof GitRepositoryManager) {
            String osFolderName = IcsUrlBuilderKt.getOsFolderName();
            boolean migrateSchemes = ((GitRepositoryManager)repositoryManager).renameDirectory(MapsKt.linkedMapOf((Pair[])new Pair[]{new Pair((Object)"$ROOT_CONFIG$", null), new Pair((Object)(osFolderName + "/$ROOT_CONFIG$"), (Object)osFolderName), new Pair((Object)"$APP_CONFIG$", null), new Pair((Object)(osFolderName + "/$APP_CONFIG$"), (Object)osFolderName)}), "Get rid of $ROOT_CONFIG$ and $APP_CONFIG");
            boolean migrateKeyMaps = ((GitRepositoryManager)repositoryManager).renameDirectory(MapsKt.linkedMapOf((Pair[])new Pair[]{new Pair((Object)(osFolderName + "/keymaps"), (Object)"keymaps")}), "Move keymaps to root");
            boolean removeOtherXml = repositoryManager.delete("other.xml");
            if (migrateSchemes || migrateKeyMaps || removeOtherXml) {
                application.invokeLater(new Runnable(this){
                    final /* synthetic */ IcsApplicationLoadListener this$0;

                    public final void run() {
                        AutoSyncManager.autoSync$default(this.this$0.getIcsManager().getAutoSyncManager$intellij_settingsRepository(), false, true, 1, null);
                    }
                    {
                        this.this$0 = icsApplicationLoadListener;
                    }
                });
            }
        }
        this.getIcsManager().beforeApplicationLoaded(application);
    }

    public static final /* synthetic */ IcsManager access$getIcsManager$p(IcsApplicationLoadListener $this) {
        return $this.getIcsManager();
    }

    public static final /* synthetic */ void access$setIcsManager$p(IcsApplicationLoadListener $this, IcsManager icsManager2) {
        $this.setIcsManager(icsManager2);
    }
}

