/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.RepositoryManager;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H$J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0015H$J\b\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0014Jk\u0010\u001b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2!\u0010\u001c\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00150\u001d26\u0010 \u001a2\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\u001f\u0012\u0013\u0012\u00110\"\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00150!H\u0016J1\u0010$\u001a\u0002H%\"\u0004\b\u0000\u0010%2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010&\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\"\u0012\u0004\u0012\u0002H%0\u001dH\u0016\u00a2\u0006\u0002\u0010'J \u0010(\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006)"}, d2={"Lorg/jetbrains/settingsRepository/BaseRepositoryManager;", "Lorg/jetbrains/settingsRepository/RepositoryManager;", "dir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getDir", "()Ljava/nio/file/Path;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "addToIndex", "", "file", "path", "", "content", "", "size", "", "delete", "", "deleteFromIndex", "isFile", "deleteRepository", "has", "isPathIgnored", "processChildren", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "processor", "Lkotlin/Function2;", "Ljava/io/InputStream;", "inputStream", "read", "R", "consumer", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "write", "intellij.settingsRepository"})
public abstract class BaseRepositoryManager
implements RepositoryManager {
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final Path dir;

    @NotNull
    protected final ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void processChildren(@NotNull String path, @NotNull Function1<? super String, Boolean> filter, @NotNull Function2<? super String, ? super InputStream, Boolean> processor) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Path path2 = this.dir.resolve(path);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"dir.resolve(path)");
        Path path3 = path2;
        Function1 filter$iv = (Function1)new Function1<Path, Boolean>(filter){
            final /* synthetic */ Function1 $filter;

            public final boolean invoke(@NotNull Path it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Boolean)this.$filter.invoke((Object)((Object)it.getFileName()).toString());
            }
            {
                this.$filter = function1;
                super(1);
            }
        };
        boolean $i$f$directoryStreamIfExists = false;
        try {
            void $this$directoryStreamIfExists$iv;
            Closeable closeable = Files.newDirectoryStream((Path)$this$directoryStreamIfExists$iv, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(filter$iv){
                final /* synthetic */ Function1 $filter;
                {
                    this.$filter = function1;
                }

                public final boolean accept(Path it) {
                    Path path = it;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                    return (Boolean)this.$filter.invoke((Object)path);
                }
            });
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                DirectoryStream fileStream = (DirectoryStream)closeable;
                boolean bl3 = false;
                for (Path file : fileStream) {
                    boolean bl4;
                    boolean bl5;
                    BasicFileAttributes attributes = null;
                    try {
                        Path path4 = file;
                        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"file");
                        attributes = PathKt.basicAttributesIfExists((Path)path4);
                    }
                    catch (IOException e) {
                        IcsManagerKt.getLOG().warn((Throwable)e);
                        continue;
                    }
                    if (attributes == null || attributes.isDirectory() || PathKt.isHidden((Path)file)) continue;
                    if (attributes.size() == 0L) {
                        Object object;
                        Logger $this$runAndLogException$iv = IcsManagerKt.getLOG();
                        boolean $i$f$runAndLogException = false;
                        bl5 = false;
                        try {
                            object = Result.Companion;
                            boolean $i$a$-runCatching-LoggerKt$runAndLogException$1$iv22 = false;
                            boolean bl6 = false;
                            IcsManagerKt.getLOG().warn("File " + path + " is empty (length 0), will be removed");
                            Boolean $i$a$-runCatching-LoggerKt$runAndLogException$1$iv22 = this.delete(file, path);
                            boolean bl7 = false;
                            object = Result.constructor-impl((Object)$i$a$-runCatching-LoggerKt$runAndLogException$1$iv22);
                        }
                        catch (Throwable $i$a$-runCatching-LoggerKt$runAndLogException$1$iv22) {
                            Result.Companion companion = Result.Companion;
                            boolean bl8 = false;
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-LoggerKt$runAndLogException$1$iv22));
                        }
                        LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
                        continue;
                    }
                    Closeable closeable2 = PathKt.inputStream((Path)file);
                    boolean bl9 = false;
                    bl5 = false;
                    Throwable throwable2 = null;
                    try {
                        InputStream it = (InputStream)closeable2;
                        boolean bl10 = false;
                        bl4 = (Boolean)processor.invoke((Object)((Object)file.getFileName()).toString(), (Object)it);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    if (bl4) continue;
                    break;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
    }

    @Override
    public void deleteRepository() {
        PathKt.delete$default((Path)this.dir, (boolean)false, (int)1, null);
    }

    protected boolean isPathIgnored(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R read(@NotNull String path, @NotNull Function1<? super InputStream, ? extends R> consumer) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Path fileToDelete = null;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            Path file;
            boolean bl3 = false;
            Path path2 = file = this.dir.resolve(path);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file");
            long l = PathKt.sizeOrNull((Path)path2);
            if (l == -1L) {
                Object object2 = consumer.invoke(null);
                return (R)object2;
            }
            if (l != 0L) {
                Object object3;
                Closeable closeable = PathKt.inputStream((Path)file);
                Function1<? super InputStream, ? extends R> function1 = consumer;
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable = null;
                try {
                    object3 = function1.invoke((Object)closeable);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Object object4 = object3;
                return (R)object4;
            }
            fileToDelete = file;
            object = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        Logger $this$runAndLogException$iv = IcsManagerKt.getLOG();
        boolean $i$f$runAndLogException = false;
        boolean bl6 = false;
        try {
            object = Result.Companion;
            boolean bl7 = false;
            boolean bl8 = false;
            if (PathKt.sizeOrNull((Path)fileToDelete) == 0L) {
                IcsManagerKt.getLOG().warn("File " + path + " is empty (length 0), will be removed");
                this.delete(fileToDelete, path);
            }
            Unit unit = Unit.INSTANCE;
            boolean bl9 = false;
            object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl10 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        return (R)consumer.invoke(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(@NotNull String path, @NotNull byte[] content, int size) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Object $this$debug$iv = IcsManagerKt.getLOG();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "Write " + path;
            logger.debug(string, (Throwable)e$iv);
        }
        try {
            int n;
            int n2;
            $this$debug$iv = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)$this$debug$iv).readLock();
            int n3 = ((ReentrantReadWriteLock)$this$debug$iv).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)$this$debug$iv).getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)$this$debug$iv).writeLock();
            writeLock.lock();
            try {
                Path file;
                boolean bl4 = false;
                Path path2 = file = this.dir.resolve(path);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file");
                PathKt.write((Path)path2, (byte[])content, (int)0, (int)size);
                if (this.isPathIgnored(path)) {
                    Logger $this$debug$iv2 = IcsManagerKt.getLOG();
                    Exception e$iv2 = null;
                    boolean $i$f$debug2 = false;
                    if ($this$debug$iv2.isDebugEnabled()) {
                        Logger logger = $this$debug$iv2;
                        boolean bl5 = false;
                        String string = path + " is ignored and will be not added to index";
                        logger.debug(string, (Throwable)e$iv2);
                    }
                } else {
                    this.addToIndex(file, path, content, size);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl6 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }
        catch (Exception e) {
            IcsManagerKt.getLOG().error((Throwable)e);
            return false;
        }
        return true;
    }

    protected abstract void addToIndex(@NotNull Path var1, @NotNull String var2, @NotNull byte[] var3, int var4);

    @Override
    public boolean delete(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Logger $this$debug$iv = IcsManagerKt.getLOG();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "Remove " + path;
            logger.debug(string, (Throwable)e$iv);
        }
        Path path2 = this.dir.resolve(path);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"dir.resolve(path)");
        return this.delete(path2, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean delete(Path file, String path) {
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists((Path)file);
        if (basicFileAttributes == null) {
            return false;
        }
        BasicFileAttributes fileAttributes = basicFileAttributes;
        boolean isFile = fileAttributes.isRegularFile();
        if (!PathKt.deleteWithParentsIfEmpty((Path)file, (Path)this.dir, (boolean)isFile)) {
            return false;
        }
        if (!this.isPathIgnored(path)) {
            int n;
            int n2;
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl4 = false;
                this.deleteFromIndex(path, isFile);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl5 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }
        return true;
    }

    protected abstract void deleteFromIndex(@NotNull String var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean has(@NotNull String path) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl2 = false;
        boolean bl3 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl4 = false;
            Path path2 = this.dir.resolve(path);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"dir.resolve(path)");
            bl = PathKt.exists((Path)path2);
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    @NotNull
    protected final Path getDir() {
        return this.dir;
    }

    public BaseRepositoryManager(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.dir = dir;
        this.lock = new ReentrantReadWriteLock();
    }
}

