/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.diagnostic.Logger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H$\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/io/DelegatingHttpRequestHandlerBase;", "Lorg/jetbrains/io/SimpleChannelInboundHandlerAdapter;", "Lio/netty/handler/codec/http/FullHttpRequest;", "()V", "exceptionCaught", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "cause", "", "messageReceived", "message", "process", "", "request", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "intellij.platform.ide.util.io"})
public abstract class DelegatingHttpRequestHandlerBase
extends SimpleChannelInboundHandlerAdapter<FullHttpRequest> {
    @Override
    protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull FullHttpRequest message) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BuiltInServer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        Logger $this$debug$iv = logger;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger2 = $this$debug$iv;
            boolean bl = false;
            String string = "\n\nIN HTTP: " + message + "\n\n";
            logger2.debug(string, e$iv);
        }
        if (!this.process(context, message, new QueryStringDecoder(message.uri()))) {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"HttpResponseStatus.NOT_FOUND");
            HttpResponse httpResponse = Responses.createStatusResponse$default(httpResponseStatus, (HttpRequest)message, null, 4, null);
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"context.channel()");
            Responses.send$default(httpResponse, channel, (HttpRequest)message, null, 4, null);
        }
    }

    protected abstract boolean process(@NotNull ChannelHandlerContext var1, @NotNull FullHttpRequest var2, @NotNull QueryStringDecoder var3);

    public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BuiltInServer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        NettyUtil.logAndClose(cause, logger, context.channel());
    }
}

