/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.NettyKt;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Random;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServerKt;
import org.jetbrains.io.BuiltInServerThreadFactory;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.io.DelegatingHttpRequestHandler;
import org.jetbrains.io.IdeaNettyLogger;
import org.jetbrains.io.PortUnificationServerHandler;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/io/BuiltInServer;", "Lcom/intellij/openapi/Disposable;", "eventLoopGroup", "Lio/netty/channel/EventLoopGroup;", "port", "", "channelRegistrar", "Lorg/jetbrains/io/ChannelRegistrar;", "(Lio/netty/channel/EventLoopGroup;ILorg/jetbrains/io/ChannelRegistrar;)V", "getEventLoopGroup", "()Lio/netty/channel/EventLoopGroup;", "isRunning", "", "()Z", "getPort", "()I", "dispose", "", "Companion", "intellij.platform.ide.util.io"})
public final class BuiltInServer
implements Disposable {
    @NotNull
    private final EventLoopGroup eventLoopGroup;
    private final int port;
    private final ChannelRegistrar channelRegistrar;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean isRunning() {
        return !this.channelRegistrar.isEmpty();
    }

    @Override
    public void dispose() {
        this.channelRegistrar.close();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BuiltInServer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        logger.info("web server stopped");
    }

    @NotNull
    public final EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public final int getPort() {
        return this.port;
    }

    private BuiltInServer(EventLoopGroup eventLoopGroup, int port, ChannelRegistrar channelRegistrar) {
        this.eventLoopGroup = eventLoopGroup;
        this.port = port;
        this.channelRegistrar = channelRegistrar;
    }

    static {
        String string = System.getProperty("io.netty.random.id", "true");
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        boolean bl = false;
        if (Boolean.parseBoolean(string2)) {
            System.setProperty("io.netty.machineId", "28:f0:76:ff:fe:16:65:0e");
            System.setProperty("io.netty.processId", String.valueOf(new Random().nextInt(65535)));
        }
        System.setProperty("io.netty.serviceThreadPrefix", "Netty ");
        BuiltInServer.Companion.setSystemPropertyIfNotConfigured("io.netty.allocator.numDirectArenas", "1");
        BuiltInServer.Companion.setSystemPropertyIfNotConfigured("io.netty.allocator.numHeapArenas", "1");
        BuiltInServer.Companion.setSystemPropertyIfNotConfigured("io.netty.allocator.useCacheForAllThreads", "false");
        BuiltInServer.Companion.setSystemPropertyIfNotConfigured("io.netty.allocator.cacheTrimIntervalMillis", "600000");
        IdeaNettyLogger logger = new IdeaNettyLogger();
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new InternalLoggerFactory(logger){
            final /* synthetic */ IdeaNettyLogger $logger;

            @NotNull
            protected IdeaNettyLogger newInstance(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return this.$logger;
            }
            {
                this.$logger = $captured_local_variable$0;
            }
        });
    }

    public /* synthetic */ BuiltInServer(EventLoopGroup eventLoopGroup, int port, ChannelRegistrar channelRegistrar, DefaultConstructorMarker $constructor_marker) {
        this(eventLoopGroup, port, channelRegistrar);
    }

    @JvmStatic
    @NotNull
    public static final BuiltInServer start(int firstPort, int portsCount, @Nullable Supplier<ChannelHandler> handler2) {
        return Companion.start(firstPort, portsCount, handler2);
    }

    @JvmStatic
    public static final void configureChildHandler(@NotNull ServerBootstrap bootstrap, @NotNull ChannelRegistrar channelRegistrar, @Nullable Supplier<ChannelHandler> channelHandler) {
        Companion.configureChildHandler(bootstrap, channelRegistrar, channelHandler);
    }

    @JvmStatic
    public static final void replaceDefaultHandler(@NotNull ChannelHandlerContext context, @NotNull ChannelHandler channelHandler) {
        Companion.replaceDefaultHandler(context, channelHandler);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0007J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0012H\u0007J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J@\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0010\b\u0002\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011J*\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0010\b\u0002\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0007\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/io/BuiltInServer$Companion;", "", "()V", "bind", "", "firstPort", "portsCount", "tryAnyPort", "", "bootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "channelRegistrar", "Lorg/jetbrains/io/ChannelRegistrar;", "isEventLoopGroupOwner", "configureChildHandler", "", "channelHandler", "Ljava/util/function/Supplier;", "Lio/netty/channel/ChannelHandler;", "replaceDefaultHandler", "context", "Lio/netty/channel/ChannelHandlerContext;", "setSystemPropertyIfNotConfigured", "name", "", "value", "start", "Lorg/jetbrains/io/BuiltInServer;", "eventLoopGroup", "Lio/netty/channel/EventLoopGroup;", "handler", "intellij.platform.ide.util.io"})
    public static final class Companion {
        private final void setSystemPropertyIfNotConfigured(String name, String value) {
            if (System.getProperty(name) == null) {
                System.setProperty(name, value);
            }
        }

        @JvmStatic
        @NotNull
        public final BuiltInServer start(int firstPort, int portsCount, @Nullable Supplier<ChannelHandler> handler2) {
            MultithreadEventLoopGroup eventLoopGroup = BuiltInServerKt.access$multiThreadEventLoopGroup(PlatformUtils.isIdeaCommunity() ? 2 : 3, new BuiltInServerThreadFactory());
            return this.start((EventLoopGroup)eventLoopGroup, true, firstPort, portsCount, false, handler2);
        }

        public static /* synthetic */ BuiltInServer start$default(Companion companion, int n, int n2, Supplier supplier, int n3, Object object) {
            if ((n3 & 4) != 0) {
                supplier = null;
            }
            return companion.start(n, n2, supplier);
        }

        @NotNull
        public final BuiltInServer start(@NotNull EventLoopGroup eventLoopGroup, boolean isEventLoopGroupOwner, int firstPort, int portsCount, boolean tryAnyPort, @Nullable Supplier<ChannelHandler> handler2) {
            Intrinsics.checkNotNullParameter((Object)eventLoopGroup, (String)"eventLoopGroup");
            ChannelRegistrar channelRegistrar = new ChannelRegistrar();
            ServerBootstrap bootstrap = NettyKt.serverBootstrap(eventLoopGroup);
            this.configureChildHandler(bootstrap, channelRegistrar, handler2);
            int port = this.bind(firstPort, portsCount, tryAnyPort, bootstrap, channelRegistrar, isEventLoopGroupOwner);
            return new BuiltInServer(eventLoopGroup, port, channelRegistrar, null);
        }

        public static /* synthetic */ BuiltInServer start$default(Companion companion, EventLoopGroup eventLoopGroup, boolean bl, int n, int n2, boolean bl2, Supplier supplier, int n3, Object object) {
            if ((n3 & 0x20) != 0) {
                supplier = null;
            }
            return companion.start(eventLoopGroup, bl, n, n2, bl2, supplier);
        }

        @JvmStatic
        public final void configureChildHandler(@NotNull ServerBootstrap bootstrap, @NotNull ChannelRegistrar channelRegistrar, @Nullable Supplier<ChannelHandler> channelHandler) {
            Intrinsics.checkNotNullParameter((Object)bootstrap, (String)"bootstrap");
            Intrinsics.checkNotNullParameter((Object)((Object)channelRegistrar), (String)"channelRegistrar");
            PortUnificationServerHandler portUnificationServerHandler = channelHandler == null ? new PortUnificationServerHandler() : null;
            bootstrap.childHandler(new ChannelHandler(channelRegistrar, channelHandler, portUnificationServerHandler){
                final /* synthetic */ ChannelRegistrar $channelRegistrar;
                final /* synthetic */ Supplier $channelHandler;
                final /* synthetic */ PortUnificationServerHandler $portUnificationServerHandler;

                protected void initChannel(@NotNull Channel channel) {
                    Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                    ChannelPipeline channelPipeline = channel.pipeline();
                    ChannelHandler[] channelHandlerArray = new ChannelHandler[2];
                    channelHandlerArray[0] = (ChannelHandler)this.$channelRegistrar;
                    Supplier supplier = this.$channelHandler;
                    if (supplier == null || (supplier = (ChannelHandler)supplier.get()) == null) {
                        supplier = (ChannelHandler)this.$portUnificationServerHandler;
                    }
                    channelHandlerArray[1] = supplier;
                    channelPipeline.addLast(channelHandlerArray);
                }
                {
                    this.$channelRegistrar = $captured_local_variable$0;
                    this.$channelHandler = $captured_local_variable$1;
                    this.$portUnificationServerHandler = $captured_local_variable$2;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final int bind(int firstPort, int portsCount, boolean tryAnyPort, ServerBootstrap bootstrap, ChannelRegistrar channelRegistrar, boolean isEventLoopGroupOwner) {
            ChannelFuture future;
            InetAddress address = InetAddress.getLoopbackAddress();
            int n = firstPort;
            int maxPort = firstPort + portsCount - 1;
            int n2 = maxPort;
            if (n <= n2) {
                while (true) {
                    void port;
                    if (port != 6953 && port != 6969 && port != 6970) {
                        ChannelFuture future2;
                        ChannelFuture channelFuture = future2 = bootstrap.bind(address, (int)port).awaitUninterruptibly();
                        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"future");
                        if (channelFuture.isSuccess()) {
                            channelRegistrar.setServerChannel(future2.channel(), isEventLoopGroupOwner);
                            return (int)port;
                        }
                        if (!tryAnyPort && port == maxPort) {
                            Throwable throwable = future2.cause();
                            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"future.cause()");
                            throw throwable;
                        }
                    }
                    if (port == n2) break;
                    ++port;
                }
            }
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(BuiltInServer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.info("Cannot bind to our default range, so, try to bind to any free port");
            ChannelFuture channelFuture = future = bootstrap.bind(address, 0).awaitUninterruptibly();
            Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"future");
            if (channelFuture.isSuccess()) {
                channelRegistrar.setServerChannel(future.channel(), isEventLoopGroupOwner);
                SocketAddress socketAddress = future.channel().localAddress();
                if (socketAddress == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.net.InetSocketAddress");
                }
                return ((InetSocketAddress)socketAddress).getPort();
            }
            Throwable throwable = future.cause();
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"future.cause()");
            throw throwable;
        }

        @JvmStatic
        public final void replaceDefaultHandler(@NotNull ChannelHandlerContext context, @NotNull ChannelHandler channelHandler) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)channelHandler, (String)"channelHandler");
            context.pipeline().replace(DelegatingHttpRequestHandler.class, "replacedDefaultHandler", channelHandler);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

