/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.io.NettyKt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH&J0\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0004\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/ide/HttpRequestHandler;", "", "()V", "isAccessible", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "isOriginAllowed", "Lorg/jetbrains/ide/HttpRequestHandler$OriginCheckResult;", "isSupported", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "sendData", "content", "", "name", "", "channel", "Lio/netty/channel/Channel;", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "Companion", "OriginCheckResult", "intellij.platform.ide.util.io"})
public abstract class HttpRequestHandler {
    @NotNull
    private static final ExtensionPointName<HttpRequestHandler> EP_NAME;
    @NotNull
    public static final Companion Companion;

    public boolean isAccessible(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String hostName = NettyKt.getHostName(request);
        return hostName != null && this.isOriginAllowed(request) != OriginCheckResult.FORBID && NettyKt.isLocalHost$default(hostName, false, false, 6, null);
    }

    @NotNull
    protected OriginCheckResult isOriginAllowed(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return NettyKt.isLocalOrigin$default(request, false, false, 3, null) ? OriginCheckResult.ALLOW : OriginCheckResult.FORBID;
    }

    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return request.method() == HttpMethod.GET || request.method() == HttpMethod.HEAD;
    }

    public abstract boolean process(@NotNull QueryStringDecoder var1, @NotNull FullHttpRequest var2, @NotNull ChannelHandlerContext var3) throws IOException;

    protected final boolean sendData(@NotNull byte[] content, @NotNull String name, @NotNull FullHttpRequest request, @NotNull Channel channel, @NotNull HttpHeaders extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)extraHeaders, (String)"extraHeaders");
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)FileResponses.INSTANCE.getContentType(name));
        Responses.addCommonHeaders((HttpResponse)response);
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"private, must-revalidate");
        HttpHeaders httpHeaders = response.headers();
        CharSequence charSequence = (CharSequence)HttpHeaderNames.LAST_MODIFIED;
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"Calendar.getInstance()");
        httpHeaders.set(charSequence, (Object)new Date(calendar.getTimeInMillis()));
        response.headers().add(extraHeaders);
        boolean keepAlive = Responses.addKeepAliveIfNeeded((HttpResponse)response, (HttpRequest)request);
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)content.length);
        }
        channel.write((Object)response);
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
            ByteArrayInputStream stream = new ByteArrayInputStream(content);
            channel.write((Object)new ChunkedStream((InputStream)stream));
            stream.close();
        }
        ChannelFuture future = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!keepAlive) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        return true;
    }

    static {
        Companion = new Companion(null);
        EP_NAME = new ExtensionPointName("com.intellij.httpRequestHandler");
    }

    @JvmStatic
    public static final boolean checkPrefix(@NotNull String uri, @NotNull String prefix) {
        return Companion.checkPrefix(uri, prefix);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/ide/HttpRequestHandler$OriginCheckResult;", "", "(Ljava/lang/String;I)V", "ALLOW", "FORBID", "ASK_CONFIRMATION", "intellij.platform.ide.util.io"})
    public static final class OriginCheckResult
    extends Enum<OriginCheckResult> {
        public static final /* enum */ OriginCheckResult ALLOW;
        public static final /* enum */ OriginCheckResult FORBID;
        public static final /* enum */ OriginCheckResult ASK_CONFIRMATION;
        private static final /* synthetic */ OriginCheckResult[] $VALUES;

        static {
            OriginCheckResult[] originCheckResultArray = new OriginCheckResult[3];
            OriginCheckResult[] originCheckResultArray2 = originCheckResultArray;
            originCheckResultArray[0] = ALLOW = new OriginCheckResult();
            originCheckResultArray[1] = FORBID = new OriginCheckResult();
            originCheckResultArray[2] = ASK_CONFIRMATION = new OriginCheckResult();
            $VALUES = originCheckResultArray;
        }

        public static OriginCheckResult[] values() {
            return (OriginCheckResult[])$VALUES.clone();
        }

        public static OriginCheckResult valueOf(String string) {
            return Enum.valueOf(OriginCheckResult.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/ide/HttpRequestHandler$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lorg/jetbrains/ide/HttpRequestHandler;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "checkPrefix", "", "uri", "", "prefix", "intellij.platform.ide.util.io"})
    public static final class Companion {
        @NotNull
        public final ExtensionPointName<HttpRequestHandler> getEP_NAME() {
            return EP_NAME;
        }

        @JvmStatic
        public final boolean checkPrefix(@NotNull String uri, @NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            if (uri.length() > prefix.length() && uri.charAt(0) == '/' && StringsKt.regionMatches((String)uri, (int)1, (String)prefix, (int)0, (int)prefix.length(), (boolean)true)) {
                if (uri.length() - prefix.length() == 1) {
                    return true;
                }
                char c = uri.charAt(prefix.length() + 1);
                return c == '/' || c == '?';
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

