/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.XCollection;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractCollectionBinding
extends NotNullDeserializeBinding
implements MultiNodeBinding,
NestedBinding {
    private final MutableAccessor myAccessor;
    private List<Binding> itemBindings;
    protected final Class<?> itemType;
    @Nullable
    private final AbstractCollection annotation;
    @Nullable
    protected final XCollection newAnnotation;
    private Serializer serializer;

    AbstractCollectionBinding(@NotNull Class elementType, @Nullable MutableAccessor accessor) {
        if (elementType == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(0);
        }
        this.myAccessor = accessor;
        this.itemType = elementType;
        XCollection xCollection = this.newAnnotation = accessor == null ? null : accessor.getAnnotation(XCollection.class);
        this.annotation = this.newAnnotation == null ? (accessor == null ? null : accessor.getAnnotation(AbstractCollection.class)) : null;
    }

    @Override
    @NotNull
    public MutableAccessor getAccessor() {
        MutableAccessor mutableAccessor = this.myAccessor;
        if (mutableAccessor == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(1);
        }
        return mutableAccessor;
    }

    protected boolean isSortOrderedSet() {
        return this.annotation == null || this.annotation.sortOrderedSet();
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    @Override
    public void init(@NotNull Type originalType, @NotNull Serializer serializer) {
        if (originalType == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(2);
        }
        if (serializer == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(3);
        }
        this.serializer = serializer;
    }

    private boolean isSurroundWithTag() {
        return this.newAnnotation == null && (this.annotation == null || this.annotation.surroundWithTag());
    }

    @NotNull
    private @NotNull Class<?> @NotNull [] getElementTypes() {
        if (this.newAnnotation != null) {
            Class<?>[] classArray = this.newAnnotation.elementTypes();
            if (classArray == null) {
                AbstractCollectionBinding.$$$reportNull$$$0(4);
            }
            return classArray;
        }
        Class[] classArray = this.annotation == null ? ArrayUtil.EMPTY_CLASS_ARRAY : this.annotation.elementTypes();
        if (classArray == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(5);
        }
        return classArray;
    }

    @Nullable
    private Binding getItemBinding(@NotNull Class<?> aClass) {
        if (aClass == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(6);
        }
        return ClassUtil.isPrimitive(aClass) ? null : this.serializer.getRootBinding(aClass, aClass);
    }

    @NotNull
    private synchronized List<Binding> getItemBindings() {
        if (this.itemBindings == null) {
            Binding binding = this.getItemBinding(this.itemType);
            Class<?>[] elementTypes = this.getElementTypes();
            if (elementTypes.length == 0) {
                this.itemBindings = binding == null ? Collections.emptyList() : Collections.singletonList(binding);
            } else {
                this.itemBindings = new SmartList<Binding>();
                if (binding != null) {
                    this.itemBindings.add(binding);
                }
                for (Class<?> aClass : elementTypes) {
                    Binding b = this.getItemBinding(aClass);
                    if (b == null || this.itemBindings.contains(b)) continue;
                    this.itemBindings.add(b);
                }
                if (this.itemBindings.isEmpty()) {
                    this.itemBindings = Collections.emptyList();
                }
            }
        }
        List<Binding> list = this.itemBindings;
        if (list == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    private Binding getElementBinding(@NotNull Element element) {
        if (element == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(8);
        }
        for (Binding binding : this.getItemBindings()) {
            if (!binding.isBoundTo(element)) continue;
            return binding;
        }
        return null;
    }

    @NotNull
    abstract Collection<?> getIterable(@NotNull Object var1);

    @Override
    @Nullable
    public Object serialize(@NotNull Object object, @Nullable Object context, @Nullable SerializationFilter filter2) {
        String tagName;
        if (object == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(9);
        }
        Collection<?> collection = this.getIterable(object);
        String string = tagName = this.isSurroundWithTag() ? this.getCollectionTagName(object) : null;
        if (tagName == null) {
            SmartList result = new SmartList();
            if (!collection.isEmpty()) {
                for (Object item : collection) {
                    ContainerUtil.addAllNotNull(result, this.serializeItem(item, result, filter2));
                }
            }
            return result;
        }
        Element result = new Element(tagName);
        if (!collection.isEmpty()) {
            for (Object item : collection) {
                Content child = (Content)this.serializeItem(item, result, filter2);
                if (child == null) continue;
                result.addContent(child);
            }
        }
        return result;
    }

    @Override
    @NotNull
    public Object deserialize(@Nullable Object context, @NotNull Element element) {
        if (element == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(10);
        }
        if (!this.isSurroundWithTag()) {
            Object object = this.doDeserializeList(context, Collections.singletonList(element));
            if (object == null) {
                AbstractCollectionBinding.$$$reportNull$$$0(11);
            }
            return object;
        }
        Object object = this.doDeserializeList(context, element.getChildren());
        if (object == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(12);
        }
        return object;
    }

    @Override
    @Nullable
    public Object deserializeList(@Nullable Object context, @NotNull List<? extends Element> elements) {
        if (elements == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(13);
        }
        if (!this.isSurroundWithTag()) {
            return this.doDeserializeList(context, elements);
        }
        assert (elements.size() == 1);
        Element element = elements.get(0);
        return this.doDeserializeList(context == null && element.getName().equals("set") ? new HashSet() : context, element.getChildren());
    }

    @NotNull
    protected abstract Object doDeserializeList(@Nullable Object var1, @NotNull List<? extends Element> var2);

    @Nullable
    private Object serializeItem(@Nullable Object value, Object context, @Nullable SerializationFilter filter2) {
        if (value == null) {
            LOG.warn("Collection " + this.myAccessor + " contains 'null' object");
            return null;
        }
        Binding binding = this.getItemBinding(value.getClass());
        if (binding == null) {
            String elementName = this.getElementName();
            if (StringUtil.isEmpty(elementName)) {
                throw new Error("elementName must be not empty");
            }
            Element serializedItem = new Element(elementName);
            String attributeName = this.getValueAttributeName();
            String serialized = XmlSerializerImpl.convertToString(value);
            if (attributeName.isEmpty()) {
                if (!serialized.isEmpty()) {
                    serializedItem.addContent((Content)new Text(serialized));
                }
            } else {
                serializedItem.setAttribute(attributeName, JDOMUtil.removeControlChars(serialized));
            }
            return serializedItem;
        }
        return binding.serialize(value, context, filter2);
    }

    protected final Object deserializeItem(@NotNull Element node, @Nullable Object context) {
        Binding binding;
        if (node == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(14);
        }
        if ((binding = this.getElementBinding(node)) == null) {
            String attributeName = this.getValueAttributeName();
            String value = attributeName.isEmpty() ? XmlSerializerImpl.getTextValue(node, "") : node.getAttributeValue(attributeName);
            return XmlSerializerImpl.convert(value, this.itemType);
        }
        return binding.deserializeUnsafe(context, node);
    }

    @NotNull
    private String getElementName() {
        if (this.newAnnotation != null) {
            String string = this.newAnnotation.elementName();
            if (string == null) {
                AbstractCollectionBinding.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = this.annotation == null ? "option" : this.annotation.elementTag();
        if (string == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private String getValueAttributeName() {
        if (this.newAnnotation != null) {
            String string = this.newAnnotation.valueAttributeName();
            if (string == null) {
                AbstractCollectionBinding.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = this.annotation == null ? "value" : this.annotation.elementValueAttribute();
        if (string == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(19);
        }
        if (this.isSurroundWithTag()) {
            return element.getName().equals(this.getCollectionTagName(null));
        }
        if (this.getItemBindings().isEmpty()) {
            return element.getName().equals(this.getElementName());
        }
        return this.getElementBinding(element) != null;
    }

    @NotNull
    protected abstract String getCollectionTagName(@Nullable Object var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/AbstractCollectionBinding";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/AbstractCollectionBinding";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemBindings";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAttributeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getItemBinding";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementBinding";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deserializeItem";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

