/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.JarLoader;
import com.intellij.util.lang.JarMemoryLoader;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.MemoryResource;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.ResourceFile;
import com.intellij.util.lang.SecureJarLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class JdkZipResourceFile
implements ResourceFile {
    private final SoftReference<JarMemoryLoader> memoryLoader;
    private volatile SoftReference<ZipFile> zipFileSoftReference;
    private final boolean lockJars;
    private final File file;
    private final boolean isSecureLoader;
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdkZipResourceFile(@NotNull Path path, boolean lockJars, boolean preloadJarContents, boolean isSecureLoader) throws IOException {
        if (path == null) {
            JdkZipResourceFile.$$$reportNull$$$0(0);
        }
        this.lockJars = lockJars;
        this.file = path.toFile();
        this.isSecureLoader = isSecureLoader;
        SoftReference<JarMemoryLoader> memoryLoader = null;
        if (preloadJarContents) {
            try {
                JarMemoryLoader loader = this.preload(path);
                if (loader != null) {
                    memoryLoader = new SoftReference<JarMemoryLoader>(loader);
                }
            }
            finally {
                if (!lockJars) {
                    this.close();
                }
            }
        }
        this.memoryLoader = memoryLoader;
    }

    private static byte @NotNull [] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        int n;
        if (stream == null) {
            JdkZipResourceFile.$$$reportNull$$$0(1);
        }
        byte[] bytes = new byte[length];
        for (int count = 0; count < length && (n = stream.read(bytes, count, length - count)) > 0; count += n) {
        }
        if (bytes == null) {
            JdkZipResourceFile.$$$reportNull$$$0(2);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    ZipFile getZipFile() throws IOException {
        ZipFile zipFile;
        if (!this.lockJars) {
            ZipFile zipFile2 = this.createZipFile(this.file);
            if (zipFile2 == null) {
                JdkZipResourceFile.$$$reportNull$$$0(3);
            }
            return zipFile2;
        }
        SoftReference<ZipFile> ref = this.zipFileSoftReference;
        ZipFile zipFile3 = zipFile = ref == null ? null : ref.get();
        if (zipFile != null) {
            ZipFile zipFile4 = zipFile;
            if (zipFile4 == null) {
                JdkZipResourceFile.$$$reportNull$$$0(4);
            }
            return zipFile4;
        }
        Object object = lock;
        synchronized (object) {
            ref = this.zipFileSoftReference;
            ZipFile zipFile5 = zipFile = ref == null ? null : ref.get();
            if (zipFile != null) {
                ZipFile zipFile6 = zipFile;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl19 : MonitorExitStatement: MONITOREXIT : var3_3
                if (zipFile6 == null) {
                    JdkZipResourceFile.$$$reportNull$$$0(5);
                }
                return zipFile6;
            }
            zipFile = this.createZipFile(this.file);
            this.zipFileSoftReference = new SoftReference<ZipFile>(zipFile);
        }
        ZipFile zipFile7 = zipFile;
        if (zipFile7 == null) {
            JdkZipResourceFile.$$$reportNull$$$0(6);
        }
        return zipFile7;
    }

    private ZipFile createZipFile(@NotNull File file) throws IOException {
        if (file == null) {
            JdkZipResourceFile.$$$reportNull$$$0(7);
        }
        return this.isSecureLoader ? new JarFile(file) : new ZipFile(file);
    }

    public void close() throws IOException {
        ZipFile zipFile;
        SoftReference<ZipFile> ref = this.zipFileSoftReference;
        ZipFile zipFile2 = zipFile = ref == null ? null : ref.get();
        if (zipFile != null) {
            this.zipFileSoftReference = null;
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Class<?> findClass(@NotNull String fileName, String className, JarLoader jarLoader, ClassPath.ClassDataConsumer classConsumer) throws IOException {
        byte[] bytes;
        byte[] data;
        JarMemoryLoader memoryLoader;
        if (fileName == null) {
            JdkZipResourceFile.$$$reportNull$$$0(8);
        }
        JarMemoryLoader jarMemoryLoader = memoryLoader = this.memoryLoader == null ? null : this.memoryLoader.get();
        if (memoryLoader != null && (data = memoryLoader.getBytes(fileName)) != null) {
            return classConsumer.consumeClassData(className, data, (Loader)jarLoader, null);
        }
        ZipFile zipFile = this.getZipFile();
        ZipEntry entry = zipFile.getEntry(fileName);
        if (entry == null) {
            return null;
        }
        try (InputStream stream = zipFile.getInputStream(entry);){
            bytes = JdkZipResourceFile.loadBytes(stream, (int)entry.getSize());
        }
        finally {
            if (!this.lockJars) {
                this.close();
            }
        }
        ProtectionDomain protectionDomain = jarLoader instanceof SecureJarLoader ? ((SecureJarLoader)jarLoader).getProtectionDomain((JarEntry)entry, new URL(jarLoader.url, entry.getName())) : null;
        return classConsumer.consumeClassData(className, bytes, (Loader)jarLoader, protectionDomain);
    }

    @Override
    public void processResources(@NotNull String dir, @NotNull Predicate<? super String> filter2, @NotNull BiConsumer<? super String, ? super InputStream> consumer) {
        if (dir == null) {
            JdkZipResourceFile.$$$reportNull$$$0(9);
        }
        if (filter2 == null) {
            JdkZipResourceFile.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            JdkZipResourceFile.$$$reportNull$$$0(11);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Resource getResource(@NotNull String name, @NotNull JarLoader jarLoader) throws IOException {
        Resource resource;
        JarMemoryLoader loader;
        if (name == null) {
            JdkZipResourceFile.$$$reportNull$$$0(12);
        }
        if (jarLoader == null) {
            JdkZipResourceFile.$$$reportNull$$$0(13);
        }
        JarMemoryLoader jarMemoryLoader = loader = this.memoryLoader == null ? null : this.memoryLoader.get();
        if (loader != null && (resource = loader.getResource(name)) != null) {
            return resource;
        }
        try {
            ZipEntry entry = this.getZipFile().getEntry(name);
            if (entry == null) {
                Resource resource2 = null;
                return resource2;
            }
            if (this.isSecureLoader) {
                SecureJarResource secureJarResource = new SecureJarResource(jarLoader.url, (JarEntry)entry, (SecureJarLoader)jarLoader);
                return secureJarResource;
            }
            ZipFileResource zipFileResource = new ZipFileResource(jarLoader.url, entry, this);
            return zipFileResource;
        }
        finally {
            if (!this.lockJars) {
                this.close();
            }
        }
    }

    @Nullable
    public JarMemoryLoader preload(@NotNull Path basePath) throws IOException {
        ZipFile zipFile;
        Enumeration<? extends ZipEntry> entries;
        if (basePath == null) {
            JdkZipResourceFile.$$$reportNull$$$0(14);
        }
        if (!(entries = (zipFile = this.getZipFile()).entries()).hasMoreElements()) {
            return null;
        }
        ZipEntry sizeEntry = entries.nextElement();
        if (sizeEntry == null || !sizeEntry.getName().equals("META-INF/jb/$$size$$")) {
            return null;
        }
        byte[] bytes = JdkZipResourceFile.loadBytes(zipFile.getInputStream(sizeEntry), 2);
        int size = ((bytes[1] & 0xFF) << 8) + (bytes[0] & 0xFF);
        Object[] table = new Object[size * 4 + 1 & 0xFFFFFFFE];
        String baseUrl = JarLoader.fileToUri(basePath).toString();
        for (int i = 0; i < size && entries.hasMoreElements(); ++i) {
            byte[] content;
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            int index = JarMemoryLoader.probePlain(name, table);
            if (index >= 0) {
                throw new IllegalArgumentException("duplicate name: " + name);
            }
            try (InputStream stream = zipFile.getInputStream(entry);){
                content = JdkZipResourceFile.loadBytes(stream, (int)entry.getSize());
            }
            int dest = -(index + 1);
            table[dest] = name;
            table[dest + 1] = new MemoryResource(baseUrl, content, name);
        }
        return new JarMemoryLoader(table);
    }

    @Override
    @Nullable
    public Attributes loadManifestAttributes() throws IOException {
        Attributes attributes;
        block9: {
            ZipFile zipFile = this.getZipFile();
            ZipEntry entry = zipFile.getEntry("META-INF/MANIFEST.MF");
            if (entry == null) {
                return null;
            }
            InputStream stream = zipFile.getInputStream(entry);
            try {
                attributes = new Manifest(stream).getMainAttributes();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            stream.close();
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ClasspathCache.IndexRegistrar buildClassPathCacheData() throws IOException {
        ClasspathCache.LoaderDataBuilder builder = new ClasspathCache.LoaderDataBuilder(true);
        Enumeration<? extends ZipEntry> entries = this.getZipFile().entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.endsWith(".class")) {
                builder.addClassPackageFromName(name);
                builder.andClassName(name);
                continue;
            }
            builder.addResourcePackageFromName(name);
            builder.addResourceName(name, name.endsWith("/") ? name.length() - 1 : name.length());
        }
        ClasspathCache.LoaderDataBuilder loaderDataBuilder = builder;
        ClasspathCache.LoaderDataBuilder loaderDataBuilder2 = loaderDataBuilder;
        if (loaderDataBuilder2 == null) {
            JdkZipResourceFile.$$$reportNull$$$0(15);
        }
        return loaderDataBuilder2;
        finally {
            if (!this.lockJars) {
                this.close();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/JdkZipResourceFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarLoader";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/JdkZipResourceFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBytes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getZipFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildClassPathCacheData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadBytes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createZipFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getResource";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "preload";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SecureJarResource
    extends ZipFileResource {
        SecureJarResource(@NotNull URL baseUrl, @NotNull JarEntry entry, @NotNull SecureJarLoader jarLoader) {
            if (baseUrl == null) {
                SecureJarResource.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                SecureJarResource.$$$reportNull$$$0(1);
            }
            if (jarLoader == null) {
                SecureJarResource.$$$reportNull$$$0(2);
            }
            super(baseUrl, entry, (JdkZipResourceFile)jarLoader.zipFile);
        }

        /*
         * Loose catch block
         */
        @Override
        public byte @NotNull [] getBytes() throws IOException {
            byte[] byArray;
            InputStream stream;
            block11: {
                block10: {
                    stream = this.file.getZipFile().getInputStream(this.entry);
                    byArray = JdkZipResourceFile.loadBytes(stream, (int)this.entry.getSize());
                    if (stream == null) break block10;
                    stream.close();
                }
                if (byArray != null) break block11;
                SecureJarResource.$$$reportNull$$$0(3);
            }
            return byArray;
            {
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            finally {
                if (!this.file.lockJars) {
                    this.file.close();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseUrl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jarLoader";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/lang/JdkZipResourceFile$SecureJarResource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/lang/JdkZipResourceFile$SecureJarResource";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBytes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ZipFileResource
    implements Resource {
        protected final URL baseUrl;
        private URL url;
        protected final ZipEntry entry;
        protected final JdkZipResourceFile file;

        private ZipFileResource(@NotNull URL baseUrl, @NotNull ZipEntry entry, @NotNull JdkZipResourceFile file) {
            if (baseUrl == null) {
                ZipFileResource.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                ZipFileResource.$$$reportNull$$$0(1);
            }
            if (file == null) {
                ZipFileResource.$$$reportNull$$$0(2);
            }
            this.baseUrl = baseUrl;
            this.entry = entry;
            this.file = file;
        }

        public String toString() {
            return this.url.toString();
        }

        @Override
        @NotNull
        public URL getURL() {
            URL result = this.url;
            if (result == null) {
                try {
                    result = new URL(this.baseUrl, this.entry.getName());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                this.url = result;
            }
            URL uRL = result;
            if (uRL == null) {
                ZipFileResource.$$$reportNull$$$0(3);
            }
            return uRL;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.getBytes());
        }

        /*
         * Loose catch block
         */
        @Override
        public byte @NotNull [] getBytes() throws IOException {
            byte[] byArray;
            InputStream stream;
            block11: {
                block10: {
                    stream = this.file.getZipFile().getInputStream(this.entry);
                    byArray = JdkZipResourceFile.loadBytes(stream, (int)this.entry.getSize());
                    if (stream == null) break block10;
                    stream.close();
                }
                if (byArray != null) break block11;
                ZipFileResource.$$$reportNull$$$0(4);
            }
            return byArray;
            {
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            finally {
                if (!this.file.lockJars) {
                    this.file.close();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseUrl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/lang/JdkZipResourceFile$ZipFileResource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/lang/JdkZipResourceFile$ZipFileResource";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getURL";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBytes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

