/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.MemoryResource;
import com.intellij.util.lang.Resource;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.NotNull;

public final class JarMemoryLoader {
    public static final String SIZE_ENTRY = "META-INF/jb/$$size$$";
    private final AtomicReferenceArray<Object> resources;

    JarMemoryLoader(Object @NotNull [] resources) {
        if (resources == null) {
            JarMemoryLoader.$$$reportNull$$$0(0);
        }
        this.resources = new AtomicReferenceArray<Object>(resources);
    }

    public Resource getResource(@NotNull String entryName) {
        int i;
        if (entryName == null) {
            JarMemoryLoader.$$$reportNull$$$0(1);
        }
        if ((i = JarMemoryLoader.probe(entryName, this.resources)) >= 0) {
            this.resources.set(i, null);
            return this.resources.getAndSet(i + 1, null);
        }
        return null;
    }

    public byte[] getBytes(@NotNull String entryName) throws IOException {
        int i;
        if (entryName == null) {
            JarMemoryLoader.$$$reportNull$$$0(2);
        }
        if ((i = JarMemoryLoader.probe(entryName, this.resources)) >= 0) {
            this.resources.set(i, null);
            MemoryResource resource = this.resources.getAndSet(i + 1, null);
            return resource == null ? null : resource.getBytes();
        }
        return null;
    }

    private static int probe(Object key, AtomicReferenceArray<Object> table) {
        int length = table.length();
        int index = Math.floorMod(key.hashCode(), length >> 1) << 1;
        Object foundKey;
        while ((foundKey = table.get(index)) != null) {
            if (key.equals(foundKey)) {
                return index;
            }
            if ((index += 2) != length) continue;
            index = 0;
        }
        return -index - 1;
    }

    public static int probePlain(Object key, Object[] table) {
        int index = Math.floorMod(key.hashCode(), table.length >> 1) << 1;
        Object foundKey;
        while ((foundKey = table[index]) != null) {
            if (key.equals(foundKey)) {
                return index;
            }
            if ((index += 2) != table.length) continue;
            index = 0;
        }
        return -index - 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/lang/JarMemoryLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getResource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getBytes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

