/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.util.lang.CachePoolImpl;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.FileLoader;
import com.intellij.util.lang.JarLoader;
import com.intellij.util.lang.JdkZipResourceFile;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.ResourceFile;
import com.intellij.util.lang.SecureJarLoader;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.ProtectionDomain;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ClassPath {
    static final String CLASS_EXTENSION = ".class";
    public static final String CLASSPATH_JAR_FILE_NAME_PREFIX = "classpath";
    static final boolean recordLoadingInfo = Boolean.getBoolean("idea.record.classpath.info");
    static final boolean recordLoadingTime = recordLoadingInfo || Boolean.getBoolean("idea.record.classloading.stats");
    static final boolean logLoadingInfo = Boolean.getBoolean("idea.log.classpath.info");
    private static final Collection<Map.Entry<String, Path>> loadedClasses;
    private static final Measurer classLoading;
    private static final Measurer resourceLoading;
    private static final AtomicLong classDefineTotalTime;
    private final List<Path> files;
    @Nullable
    private final ResourceFileFactory resourceFileFactory;
    private final List<Loader> loaders;
    private volatile boolean allUrlsWereProcessed;
    private final AtomicInteger lastLoaderProcessed;
    private final Map<Path, Loader> loaderMap;
    private final ClasspathCache cache;
    private final Set<Path> filesWithProtectionDomain;
    final boolean lockJars;
    private final boolean useCache;
    final boolean preloadJarContents;
    final boolean isClassPathIndexEnabled;
    @Nullable
    private final CachePoolImpl cachePool;
    @Nullable
    private final Predicate<? super Path> cachingCondition;
    final boolean errorOnMissingJar;
    @NotNull
    private final ClassDataConsumer classDataConsumer;

    @Nullable
    public ResourceFileFactory getResourceFileFactory() {
        return this.resourceFileFactory;
    }

    ClassPath(@NotNull List<Path> files, @NotNull Set<Path> filesWithProtectionDomain, @NotNull UrlClassLoader.Builder configuration, @Nullable ResourceFileFactory resourceFileFactory, @NotNull ClassDataConsumer classDataConsumer) {
        if (files == null) {
            ClassPath.$$$reportNull$$$0(0);
        }
        if (filesWithProtectionDomain == null) {
            ClassPath.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            ClassPath.$$$reportNull$$$0(2);
        }
        if (classDataConsumer == null) {
            ClassPath.$$$reportNull$$$0(3);
        }
        this.loaders = new ArrayList<Loader>();
        this.lastLoaderProcessed = new AtomicInteger();
        this.loaderMap = new HashMap<Path, Loader>();
        this.cache = new ClasspathCache();
        this.lockJars = configuration.lockJars;
        this.useCache = configuration.useCache;
        this.preloadJarContents = configuration.preloadJarContents;
        this.cachePool = configuration.cachePool;
        this.cachingCondition = configuration.cachingCondition;
        this.isClassPathIndexEnabled = configuration.isClassPathIndexEnabled;
        this.errorOnMissingJar = configuration.errorOnMissingJar;
        this.filesWithProtectionDomain = filesWithProtectionDomain;
        this.classDataConsumer = recordLoadingTime ? new MeasuringClassDataConsumer(classDataConsumer) : classDataConsumer;
        this.files = new ArrayList<Path>(files.size());
        this.resourceFileFactory = resourceFileFactory;
        if (!files.isEmpty()) {
            for (int i = files.size() - 1; i >= 0; --i) {
                this.files.add(files.get(i));
            }
        }
    }

    public synchronized void reset(@NotNull List<? extends Path> paths) {
        if (paths == null) {
            ClassPath.$$$reportNull$$$0(4);
        }
        this.lastLoaderProcessed.set(0);
        this.allUrlsWereProcessed = false;
        this.loaders.clear();
        this.loaderMap.clear();
        this.cache.clearCache();
        this.addFiles(paths);
    }

    @NotNull
    public static Collection<Map.Entry<String, Path>> getLoadedClasses() {
        return new ArrayList<Map.Entry<String, Path>>(loadedClasses);
    }

    @NotNull
    public static Map<String, Long> getLoadingStats() {
        HashMap<String, Long> result = new HashMap<String, Long>(5);
        result.put("classLoadingTime", classLoading.timeCounter.get());
        result.put("classDefineTime", classDefineTotalTime.get());
        result.put("classRequests", Long.valueOf(classLoading.requestCounter.get()));
        result.put("resourceLoadingTime", resourceLoading.timeCounter.get());
        result.put("resourceRequests", Long.valueOf(resourceLoading.requestCounter.get()));
        result.put("identity", Long.valueOf(ClassPath.class.hashCode()));
        HashMap<String, Long> hashMap = result;
        if (hashMap == null) {
            ClassPath.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    @ApiStatus.Internal
    synchronized void addFiles(@NotNull List<? extends Path> files) {
        if (files == null) {
            ClassPath.$$$reportNull$$$0(6);
        }
        for (int i = files.size() - 1; i >= 0; --i) {
            this.files.add(files.get(i));
        }
        this.allUrlsWereProcessed = false;
    }

    public synchronized void appendFiles(@NotNull List<? extends Path> newList) {
        if (newList == null) {
            ClassPath.$$$reportNull$$$0(7);
        }
        HashSet<Path> existing = new HashSet<Path>(this.files);
        for (int i = newList.size() - 1; i >= 0; --i) {
            Path file = newList.get(i);
            if (existing.contains(file)) continue;
            this.files.add(file);
        }
        this.allUrlsWereProcessed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Class<?> findClass(@NotNull String className) throws IOException {
        if (className == null) {
            ClassPath.$$$reportNull$$$0(8);
        }
        long start = classLoading.startTiming();
        try {
            Loader loader;
            int i;
            String fileName = className.replace('.', '/') + CLASS_EXTENSION;
            if (this.useCache) {
                Loader[] loaders = this.cache.getClassLoadersByName(fileName);
                if (loaders != null) {
                    for (Loader loader2 : loaders) {
                        Class<?> result;
                        if (!loader2.containsName(fileName) || (result = ClassPath.findClassInLoader(fileName, className, this.classDataConsumer, loader2)) == null) continue;
                        Class<?> clazz = result;
                        return clazz;
                    }
                }
                if (this.allUrlsWereProcessed) {
                    Loader[] loaderArray = null;
                    return loaderArray;
                }
                i = this.lastLoaderProcessed.get();
            } else {
                i = 0;
            }
            while ((loader = this.getLoader(i++)) != null) {
                if (this.useCache && !loader.containsName(fileName)) continue;
                Class<?> result = ClassPath.findClassInLoader(fileName, className, this.classDataConsumer, loader);
                if (result == null) continue;
                Class<?> clazz = result;
                return clazz;
            }
        }
        finally {
            classLoading.record(start, className);
        }
        return null;
    }

    @Nullable
    private static Class<?> findClassInLoader(@NotNull String fileName, @NotNull String className, @NotNull ClassDataConsumer classConsumer, @NotNull Loader loader) throws IOException {
        Class<?> result;
        if (fileName == null) {
            ClassPath.$$$reportNull$$$0(9);
        }
        if (className == null) {
            ClassPath.$$$reportNull$$$0(10);
        }
        if (classConsumer == null) {
            ClassPath.$$$reportNull$$$0(11);
        }
        if (loader == null) {
            ClassPath.$$$reportNull$$$0(12);
        }
        if ((result = loader.findClass(fileName, className, classConsumer)) == null) {
            return null;
        }
        if (loadedClasses != null) {
            loadedClasses.add(new AbstractMap.SimpleImmutableEntry<String, Path>(fileName, loader.path));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Resource findResource(@NotNull String resourceName) {
        if (resourceName == null) {
            ClassPath.$$$reportNull$$$0(13);
        }
        long start = resourceLoading.startTiming();
        try {
            Loader loader;
            int i;
            if (this.useCache) {
                Loader[] loaders = this.cache.getLoadersByName(resourceName);
                if (loaders != null) {
                    for (Loader loader2 : loaders) {
                        Resource resource;
                        if (!loader2.containsName(resourceName) || (resource = loader2.getResource(resourceName)) == null) continue;
                        if (loadedClasses != null) {
                            loadedClasses.add(new AbstractMap.SimpleImmutableEntry<String, Path>(resourceName, loader2.path));
                        }
                        Resource resource2 = resource;
                        return resource2;
                    }
                }
                if (this.allUrlsWereProcessed) {
                    Loader[] loaderArray = null;
                    return loaderArray;
                }
                i = this.lastLoaderProcessed.get();
            } else {
                i = 0;
            }
            while ((loader = this.getLoader(i++)) != null) {
                if (this.useCache && !loader.containsName(resourceName)) continue;
                Resource resource = loader.getResource(resourceName);
                if (resource == null) continue;
                if (loadedClasses != null) {
                    loadedClasses.add(new AbstractMap.SimpleImmutableEntry<String, Path>(resourceName, loader.path));
                }
                Resource resource3 = resource;
                return resource3;
            }
        }
        finally {
            resourceLoading.record(start, resourceName);
        }
        return null;
    }

    @NotNull
    public Enumeration<URL> getResources(@NotNull String name) {
        if (name == null) {
            ClassPath.$$$reportNull$$$0(14);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if (this.useCache && this.allUrlsWereProcessed) {
            Loader[] loaders = this.cache.getLoadersByName(name);
            return loaders == null || loaders.length == 0 ? Collections.emptyEnumeration() : new ResourceEnumeration(name, loaders);
        }
        return new UncachedResourceEnumeration(name, this);
    }

    void processResources(@NotNull String dir, @NotNull Predicate<? super String> fileNameFilter, @NotNull BiConsumer<? super String, ? super InputStream> consumer) throws IOException {
        block6: {
            Loader loader;
            block5: {
                if (dir == null) {
                    ClassPath.$$$reportNull$$$0(15);
                }
                if (fileNameFilter == null) {
                    ClassPath.$$$reportNull$$$0(16);
                }
                if (consumer == null) {
                    ClassPath.$$$reportNull$$$0(17);
                }
                if (!this.useCache || !this.allUrlsWereProcessed) break block5;
                Loader[] loaders = this.cache.getLoadersByName(dir + '/');
                if (loaders == null) break block6;
                for (Loader loader2 : loaders) {
                    loader2.processResources(dir, fileNameFilter, consumer);
                }
                break block6;
            }
            int index = 0;
            while ((loader = this.getLoader(index++)) != null) {
                loader.processResources(dir, fileNameFilter, consumer);
            }
        }
    }

    @Nullable
    private Loader getLoader(int i) {
        return i < this.lastLoaderProcessed.get() ? this.loaders.get(i) : this.getLoaderSlowPath(i);
    }

    @Nullable
    private synchronized Loader getLoaderSlowPath(int i) {
        while (this.loaders.size() < i + 1) {
            int size = this.files.size();
            if (size == 0) {
                if (this.useCache) {
                    this.allUrlsWereProcessed = true;
                }
                return null;
            }
            Path path = this.files.remove(size - 1);
            if (this.loaderMap.containsKey(path)) continue;
            try {
                Loader loader = this.createLoader(path);
                if (loader == null) continue;
                if (this.useCache) {
                    this.initLoaderCache(path, loader);
                }
                this.loaders.add(loader);
                this.loaderMap.put(path, loader);
                this.lastLoaderProcessed.incrementAndGet();
            }
            catch (IOException e) {
                LoggerRt.getInstance(ClassPath.class).info("path: " + path, e);
            }
        }
        return this.loaders.get(i);
    }

    @NotNull
    public List<Path> getBaseUrls() {
        ArrayList<Path> result = new ArrayList<Path>();
        for (Loader loader : this.loaders) {
            result.add(loader.path);
        }
        ArrayList<Path> arrayList = result;
        if (arrayList == null) {
            ClassPath.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @Nullable
    private Loader createLoader(@NotNull Path file) throws IOException {
        String[] referencedJars;
        JarLoader loader;
        BasicFileAttributes fileAttributes;
        if (file == null) {
            ClassPath.$$$reportNull$$$0(19);
        }
        try {
            fileAttributes = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException ignore) {
            return null;
        }
        if (fileAttributes.isDirectory()) {
            return new FileLoader(file, this.isClassPathIndexEnabled);
        }
        if (!fileAttributes.isRegularFile()) {
            return null;
        }
        if (this.filesWithProtectionDomain.contains(file)) {
            loader = new SecureJarLoader(file, this);
        } else {
            ResourceFile zipFile = this.resourceFileFactory == null ? new JdkZipResourceFile(file, this.lockJars, this.preloadJarContents, false) : this.resourceFileFactory.create(file);
            loader = new JarLoader(file, this, zipFile);
        }
        String filePath = file.toString();
        if (filePath.startsWith(CLASSPATH_JAR_FILE_NAME_PREFIX, filePath.lastIndexOf(File.separatorChar) + 1) && (referencedJars = ClassPath.loadManifestClasspath(loader)) != null) {
            long startReferenced = logLoadingInfo ? System.nanoTime() : 0L;
            ArrayList<Path> urls = new ArrayList<Path>(referencedJars.length);
            for (String referencedJar : referencedJars) {
                try {
                    urls.add(Paths.get(UrlClassLoader.urlToFilePath(referencedJar), new String[0]));
                }
                catch (Exception e) {
                    LoggerRt.getInstance(ClassPath.class).warn("file: " + file + " / " + referencedJar, e);
                }
            }
            this.addFiles(urls);
            if (logLoadingInfo) {
                System.out.println("Loaded all " + referencedJars.length + " files " + (System.nanoTime() - startReferenced) / 1000000L + "ms");
            }
        }
        return loader;
    }

    private void initLoaderCache(@NotNull Path file, @NotNull Loader loader) throws IOException {
        ClasspathCache.IndexRegistrar data;
        if (file == null) {
            ClassPath.$$$reportNull$$$0(20);
        }
        if (loader == null) {
            ClassPath.$$$reportNull$$$0(21);
        }
        ClasspathCache.IndexRegistrar indexRegistrar = data = this.cachePool == null ? null : (ClasspathCache.IndexRegistrar)this.cachePool.loaderIndexCache.get(file);
        if (data == null) {
            data = loader.buildData();
            if (this.cachePool != null && this.cachingCondition != null && this.cachingCondition.test(file)) {
                ClasspathCache.LoaderData loaderData = data instanceof ClasspathCache.LoaderData ? (ClasspathCache.LoaderData)data : ((ClasspathCache.LoaderDataBuilder)data).build();
                this.cachePool.loaderIndexCache.put(file, loaderData);
                data = loaderData;
            }
        }
        this.cache.applyLoaderData(data, loader);
        if (this.files.isEmpty()) {
            this.allUrlsWereProcessed = true;
        }
    }

    Map<Loader.Attribute, String> getManifestData(@NotNull Path file) {
        if (file == null) {
            ClassPath.$$$reportNull$$$0(22);
        }
        return this.useCache && this.cachePool != null ? this.cachePool.getManifestData(file) : null;
    }

    void cacheManifestData(@NotNull Path file, @NotNull Map<Loader.Attribute, String> manifestAttributes) {
        if (file == null) {
            ClassPath.$$$reportNull$$$0(23);
        }
        if (manifestAttributes == null) {
            ClassPath.$$$reportNull$$$0(24);
        }
        if (this.useCache && this.cachePool != null && this.cachingCondition != null && this.cachingCondition.test(file)) {
            this.cachePool.cacheManifestData(file, manifestAttributes);
        }
    }

    private static String @Nullable [] loadManifestClasspath(@NotNull JarLoader loader) {
        if (loader == null) {
            ClassPath.$$$reportNull$$$0(25);
        }
        try {
            String[] urls;
            String classPath = loader.getClassPathManifestAttribute();
            if (classPath != null && (urls = classPath.split(" ")).length > 0 && urls[0].startsWith("file:")) {
                return urls;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        classLoading = new Measurer();
        resourceLoading = new Measurer();
        classDefineTotalTime = new AtomicLong();
        ConcurrentLinkedQueue concurrentLinkedQueue = loadedClasses = recordLoadingInfo ? new ConcurrentLinkedQueue() : null;
        if (logLoadingInfo) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> System.out.println("Classloading requests: " + ClassPath.class.getClassLoader() + ", class=" + classLoading + ", resource=" + resourceLoading), "Shutdown hook for tracing classloading information"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesWithProtectionDomain";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDataConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/ClassPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newList";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classConsumer";
                break;
            }
            case 12: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameFilter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifestAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/ClassPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingStats";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 5: 
            case 18: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findClassInLoader";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findResource";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getResources";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createLoader";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "initLoaderCache";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getManifestData";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "cacheManifestData";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loadManifestClasspath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Measurer {
        private final AtomicLong timeCounter = new AtomicLong();
        private final AtomicInteger requestCounter = new AtomicInteger();
        private final ThreadLocal<Boolean> doingTiming = new ThreadLocal();

        private Measurer() {
        }

        long startTiming() {
            if (!recordLoadingTime || this.doingTiming.get() != null) {
                return -1L;
            }
            this.doingTiming.set(Boolean.TRUE);
            return System.nanoTime();
        }

        void record(long start, String resourceName) {
            if (start == -1L) {
                return;
            }
            this.doingTiming.set(null);
            long time = System.nanoTime() - start;
            long totalTime = this.timeCounter.addAndGet(time);
            int totalRequests = this.requestCounter.incrementAndGet();
            if (logLoadingInfo) {
                if (time > 3000000L) {
                    System.out.println(TimeUnit.NANOSECONDS.toMillis(time) + " ms for " + resourceName);
                }
                if (totalRequests % 10000 == 0) {
                    System.out.println(ClassPath.class.getClassLoader() + ", requests: " + totalRequests + ", time:" + TimeUnit.NANOSECONDS.toMillis(totalTime) + "ms");
                }
            }
        }

        public String toString() {
            return "Measurer(time=" + TimeUnit.NANOSECONDS.toMillis(this.timeCounter.get()) + "ms, requests=" + this.requestCounter + ')';
        }
    }

    private static final class MeasuringClassDataConsumer
    implements ClassDataConsumer {
        private static final ThreadLocal<Boolean> doingClassDefineTiming = new ThreadLocal();
        private final ClassDataConsumer classDataConsumer;

        MeasuringClassDataConsumer(ClassDataConsumer classDataConsumer) {
            this.classDataConsumer = classDataConsumer;
        }

        @Override
        public boolean isByteBufferSupported(String name, @Nullable ProtectionDomain protectionDomain) {
            return this.classDataConsumer.isByteBufferSupported(name, protectionDomain);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> consumeClassData(String name, byte[] data, Loader loader, @Nullable ProtectionDomain protectionDomain) throws IOException {
            long start = MeasuringClassDataConsumer.startTiming();
            try {
                Class<?> clazz = this.classDataConsumer.consumeClassData(name, data, loader, protectionDomain);
                return clazz;
            }
            finally {
                MeasuringClassDataConsumer.record(start);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> consumeClassData(String name, ByteBuffer data, Loader loader, @Nullable ProtectionDomain protectionDomain) throws IOException {
            long start = MeasuringClassDataConsumer.startTiming();
            try {
                Class<?> clazz = this.classDataConsumer.consumeClassData(name, data, loader, protectionDomain);
                return clazz;
            }
            finally {
                MeasuringClassDataConsumer.record(start);
            }
        }

        private static long startTiming() {
            if (doingClassDefineTiming.get() != null) {
                return -1L;
            }
            doingClassDefineTiming.set(Boolean.TRUE);
            return System.nanoTime();
        }

        private static void record(long start) {
            if (start != -1L) {
                doingClassDefineTiming.set(null);
                classDefineTotalTime.addAndGet(System.nanoTime() - start);
            }
        }
    }

    private static final class UncachedResourceEnumeration
    implements Enumeration<URL> {
        private int index;
        private Resource resource;
        private final String name;
        private final ClassPath classPath;

        UncachedResourceEnumeration(@NotNull String name, @NotNull ClassPath classPath) {
            if (name == null) {
                UncachedResourceEnumeration.$$$reportNull$$$0(0);
            }
            if (classPath == null) {
                UncachedResourceEnumeration.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.classPath = classPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean next() {
            if (this.resource != null) {
                return true;
            }
            long start = resourceLoading.startTiming();
            try {
                Loader loader;
                while ((loader = this.classPath.getLoader(this.index++)) != null) {
                    if (this.classPath.useCache && !loader.containsName(this.name)) continue;
                    this.resource = loader.getResource(this.name);
                    if (this.resource == null) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                resourceLoading.record(start, this.name);
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public URL nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            Resource resource = this.resource;
            this.resource = null;
            return resource.getURL();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "classPath";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/lang/ClassPath$UncachedResourceEnumeration";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ResourceEnumeration
    implements Enumeration<URL> {
        private int index;
        private Resource resource;
        private final String name;
        private final Loader[] loaders;

        ResourceEnumeration(@NotNull String name, Loader[] loaders) {
            if (name == null) {
                ResourceEnumeration.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.loaders = loaders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean next() {
            if (this.resource != null) {
                return true;
            }
            long start = resourceLoading.startTiming();
            try {
                while (this.index < this.loaders.length) {
                    Loader loader;
                    if (!(loader = this.loaders[this.index++]).containsName(this.name)) {
                        this.resource = null;
                        continue;
                    }
                    this.resource = loader.getResource(this.name);
                    if (this.resource == null) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                resourceLoading.record(start, this.name);
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public URL nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            Resource resource = this.resource;
            this.resource = null;
            return resource.getURL();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/lang/ClassPath$ResourceEnumeration", "<init>"));
        }
    }

    public static interface ResourceFileFactory {
        public ResourceFile create(Path var1) throws IOException;
    }

    static interface ClassDataConsumer {
        public boolean isByteBufferSupported(String var1, @Nullable ProtectionDomain var2);

        public Class<?> consumeClassData(String var1, byte[] var2, Loader var3, @Nullable ProtectionDomain var4) throws IOException;

        public Class<?> consumeClassData(String var1, ByteBuffer var2, Loader var3, @Nullable ProtectionDomain var4) throws IOException;
    }
}

