/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.io.DirectBufferWrapper;
import com.intellij.util.io.IOStatistics;
import com.intellij.util.io.MappingFailedException;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.system.CpuArch;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class StorageLock {
    private static final Logger LOG = Logger.getInstance(StorageLock.class);
    static final int MAX_PAGES_COUNT = 65535;
    private static final int MAX_LIVE_STORAGES_COUNT = 65535;
    private static final int FILE_INDEX_MASK = -65536;
    private static final int FILE_INDEX_SHIFT = 16;
    private static final int LOWER_LIMIT;
    private static final int UPPER_LIMIT;
    static final int BUFFER_SIZE;
    public final StorageLockContext myDefaultContext;
    private final Int2ObjectMap<PagedFileStorage> myIndex2Storage = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
    private final LinkedHashMap<Integer, DirectBufferWrapper> mySegments;
    private final ReentrantLock mySegmentsAccessLock = new ReentrantLock();
    private final ReentrantLock mySegmentsAllocationLock = new ReentrantLock();
    private final ConcurrentLinkedQueue<DirectBufferWrapper> mySegmentsToRemove = new ConcurrentLinkedQueue();
    private volatile long mySize;
    private volatile long mySizeLimit;
    private volatile int myMappingChangeCount;

    private static long maxDirectMemory() {
        try {
            Class<?> aClass = Class.forName("sun.misc.VM");
            Method maxDirectMemory = aClass.getMethod("maxDirectMemory", new Class[0]);
            return (Long)maxDirectMemory.invoke(null, new Object[0]);
        }
        catch (Throwable aClass) {
            try {
                Class<?> aClass2 = Class.forName("java.nio.Bits");
                Field maxMemory = aClass2.getDeclaredField("maxMemory");
                maxMemory.setAccessible(true);
                return (Long)maxMemory.get(null);
            }
            catch (Throwable throwable) {
                return Runtime.getRuntime().maxMemory();
            }
        }
    }

    public StorageLock() {
        this.myDefaultContext = new StorageLockContext(this, true, false);
        this.mySizeLimit = UPPER_LIMIT;
        this.mySegments = new LinkedHashMap<Integer, DirectBufferWrapper>(10, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, DirectBufferWrapper> eldest) {
                return StorageLock.this.mySize > StorageLock.this.mySizeLimit;
            }

            @Override
            @Nullable
            public DirectBufferWrapper remove(Object key) {
                DirectBufferWrapper wrapper = (DirectBufferWrapper)super.remove(key);
                if (wrapper != null) {
                    ++StorageLock.this.myMappingChangeCount;
                    StorageLock.this.mySegmentsToRemove.offer(wrapper);
                    StorageLock.this.mySize -= wrapper.getLength();
                }
                return wrapper;
            }
        };
    }

    int getMappingChangeCount() {
        return this.myMappingChangeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int registerPagedFileStorage(@NotNull PagedFileStorage storage) {
        if (storage == null) {
            StorageLock.$$$reportNull$$$0(0);
        }
        Int2ObjectMap<PagedFileStorage> int2ObjectMap = this.myIndex2Storage;
        synchronized (int2ObjectMap) {
            int registered = this.myIndex2Storage.size();
            assert (registered <= 65535);
            int value = registered << 16;
            while (this.myIndex2Storage.get(value) != null) {
                assert (++registered <= 65535);
                value = registered << 16;
            }
            this.myIndex2Storage.put(value, (Object)storage);
            return value;
        }
    }

    private PagedFileStorage getRegisteredPagedFileStorageByIndex(int index) {
        return (PagedFileStorage)this.myIndex2Storage.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectBufferWrapper get(Integer key, boolean read, boolean readOnly) {
        DirectBufferWrapper wrapper;
        try {
            this.mySegmentsAccessLock.lock();
            wrapper = this.mySegments.get(key);
            if (wrapper != null) {
                DirectBufferWrapper directBufferWrapper = wrapper;
                return directBufferWrapper;
            }
        }
        finally {
            this.mySegmentsAccessLock.unlock();
        }
        this.mySegmentsAllocationLock.lock();
        try {
            long finished;
            this.mySegmentsAccessLock.lock();
            try {
                wrapper = this.mySegments.get(key);
                if (wrapper != null) {
                    DirectBufferWrapper directBufferWrapper = wrapper;
                    return directBufferWrapper;
                }
            }
            finally {
                this.mySegmentsAccessLock.unlock();
            }
            long started = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
            wrapper = this.createValue(key, read, readOnly);
            if (IOStatistics.DEBUG && (finished = System.currentTimeMillis()) - started > 100L) {
                IOStatistics.dump("Mapping " + wrapper + " for " + (finished - started));
            }
            this.mySegmentsAccessLock.lock();
            try {
                this.mySegments.put(key, wrapper);
                this.mySize += (long)wrapper.getLength();
            }
            finally {
                this.mySegmentsAccessLock.unlock();
            }
            this.ensureSize(this.mySizeLimit);
            DirectBufferWrapper directBufferWrapper = wrapper;
            return directBufferWrapper;
        }
        finally {
            this.mySegmentsAllocationLock.unlock();
        }
    }

    private void disposeRemovedSegments() {
        if (this.mySegmentsToRemove.isEmpty()) {
            return;
        }
        assert (this.mySegmentsAllocationLock.isHeldByCurrentThread());
        Iterator<DirectBufferWrapper> iterator = this.mySegmentsToRemove.iterator();
        while (iterator.hasNext()) {
            iterator.next().release();
            iterator.remove();
        }
    }

    private void ensureSize(long sizeLimit) {
        assert (this.mySegmentsAllocationLock.isHeldByCurrentThread());
        try {
            this.mySegmentsAccessLock.lock();
            while (this.mySize > sizeLimit) {
                this.mySegments.doRemoveEldestEntry();
            }
        }
        finally {
            this.mySegmentsAccessLock.unlock();
        }
        this.disposeRemovedSegments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private DirectBufferWrapper createValue(Integer key, boolean read, boolean readOnly) {
        int storageIndex = key & 0xFFFF0000;
        PagedFileStorage owner = this.getRegisteredPagedFileStorageByIndex(storageIndex);
        assert (owner != null) : "No storage for index " + storageIndex;
        owner.getStorageLockContext().checkThreadAccess(read);
        long off = (long)(key & 0xFFFF) * (long)owner.myPageSize;
        long ownerLength = owner.length();
        if (off > ownerLength) {
            throw new IndexOutOfBoundsException("off=" + off + " key.owner.length()=" + ownerLength);
        }
        int min = (int)Math.min(ownerLength - off, (long)owner.myPageSize);
        DirectBufferWrapper wrapper = readOnly ? DirectBufferWrapper.readOnlyDirect(owner.getFile(), off, min) : DirectBufferWrapper.readWriteDirect(owner.getFile(), off, min);
        OutOfMemoryError oome = null;
        while (true) {
            DirectBufferWrapper directBufferWrapper;
            try {
                wrapper.getBuffer();
                if (oome != null) {
                    LOG.info("Successfully recovered OOME in memory mapping: -Xmx=" + Runtime.getRuntime().maxMemory() / 0x100000L + "MB new size limit: " + this.mySizeLimit / 0x100000L + "MB trying to allocate " + wrapper.getLength() + " block");
                }
                directBufferWrapper = wrapper;
            }
            catch (IOException e) {
                throw new MappingFailedException("Cannot map buffer", e);
            }
            catch (OutOfMemoryError e) {
                long newSize;
                oome = e;
                if (this.mySizeLimit > (long)LOWER_LIMIT) {
                    this.mySizeLimit -= (long)owner.myPageSize;
                }
                if ((newSize = this.mySize - (long)owner.myPageSize) < 0L) {
                    LOG.info("Currently allocated:" + this.mySize);
                    LOG.info("Mapping failed due to OOME. Current buffers: " + this.mySegments);
                    LOG.info(oome);
                    try {
                        Object reserved;
                        Object max;
                        Class<?> aClass = Class.forName("java.nio.Bits");
                        Field reservedMemory = aClass.getDeclaredField("reservedMemory");
                        reservedMemory.setAccessible(true);
                        Field maxMemory = aClass.getDeclaredField("maxMemory");
                        maxMemory.setAccessible(true);
                        Class<?> clazz = aClass;
                        synchronized (clazz) {
                            max = maxMemory.get(null);
                            reserved = reservedMemory.get(null);
                        }
                        LOG.info("Max memory:" + max + ", reserved memory:" + reserved);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new MappingFailedException("Cannot recover from OOME in memory mapping: -Xmx=" + Runtime.getRuntime().maxMemory() / 0x100000L + "MB new size limit: " + this.mySizeLimit / 0x100000L + "MB trying to allocate " + wrapper.getLength() + " block", e);
                }
                this.ensureSize(newSize);
                continue;
            }
            if (directBufferWrapper == null) {
                StorageLock.$$$reportNull$$$0(1);
            }
            return directBufferWrapper;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Map<Integer, DirectBufferWrapper> getBuffersOrderedForOwner(int index, StorageLockContext storageLockContext) {
        this.mySegmentsAccessLock.lock();
        try {
            storageLockContext.checkThreadAccess(false);
            TreeMap<Integer, DirectBufferWrapper> mineBuffers = null;
            for (Map.Entry<Integer, DirectBufferWrapper> entry : this.mySegments.entrySet()) {
                if ((entry.getKey() & 0xFFFF0000) != index) continue;
                if (mineBuffers == null) {
                    mineBuffers = new TreeMap<Integer, DirectBufferWrapper>(Comparator.comparingInt(o -> o));
                }
                mineBuffers.put(entry.getKey(), entry.getValue());
            }
            Iterator<Map.Entry<Integer, DirectBufferWrapper>> iterator = mineBuffers;
            return iterator;
        }
        finally {
            this.mySegmentsAccessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmapBuffersForOwner(int index, StorageLockContext storageLockContext) {
        Map<Integer, DirectBufferWrapper> buffers = this.getBuffersOrderedForOwner(index, storageLockContext);
        if (buffers != null) {
            this.mySegmentsAccessLock.lock();
            try {
                for (Integer key : buffers.keySet()) {
                    this.mySegments.remove(key);
                }
            }
            finally {
                this.mySegmentsAccessLock.unlock();
            }
            this.mySegmentsAllocationLock.lock();
            try {
                this.disposeRemovedSegments();
            }
            finally {
                this.mySegmentsAllocationLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBuffersForOwner(int index, StorageLockContext storageLockContext) throws IOException {
        Map<Integer, DirectBufferWrapper> buffers = this.getBuffersOrderedForOwner(index, storageLockContext);
        if (buffers != null) {
            SmartList<IOException> exceptions = new SmartList<IOException>();
            this.mySegmentsAllocationLock.lock();
            try (DirectBufferWrapper.FileContext fileContext = null;){
                for (DirectBufferWrapper buffer : buffers.values()) {
                    if (!buffer.isDirty()) continue;
                    if (fileContext == null) {
                        fileContext = buffer.openContext();
                    }
                    buffer.flushWithContext(fileContext);
                }
            }
            finally {
                this.mySegmentsAllocationLock.unlock();
            }
            if (!exceptions.isEmpty()) {
                throw new IOException(new CompoundRuntimeException(exceptions));
            }
        }
    }

    void invalidateBuffer(int page) {
        this.mySegmentsAccessLock.lock();
        try {
            this.mySegments.remove(page);
        }
        finally {
            this.mySegmentsAccessLock.unlock();
        }
        this.mySegmentsAllocationLock.lock();
        try {
            this.disposeRemovedSegments();
        }
        finally {
            this.mySegmentsAllocationLock.unlock();
        }
    }

    void removeStorage(int index) {
        this.myIndex2Storage.remove(index);
    }

    static {
        int lower = 100;
        int upper = CpuArch.is32Bit() ? 200 : 500;
        BUFFER_SIZE = Math.max(1, SystemProperties.getIntProperty("idea.paged.storage.page.size", 10)) * 0x100000;
        long max = StorageLock.maxDirectMemory() - 2L * (long)BUFFER_SIZE;
        LOWER_LIMIT = (int)Math.min(0x6400000L, max);
        UPPER_LIMIT = (int)Math.min((long)Math.max(LOWER_LIMIT, SystemProperties.getIntProperty("idea.max.paged.storage.cache", upper) * 0x100000), max);
        LOG.info("lower=" + LOWER_LIMIT / 0x100000 + "; upper=" + UPPER_LIMIT / 0x100000 + "; buffer=" + BUFFER_SIZE / 0x100000 + "; max=" + max / 0x100000L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/StorageLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/StorageLock";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerPagedFileStorage";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

