/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.FileChannelUtil;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class OpenChannelsCache {
    private final int myCacheSizeLimit;
    @NotNull
    private final Set<StandardOpenOption> myOpenOptions;
    @NotNull
    private final Map<Path, ChannelDescriptor> myCache;
    private final Object myLock;

    OpenChannelsCache(int cacheSizeLimit, @NotNull Set<StandardOpenOption> openOptions) {
        if (openOptions == null) {
            OpenChannelsCache.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myCacheSizeLimit = cacheSizeLimit;
        this.myOpenOptions = openOptions;
        this.myCache = new LinkedHashMap<Path, ChannelDescriptor>(cacheSizeLimit, 0.5f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T useChannel(@NotNull Path path, @NotNull ChannelProcessor<T> processor) throws IOException {
        ChannelDescriptor descriptor;
        if (path == null) {
            OpenChannelsCache.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            OpenChannelsCache.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            descriptor = this.myCache.get(path);
            if (descriptor == null) {
                this.releaseOverCachedChannels();
                descriptor = new ChannelDescriptor(path, this.myOpenOptions);
                this.myCache.put(path, descriptor);
            }
            descriptor.lock();
        }
        try {
            object = processor.process(descriptor.getChannel());
            return (T)object;
        }
        finally {
            Object object2 = this.myLock;
            synchronized (object2) {
                descriptor.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeChannel(Path path) {
        Object object = this.myLock;
        synchronized (object) {
            ChannelDescriptor descriptor = this.myCache.remove(path);
            if (descriptor != null) {
                assert (!descriptor.isLocked());
                try {
                    descriptor.getChannel().close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void releaseOverCachedChannels() {
        int dropCount = this.myCache.size() - this.myCacheSizeLimit;
        if (dropCount >= 0) {
            ArrayList<Path> keysToDrop = new ArrayList<Path>();
            for (Map.Entry<Path, ChannelDescriptor> entry : this.myCache.entrySet()) {
                if (dropCount < 0) break;
                if (entry.getValue().isLocked()) continue;
                --dropCount;
                keysToDrop.add(entry.getKey());
            }
            for (Path file : keysToDrop) {
                this.closeChannel(file);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openOptions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/OpenChannelsCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "useChannel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ChannelDescriptor {
        private int myLockCount;
        @NotNull
        private final FileChannel myChannel;

        ChannelDescriptor(@NotNull Path file, @NotNull Set<? extends OpenOption> accessMode) throws IOException {
            if (file == null) {
                ChannelDescriptor.$$$reportNull$$$0(0);
            }
            if (accessMode == null) {
                ChannelDescriptor.$$$reportNull$$$0(1);
            }
            this.myLockCount = 0;
            this.myChannel = Objects.requireNonNull(FileUtilRt.doIOOperation(lastAttempt -> {
                try {
                    return FileChannelUtil.unInterruptible(FileChannel.open(file, accessMode, new FileAttribute[0]));
                }
                catch (NoSuchFileException ex) {
                    Path parent = file.getParent();
                    if (!Files.exists(parent, new LinkOption[0])) {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    if (!lastAttempt) {
                        return null;
                    }
                    throw ex;
                }
            }));
        }

        void lock() {
            ++this.myLockCount;
        }

        void unlock() {
            --this.myLockCount;
        }

        boolean isLocked() {
            return this.myLockCount != 0;
        }

        @NotNull
        FileChannel getChannel() {
            FileChannel fileChannel = this.myChannel;
            if (fileChannel == null) {
                ChannelDescriptor.$$$reportNull$$$0(2);
            }
            return fileChannel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accessMode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/OpenChannelsCache$ChannelDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/OpenChannelsCache$ChannelDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChannel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @FunctionalInterface
    static interface ChannelProcessor<T> {
        public T process(@NotNull FileChannel var1) throws IOException;
    }
}

