/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtilRt;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.channels.FileChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileChannelUtil {
    private static final Logger LOG = Logger.getInstance(FileChannelUtil.class);
    private static final Class<?> sunNioChFileChannelImpl = FileChannelUtil.setupFileChannelImpl();
    private static final MethodHandle setUnInterruptible = FileChannelUtil.setupUnInterruptibleHandle();

    private static Class<?> setupFileChannelImpl() {
        try {
            return Class.forName("sun.nio.ch.FileChannelImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Nullable
    private static MethodHandle setupUnInterruptibleHandle() {
        MethodHandle setUnInterruptible = null;
        try {
            if (sunNioChFileChannelImpl != null) {
                setUnInterruptible = MethodHandles.lookup().findVirtual(sunNioChFileChannelImpl, "setUninterruptible", MethodType.methodType(Void.TYPE));
            }
        }
        catch (NoSuchMethodException e) {
            LOG.info("interruptible FileChannels will be used for indexes");
        }
        catch (IllegalAccessException e) {
            LOG.error(e);
        }
        if (setUnInterruptible != null) {
            LOG.info("uninterruptible FileChannels will be used for indexes");
        } else {
            LOG.info("interruptible FileChannels will be used for indexes");
        }
        return setUnInterruptible;
    }

    @NotNull
    public static FileChannel unInterruptible(@NotNull FileChannel channel) {
        if (channel == null) {
            FileChannelUtil.$$$reportNull$$$0(0);
        }
        try {
            if (setUnInterruptible != null && sunNioChFileChannelImpl != null && sunNioChFileChannelImpl.isInstance(channel)) {
                setUnInterruptible.invoke(channel);
            }
        }
        catch (Throwable e) {
            ExceptionUtilRt.rethrowUnchecked(e);
            throw new RuntimeException(e);
        }
        FileChannel fileChannel = channel;
        if (fileChannel == null) {
            FileChannelUtil.$$$reportNull$$$0(1);
        }
        return fileChannel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/FileChannelUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/FileChannelUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "unInterruptible";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unInterruptible";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

