/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.ByteBufferUtil;
import com.intellij.util.io.DirectByteBufferAllocator;
import com.intellij.util.io.FileChannelUtil;
import com.intellij.util.io.IOUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DirectBufferWrapper {
    private static final Logger LOG = Logger.getInstance(DirectBufferWrapper.class);
    private final Path myFile;
    private final long myPosition;
    private final int myLength;
    private final boolean myReadOnly;
    private volatile ByteBuffer myBuffer;
    private volatile boolean myDirty;

    DirectBufferWrapper(Path file, long offset, int length, boolean readOnly) {
        this.myFile = file;
        this.myPosition = offset;
        this.myLength = length;
        this.myReadOnly = readOnly;
    }

    void markDirty() throws IOException {
        if (this.myReadOnly) {
            throw new IOException("Read-only byte buffer can't be modified. File: " + this.myFile);
        }
        if (!this.myDirty) {
            this.myDirty = true;
        }
    }

    final boolean isDirty() {
        return this.myDirty;
    }

    public ByteBuffer getCachedBuffer() {
        return this.myBuffer;
    }

    ByteBuffer getBuffer() throws IOException {
        ByteBuffer buffer = this.myBuffer;
        if (buffer == null) {
            this.myBuffer = buffer = DirectByteBufferAllocator.allocate(() -> this.create());
        }
        return buffer;
    }

    private ByteBuffer create() throws IOException {
        try (FileContext context = this.openContext();){
            FileChannel channel = context.myFile;
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.myLength);
            channel.read(buffer, this.myPosition);
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }

    void release() {
        if (this.isDirty()) {
            this.flush();
        }
        if (this.myBuffer != null) {
            ByteBufferUtil.cleanBuffer(this.myBuffer);
            this.myBuffer = null;
        }
    }

    void flushWithContext(@NotNull FileContext fileContext) throws IOException {
        ByteBuffer buffer;
        if (fileContext == null) {
            DirectBufferWrapper.$$$reportNull$$$0(0);
        }
        if ((buffer = this.getCachedBuffer()) != null && this.isDirty()) {
            this.doFlush(fileContext, buffer);
        }
    }

    @NotNull
    FileContext openContext() throws IOException {
        return new FileContext(this.myFile, this.myReadOnly);
    }

    private void doFlush(FileContext fileContext, ByteBuffer buffer) throws IOException {
        FileChannel channel = fileContext.myFile;
        buffer.rewind();
        channel.write(buffer, this.myPosition);
        this.myDirty = false;
    }

    public void flush() {
        ByteBuffer buffer = this.getCachedBuffer();
        if (buffer != null && this.isDirty()) {
            try (FileContext context = this.openContext();){
                this.doFlush(context, buffer);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    int getLength() {
        return this.myLength;
    }

    public String toString() {
        return "Buffer for " + this.myFile + ", offset:" + this.myPosition + ", size: " + this.myLength;
    }

    /*
     * WARNING - void declaration
     */
    public static DirectBufferWrapper readWriteDirect(@NotNull Path file, long offset, int n) {
        void length;
        if (file == null) {
            DirectBufferWrapper.$$$reportNull$$$0(1);
        }
        return new DirectBufferWrapper(file, offset, (int)length, false);
    }

    /*
     * WARNING - void declaration
     */
    public static DirectBufferWrapper readOnlyDirect(@NotNull Path file, long offset, int n) {
        void length;
        if (file == null) {
            DirectBufferWrapper.$$$reportNull$$$0(2);
        }
        return new DirectBufferWrapper(file, offset, (int)length, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/DirectBufferWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "flushWithContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readWriteDirect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readOnlyDirect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class FileContext
    implements AutoCloseable {
        @NotNull
        private final FileChannel myFile;
        private final boolean myReadOnly;

        FileContext(Path path, boolean readOnly) throws IOException {
            this.myReadOnly = readOnly;
            this.myFile = Objects.requireNonNull(FileUtilRt.doIOOperation(finalAttempt -> {
                try {
                    EnumSet<StandardOpenOption> options = this.myReadOnly ? EnumSet.of(StandardOpenOption.READ) : EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                    return FileChannelUtil.unInterruptible(FileChannel.open(path, options, new FileAttribute[0]));
                }
                catch (NoSuchFileException ex) {
                    Path parentFile = path.getParent();
                    if (!Files.exists(parentFile, new LinkOption[0])) {
                        if (!Files.isWritable(path)) {
                            throw ex;
                        }
                        Files.createDirectories(parentFile, new FileAttribute[0]);
                    }
                    if (!finalAttempt) {
                        return null;
                    }
                    throw ex;
                }
            }));
        }

        @Override
        public void close() {
            IOUtil.closeSafe(LOG, this.myFile);
        }
    }
}

