/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class ValueSerializationChecker<Value, Input> {
    private static final Logger LOG = Logger.getInstance(ValueSerializationChecker.class);
    @NotNull
    private final DataExternalizer<Value> myValueExternalizer;
    @NotNull
    private final IndexId<?, Value> myIndexId;

    ValueSerializationChecker(@NotNull IndexExtension<?, Value, ?> extension) {
        if (extension == null) {
            ValueSerializationChecker.$$$reportNull$$$0(0);
        }
        this.myValueExternalizer = extension.getValueExternalizer();
        this.myIndexId = extension.getName();
    }

    void checkValuesHaveProperEqualsAndHashCode(@NotNull Map<?, Value> data, @NotNull Input input) {
        if (data == null) {
            ValueSerializationChecker.$$$reportNull$$$0(1);
        }
        if (input == null) {
            ValueSerializationChecker.$$$reportNull$$$0(2);
        }
        for (Map.Entry<?, Value> e : data.entrySet()) {
            Value value = e.getValue();
            if (!Comparing.equal(value, value) || value != null && value.hashCode() != value.hashCode()) {
                LOG.error("Index " + this.myIndexId + " violates equals / hashCode contract for Value parameter");
            }
            try {
                BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
                DataOutputStream outputStream = new DataOutputStream(out);
                this.myValueExternalizer.save(outputStream, value);
                outputStream.close();
                Value deserializedValue = this.myValueExternalizer.read(new DataInputStream(out.toInputStream()));
                if (Comparing.equal(value, deserializedValue) && (value == null || value.hashCode() == deserializedValue.hashCode())) continue;
                LOG.error("Index " + this.myIndexId + " deserialization violates equals / hashCode contract for Value parameter" + " while indexing " + input + ". Original value: '" + value + "'; Deserialized value: '" + deserializedValue + "'");
            }
            catch (IOException ex) {
                LOG.error(ex);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/impl/ValueSerializationChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkValuesHaveProperEqualsAndHashCode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

