/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.Processor;
import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.UpdatableValueContainer;
import com.intellij.util.indexing.impl.ValueContainerExternalizer;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.indexing.impl.ValueContainerInputRemapping;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentMapBase;
import com.intellij.util.io.PersistentMapBuilder;
import com.intellij.util.io.PersistentMapImpl;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

class ValueContainerMap<Key, Value> {
    @NotNull
    private final PersistentMapBase<Key, UpdatableValueContainer<Value>> myPersistentMap;
    @NotNull
    private final KeyDescriptor<Key> myKeyDescriptor;
    @NotNull
    private final DataExternalizer<Value> myValueExternalizer;
    private final boolean myKeyIsUniqueForIndexedFile;

    ValueContainerMap(@NotNull PersistentMapBase<Key, UpdatableValueContainer<Value>> persistentMap, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, boolean keyIsUniqueForIndexedFile) {
        if (persistentMap == null) {
            ValueContainerMap.$$$reportNull$$$0(0);
        }
        if (keyDescriptor == null) {
            ValueContainerMap.$$$reportNull$$$0(1);
        }
        if (valueExternalizer == null) {
            ValueContainerMap.$$$reportNull$$$0(2);
        }
        this.myPersistentMap = persistentMap;
        this.myKeyDescriptor = keyDescriptor;
        this.myValueExternalizer = valueExternalizer;
        this.myKeyIsUniqueForIndexedFile = keyIsUniqueForIndexedFile;
    }

    ValueContainerMap(@NotNull Path file, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, boolean keyIsUniqueForIndexedFile, @NotNull ValueContainerInputRemapping inputRemapping, boolean isReadonly, boolean compactOnClose) throws IOException {
        if (file == null) {
            ValueContainerMap.$$$reportNull$$$0(3);
        }
        if (keyDescriptor == null) {
            ValueContainerMap.$$$reportNull$$$0(4);
        }
        if (valueExternalizer == null) {
            ValueContainerMap.$$$reportNull$$$0(5);
        }
        if (inputRemapping == null) {
            ValueContainerMap.$$$reportNull$$$0(6);
        }
        this.myPersistentMap = new PersistentMapImpl<Key, UpdatableValueContainer<Value>>(PersistentMapBuilder.newBuilder(file, keyDescriptor, new ValueContainerExternalizer<Value>(valueExternalizer, inputRemapping)).withReadonly(isReadonly).withCompactOnClose(compactOnClose));
        this.myValueExternalizer = valueExternalizer;
        this.myKeyDescriptor = keyDescriptor;
        this.myKeyIsUniqueForIndexedFile = keyIsUniqueForIndexedFile;
    }

    void merge(Key key, final UpdatableValueContainer<Value> valueContainer) throws IOException {
        if (!valueContainer.needsCompacting() && !this.myKeyIsUniqueForIndexedFile) {
            this.myPersistentMap.appendData(key, new AppendablePersistentMap.ValueDataAppender(){

                @Override
                public void append(@NotNull DataOutput out) throws IOException {
                    if (out == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    valueContainer.saveTo(out, ValueContainerMap.this.myValueExternalizer);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/indexing/impl/ValueContainerMap$1", "append"));
                }
            });
        } else {
            this.myPersistentMap.put(key, valueContainer);
        }
    }

    boolean processKeys(@NotNull Processor<? super Key> processor) throws IOException {
        if (processor == null) {
            ValueContainerMap.$$$reportNull$$$0(7);
        }
        return this.myKeyDescriptor instanceof InlineKeyDescriptor ? this.myPersistentMap.processExistingKeys(processor) : this.myPersistentMap.processKeys(processor);
    }

    @NotNull
    ChangeTrackingValueContainer<Value> getModifiableValueContainer(Key key) {
        return new ChangeTrackingValueContainer(() -> {
            ValueContainerImpl value;
            try {
                value = (ValueContainerImpl)this.myPersistentMap.get(key);
                if (value == null) {
                    value = new ValueContainerImpl();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return value;
        });
    }

    void force() {
        try {
            this.myPersistentMap.force();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void close() throws IOException {
        this.myPersistentMap.close();
    }

    void closeAndDelete() throws IOException {
        this.myPersistentMap.closeAndDelete();
    }

    void markDirty() throws IOException {
        this.myPersistentMap.markDirty();
    }

    boolean isClosed() {
        return this.myPersistentMap.isClosed();
    }

    boolean isDirty() {
        return this.myPersistentMap.isClosed();
    }

    @TestOnly
    PersistentMapBase<Key, UpdatableValueContainer<Value>> getStorageMap() {
        return this.myPersistentMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistentMap";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputRemapping";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/impl/ValueContainerMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processKeys";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

