/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.containers.CanonicalObjectStrategy;
import com.intellij.util.containers.FastUtilCaseInsensitiveStringHashingStrategy;
import com.intellij.util.containers.HashingStrategy;
import it.unimi.dsi.fastutil.Hash;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FastUtilHashingStrategies
implements Hash.Strategy<CharSequence> {
    private static final Hash.Strategy<CharSequence> CASE_SENSITIVE = new FastUtilHashingStrategies(true);
    private static final Hash.Strategy<CharSequence> CASE_INSENSITIVE = new FastUtilHashingStrategies(false);
    private final boolean isCaseSensitive;

    @NotNull
    public static Hash.Strategy<CharSequence> getCharSequenceStrategy(boolean isCaseSensitive) {
        Hash.Strategy<CharSequence> strategy = isCaseSensitive ? CASE_SENSITIVE : CASE_INSENSITIVE;
        if (strategy == null) {
            FastUtilHashingStrategies.$$$reportNull$$$0(0);
        }
        return strategy;
    }

    @NotNull
    public static Hash.Strategy<String> getStringStrategy(boolean isCaseSensitive) {
        Object object = isCaseSensitive ? FastUtilHashingStrategies.getCanonicalStrategy() : FastUtilCaseInsensitiveStringHashingStrategy.INSTANCE;
        if (object == null) {
            FastUtilHashingStrategies.$$$reportNull$$$0(1);
        }
        return object;
    }

    @NotNull
    public static Hash.Strategy<String> getCaseInsensitiveStringStrategy() {
        Hash.Strategy<String> strategy = FastUtilCaseInsensitiveStringHashingStrategy.INSTANCE;
        if (strategy == null) {
            FastUtilHashingStrategies.$$$reportNull$$$0(2);
        }
        return strategy;
    }

    @NotNull
    public static <T> Hash.Strategy<T> getCanonicalStrategy() {
        Hash.Strategy<Object> strategy = CanonicalObjectStrategy.INSTANCE;
        if (strategy == null) {
            FastUtilHashingStrategies.$$$reportNull$$$0(3);
        }
        return strategy;
    }

    @NotNull
    public static <T> Hash.Strategy<T> adaptAsNotNull(final @NotNull HashingStrategy<? super T> hashingStrategy) {
        if (hashingStrategy == null) {
            FastUtilHashingStrategies.$$$reportNull$$$0(4);
        }
        return new Hash.Strategy<T>(){

            public int hashCode(@Nullable T o) {
                return o == null ? 0 : hashingStrategy.hashCode(o);
            }

            public boolean equals(@Nullable T a, @Nullable T b) {
                return a == b || a != null && b != null && hashingStrategy.equals(a, b);
            }
        };
    }

    private FastUtilHashingStrategies(boolean caseSensitive) {
        this.isCaseSensitive = caseSensitive;
    }

    public int hashCode(CharSequence o) {
        if (o == null) {
            return 0;
        }
        return this.isCaseSensitive ? StringUtil.stringHashCode(o) : StringUtil.stringHashCodeInsensitive(o);
    }

    public boolean equals(CharSequence s1, CharSequence s2) {
        return StringUtilRt.equal(s1, s2, this.isCaseSensitive);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/FastUtilHashingStrategies";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharSequenceStrategy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringStrategy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseInsensitiveStringStrategy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalStrategy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/FastUtilHashingStrategies";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "adaptAsNotNull";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

