/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentIntKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentIntObjectHashMap;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ConcurrentLongObjectHashMap;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ConcurrentSoftHashMap;
import com.intellij.util.containers.ConcurrentSoftKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakKeyWeakValueHashMap;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.IntKeyWeakValueHashMap;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.LockFreeCopyOnWriteArrayList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.ObjectIntMap;
import com.intellij.util.containers.SequenceIterator;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.containers.SoftKeySoftValueHashMap;
import com.intellij.util.containers.SoftValueHashMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.containers.WeakHashSet;
import com.intellij.util.containers.WeakKeyIntValueHashMap;
import com.intellij.util.containers.WeakKeySoftValueHashMap;
import com.intellij.util.containers.WeakKeyWeakValueHashMap;
import com.intellij.util.containers.WeakValueHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public final class ContainerUtil {
    private static final int INSERTION_SORT_THRESHOLD = 10;

    @SafeVarargs
    @Contract(pure=true)
    public static <T> T @NotNull [] ar(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(1);
        }
        return elements;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    @NotNull
    public static <K, V> HashMap<K, V> newHashMap(@NotNull Map<? extends K, ? extends V> map2) {
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(2);
        }
        return new HashMap<K, V>(map2);
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> newHashMap(@NotNull Pair<? extends K, ? extends V> first, Pair<? extends K, ? extends V> ... entries) {
        if (first == null) {
            ContainerUtil.$$$reportNull$$$0(3);
        }
        if (entries == null) {
            ContainerUtil.$$$reportNull$$$0(4);
        }
        HashMap<K, V> map2 = new HashMap<K, V>(entries.length + 1);
        map2.put(first.getFirst(), first.getSecond());
        for (Pair<K, V> pair : entries) {
            map2.put(pair.getFirst(), pair.getSecond());
        }
        HashMap<K, V> hashMap = map2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> newHashMap(@NotNull List<? extends K> keys, @NotNull List<? extends V> values) {
        if (keys == null) {
            ContainerUtil.$$$reportNull$$$0(6);
        }
        if (values == null) {
            ContainerUtil.$$$reportNull$$$0(7);
        }
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException(keys + " must have same length as " + values);
        }
        HashMap<K, V> map2 = new HashMap<K, V>(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            map2.put(keys.get(i), values.get(i));
        }
        HashMap<K, V> hashMap = map2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@NotNull Pair<? extends K, ? extends V> first, Pair<? extends K, ? extends V> ... entries) {
        if (first == null) {
            ContainerUtil.$$$reportNull$$$0(9);
        }
        if (entries == null) {
            ContainerUtil.$$$reportNull$$$0(10);
        }
        LinkedHashMap<K, V> map2 = new LinkedHashMap<K, V>();
        map2.put(first.getFirst(), first.getSecond());
        for (Pair<K, V> pair : entries) {
            map2.put(pair.getFirst(), pair.getSecond());
        }
        LinkedHashMap<K, V> linkedHashMap = map2;
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(11);
        }
        return linkedHashMap;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    @Contract(pure=true)
    @NotNull
    public static <K, V> THashMap<K, V> newTroveMap() {
        return new THashMap();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    @NotNull
    public static <T> TObjectHashingStrategy<T> canonicalStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.CANONICAL;
        if (tObjectHashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(12);
        }
        return tObjectHashingStrategy;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    @NotNull
    public static <T> TObjectHashingStrategy<T> identityStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.IDENTITY;
        if (tObjectHashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(13);
        }
        return tObjectHashingStrategy;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    @NotNull
    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        return new IdentityHashMap();
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static <T> LinkedList<T> newLinkedList() {
        return new LinkedList();
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> LinkedList<T> newLinkedList(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(14);
        }
        LinkedList list = new LinkedList();
        Collections.addAll(list, elements);
        LinkedList linkedList = list;
        if (linkedList == null) {
            ContainerUtil.$$$reportNull$$$0(15);
        }
        return linkedList;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <E> ArrayList<E> newArrayList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(16);
        }
        return new ArrayList<E>(Arrays.asList(array));
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    @NotNull
    public static <E> ArrayList<E> newArrayList(@NotNull Collection<? extends E> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(17);
        }
        DeprecatedMethodException.report("Use `new ArrayList(Collection)` instead. " + iterable.getClass());
        return new ArrayList<E>(iterable);
    }

    @Contract(pure=true)
    @NotNull
    public static <E> ArrayList<E> newArrayList(@NotNull Iterable<? extends E> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(18);
        }
        ArrayList<E> collection = new ArrayList<E>();
        for (E element : iterable) {
            collection.add(element);
        }
        ArrayList<E> arrayList = collection;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        return new ArrayList(size);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> newArrayList(final T @NotNull [] elements, final int start, final int end) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(20);
        }
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        return new AbstractList<T>(){
            private final int size;
            {
                this.size = end - start;
            }

            @Override
            public T get(int index) {
                if (index < 0 || index >= this.size) {
                    throw new IndexOutOfBoundsException("index:" + index + " size:" + this.size);
                }
                return elements[start + index];
            }

            @Override
            public int size() {
                return this.size;
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> newUnmodifiableList(@NotNull List<? extends T> originalList) {
        int size;
        if (originalList == null) {
            ContainerUtil.$$$reportNull$$$0(21);
        }
        if ((size = originalList.size()) == 0) {
            return ContainerUtil.emptyList();
        }
        if (size == 1) {
            List<T> list = Collections.singletonList(originalList.get(0));
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(22);
            }
            return list;
        }
        List<? extends T> list = Collections.unmodifiableList(new ArrayList<T>(originalList));
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Collection<T> unmodifiableOrEmptyCollection(@NotNull Collection<? extends T> original) {
        int size;
        if (original == null) {
            ContainerUtil.$$$reportNull$$$0(24);
        }
        if ((size = original.size()) == 0) {
            return ContainerUtil.emptyList();
        }
        Collection<? extends T> collection = Collections.unmodifiableCollection(original);
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(25);
        }
        return collection;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> unmodifiableOrEmptyList(@NotNull List<? extends T> original) {
        int size;
        if (original == null) {
            ContainerUtil.$$$reportNull$$$0(26);
        }
        if ((size = original.size()) == 0) {
            return ContainerUtil.emptyList();
        }
        List<? extends T> list = Collections.unmodifiableList(original);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(27);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> unmodifiableOrEmptySet(@NotNull Set<? extends T> original) {
        int size;
        if (original == null) {
            ContainerUtil.$$$reportNull$$$0(28);
        }
        if ((size = original.size()) == 0) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(29);
            }
            return set;
        }
        Set<? extends T> set = Collections.unmodifiableSet(original);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(30);
        }
        return set;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> unmodifiableOrEmptyMap(@NotNull Map<? extends K, ? extends V> original) {
        int size;
        if (original == null) {
            ContainerUtil.$$$reportNull$$$0(31);
        }
        if ((size = original.size()) == 0) {
            Map map2 = Collections.emptyMap();
            if (map2 == null) {
                ContainerUtil.$$$reportNull$$$0(32);
            }
            return map2;
        }
        Map<? extends K, ? extends V> map3 = Collections.unmodifiableMap(original);
        if (map3 == null) {
            ContainerUtil.$$$reportNull$$$0(33);
        }
        return map3;
    }

    @Deprecated
    @NotNull
    public static <T> List<T> newSmartList() {
        return new SmartList();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static <T> List<T> newSmartList(T element) {
        return new SmartList<T>(element);
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(34);
        }
        return new HashSet<T>(Arrays.asList(elements));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Iterable<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(35);
        }
        Iterator<T> iterator = iterable.iterator();
        HashSet<T> set = new HashSet<T>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        HashSet<T> hashSet = set;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(36);
        }
        return hashSet;
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(37);
        }
        return new HashSet<T>(collection);
    }

    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Iterator<? extends T> iterator) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(38);
        }
        HashSet<T> set = new HashSet<T>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        HashSet<T> hashSet = set;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(39);
        }
        return hashSet;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> newHashOrEmptySet(@Nullable Iterable<? extends T> iterable) {
        boolean isEmpty;
        boolean bl = isEmpty = iterable == null || iterable instanceof Collection && ((Collection)iterable).isEmpty();
        if (isEmpty) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(40);
            }
            return set;
        }
        return ContainerUtil.newHashSet(iterable);
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    @Contract(pure=true)
    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(41);
        }
        LinkedHashSet<T> collection = new LinkedHashSet<T>();
        for (T element : elements) {
            collection.add(element);
        }
        LinkedHashSet<T> linkedHashSet = collection;
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(42);
        }
        return linkedHashSet;
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Collection<? extends T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(43);
        }
        DeprecatedMethodException.report("Use `new LinkedHashSet(Collection)` instead. " + elements.getClass());
        return new LinkedHashSet<T>(elements);
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(44);
        }
        return new LinkedHashSet<T>(Arrays.asList(elements));
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> THashSet<T> newTroveSet() {
        return new THashSet();
    }

    @SafeVarargs
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Contract(pure=true)
    @NotNull
    public static <T> THashSet<T> newTroveSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(45);
        }
        return new THashSet(Arrays.asList(elements));
    }

    @Deprecated
    @SafeVarargs
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Contract(pure=true)
    @NotNull
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy, T ... elements) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(46);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(47);
        }
        return new THashSet(Arrays.asList(elements), strategy);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Contract(pure=true)
    @NotNull
    public static <K, V> THashMap<K, V> newIdentityTroveMap() {
        return new THashMap(ContainerUtil.identityStrategy());
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Contract(pure=true)
    @NotNull
    public static <T extends Comparable<? super T>> TreeSet<T> newTreeSet() {
        return new TreeSet();
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> newConcurrentSet() {
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(48);
        }
        return set;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    @Contract(pure=true)
    @NotNull
    public static <E> List<E> reverse(final @NotNull List<? extends E> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(49);
        }
        if (elements.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return elements.get(elements.size() - 1 - index);
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> union(@NotNull Map<? extends K, ? extends V> map2, @NotNull Map<? extends K, ? extends V> map22) {
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(50);
        }
        if (map22 == null) {
            ContainerUtil.$$$reportNull$$$0(51);
        }
        THashMap result = new THashMap(map2.size() + map22.size());
        result.putAll(map2);
        result.putAll(map22);
        THashMap tHashMap = result;
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(52);
        }
        return tHashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> union(@NotNull Set<? extends T> set, @NotNull Set<? extends T> set2) {
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(53);
        }
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(54);
        }
        return ContainerUtil.union(set, set2);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> union(@NotNull Collection<? extends T> set, @NotNull Collection<? extends T> set2) {
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(55);
        }
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(56);
        }
        HashSet<T> result = new HashSet<T>(set.size() + set2.size());
        result.addAll(set);
        result.addAll(set2);
        HashSet<T> hashSet = result;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(57);
        }
        return hashSet;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <E> Set<E> immutableSet(E ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(58);
        }
        switch (elements.length) {
            case 0: {
                Set set = Collections.emptySet();
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(59);
                }
                return set;
            }
            case 1: {
                Set<E> set = Collections.singleton(elements[0]);
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(60);
                }
                return set;
            }
        }
        Set<E> set = Collections.unmodifiableSet(new HashSet<E>(Arrays.asList(elements)));
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(61);
        }
        return set;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <E> ImmutableList<E> immutableList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(62);
        }
        return new ImmutableListBackedByArray(array);
    }

    @Contract(pure=true)
    @NotNull
    public static <E> ImmutableList<E> immutableSingletonList(E element) {
        ImmutableList<E> immutableList = ImmutableList.singleton(element);
        if (immutableList == null) {
            ContainerUtil.$$$reportNull$$$0(63);
        }
        return immutableList;
    }

    @Contract(pure=true)
    @NotNull
    public static <E> ImmutableList<E> immutableList(@NotNull List<? extends E> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(64);
        }
        return new ImmutableListBackedByList(list);
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> ImmutableMapBuilder<K, V> immutableMapBuilder() {
        return new ImmutableMapBuilder();
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> MultiMap<K, V> groupBy(@NotNull Iterable<? extends V> collection, @NotNull NullableFunction<? super V, ? extends K> grouper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(65);
        }
        if (grouper == null) {
            ContainerUtil.$$$reportNull$$$0(66);
        }
        MultiMap<K, V> result = MultiMap.createLinked();
        for (V data : collection) {
            K key = grouper.fun(data);
            if (key == null) continue;
            result.putValue(key, data);
        }
        if (!result.isEmpty() && result.keySet().iterator().next() instanceof Comparable) {
            return new KeyOrderedMultiMap(result);
        }
        MultiMap<K, V> multiMap = result;
        if (multiMap == null) {
            ContainerUtil.$$$reportNull$$$0(67);
        }
        return multiMap;
    }

    @Contract(pure=true)
    public static <T> T getOrElse(@NotNull List<? extends T> elements, int i, T defaultValue) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(68);
        }
        return elements.size() > i ? elements.get(i) : defaultValue;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> intersection(@NotNull Map<? extends K, ? extends V> map1, @NotNull Map<? extends K, ? extends V> map2) {
        if (map1 == null) {
            ContainerUtil.$$$reportNull$$$0(69);
        }
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(70);
        }
        if (map1.isEmpty() || map2.isEmpty()) {
            Map map3 = Collections.emptyMap();
            if (map3 == null) {
                ContainerUtil.$$$reportNull$$$0(71);
            }
            return map3;
        }
        if (map2.size() < map1.size()) {
            Map<K, V> t = map1;
            map1 = map2;
            map2 = t;
        }
        HashMap<K, V> res = new HashMap<K, V>(map1);
        for (Map.Entry<K, V> entry : map1.entrySet()) {
            V v2;
            K key = entry.getKey();
            V v1 = entry.getValue();
            if (Objects.equals(v1, v2 = map2.get(key))) continue;
            res.remove(key);
        }
        HashMap<K, V> hashMap = res;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(72);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, Couple<V>> diff(@NotNull Map<? extends K, ? extends V> map1, @NotNull Map<? extends K, ? extends V> map2) {
        if (map1 == null) {
            ContainerUtil.$$$reportNull$$$0(73);
        }
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(74);
        }
        Set<K> keys = ContainerUtil.union(map1.keySet(), map2.keySet());
        HashMap<K, Couple<V>> res = new HashMap<K, Couple<V>>();
        for (K k : keys) {
            V v2;
            V v1 = map1.get(k);
            if (Objects.equals(v1, v2 = map2.get(k))) continue;
            res.put(k, Couple.of(v1, v2));
        }
        HashMap<K, Couple<V>> hashMap = res;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(75);
        }
        return hashMap;
    }

    public static <T> void processSortedListsInOrder(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems, @NotNull PairConsumer<? super T, ? super Boolean> processor) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(76);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(77);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(78);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(79);
        }
        int index1 = 0;
        int index2 = 0;
        while (index1 < list1.size() || index2 < list2.size()) {
            T element2;
            T e;
            if (index1 >= list1.size()) {
                e = list2.get(index2++);
                processor.consume((Boolean)e, (Boolean)((Boolean)Boolean.valueOf(false)));
                continue;
            }
            if (index2 >= list2.size()) {
                e = list1.get(index1++);
                processor.consume((Boolean)e, (Boolean)((Boolean)Boolean.valueOf(true)));
                continue;
            }
            T element1 = list1.get(index1);
            int c = comparator.compare(element1, element2 = list2.get(index2));
            if (c == 0) {
                ++index1;
                ++index2;
                if (mergeEqualItems) {
                    e = element1;
                    processor.consume((Boolean)e, (Boolean)((Boolean)Boolean.valueOf(true)));
                    continue;
                }
                processor.consume((Boolean)element1, (Boolean)((Boolean)Boolean.valueOf(true)));
                e = element2;
                processor.consume((Boolean)e, (Boolean)((Boolean)Boolean.valueOf(false)));
                continue;
            }
            if (c < 0) {
                e = element1;
                ++index1;
                processor.consume((Boolean)e, (Boolean)((Boolean)Boolean.valueOf(true)));
                continue;
            }
            e = element2;
            ++index2;
            processor.consume((Boolean)e, (Boolean)((Boolean)Boolean.valueOf(false)));
        }
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> mergeSortedLists(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(80);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(81);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(82);
        }
        ArrayList result = new ArrayList(list1.size() + list2.size());
        ContainerUtil.processSortedListsInOrder(list1, list2, comparator, mergeEqualItems, (t, __) -> result.add(t));
        ArrayList arrayList = result;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(83);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> subList(@NotNull List<T> list, int from) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(84);
        }
        List<T> list2 = list.subList(from, list.size());
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(85);
        }
        return list2;
    }

    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Iterable<? extends T> appendix) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(86);
        }
        if (appendix == null) {
            ContainerUtil.$$$reportNull$$$0(87);
        }
        ContainerUtil.addAll(collection, appendix.iterator());
    }

    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> iterator) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(88);
        }
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(89);
        }
        while (iterator.hasNext()) {
            T o = iterator.next();
            collection.add(o);
        }
    }

    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(90);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(91);
        }
        ContainerUtil.addAllNotNull(collection, elements.iterator());
    }

    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(92);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(93);
        }
        while (elements.hasNext()) {
            T o = elements.next();
            if (o == null) continue;
            collection.add(o);
        }
    }

    @NotNull
    public static <T> List<T> collect(@NotNull Iterator<? extends T> iterator) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(94);
        }
        if (!iterator.hasNext()) {
            return ContainerUtil.emptyList();
        }
        ArrayList list = new ArrayList();
        ContainerUtil.addAll(list, iterator);
        ArrayList arrayList = list;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(95);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> newMapFromKeys(@NotNull Iterator<? extends K> keys, @NotNull Convertor<? super K, ? extends V> valueConvertor) {
        if (keys == null) {
            ContainerUtil.$$$reportNull$$$0(96);
        }
        if (valueConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(97);
        }
        HashMap<K, V> map2 = new HashMap<K, V>();
        while (keys.hasNext()) {
            K key = keys.next();
            map2.put(key, valueConvertor.convert(key));
        }
        HashMap<K, V> hashMap = map2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(98);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> newMapFromValues(@NotNull Iterator<? extends V> values, @NotNull Convertor<? super V, ? extends K> keyConvertor) {
        if (values == null) {
            ContainerUtil.$$$reportNull$$$0(99);
        }
        if (keyConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(100);
        }
        HashMap map2 = new HashMap();
        ContainerUtil.fillMapWithValues(map2, values, keyConvertor);
        HashMap hashMap = map2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(101);
        }
        return hashMap;
    }

    public static <K, V> void fillMapWithValues(@NotNull Map<? super K, ? super V> map2, @NotNull Iterator<? extends V> values, @NotNull Convertor<? super V, ? extends K> keyConvertor) {
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(102);
        }
        if (values == null) {
            ContainerUtil.$$$reportNull$$$0(103);
        }
        if (keyConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(104);
        }
        while (values.hasNext()) {
            V value = values.next();
            map2.put(keyConvertor.convert(value), value);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, Set<V>> classify(@NotNull Iterator<? extends V> iterator, @NotNull Convertor<? super V, ? extends K> keyConvertor) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(105);
        }
        if (keyConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(106);
        }
        LinkedHashMap<Object, Set> hashMap = new LinkedHashMap<Object, Set>();
        while (iterator.hasNext()) {
            V value = iterator.next();
            K key = keyConvertor.convert(value);
            Set set = hashMap.computeIfAbsent(key, __ -> new LinkedHashSet());
            set.add(value);
        }
        LinkedHashMap<Object, Set> linkedHashMap = hashMap;
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(107);
        }
        return linkedHashMap;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> emptyIterable() {
        List list = Collections.emptyList();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(108);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T> T find(T @NotNull [] array, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(109);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(110);
        }
        for (T element : array) {
            if (!condition.value(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean process(@NotNull Iterable<? extends T> iterable, @NotNull Processor<? super T> processor) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(111);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(112);
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull List<? extends T> list, @NotNull Processor<? super T> processor) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(113);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(114);
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T t = list.get(i);
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(T @NotNull [] iterable, @NotNull Processor<? super T> processor) {
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(115);
        }
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(116);
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull Iterator<? extends T> iterator, @NotNull Processor<? super T> processor) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(117);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(118);
        }
        while (iterator.hasNext()) {
            if (processor.process(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> T find(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(119);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(120);
        }
        return ContainerUtil.find(iterable.iterator(), condition);
    }

    @Contract(pure=true)
    public static <T> T find(@NotNull Iterable<? extends T> iterable, @NotNull T equalTo) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(121);
        }
        if (equalTo == null) {
            ContainerUtil.$$$reportNull$$$0(122);
        }
        return (T)ContainerUtil.find(iterable, object -> equalTo == object || equalTo.equals(object));
    }

    @Contract(pure=true)
    public static <T> T find(@NotNull Iterator<? extends T> iterator, @NotNull T equalTo) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(123);
        }
        if (equalTo == null) {
            ContainerUtil.$$$reportNull$$$0(124);
        }
        return (T)ContainerUtil.find(iterator, (? super T object) -> equalTo == object || equalTo.equals(object));
    }

    public static <T> T find(@NotNull Iterator<? extends T> iterator, @NotNull Condition<? super T> condition) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(125);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(126);
        }
        while (iterator.hasNext()) {
            T value = iterator.next();
            if (!condition.value(value)) continue;
            return value;
        }
        return null;
    }

    @Contract(pure=true)
    public static <T> T findLast(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        int index;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(127);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(128);
        }
        if ((index = ContainerUtil.lastIndexOf(list, condition)) < 0) {
            return null;
        }
        return list.get(index);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, K, V> Map<K, V> map2Map(T @NotNull [] collection, @NotNull Function<? super T, ? extends Pair<? extends K, ? extends V>> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(129);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(130);
        }
        return ContainerUtil.map2Map(Arrays.asList(collection), mapper);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, K, V> Map<K, V> map2Map(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends Pair<? extends K, ? extends V>> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(131);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(132);
        }
        THashMap set = new THashMap(collection.size());
        for (T t : collection) {
            Pair<? extends K, ? extends V> pair = mapper.fun(t);
            set.put(pair.first, pair.second);
        }
        THashMap tHashMap = set;
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(133);
        }
        return tHashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, K, V> Map<K, V> map2MapNotNull(T @NotNull [] collection, @NotNull Function<? super T, ? extends Pair<? extends K, ? extends V>> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(134);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(135);
        }
        return ContainerUtil.map2MapNotNull(Arrays.asList(collection), mapper);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, K, V> Map<K, V> map2MapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends Pair<? extends K, ? extends V>> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(136);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(137);
        }
        THashMap set = new THashMap(collection.size());
        for (T t : collection) {
            Pair<? extends K, ? extends V> pair = mapper.fun(t);
            if (pair == null) continue;
            set.put(pair.first, pair.second);
        }
        THashMap tHashMap = set;
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(138);
        }
        return tHashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> map2Map(@NotNull Collection<? extends Pair<? extends K, ? extends V>> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(139);
        }
        HashMap result = new HashMap(collection.size());
        for (Pair<K, V> pair : collection) {
            result.put(pair.first, pair.second);
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(140);
        }
        return hashMap;
    }

    @Contract(pure=true)
    public static <T> Object @NotNull [] map2Array(T @NotNull [] array, @NotNull Function<? super T, Object> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(141);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(142);
        }
        return ContainerUtil.map2Array(array, Object.class, mapper);
    }

    @Contract(pure=true)
    public static <T> Object @NotNull [] map2Array(@NotNull Collection<? extends T> array, @NotNull Function<? super T, Object> mapper) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(143);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(144);
        }
        return ContainerUtil.map2Array(array, Object.class, mapper);
    }

    @Contract(pure=true)
    public static <T, V> V @NotNull [] map2Array(T @NotNull [] array, @NotNull Class<V> aClass, @NotNull Function<? super T, ? extends V> mapper) {
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(145);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(146);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(147);
        }
        V[] result = ArrayUtil.newArray(aClass, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = mapper.fun(array[i]);
        }
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(148);
        }
        return result;
    }

    @Contract(pure=true)
    public static <T, V> V @NotNull [] map2Array(@NotNull Collection<? extends T> collection, @NotNull Class<V> aClass, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(149);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(150);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(151);
        }
        V[] result = ArrayUtil.newArray(aClass, collection.size());
        int i = 0;
        for (T t : collection) {
            result[i++] = mapper.fun(t);
        }
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(152);
        }
        return result;
    }

    @Contract(mutates="param2")
    public static <T, V> V @NotNull [] map2Array(@NotNull Collection<? extends T> collection, V @NotNull [] to, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(153);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(154);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(155);
        }
        V[] VArray = ContainerUtil.map2List(collection, mapper).toArray(to);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(156);
        }
        return VArray;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> filter(T @NotNull [] collection, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(157);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(158);
        }
        return ContainerUtil.findAll(collection, condition);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> findAll(T @NotNull [] collection, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(159);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(160);
        }
        SmartList<T> result = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        SmartList<T> smartList = result;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(161);
        }
        return smartList;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> filterIsInstance(@NotNull Collection<?> collection, @NotNull Class<? extends T> aClass) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(162);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(163);
        }
        return ContainerUtil.filter(collection, Conditions.instanceOf(aClass));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> filterIsInstance(Object @NotNull [] collection, @NotNull Class<? extends T> aClass) {
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(164);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(165);
        }
        return ContainerUtil.filter(collection, Conditions.instanceOf(aClass));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> filter(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(166);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(167);
        }
        return ContainerUtil.findAll(collection, condition);
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> filter(@NotNull Map<? extends K, ? extends V> map2, @NotNull Condition<? super K> keyFilter) {
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(168);
        }
        if (keyFilter == null) {
            ContainerUtil.$$$reportNull$$$0(169);
        }
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            if (!keyFilter.value(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        HashMap<K, V> hashMap = result;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(170);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> findAll(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(171);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(172);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        SmartList<T> result = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        SmartList<T> smartList = result;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(173);
        }
        return smartList;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> skipNulls(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(174);
        }
        return ContainerUtil.findAll(collection, Conditions.notNull());
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V extends T> List<V> findAll(T @NotNull [] array, @NotNull Class<V> instanceOf) {
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(175);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(176);
        }
        SmartList<T> result = new SmartList<T>();
        for (T t : array) {
            if (!instanceOf.isInstance(t)) continue;
            result.add(t);
        }
        SmartList<T> smartList = result;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(177);
        }
        return smartList;
    }

    @Contract(pure=true)
    public static <T, V extends T> V @NotNull [] findAllAsArray(T @NotNull [] collection, @NotNull Class<V> instanceOf) {
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(178);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(179);
        }
        List<V> list = ContainerUtil.findAll(collection, instanceOf);
        V[] array = ArrayUtil.newArray(instanceOf, list.size());
        V[] VArray = list.toArray(array);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(180);
        }
        return VArray;
    }

    @Contract(pure=true)
    public static <T, V extends T> V @NotNull [] findAllAsArray(@NotNull Collection<? extends T> collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(181);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(182);
        }
        List<V> list = ContainerUtil.findAll(collection, instanceOf);
        V[] array = ArrayUtil.newArray(instanceOf, list.size());
        V[] VArray = list.toArray(array);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(183);
        }
        return VArray;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] findAllAsArray(T @NotNull [] collection, @NotNull Condition<? super T> instanceOf) {
        List<T> list;
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(184);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(185);
        }
        if ((list = ContainerUtil.findAll(collection, instanceOf)).size() == collection.length) {
            if (collection == null) {
                ContainerUtil.$$$reportNull$$$0(186);
            }
            return collection;
        }
        T[] array = ArrayUtil.newArray(ArrayUtil.getComponentType(collection), list.size());
        T[] TArray = list.toArray(array);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(187);
        }
        return TArray;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V extends T> List<V> findAll(@NotNull Collection<? extends T> collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(188);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(189);
        }
        SmartList<T> result = new SmartList<T>();
        for (T t : collection) {
            if (!instanceOf.isInstance(t)) continue;
            result.add(t);
        }
        SmartList<T> smartList = result;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(190);
        }
        return smartList;
    }

    public static <T> boolean all(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(191);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(192);
        }
        for (T t : collection) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    public static void removeDuplicates(@NotNull Collection<?> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(193);
        }
        HashSet collected = new HashSet();
        collection.removeIf(t -> !collected.add(t));
    }

    @Contract(pure=true)
    @NotNull
    public static Map<String, String> stringMap(String ... keyValues) {
        if (keyValues == null) {
            ContainerUtil.$$$reportNull$$$0(194);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < keyValues.length - 1; i += 2) {
            result.put(keyValues[i], keyValues[i + 1]);
        }
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(195);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> iterate(T @NotNull [] array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(196);
        }
        Iterator iterator = array.length == 0 ? Collections.emptyIterator() : Arrays.asList(array).iterator();
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(197);
        }
        return iterator;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> iterate(final @NotNull Enumeration<? extends T> enumeration) {
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(198);
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> iterate(T @NotNull [] arrays, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(199);
        }
        if (arrays == null) {
            ContainerUtil.$$$reportNull$$$0(200);
        }
        return ContainerUtil.iterate(Arrays.asList(arrays), condition);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> iterate(final @NotNull Collection<? extends T> collection, final @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(201);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(202);
        }
        if (collection.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(203);
            }
            return list;
        }
        Iterable iterable = () -> new Iterator<T>(){
            private final Iterator impl;
            private Object next;
            {
                this.impl = collection.iterator();
                this.next = this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                Object result = this.next;
                this.next = this.findNext();
                return result;
            }

            @Nullable
            private T findNext() {
                while (this.impl.hasNext()) {
                    Object each = this.impl.next();
                    if (!condition.value(each)) continue;
                    return each;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(204);
        }
        return iterable;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> iterateBackward(final @NotNull List<? extends T> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(205);
        }
        Iterable iterable = () -> new Iterator<T>(){
            private final ListIterator it;
            {
                this.it = list.listIterator(list.size());
            }

            @Override
            public boolean hasNext() {
                return this.it.hasPrevious();
            }

            @Override
            public T next() {
                return this.it.previous();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(206);
        }
        return iterable;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, E> Iterable<Pair<T, E>> zip(final @NotNull Iterable<? extends T> iterable1, final @NotNull Iterable<? extends E> iterable2) {
        if (iterable1 == null) {
            ContainerUtil.$$$reportNull$$$0(207);
        }
        if (iterable2 == null) {
            ContainerUtil.$$$reportNull$$$0(208);
        }
        Iterable<Pair<T, E>> iterable = () -> new Iterator<Pair<T, E>>(){
            private final Iterator i1;
            private final Iterator i2;
            {
                this.i1 = iterable1.iterator();
                this.i2 = iterable2.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i1.hasNext() && this.i2.hasNext();
            }

            @Override
            public Pair<T, E> next() {
                return Pair.create(this.i1.next(), this.i2.next());
            }

            @Override
            public void remove() {
                this.i1.remove();
                this.i2.remove();
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(209);
        }
        return iterable;
    }

    public static void swapElements(@NotNull List<?> list, int index1, int index2) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(210);
        }
        Object e1 = list.get(index1);
        Object e2 = list.get(index2);
        list.set(index1, e2);
        list.set(index2, e1);
    }

    @NotNull
    public static <T> List<T> collect(@NotNull Iterator<?> iterator, @NotNull FilteringIterator.InstanceOf<T> instanceOf) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(211);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(212);
        }
        return ContainerUtil.collect(FilteringIterator.create(iterator, instanceOf));
    }

    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Enumeration<? extends T> enumeration) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(213);
        }
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(214);
        }
        while (enumeration.hasMoreElements()) {
            T element = enumeration.nextElement();
            collection.add(element);
        }
    }

    @SafeVarargs
    @NotNull
    public static <T, C extends Collection<? super T>> C addAll(@NotNull C collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(215);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(216);
        }
        for (T element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(217);
        }
        return c;
    }

    @SafeVarargs
    @NotNull
    public static <T, C extends Collection<T>> C addAllNotNull(@NotNull C collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(218);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(219);
        }
        for (T element : elements) {
            if (element == null) continue;
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(220);
        }
        return c;
    }

    @SafeVarargs
    public static <T> boolean removeAll(@NotNull Collection<T> collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(221);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(222);
        }
        boolean modified = false;
        for (T element : elements) {
            modified |= collection.remove(element);
        }
        return modified;
    }

    public static <T> boolean retainAll(@NotNull Collection<T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(223);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(224);
        }
        boolean modified = false;
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (condition.value(next)) continue;
            iterator.remove();
            modified = true;
        }
        return modified;
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(@NotNull Iterable<? extends T> iterable, @NotNull Class<? extends U> aClass) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(225);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(226);
        }
        return ContainerUtil.findInstance(iterable.iterator(), aClass);
    }

    public static <T, U extends T> U findInstance(@NotNull Iterator<? extends T> iterator, @NotNull Class<? extends U> aClass) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(227);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(228);
        }
        return (U)ContainerUtil.find(iterator, FilteringIterator.instanceOf(aClass));
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(T @NotNull [] array, @NotNull Class<? extends U> aClass) {
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(229);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(230);
        }
        return (U)ContainerUtil.find(array, FilteringIterator.instanceOf(aClass));
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> List<T> concat(V @NotNull [] array, @NotNull Function<? super V, ? extends Collection<? extends T>> fun) {
        if (fun == null) {
            ContainerUtil.$$$reportNull$$$0(231);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(232);
        }
        return ContainerUtil.concat(Arrays.asList(array), fun);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> concat(@NotNull Iterable<? extends Collection<? extends T>> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(233);
        }
        int totalSize = 0;
        for (Collection<T> ts : list) {
            totalSize += ts.size();
        }
        ArrayList result = new ArrayList(totalSize);
        for (Collection<T> collection : list) {
            result.addAll(collection);
        }
        List list2 = result.isEmpty() ? Collections.emptyList() : result;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(234);
        }
        return list2;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> List<T> append(@NotNull List<? extends T> list, T ... values) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(235);
        }
        if (values == null) {
            ContainerUtil.$$$reportNull$$$0(236);
        }
        return ContainerUtil.concat(list, Arrays.asList(values));
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> List<T> prepend(@NotNull List<? extends T> list, T ... values) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(237);
        }
        if (values == null) {
            ContainerUtil.$$$reportNull$$$0(238);
        }
        return ContainerUtil.concat(Arrays.asList(values), list);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> concat(final @NotNull List<? extends T> list1, final @NotNull List<? extends T> list2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(239);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(240);
        }
        if (list1.isEmpty() && list2.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(241);
            }
            return list;
        }
        if (list1.isEmpty()) {
            List<T> list = list2;
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(242);
            }
            return list;
        }
        if (list2.isEmpty()) {
            List<T> list = list1;
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(243);
            }
            return list;
        }
        final int size1 = list1.size();
        final int size = size1 + list2.size();
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index < size1) {
                    return list1.get(index);
                }
                return list2.get(index - size1);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> concat(final @NotNull Iterable<? extends T> it1, final @NotNull Iterable<? extends T> it2) {
        if (it1 == null) {
            ContainerUtil.$$$reportNull$$$0(244);
        }
        if (it2 == null) {
            ContainerUtil.$$$reportNull$$$0(245);
        }
        return new Iterable<T>(){

            @Override
            public void forEach(Consumer<? super T> action) {
                it1.forEach(action);
                it2.forEach(action);
            }

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<? extends T> it;
                    boolean firstFinished;
                    {
                        this.it = it1.iterator();
                        this.advance();
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.firstFinished || this.it.hasNext();
                    }

                    @Override
                    public T next() {
                        Object value = this.it.next();
                        this.advance();
                        return value;
                    }

                    private void advance() {
                        if (!this.firstFinished && !this.it.hasNext()) {
                            this.it = it2.iterator();
                            this.firstFinished = true;
                        }
                    }
                };
            }
        };
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> concat(Iterable<? extends T> ... iterables) {
        if (iterables == null) {
            ContainerUtil.$$$reportNull$$$0(246);
        }
        if (iterables.length == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(247);
            }
            return list;
        }
        if (iterables.length == 1) {
            Iterable<? extends T> iterable = iterables[0];
            if (iterable == null) {
                ContainerUtil.$$$reportNull$$$0(248);
            }
            return iterable;
        }
        Iterable iterable = () -> {
            Iterator[] iterators = new Iterator[iterables.length];
            for (int i = 0; i < iterables.length; ++i) {
                Iterable iterable = iterables[i];
                iterators[i] = iterable.iterator();
            }
            return ContainerUtil.concatIterators(iterators);
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(249);
        }
        return iterable;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> concatIterators(Iterator<? extends T> ... iterators) {
        if (iterators == null) {
            ContainerUtil.$$$reportNull$$$0(250);
        }
        return new SequenceIterator<T>(iterators);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> concatIterators(@NotNull Collection<? extends Iterator<? extends T>> iterators) {
        if (iterators == null) {
            ContainerUtil.$$$reportNull$$$0(251);
        }
        return new SequenceIterator(iterators);
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> concat(T[] ... arrays) {
        Iterable iterable = () -> {
            Iterator[] iterators = new Iterator[arrays.length];
            for (int i = 0; i < arrays.length; ++i) {
                iterators[i] = ContainerUtil.iterate(arrays[i]);
            }
            return ContainerUtil.concatIterators(iterators);
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(252);
        }
        return iterable;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> List<T> concat(final List<? extends T> ... lists) {
        if (lists == null) {
            ContainerUtil.$$$reportNull$$$0(253);
        }
        int size = 0;
        for (List<T> list : lists) {
            size += list.size();
        }
        if (size == 0) {
            return ContainerUtil.emptyList();
        }
        final int finalSize = size;
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index >= 0 && index < finalSize) {
                    int from = 0;
                    for (List each : lists) {
                        if (from <= index && index < from + each.size()) {
                            return each.get(index - from);
                        }
                        from += each.size();
                    }
                    if (from != finalSize) {
                        throw new ConcurrentModificationException("The list has changed. Its size was " + finalSize + "; now it's " + from);
                    }
                }
                throw new IndexOutOfBoundsException("index: " + index + "; size: " + this.size());
            }

            @Override
            public int size() {
                return finalSize;
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> concat(@NotNull List<List<? extends T>> lists) {
        if (lists == null) {
            ContainerUtil.$$$reportNull$$$0(254);
        }
        return ContainerUtil.concat(lists.toArray(new List[0]));
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> List<V> concat(@NotNull Iterable<? extends T> list, @NotNull Function<? super T, ? extends Collection<? extends V>> listGenerator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(255);
        }
        if (listGenerator == null) {
            ContainerUtil.$$$reportNull$$$0(256);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T v : list) {
            result.addAll(listGenerator.fun(v));
        }
        List<T> list2 = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(257);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> boolean intersects(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(258);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(259);
        }
        if (collection1.size() <= collection2.size()) {
            for (T t : collection1) {
                if (!collection2.contains(t)) continue;
                return true;
            }
        } else {
            for (T t : collection2) {
                if (!collection1.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Collection<T> intersection(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(260);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(261);
        }
        if (collection1.isEmpty() || collection2.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T t : collection1) {
            if (!collection2.contains(t)) continue;
            result.add(t);
        }
        List<T> list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(262);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static <E extends Enum<E>> EnumSet<E> intersection(@NotNull EnumSet<E> collection1, @NotNull EnumSet<E> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(263);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(264);
        }
        if (collection1.isEmpty()) {
            EnumSet<E> enumSet = collection1;
            if (enumSet == null) {
                ContainerUtil.$$$reportNull$$$0(265);
            }
            return enumSet;
        }
        if (collection2.isEmpty()) {
            EnumSet<E> enumSet = collection2;
            if (enumSet == null) {
                ContainerUtil.$$$reportNull$$$0(266);
            }
            return enumSet;
        }
        EnumSet<E> result = EnumSet.copyOf(collection1);
        result.retainAll(collection2);
        EnumSet<E> enumSet = result;
        if (enumSet == null) {
            ContainerUtil.$$$reportNull$$$0(267);
        }
        return enumSet;
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<? extends T> items) {
        return ContainerUtil.getFirstItem(items, null);
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable List<? extends T> items) {
        return items == null || items.isEmpty() ? null : (T)items.get(0);
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<? extends T> items, @Nullable T defaultResult) {
        return items == null || items.isEmpty() ? defaultResult : items.iterator().next();
    }

    @Contract(pure=true)
    public static <T> T getOnlyItem(@Nullable Collection<? extends T> items) {
        return ContainerUtil.getOnlyItem(items, null);
    }

    @Contract(pure=true)
    public static <T> T getOnlyItem(@Nullable Collection<? extends T> items, @Nullable T defaultResult) {
        return items == null || items.size() != 1 ? defaultResult : items.iterator().next();
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> getFirstItems(@NotNull List<T> items, int maxItems) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(268);
        }
        if (maxItems < 0) {
            throw new IllegalArgumentException("Expected non-negative maxItems; got: " + maxItems);
        }
        List<T> list = maxItems >= items.size() ? items : items.subList(0, maxItems);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(269);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T> T iterateAndGetLastItem(@NotNull Iterable<? extends T> items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(270);
        }
        Iterator<T> itr = items.iterator();
        T res = null;
        while (itr.hasNext()) {
            res = itr.next();
        }
        return res;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, U> Iterator<U> mapIterator(final @NotNull Iterator<? extends T> iterator, final @NotNull Function<? super T, ? extends U> mapper) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(271);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(272);
        }
        return new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public U next() {
                return mapper.fun(iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> filterIterator(final @NotNull Iterator<? extends T> iterator, final @NotNull Condition<? super T> filter2) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(273);
        }
        if (filter2 == null) {
            ContainerUtil.$$$reportNull$$$0(274);
        }
        return new Iterator<T>(){
            T next;
            boolean hasNext;
            {
                this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            private void findNext() {
                this.hasNext = false;
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    if (!filter2.value(t)) continue;
                    this.next = t;
                    this.hasNext = true;
                    break;
                }
            }

            @Override
            public T next() {
                if (this.hasNext) {
                    Object result = this.next;
                    this.findNext();
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @Contract(pure=true)
    public static <T> T getLastItem(@Nullable List<? extends T> list, @Nullable T def) {
        return ContainerUtil.isEmpty(list) ? def : list.get(list.size() - 1);
    }

    @Contract(pure=true)
    public static <T> T getLastItem(@Nullable List<? extends T> list) {
        return ContainerUtil.getLastItem(list, null);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Collection<T> subtract(@NotNull Collection<? extends T> from, @NotNull Collection<? extends T> what) {
        if (from == null) {
            ContainerUtil.$$$reportNull$$$0(275);
        }
        if (what == null) {
            ContainerUtil.$$$reportNull$$$0(276);
        }
        HashSet<T> set = new HashSet<T>(from);
        set.removeAll(what);
        Collection<T> collection = set.isEmpty() ? ContainerUtil.emptyList() : set;
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(277);
        }
        return collection;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] toArray(@NotNull Collection<T> c, @NotNull ArrayFactory<? extends T> factory) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(278);
        }
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(279);
        }
        T[] a = factory.create(c.size());
        T[] TArray = c.toArray(a);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(280);
        }
        return TArray;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] toArray(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<? extends T> factory) {
        if (c1 == null) {
            ContainerUtil.$$$reportNull$$$0(281);
        }
        if (c2 == null) {
            ContainerUtil.$$$reportNull$$$0(282);
        }
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(283);
        }
        T[] TArray = ArrayUtil.mergeCollections(c1, c2, factory);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(284);
        }
        return TArray;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] mergeCollectionsToArray(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<? extends T> factory) {
        if (c1 == null) {
            ContainerUtil.$$$reportNull$$$0(285);
        }
        if (c2 == null) {
            ContainerUtil.$$$reportNull$$$0(286);
        }
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(287);
        }
        T[] TArray = ArrayUtil.mergeCollections(c1, c2, factory);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(288);
        }
        return TArray;
    }

    public static <T extends Comparable<? super T>> void sort(@NotNull List<T> list) {
        int size;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(289);
        }
        if ((size = list.size()) < 2) {
            return;
        }
        if (size == 2) {
            Comparable t1;
            Comparable t0 = (Comparable)list.get(0);
            if (t0.compareTo(t1 = (Comparable)list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    Comparable tj;
                    Comparable ti = (Comparable)list.get(i);
                    if (ti.compareTo(tj = (Comparable)list.get(j)) >= 0) continue;
                    list.set(i, tj);
                    list.set(j, ti);
                }
            }
        } else {
            Collections.sort(list);
        }
    }

    public static <T> void sort(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        int size;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(290);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(291);
        }
        if ((size = list.size()) < 2) {
            return;
        }
        if (size == 2) {
            T t1;
            T t0 = list.get(0);
            if (comparator.compare(t0, t1 = list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T tj;
                    T ti = list.get(i);
                    if (comparator.compare(ti, tj = list.get(j)) >= 0) continue;
                    list.set(i, tj);
                    list.set(j, ti);
                }
            }
        } else {
            list.sort(comparator);
        }
    }

    public static <T extends Comparable<? super T>> void sort(T @NotNull [] a) {
        int size;
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(292);
        }
        if ((size = a.length) < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (t0.compareTo(t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = a[i];
                    T tj = a[j];
                    if (ti.compareTo(tj) >= 0) continue;
                    a[i] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> sorted(@NotNull Collection<? extends T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(293);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(294);
        }
        return ContainerUtil.sorted(list, comparator);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> sorted(@NotNull Iterable<? extends T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(295);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(296);
        }
        ArrayList<? extends T> sorted = ContainerUtil.newArrayList(list);
        ContainerUtil.sort(sorted, comparator);
        ArrayList<? extends T> arrayList = sorted;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(297);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static <T extends Comparable<? super T>> List<T> sorted(@NotNull Collection<? extends T> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(298);
        }
        ArrayList<T> result = new ArrayList<T>(list);
        result.sort(null);
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(299);
        }
        return arrayList;
    }

    public static <T> void sort(T @NotNull [] a, @NotNull Comparator<? super T> comparator) {
        int size;
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(300);
        }
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(301);
        }
        if ((size = a.length) < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (comparator.compare(t0, t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = a[i];
                    T tj = a[j];
                    if (comparator.compare(ti, tj) >= 0) continue;
                    a[i] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a, comparator);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> List<V> map(@NotNull Iterable<? extends T> iterable, @NotNull Function<? super T, ? extends V> mapping) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(302);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(303);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T t : iterable) {
            result.add(mapping.fun(t));
        }
        List<T> list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(304);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> List<V> map(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(305);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(306);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(mapping.fun(t));
        }
        ArrayList<V> arrayList = list;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(307);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @NotNull List<@NotNull V> mapNotNull(T @NotNull [] array, @NotNull Function<? super T, ? extends @Nullable V> mapping) {
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(308);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(309);
        }
        if (array.length == 0) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(array.length);
        for (T t : array) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        List<T> list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(310);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @NotNull V @NotNull [] mapNotNull(T @NotNull [] array, @NotNull Function<? super T, ? extends @Nullable V> mapping, V @NotNull [] emptyArray) {
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(311);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(312);
        }
        if (emptyArray == null) {
            ContainerUtil.$$$reportNull$$$0(313);
        }
        assert (emptyArray.length == 0) : "You must pass an empty array";
        ArrayList<V> result = new ArrayList<V>(array.length);
        for (T t : array) {
            V v = mapping.fun(t);
            if (v == null) continue;
            result.add(v);
        }
        if (result.isEmpty()) {
            if (emptyArray == null) {
                ContainerUtil.$$$reportNull$$$0(314);
            }
            return emptyArray;
        }
        V[] VArray = result.toArray(emptyArray);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(315);
        }
        return VArray;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @NotNull List<@NotNull V> mapNotNull(@NotNull Iterable<? extends T> iterable, @NotNull Function<? super T, ? extends @Nullable V> mapping) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(316);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(317);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T t : iterable) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        List<T> list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(318);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @NotNull List<@NotNull V> mapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends @Nullable V> mapping) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(319);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(320);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(collection.size());
        for (T t : collection) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        List<T> list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(321);
        }
        return list;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> List<T> packNullables(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(322);
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T element : elements) {
            ContainerUtil.addIfNotNull(list, element);
        }
        List<T> list2 = list.isEmpty() ? ContainerUtil.emptyList() : list;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(323);
        }
        return list2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> List<V> map(T @NotNull [] array, @NotNull Function<? super T, ? extends V> mapping) {
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(324);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(325);
        }
        ArrayList<T> result = new ArrayList<T>(array.length);
        for (T t : array) {
            result.add(mapping.fun(t));
        }
        List<T> list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(326);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T, V> V @NotNull [] map(T @NotNull [] arr, @NotNull Function<? super T, ? extends V> mapping, V @NotNull [] emptyArray) {
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(327);
        }
        if (arr == null) {
            ContainerUtil.$$$reportNull$$$0(328);
        }
        if (emptyArray == null) {
            ContainerUtil.$$$reportNull$$$0(329);
        }
        if (arr.length == 0) {
            assert (emptyArray.length == 0) : "You must pass an empty array";
            if (emptyArray == null) {
                ContainerUtil.$$$reportNull$$$0(330);
            }
            return emptyArray;
        }
        V[] result = emptyArray.length < arr.length ? Arrays.copyOf(emptyArray, arr.length) : emptyArray;
        for (int i = 0; i < arr.length; ++i) {
            result[i] = mapping.fun(arr[i]);
        }
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(331);
        }
        return result;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> set(T ... items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(332);
        }
        return new HashSet<T>(Arrays.asList(items));
    }

    public static <K, V> void putIfNotNull(K key, @Nullable V value, @NotNull Map<? super K, ? super V> result) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(333);
        }
        if (value != null) {
            result.put(key, value);
        }
    }

    public static <K, V> void putIfNotNull(K key, @Nullable Collection<? extends V> value, @NotNull MultiMap<? super K, ? super V> result) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(334);
        }
        if (value != null) {
            result.putValues(key, value);
        }
    }

    public static <K, V> void putIfNotNull(K key, @Nullable V value, @NotNull MultiMap<? super K, ? super V> result) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(335);
        }
        if (value != null) {
            result.putValue(key, value);
        }
    }

    public static <T> void add(T element, @NotNull Collection<? super T> result, @NotNull Disposable parentDisposable) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(336);
        }
        if (parentDisposable == null) {
            ContainerUtil.$$$reportNull$$$0(337);
        }
        if (result.add(element)) {
            Disposer.register(parentDisposable, () -> result.remove(element));
        }
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> createMaybeSingletonList(@Nullable T element) {
        List<T> list = element == null ? ContainerUtil.emptyList() : Collections.singletonList(element);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(338);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> createMaybeSingletonSet(@Nullable T element) {
        Set set = element == null ? Collections.emptySet() : Collections.singleton(element);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(339);
        }
        return set;
    }

    @NotNull
    public static <T, V> V getOrCreate(@NotNull Map<T, V> result, T key, @NotNull V defaultValue) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(340);
        }
        if (defaultValue == null) {
            ContainerUtil.$$$reportNull$$$0(341);
        }
        Object object = result.computeIfAbsent(key, __ -> defaultValue);
        if (object == null) {
            ContainerUtil.$$$reportNull$$$0(342);
        }
        return (V)object;
    }

    public static <T, V> V getOrCreate(@NotNull Map<T, V> result, T key, @NotNull Factory<? extends V> factory) {
        V value;
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(343);
        }
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(344);
        }
        if ((value = result.get(key)) == null) {
            value = factory.create();
            result.put(key, value);
        }
        return value;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> V getOrElse(@NotNull Map<? extends T, ? extends V> map2, T key, @NotNull V defValue) {
        V value;
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(345);
        }
        if (defValue == null) {
            ContainerUtil.$$$reportNull$$$0(346);
        }
        V v = (value = map2.get(key)) == null ? defValue : value;
        if (v == null) {
            ContainerUtil.$$$reportNull$$$0(347);
        }
        return v;
    }

    @Contract(pure=true)
    public static <T> boolean and(T @NotNull [] iterable, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(348);
        }
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(349);
        }
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(350);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(351);
        }
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean exists(T @NotNull [] array, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(352);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(353);
        }
        for (T t : array) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> boolean exists(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(354);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(355);
        }
        return ContainerUtil.or(iterable, condition);
    }

    @Contract(pure=true)
    public static <T> boolean or(T @NotNull [] iterable, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(356);
        }
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(357);
        }
        return ContainerUtil.exists(iterable, condition);
    }

    @Contract(pure=true)
    public static <T> boolean or(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(358);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(359);
        }
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> int count(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(360);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(361);
        }
        int count = 0;
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            ++count;
        }
        return count;
    }

    @SafeVarargs
    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> List<T> list(T ... items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(362);
        }
        List<T> list = Arrays.asList(items);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(363);
        }
        return list;
    }

    public static <T> void quickSort(@NotNull List<? extends T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(364);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(365);
        }
        ContainerUtil.quickSort(list, comparator, 0, list.size());
    }

    private static <T> void quickSort(@NotNull List<? extends T> x, @NotNull Comparator<? super T> comparator, int off, int len) {
        int c;
        int a;
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(366);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(367);
        }
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comparator.compare(x.get(j), x.get(j - 1)) < 0; --j) {
                    ContainerUtil.swapElements(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ContainerUtil.med3(x, comparator, l, l + s, l + 2 * s);
                m = ContainerUtil.med3(x, comparator, m - s, m, m + s);
                n = ContainerUtil.med3(x, comparator, n - 2 * s, n - s, n);
            }
            m = ContainerUtil.med3(x, comparator, l, m, n);
        }
        T v = x.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && comparator.compare(x.get(b), v) <= 0) {
                if (comparator.compare(x.get(b), v) == 0) {
                    ContainerUtil.swapElements(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(v, x.get(c)) <= 0) {
                if (comparator.compare(x.get(c), v) == 0) {
                    ContainerUtil.swapElements(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ContainerUtil.swapElements(x, b++, c--);
        }
        int s = Math.min(a - off, b - a);
        ContainerUtil.vecswap(x, off, b - s, s);
        int n = off + len;
        s = Math.min(d - c, n - d - 1);
        ContainerUtil.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ContainerUtil.quickSort(x, comparator, off, s);
        }
        if ((s = d - c) > 1) {
            ContainerUtil.quickSort(x, comparator, n - s, s);
        }
    }

    private static <T> int med3(@NotNull List<? extends T> x, @NotNull Comparator<? super T> comparator, int a, int b, int c) {
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(368);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(369);
        }
        return comparator.compare(x.get(a), x.get(b)) < 0 ? (comparator.compare(x.get(b), x.get(c)) < 0 ? b : (comparator.compare(x.get(a), x.get(c)) < 0 ? c : a)) : (comparator.compare(x.get(c), x.get(b)) < 0 ? b : (comparator.compare(x.get(c), x.get(a)) < 0 ? c : a));
    }

    private static <T> void vecswap(List<T> x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ContainerUtil.swapElements(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    @Contract(pure=true)
    @NotNull
    public static <E> List<E> flatten(Collection<E> @NotNull [] collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(370);
        }
        return ContainerUtil.flatten(Arrays.asList(collections));
    }

    @NotNull
    public static <T> List<T> removeDuplicatesFromSorted(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(371);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(372);
        }
        Object prev = null;
        ArrayList<T> result = null;
        for (int i = 0; i < list.size(); ++i) {
            int cmp;
            T t = list.get(i);
            if (t == null) {
                throw new IllegalArgumentException("get(" + i + ") = null");
            }
            int n = cmp = prev == null ? -1 : comparator.compare(prev, t);
            if (cmp < 0) {
                if (result != null) {
                    result.add(t);
                }
            } else if (cmp == 0) {
                if (result == null) {
                    result = new ArrayList<T>(list.size());
                    result.addAll(list.subList(0, i));
                }
            } else {
                throw new IllegalArgumentException("List must be sorted but get(" + (i - 1) + ")=" + list.get(i - 1) + " > get(" + i + ")=" + t);
            }
            prev = t;
        }
        List<T> list2 = result == null ? list : result;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(373);
        }
        return list2;
    }

    @Contract(pure=true)
    @NotNull
    public static <E> List<E> flatten(@NotNull Iterable<? extends Collection<? extends E>> collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(374);
        }
        int totalSize = 0;
        for (Collection<E> list : collections) {
            totalSize += list.size();
        }
        ArrayList result = new ArrayList(totalSize);
        for (Collection<E> collection : collections) {
            result.addAll(collection);
        }
        List list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(375);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static <E> List<E> flattenIterables(@NotNull Iterable<? extends Iterable<? extends E>> collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(376);
        }
        int totalSize = 0;
        for (Iterable<E> iterable : collections) {
            totalSize += iterable instanceof Collection ? ((Collection)iterable).size() : 10;
        }
        ArrayList result = new ArrayList(totalSize);
        for (Iterable<E> list : collections) {
            for (E e : list) {
                result.add(e);
            }
        }
        List list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(377);
        }
        return list;
    }

    @NotNull
    public static <T, V> List<V> flatMap(@NotNull Iterable<? extends T> iterable, @NotNull @NotNull Function<? super T, @NotNull ? extends List<V>> mapping) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(378);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(379);
        }
        List<V> result = null;
        boolean isOriginal = true;
        for (T each : iterable) {
            List<V> toAdd = mapping.fun(each);
            if (toAdd.isEmpty()) continue;
            if (result == null) {
                result = toAdd;
                continue;
            }
            if (isOriginal) {
                List<V> original = result;
                result = new ArrayList<V>(Math.max(10, result.size() + toAdd.size()));
                result.addAll(original);
                isOriginal = false;
            }
            result.addAll(toAdd);
        }
        List<T> list = result == null ? ContainerUtil.emptyList() : Collections.unmodifiableList(result);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(380);
        }
        return list;
    }

    public static <K, V> V @NotNull [] convert(K @NotNull [] from, V @NotNull [] to, @NotNull Function<? super K, ? extends V> fun) {
        if (fun == null) {
            ContainerUtil.$$$reportNull$$$0(381);
        }
        if (from == null) {
            ContainerUtil.$$$reportNull$$$0(382);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(383);
        }
        if (to.length < from.length) {
            to = ArrayUtil.newArray(ArrayUtil.getComponentType(to), from.length);
        }
        for (int i = 0; i < from.length; ++i) {
            to[i] = fun.fun(from[i]);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(384);
        }
        return to;
    }

    @Contract(pure=true)
    public static <T> boolean containsIdentity(@NotNull Iterable<? extends T> list, T element) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(385);
        }
        for (T t : list) {
            if (t != element) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> int indexOfIdentity(@NotNull List<? extends T> list, T element) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(386);
        }
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            if (list.get(i) != element) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> boolean equalsIdentity(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(387);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(388);
        }
        int listSize = list1.size();
        if (list2.size() != listSize) {
            return false;
        }
        for (int i = 0; i < listSize; ++i) {
            if (list1.get(i) == list2.get(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean isSameElements(@NotNull Collection<? extends T> list1, @NotNull Collection<? extends T> list2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(389);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(390);
        }
        return list1.size() == list2.size() && list1.containsAll(list2);
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(391);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(392);
        }
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            T t = list.get(i);
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int lastIndexOf(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(393);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(394);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            T t = list.get(i);
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int lastIndexOfIdentity(@NotNull List<? extends T> list, T object) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(395);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            T t = list.get(i);
            if (t != object) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T, U extends T> U findLastInstance(@NotNull List<? extends T> list, @NotNull Class<? extends U> clazz) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(396);
        }
        if (clazz == null) {
            ContainerUtil.$$$reportNull$$$0(397);
        }
        int i = ContainerUtil.lastIndexOf(list, clazz::isInstance);
        return i < 0 ? null : (U)list.get(i);
    }

    @Contract(pure=true)
    public static <T, U extends T> int lastIndexOfInstance(@NotNull List<? extends T> list, @NotNull Class<U> clazz) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(398);
        }
        if (clazz == null) {
            ContainerUtil.$$$reportNull$$$0(399);
        }
        return ContainerUtil.lastIndexOf(list, clazz::isInstance);
    }

    @Contract(pure=true)
    @NotNull
    public static <A, B> Map<B, A> reverseMap(@NotNull Map<? extends A, ? extends B> map2) {
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(400);
        }
        HashMap<B, A> result = new HashMap<B, A>();
        for (Map.Entry<A, B> entry : map2.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        HashMap<B, A> hashMap = result;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(401);
        }
        return hashMap;
    }

    @Contract(value="null -> null; !null -> !null")
    public static <T> List<T> trimToSize(@Nullable List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return list;
    }

    @Deprecated
    @Contract(value=" -> new", pure=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static <T> Stack<T> newStack() {
        return new Stack();
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> emptyList() {
        List list = ContainerUtilRt.emptyList();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(402);
        }
        return list;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> CopyOnWriteArrayList<T> createEmptyCOWList() {
        return new CopyOnWriteArrayList<T>(ContainerUtil.emptyList());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> List<T> createLockFreeCopyOnWriteList() {
        return ContainerUtil.createConcurrentList();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> List<T> createLockFreeCopyOnWriteList(@NotNull Collection<? extends T> c) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(403);
        }
        return new LockFreeCopyOnWriteArrayList<T>(c);
    }

    @Deprecated
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> ConcurrentLongObjectMap<V> createConcurrentLongObjectMap() {
        return new ConcurrentLongObjectHashMap();
    }

    @Deprecated
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectMap() {
        return new ConcurrentIntObjectHashMap();
    }

    @Deprecated
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectWeakValueMap() {
        return new ConcurrentIntKeyWeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakValueMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(404);
        }
        return concurrentMap;
    }

    @Contract(value="_,_,_,_ -> new", pure=true)
    @NotNull
    static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(405);
        }
        return new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftKeySoftValueMap() {
        return new ConcurrentSoftKeySoftValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.canonical());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap() {
        return new ConcurrentWeakKeySoftValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.canonical());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap() {
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.canonical());
    }

    @ApiStatus.Internal
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(406);
        }
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), strategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftValueMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(407);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap() {
        return new ConcurrentSoftHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(408);
        }
        return concurrentMap;
    }

    @ApiStatus.Internal
    @Contract(value="_,_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(409);
        }
        return new ConcurrentSoftHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @NotNull
    public static <K> HashingStrategy<K> createHashingStrategy(final @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(410);
        }
        return new HashingStrategy<K>(){

            @Override
            public int hashCode(@Nullable K object) {
                return hashingStrategy.computeHashCode(object);
            }

            @Override
            public boolean equals(@Nullable K o1, @Nullable K o2) {
                return hashingStrategy.equals(o1, o2);
            }
        };
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(411);
        }
        return new ConcurrentWeakHashMap(initialCapacity, loadFactor, concurrencyLevel, ContainerUtil.createHashingStrategy(hashingStrategy));
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(@NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(412);
        }
        return new ConcurrentWeakHashMap(ContainerUtil.createHashingStrategy(hashingStrategy));
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> ConcurrentList<T> createConcurrentList() {
        return new LockFreeCopyOnWriteArrayList();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> ConcurrentList<T> createConcurrentList(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(413);
        }
        return new LockFreeCopyOnWriteArrayList<T>(collection);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static <T> void addIfNotNull(@Nullable T element, @NotNull Collection<? super T> result) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(414);
        }
        ContainerUtil.addIfNotNull(result, element);
    }

    public static <T> void addIfNotNull(@NotNull Collection<? super T> result, @Nullable T element) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(415);
        }
        if (element != null) {
            result.add(element);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> List<V> map2List(T @NotNull [] array, @NotNull Function<? super T, ? extends V> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(416);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(417);
        }
        if (array.length == 0) {
            return ContainerUtil.emptyList();
        }
        ArrayList<V> list = new ArrayList<V>(array.length);
        for (T t : array) {
            list.add(mapper.fun(t));
        }
        ArrayList<V> arrayList = list;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(418);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(419);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(420);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(mapper.fun(t));
        }
        ArrayList<V> arrayList = list;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(421);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> List<Pair<K, V>> map2List(@NotNull Map<? extends K, ? extends V> map2) {
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(422);
        }
        if (map2.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<Pair<K, V>> result = new ArrayList<Pair<K, V>>(map2.size());
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            result.add(Pair.create(entry.getKey(), entry.getValue()));
        }
        ArrayList<Pair<K, V>> arrayList = result;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(423);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> Set<V> map2Set(T @NotNull [] array, @NotNull Function<? super T, ? extends V> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(424);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(425);
        }
        if (array.length == 0) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(426);
            }
            return set;
        }
        HashSet<V> set = new HashSet<V>(array.length);
        for (T t : array) {
            set.add(mapper.fun(t));
        }
        HashSet<V> hashSet = set;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(427);
        }
        return hashSet;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(428);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(429);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(430);
            }
            return set;
        }
        HashSet<V> set = new HashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        HashSet<V> hashSet = set;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(431);
        }
        return hashSet;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> Set<V> map2LinkedSet(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(432);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(433);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(434);
            }
            return set;
        }
        LinkedHashSet<V> set = new LinkedHashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        LinkedHashSet<V> linkedHashSet = set;
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(435);
        }
        return linkedHashSet;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> Set<V> map2SetNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(436);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(437);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(438);
            }
            return set;
        }
        HashSet set = new HashSet(collection.size());
        for (T t : collection) {
            V value = mapper.fun(t);
            if (value == null) continue;
            set.add(value);
        }
        Set set2 = set.isEmpty() ? Collections.emptySet() : set;
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(439);
        }
        return set2;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Contract(mutates="param2")
    public static <T> T @NotNull [] toArray(@NotNull List<T> collection, T @NotNull [] array) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(440);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(441);
        }
        T[] TArray = collection.toArray(array);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(442);
        }
        return TArray;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Contract(mutates="param2")
    public static <T> T @NotNull [] toArray(@NotNull Collection<? extends T> c, T @NotNull [] sample) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(443);
        }
        if (sample == null) {
            ContainerUtil.$$$reportNull$$$0(444);
        }
        T[] TArray = c.toArray(sample);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(445);
        }
        return TArray;
    }

    public static <T> T @NotNull [] copyAndClear(@NotNull Collection<? extends T> collection, @NotNull ArrayFactory<? extends T> factory, boolean clear) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(446);
        }
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(447);
        }
        int size = collection.size();
        T[] a = factory.create(size);
        if (size > 0) {
            a = collection.toArray(a);
            if (clear) {
                collection.clear();
            }
        }
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(448);
        }
        return a;
    }

    @NotNull
    public static <T> List<T> copyList(@NotNull List<? extends T> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(449);
        }
        if (list == Collections.emptyList()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(450);
            }
            return list2;
        }
        if (list.size() == 1) {
            return new SmartList<T>(list.get(0));
        }
        if (list.isEmpty()) {
            return new SmartList();
        }
        return new ArrayList<T>(list);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Collection<T> toCollection(@NotNull Iterable<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(451);
        }
        return iterable instanceof Collection ? (ArrayList<? extends T>)iterable : ContainerUtil.newArrayList(iterable);
    }

    @NotNull
    public static <T> List<T> toList(@NotNull Enumeration<? extends T> enumeration) {
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(452);
        }
        if (!enumeration.hasMoreElements()) {
            List list = Collections.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(453);
            }
            return list;
        }
        SmartList<T> result = new SmartList<T>();
        while (enumeration.hasMoreElements()) {
            result.add(enumeration.nextElement());
        }
        SmartList<T> smartList = result;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(454);
        }
        return smartList;
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(@Nullable Collection<? extends T> collection) {
        return collection == null || collection.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable Map<?, ?> map2) {
        return map2 == null || map2.isEmpty();
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> notNullize(@Nullable List<T> list) {
        List<T> list2 = list == null ? ContainerUtil.emptyList() : list;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(455);
        }
        return list2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> notNullize(@Nullable Set<T> set) {
        Set set2 = set == null ? Collections.emptySet() : set;
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(456);
        }
        return set2;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> notNullize(@Nullable Map<K, V> map2) {
        Map map3 = map2 == null ? Collections.emptyMap() : map2;
        if (map3 == null) {
            ContainerUtil.$$$reportNull$$$0(457);
        }
        return map3;
    }

    @Contract(pure=true)
    public static <T> boolean startsWith(@NotNull List<? extends T> list, @NotNull List<? extends T> prefix) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(458);
        }
        if (prefix == null) {
            ContainerUtil.$$$reportNull$$$0(459);
        }
        return list.size() >= prefix.size() && list.subList(0, prefix.size()).equals(prefix);
    }

    @Contract(pure=true)
    @Nullable
    public static <C extends Collection<?>> C nullize(@Nullable C collection) {
        return ContainerUtil.isEmpty(collection) ? null : (C)collection;
    }

    @Contract(pure=true)
    public static <T extends Comparable<? super T>> int compareLexicographically(@NotNull List<? extends T> o1, @NotNull List<? extends T> o2) {
        if (o1 == null) {
            ContainerUtil.$$$reportNull$$$0(460);
        }
        if (o2 == null) {
            ContainerUtil.$$$reportNull$$$0(461);
        }
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int result = Comparing.compare((Comparable)o1.get(i), (Comparable)o2.get(i));
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(o1.size(), o2.size());
    }

    @Contract(pure=true)
    public static <T> int compareLexicographically(@NotNull List<? extends T> o1, @NotNull List<? extends T> o2, @NotNull Comparator<? super T> comparator) {
        if (o1 == null) {
            ContainerUtil.$$$reportNull$$$0(462);
        }
        if (o2 == null) {
            ContainerUtil.$$$reportNull$$$0(463);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(464);
        }
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int result = comparator.compare(o1.get(i), o2.get(i));
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(o1.size(), o2.size());
    }

    @Contract(pure=true)
    @NotNull
    public static String toString(@NotNull Map<?, ?> map2) {
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(465);
        }
        StringBuilder sb = new StringBuilder("{");
        Iterator<Map.Entry<?, ?>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry = iterator.next();
            sb.append(entry.getKey()).append('=').append(entry.getValue());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('}');
        String string = sb.toString();
        if (string == null) {
            ContainerUtil.$$$reportNull$$$0(466);
        }
        return string;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakKeySoftValueMap() {
        return new WeakKeySoftValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakKeyWeakValueMap() {
        return new WeakKeyWeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftKeySoftValueMap() {
        return new SoftKeySoftValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftValueMap() {
        return new SoftValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakValueMap() {
        return new WeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftMap() {
        return new SoftHashMap(4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    static <K, V> Map<K, V> createSoftMap(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(467);
        }
        return new SoftHashMap(strategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap() {
        return ContainerUtil.createWeakMap(4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity) {
        return new WeakHashMap(initialCapacity, 0.8f, HashingStrategy.canonical());
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity, float loadFactor, @NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(468);
        }
        return new WeakHashMap(initialCapacity, loadFactor, strategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> Set<T> createWeakSet() {
        return new WeakHashSet();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> IntObjectMap<T> createIntKeyWeakValueMap() {
        return new IntKeyWeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> ObjectIntMap<T> createWeakKeyIntValueMap() {
        return new WeakKeyIntValueHashMap();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> List<T> immutableCopy(@NotNull List<? extends T> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(469);
        }
        if (list.isEmpty()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(470);
            }
            return list2;
        }
        if (list.size() == 1) {
            List<T> list3 = Collections.singletonList(list.get(0));
            if (list3 == null) {
                ContainerUtil.$$$reportNull$$$0(471);
            }
            return list3;
        }
        return ContainerUtil.immutableList(list.toArray());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 52: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 67: 
            case 71: 
            case 72: 
            case 75: 
            case 83: 
            case 85: 
            case 95: 
            case 98: 
            case 101: 
            case 107: 
            case 108: 
            case 133: 
            case 138: 
            case 140: 
            case 148: 
            case 152: 
            case 156: 
            case 161: 
            case 170: 
            case 173: 
            case 177: 
            case 180: 
            case 183: 
            case 186: 
            case 187: 
            case 190: 
            case 195: 
            case 197: 
            case 203: 
            case 204: 
            case 206: 
            case 209: 
            case 217: 
            case 220: 
            case 234: 
            case 241: 
            case 242: 
            case 243: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 257: 
            case 262: 
            case 265: 
            case 266: 
            case 267: 
            case 269: 
            case 277: 
            case 280: 
            case 284: 
            case 288: 
            case 297: 
            case 299: 
            case 304: 
            case 307: 
            case 310: 
            case 314: 
            case 315: 
            case 318: 
            case 321: 
            case 323: 
            case 326: 
            case 330: 
            case 331: 
            case 338: 
            case 339: 
            case 342: 
            case 347: 
            case 363: 
            case 373: 
            case 375: 
            case 377: 
            case 380: 
            case 384: 
            case 401: 
            case 402: 
            case 404: 
            case 407: 
            case 408: 
            case 418: 
            case 421: 
            case 423: 
            case 426: 
            case 427: 
            case 430: 
            case 431: 
            case 434: 
            case 435: 
            case 438: 
            case 439: 
            case 442: 
            case 445: 
            case 448: 
            case 450: 
            case 453: 
            case 454: 
            case 455: 
            case 456: 
            case 457: 
            case 466: 
            case 470: 
            case 471: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 52: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 67: 
            case 71: 
            case 72: 
            case 75: 
            case 83: 
            case 85: 
            case 95: 
            case 98: 
            case 101: 
            case 107: 
            case 108: 
            case 133: 
            case 138: 
            case 140: 
            case 148: 
            case 152: 
            case 156: 
            case 161: 
            case 170: 
            case 173: 
            case 177: 
            case 180: 
            case 183: 
            case 186: 
            case 187: 
            case 190: 
            case 195: 
            case 197: 
            case 203: 
            case 204: 
            case 206: 
            case 209: 
            case 217: 
            case 220: 
            case 234: 
            case 241: 
            case 242: 
            case 243: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 257: 
            case 262: 
            case 265: 
            case 266: 
            case 267: 
            case 269: 
            case 277: 
            case 280: 
            case 284: 
            case 288: 
            case 297: 
            case 299: 
            case 304: 
            case 307: 
            case 310: 
            case 314: 
            case 315: 
            case 318: 
            case 321: 
            case 323: 
            case 326: 
            case 330: 
            case 331: 
            case 338: 
            case 339: 
            case 342: 
            case 347: 
            case 363: 
            case 373: 
            case 375: 
            case 377: 
            case 380: 
            case 384: 
            case 401: 
            case 402: 
            case 404: 
            case 407: 
            case 408: 
            case 418: 
            case 421: 
            case 423: 
            case 426: 
            case 427: 
            case 430: 
            case 431: 
            case 434: 
            case 435: 
            case 438: 
            case 439: 
            case 442: 
            case 445: 
            case 448: 
            case 450: 
            case 453: 
            case 454: 
            case 455: 
            case 456: 
            case 457: 
            case 466: 
            case 470: 
            case 471: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 52: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 67: 
            case 71: 
            case 72: 
            case 75: 
            case 83: 
            case 85: 
            case 95: 
            case 98: 
            case 101: 
            case 107: 
            case 108: 
            case 133: 
            case 138: 
            case 140: 
            case 148: 
            case 152: 
            case 156: 
            case 161: 
            case 170: 
            case 173: 
            case 177: 
            case 180: 
            case 183: 
            case 186: 
            case 187: 
            case 190: 
            case 195: 
            case 197: 
            case 203: 
            case 204: 
            case 206: 
            case 209: 
            case 217: 
            case 220: 
            case 234: 
            case 241: 
            case 242: 
            case 243: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 257: 
            case 262: 
            case 265: 
            case 266: 
            case 267: 
            case 269: 
            case 277: 
            case 280: 
            case 284: 
            case 288: 
            case 297: 
            case 299: 
            case 304: 
            case 307: 
            case 310: 
            case 314: 
            case 315: 
            case 318: 
            case 321: 
            case 323: 
            case 326: 
            case 330: 
            case 331: 
            case 338: 
            case 339: 
            case 342: 
            case 347: 
            case 363: 
            case 373: 
            case 375: 
            case 377: 
            case 380: 
            case 384: 
            case 401: 
            case 402: 
            case 404: 
            case 407: 
            case 408: 
            case 418: 
            case 421: 
            case 423: 
            case 426: 
            case 427: 
            case 430: 
            case 431: 
            case 434: 
            case 435: 
            case 438: 
            case 439: 
            case 442: 
            case 445: 
            case 448: 
            case 450: 
            case 453: 
            case 454: 
            case 455: 
            case 456: 
            case 457: 
            case 466: 
            case 470: 
            case 471: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 2: 
            case 50: 
            case 102: 
            case 168: 
            case 345: 
            case 400: 
            case 422: 
            case 465: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 6: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 7: 
            case 99: 
            case 103: 
            case 236: 
            case 238: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 16: 
            case 62: 
            case 110: 
            case 142: 
            case 143: 
            case 147: 
            case 176: 
            case 196: 
            case 230: 
            case 232: 
            case 309: 
            case 312: 
            case 325: 
            case 353: 
            case 417: 
            case 425: 
            case 441: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 17: 
            case 18: 
            case 35: 
            case 111: 
            case 116: 
            case 119: 
            case 121: 
            case 225: 
            case 302: 
            case 316: 
            case 349: 
            case 350: 
            case 354: 
            case 357: 
            case 358: 
            case 360: 
            case 378: 
            case 451: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalList";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 37: 
            case 65: 
            case 86: 
            case 88: 
            case 90: 
            case 92: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 139: 
            case 149: 
            case 153: 
            case 158: 
            case 160: 
            case 162: 
            case 165: 
            case 166: 
            case 171: 
            case 174: 
            case 179: 
            case 181: 
            case 185: 
            case 188: 
            case 191: 
            case 193: 
            case 201: 
            case 213: 
            case 215: 
            case 218: 
            case 221: 
            case 223: 
            case 305: 
            case 319: 
            case 413: 
            case 419: 
            case 428: 
            case 432: 
            case 436: 
            case 440: 
            case 446: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 38: 
            case 89: 
            case 94: 
            case 105: 
            case 117: 
            case 123: 
            case 125: 
            case 211: 
            case 227: 
            case 271: 
            case 273: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 46: 
            case 406: 
            case 467: 
            case 468: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 51: 
            case 70: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map2";
                break;
            }
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
            case 64: 
            case 84: 
            case 113: 
            case 127: 
            case 205: 
            case 210: 
            case 233: 
            case 235: 
            case 237: 
            case 255: 
            case 289: 
            case 290: 
            case 293: 
            case 295: 
            case 298: 
            case 364: 
            case 371: 
            case 385: 
            case 386: 
            case 391: 
            case 393: 
            case 395: 
            case 396: 
            case 398: 
            case 449: 
            case 458: 
            case 469: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouper";
                break;
            }
            case 69: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map1";
                break;
            }
            case 76: 
            case 80: 
            case 239: 
            case 387: 
            case 389: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 77: 
            case 81: 
            case 240: 
            case 388: 
            case 390: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
            case 78: 
            case 82: 
            case 291: 
            case 294: 
            case 296: 
            case 300: 
            case 365: 
            case 367: 
            case 369: 
            case 372: 
            case 464: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 79: 
            case 112: 
            case 114: 
            case 115: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendix";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueConvertor";
                break;
            }
            case 100: 
            case 104: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyConvertor";
                break;
            }
            case 109: 
            case 120: 
            case 126: 
            case 128: 
            case 157: 
            case 159: 
            case 167: 
            case 172: 
            case 192: 
            case 199: 
            case 202: 
            case 224: 
            case 348: 
            case 351: 
            case 352: 
            case 355: 
            case 356: 
            case 359: 
            case 361: 
            case 392: 
            case 394: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 122: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalTo";
                break;
            }
            case 129: 
            case 132: 
            case 134: 
            case 137: 
            case 141: 
            case 144: 
            case 146: 
            case 151: 
            case 154: 
            case 272: 
            case 416: 
            case 420: 
            case 424: 
            case 429: 
            case 433: 
            case 437: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 145: 
            case 150: 
            case 163: 
            case 164: 
            case 226: 
            case 228: 
            case 229: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 155: 
            case 383: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
            case 175: 
            case 178: 
            case 182: 
            case 184: 
            case 189: 
            case 212: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOf";
                break;
            }
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValues";
                break;
            }
            case 198: 
            case 214: 
            case 452: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumeration";
                break;
            }
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrays";
                break;
            }
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable1";
                break;
            }
            case 208: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable2";
                break;
            }
            case 231: 
            case 381: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 244: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it1";
                break;
            }
            case 245: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it2";
                break;
            }
            case 246: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterables";
                break;
            }
            case 250: 
            case 251: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterators";
                break;
            }
            case 253: 
            case 254: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 256: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listGenerator";
                break;
            }
            case 258: 
            case 260: 
            case 263: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection1";
                break;
            }
            case 259: 
            case 261: 
            case 264: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection2";
                break;
            }
            case 268: 
            case 270: 
            case 332: 
            case 362: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 274: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 275: 
            case 382: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 276: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 278: 
            case 403: 
            case 443: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 279: 
            case 283: 
            case 287: 
            case 344: 
            case 447: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 281: 
            case 285: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 282: 
            case 286: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 292: 
            case 301: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 303: 
            case 306: 
            case 308: 
            case 311: 
            case 317: 
            case 320: 
            case 324: 
            case 327: 
            case 379: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 313: 
            case 329: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyArray";
                break;
            }
            case 328: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr";
                break;
            }
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 340: 
            case 343: 
            case 414: 
            case 415: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 337: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 341: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 346: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defValue";
                break;
            }
            case 366: 
            case 368: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 370: 
            case 374: 
            case 376: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collections";
                break;
            }
            case 397: 
            case 399: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 405: 
            case 409: 
            case 410: 
            case 411: 
            case 412: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 444: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 459: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 460: 
            case 462: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 461: 
            case 463: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ar";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashMap";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashMap";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalStrategy";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "identityStrategy";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedList";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayList";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "newUnmodifiableList";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyCollection";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyList";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptySet";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyMap";
                break;
            }
            case 36: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashSet";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashOrEmptySet";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashSet";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "newConcurrentSet";
                break;
            }
            case 52: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSet";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSingletonList";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "groupBy";
                break;
            }
            case 71: 
            case 72: 
            case 262: 
            case 265: 
            case 266: 
            case 267: {
                objectArray = objectArray2;
                objectArray2[1] = "intersection";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "diff";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeSortedLists";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "subList";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromKeys";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromValues";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "classify";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyIterable";
                break;
            }
            case 133: 
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Map";
                break;
            }
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "map2MapNotNull";
                break;
            }
            case 148: 
            case 152: 
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Array";
                break;
            }
            case 161: 
            case 173: 
            case 177: 
            case 190: {
                objectArray = objectArray2;
                objectArray2[1] = "findAll";
                break;
            }
            case 170: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 180: 
            case 183: 
            case 186: 
            case 187: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllAsArray";
                break;
            }
            case 195: {
                objectArray = objectArray2;
                objectArray2[1] = "stringMap";
                break;
            }
            case 197: 
            case 203: 
            case 204: {
                objectArray = objectArray2;
                objectArray2[1] = "iterate";
                break;
            }
            case 206: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateBackward";
                break;
            }
            case 209: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 217: {
                objectArray = objectArray2;
                objectArray2[1] = "addAll";
                break;
            }
            case 220: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllNotNull";
                break;
            }
            case 234: 
            case 241: 
            case 242: 
            case 243: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 257: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 269: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstItems";
                break;
            }
            case 277: {
                objectArray = objectArray2;
                objectArray2[1] = "subtract";
                break;
            }
            case 280: 
            case 284: 
            case 442: 
            case 445: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 288: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeCollectionsToArray";
                break;
            }
            case 297: 
            case 299: {
                objectArray = objectArray2;
                objectArray2[1] = "sorted";
                break;
            }
            case 304: 
            case 307: 
            case 326: 
            case 330: 
            case 331: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 310: 
            case 314: 
            case 315: 
            case 318: 
            case 321: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNotNull";
                break;
            }
            case 323: {
                objectArray = objectArray2;
                objectArray2[1] = "packNullables";
                break;
            }
            case 338: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonList";
                break;
            }
            case 339: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonSet";
                break;
            }
            case 342: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 347: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrElse";
                break;
            }
            case 363: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 373: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatesFromSorted";
                break;
            }
            case 375: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 377: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenIterables";
                break;
            }
            case 380: {
                objectArray = objectArray2;
                objectArray2[1] = "flatMap";
                break;
            }
            case 384: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 401: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseMap";
                break;
            }
            case 402: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyList";
                break;
            }
            case 404: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakValueMap";
                break;
            }
            case 407: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftValueMap";
                break;
            }
            case 408: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakMap";
                break;
            }
            case 418: 
            case 421: 
            case 423: {
                objectArray = objectArray2;
                objectArray2[1] = "map2List";
                break;
            }
            case 426: 
            case 427: 
            case 430: 
            case 431: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Set";
                break;
            }
            case 434: 
            case 435: {
                objectArray = objectArray2;
                objectArray2[1] = "map2LinkedSet";
                break;
            }
            case 438: 
            case 439: {
                objectArray = objectArray2;
                objectArray2[1] = "map2SetNotNull";
                break;
            }
            case 448: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAndClear";
                break;
            }
            case 450: {
                objectArray = objectArray2;
                objectArray2[1] = "copyList";
                break;
            }
            case 453: 
            case 454: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 455: 
            case 456: 
            case 457: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 466: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 470: 
            case 471: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ar";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 52: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 67: 
            case 71: 
            case 72: 
            case 75: 
            case 83: 
            case 85: 
            case 95: 
            case 98: 
            case 101: 
            case 107: 
            case 108: 
            case 133: 
            case 138: 
            case 140: 
            case 148: 
            case 152: 
            case 156: 
            case 161: 
            case 170: 
            case 173: 
            case 177: 
            case 180: 
            case 183: 
            case 186: 
            case 187: 
            case 190: 
            case 195: 
            case 197: 
            case 203: 
            case 204: 
            case 206: 
            case 209: 
            case 217: 
            case 220: 
            case 234: 
            case 241: 
            case 242: 
            case 243: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 257: 
            case 262: 
            case 265: 
            case 266: 
            case 267: 
            case 269: 
            case 277: 
            case 280: 
            case 284: 
            case 288: 
            case 297: 
            case 299: 
            case 304: 
            case 307: 
            case 310: 
            case 314: 
            case 315: 
            case 318: 
            case 321: 
            case 323: 
            case 326: 
            case 330: 
            case 331: 
            case 338: 
            case 339: 
            case 342: 
            case 347: 
            case 363: 
            case 373: 
            case 375: 
            case 377: 
            case 380: 
            case 384: 
            case 401: 
            case 402: 
            case 404: 
            case 407: 
            case 408: 
            case 418: 
            case 421: 
            case 423: 
            case 426: 
            case 427: 
            case 430: 
            case 431: 
            case 434: 
            case 435: 
            case 438: 
            case 439: 
            case 442: 
            case 445: 
            case 448: 
            case 450: 
            case 453: 
            case 454: 
            case 455: 
            case 456: 
            case 457: 
            case 466: 
            case 470: 
            case 471: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newHashMap";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashMap";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedList";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "newArrayList";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "newUnmodifiableList";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyCollection";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyList";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptySet";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyMap";
                break;
            }
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "newHashSet";
                break;
            }
            case 41: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashSet";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "newTroveSet";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "reverse";
                break;
            }
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "immutableSet";
                break;
            }
            case 62: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "immutableList";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "groupBy";
                break;
            }
            case 68: 
            case 345: 
            case 346: {
                objectArray = objectArray;
                objectArray[2] = "getOrElse";
                break;
            }
            case 69: 
            case 70: 
            case 260: 
            case 261: 
            case 263: 
            case 264: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "processSortedListsInOrder";
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "mergeSortedLists";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "subList";
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 213: 
            case 214: 
            case 215: 
            case 216: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 218: 
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "addAllNotNull";
                break;
            }
            case 94: 
            case 211: 
            case 212: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromKeys";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromValues";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "fillMapWithValues";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 109: 
            case 110: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "findLast";
                break;
            }
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "map2Map";
                break;
            }
            case 134: 
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "map2MapNotNull";
                break;
            }
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "map2Array";
                break;
            }
            case 157: 
            case 158: 
            case 166: 
            case 167: 
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 159: 
            case 160: 
            case 171: 
            case 172: 
            case 175: 
            case 176: 
            case 188: 
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "findAll";
                break;
            }
            case 162: 
            case 163: 
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "filterIsInstance";
                break;
            }
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "skipNulls";
                break;
            }
            case 178: 
            case 179: 
            case 181: 
            case 182: 
            case 184: 
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "findAllAsArray";
                break;
            }
            case 191: 
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "all";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "stringMap";
                break;
            }
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "iterate";
                break;
            }
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "iterateBackward";
                break;
            }
            case 207: 
            case 208: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 210: {
                objectArray = objectArray;
                objectArray[2] = "swapElements";
                break;
            }
            case 221: 
            case 222: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 223: 
            case 224: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: {
                objectArray = objectArray;
                objectArray[2] = "findInstance";
                break;
            }
            case 231: 
            case 232: 
            case 233: 
            case 239: 
            case 240: 
            case 244: 
            case 245: 
            case 246: 
            case 253: 
            case 254: 
            case 255: 
            case 256: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 235: 
            case 236: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 237: 
            case 238: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 250: 
            case 251: {
                objectArray = objectArray;
                objectArray[2] = "concatIterators";
                break;
            }
            case 258: 
            case 259: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 268: {
                objectArray = objectArray;
                objectArray[2] = "getFirstItems";
                break;
            }
            case 270: {
                objectArray = objectArray;
                objectArray[2] = "iterateAndGetLastItem";
                break;
            }
            case 271: 
            case 272: {
                objectArray = objectArray;
                objectArray[2] = "mapIterator";
                break;
            }
            case 273: 
            case 274: {
                objectArray = objectArray;
                objectArray[2] = "filterIterator";
                break;
            }
            case 275: 
            case 276: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
            case 278: 
            case 279: 
            case 281: 
            case 282: 
            case 283: 
            case 440: 
            case 441: 
            case 443: 
            case 444: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 285: 
            case 286: 
            case 287: {
                objectArray = objectArray;
                objectArray[2] = "mergeCollectionsToArray";
                break;
            }
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 300: 
            case 301: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 298: {
                objectArray = objectArray;
                objectArray[2] = "sorted";
                break;
            }
            case 302: 
            case 303: 
            case 305: 
            case 306: 
            case 324: 
            case 325: 
            case 327: 
            case 328: 
            case 329: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 308: 
            case 309: 
            case 311: 
            case 312: 
            case 313: 
            case 316: 
            case 317: 
            case 319: 
            case 320: {
                objectArray = objectArray;
                objectArray[2] = "mapNotNull";
                break;
            }
            case 322: {
                objectArray = objectArray;
                objectArray[2] = "packNullables";
                break;
            }
            case 332: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 333: 
            case 334: 
            case 335: {
                objectArray = objectArray;
                objectArray[2] = "putIfNotNull";
                break;
            }
            case 336: 
            case 337: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 340: 
            case 341: 
            case 343: 
            case 344: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 348: 
            case 349: 
            case 350: 
            case 351: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 352: 
            case 353: 
            case 354: 
            case 355: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 356: 
            case 357: 
            case 358: 
            case 359: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 360: 
            case 361: {
                objectArray = objectArray;
                objectArray[2] = "count";
                break;
            }
            case 362: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 364: 
            case 365: 
            case 366: 
            case 367: {
                objectArray = objectArray;
                objectArray[2] = "quickSort";
                break;
            }
            case 368: 
            case 369: {
                objectArray = objectArray;
                objectArray[2] = "med3";
                break;
            }
            case 370: 
            case 374: {
                objectArray = objectArray;
                objectArray[2] = "flatten";
                break;
            }
            case 371: 
            case 372: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatesFromSorted";
                break;
            }
            case 376: {
                objectArray = objectArray;
                objectArray[2] = "flattenIterables";
                break;
            }
            case 378: 
            case 379: {
                objectArray = objectArray;
                objectArray[2] = "flatMap";
                break;
            }
            case 381: 
            case 382: 
            case 383: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 385: {
                objectArray = objectArray;
                objectArray[2] = "containsIdentity";
                break;
            }
            case 386: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIdentity";
                break;
            }
            case 387: 
            case 388: {
                objectArray = objectArray;
                objectArray[2] = "equalsIdentity";
                break;
            }
            case 389: 
            case 390: {
                objectArray = objectArray;
                objectArray[2] = "isSameElements";
                break;
            }
            case 391: 
            case 392: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 393: 
            case 394: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 395: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfIdentity";
                break;
            }
            case 396: 
            case 397: {
                objectArray = objectArray;
                objectArray[2] = "findLastInstance";
                break;
            }
            case 398: 
            case 399: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfInstance";
                break;
            }
            case 400: {
                objectArray = objectArray;
                objectArray[2] = "reverseMap";
                break;
            }
            case 403: {
                objectArray = objectArray;
                objectArray[2] = "createLockFreeCopyOnWriteList";
                break;
            }
            case 405: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 406: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 409: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentSoftMap";
                break;
            }
            case 410: {
                objectArray = objectArray;
                objectArray[2] = "createHashingStrategy";
                break;
            }
            case 411: 
            case 412: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakMap";
                break;
            }
            case 413: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentList";
                break;
            }
            case 414: 
            case 415: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 416: 
            case 417: 
            case 419: 
            case 420: 
            case 422: {
                objectArray = objectArray;
                objectArray[2] = "map2List";
                break;
            }
            case 424: 
            case 425: 
            case 428: 
            case 429: {
                objectArray = objectArray;
                objectArray[2] = "map2Set";
                break;
            }
            case 432: 
            case 433: {
                objectArray = objectArray;
                objectArray[2] = "map2LinkedSet";
                break;
            }
            case 436: 
            case 437: {
                objectArray = objectArray;
                objectArray[2] = "map2SetNotNull";
                break;
            }
            case 446: 
            case 447: {
                objectArray = objectArray;
                objectArray[2] = "copyAndClear";
                break;
            }
            case 449: {
                objectArray = objectArray;
                objectArray[2] = "copyList";
                break;
            }
            case 451: {
                objectArray = objectArray;
                objectArray[2] = "toCollection";
                break;
            }
            case 452: {
                objectArray = objectArray;
                objectArray[2] = "toList";
                break;
            }
            case 458: 
            case 459: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 460: 
            case 461: 
            case 462: 
            case 463: 
            case 464: {
                objectArray = objectArray;
                objectArray[2] = "compareLexicographically";
                break;
            }
            case 465: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 467: {
                objectArray = objectArray;
                objectArray[2] = "createSoftMap";
                break;
            }
            case 468: {
                objectArray = objectArray;
                objectArray[2] = "createWeakMap";
                break;
            }
            case 469: {
                objectArray = objectArray;
                objectArray[2] = "immutableCopy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 52: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 67: 
            case 71: 
            case 72: 
            case 75: 
            case 83: 
            case 85: 
            case 95: 
            case 98: 
            case 101: 
            case 107: 
            case 108: 
            case 133: 
            case 138: 
            case 140: 
            case 148: 
            case 152: 
            case 156: 
            case 161: 
            case 170: 
            case 173: 
            case 177: 
            case 180: 
            case 183: 
            case 186: 
            case 187: 
            case 190: 
            case 195: 
            case 197: 
            case 203: 
            case 204: 
            case 206: 
            case 209: 
            case 217: 
            case 220: 
            case 234: 
            case 241: 
            case 242: 
            case 243: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 257: 
            case 262: 
            case 265: 
            case 266: 
            case 267: 
            case 269: 
            case 277: 
            case 280: 
            case 284: 
            case 288: 
            case 297: 
            case 299: 
            case 304: 
            case 307: 
            case 310: 
            case 314: 
            case 315: 
            case 318: 
            case 321: 
            case 323: 
            case 326: 
            case 330: 
            case 331: 
            case 338: 
            case 339: 
            case 342: 
            case 347: 
            case 363: 
            case 373: 
            case 375: 
            case 377: 
            case 380: 
            case 384: 
            case 401: 
            case 402: 
            case 404: 
            case 407: 
            case 408: 
            case 418: 
            case 421: 
            case 423: 
            case 426: 
            case 427: 
            case 430: 
            case 431: 
            case 434: 
            case 435: 
            case 438: 
            case 439: 
            case 442: 
            case 445: 
            case 448: 
            case 450: 
            case 453: 
            case 454: 
            case 455: 
            case 456: 
            case 457: 
            case 466: 
            case 470: 
            case 471: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class KeyOrderedMultiMap<K extends Comparable<? super K>, V>
    extends MultiMap<K, V> {
        public KeyOrderedMultiMap() {
            super(new TreeMap());
        }

        public KeyOrderedMultiMap(@NotNull MultiMap<? extends K, ? extends V> toCopy) {
            if (toCopy == null) {
                KeyOrderedMultiMap.$$$reportNull$$$0(0);
            }
            super(new TreeMap());
            this.putAllValues(toCopy);
        }

        @NotNull
        public NavigableSet<K> navigableKeySet() {
            NavigableSet navigableSet = ((TreeMap)this.myMap).navigableKeySet();
            if (navigableSet == null) {
                KeyOrderedMultiMap.$$$reportNull$$$0(1);
            }
            return navigableSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toCopy";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ContainerUtil$KeyOrderedMultiMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ContainerUtil$KeyOrderedMultiMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "navigableKeySet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ImmutableListBackedByArray<E>
    extends ImmutableList<E> {
        private final E[] myStore;

        private ImmutableListBackedByArray(E @NotNull [] array) {
            if (array == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(0);
            }
            this.myStore = array;
        }

        @Override
        public E get(int index) {
            return this.myStore[index];
        }

        @Override
        public int size() {
            return this.myStore.length;
        }

        @Override
        public <T> T @NotNull [] toArray(T @NotNull [] a) {
            int size;
            if (a == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(1);
            }
            T[] result = a.length >= (size = this.size()) ? a : ArrayUtil.newArray(ArrayUtil.getComponentType(a), size);
            System.arraycopy(this.myStore, 0, result, 0, size);
            if (result.length > size) {
                result[size] = null;
            }
            if (result == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(2);
            }
            return result;
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            int length = this.myStore.length;
            for (int i = 0; i < length; ++i) {
                action.accept(this.myStore[i]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByArray";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ImmutableListBackedByList<E>
    extends ImmutableList<E> {
        private final List<? extends E> myStore;

        private ImmutableListBackedByList(@NotNull List<? extends E> list) {
            if (list == null) {
                ImmutableListBackedByList.$$$reportNull$$$0(0);
            }
            this.myStore = list;
        }

        @Override
        public E get(int index) {
            return this.myStore.get(index);
        }

        @Override
        public int size() {
            return this.myStore.size();
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.myStore.forEach(action);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByList", "<init>"));
        }
    }

    public static final class ImmutableMapBuilder<K, V> {
        private final Map<K, V> myMap = new HashMap();

        @NotNull
        public ImmutableMapBuilder<K, V> put(K key, V value) {
            this.myMap.put(key, value);
            ImmutableMapBuilder immutableMapBuilder = this;
            if (immutableMapBuilder == null) {
                ImmutableMapBuilder.$$$reportNull$$$0(0);
            }
            return immutableMapBuilder;
        }

        @Contract(pure=true)
        @NotNull
        public Map<K, V> build() {
            Map<K, V> map2 = Collections.unmodifiableMap(this.myMap);
            if (map2 == null) {
                ImmutableMapBuilder.$$$reportNull$$$0(1);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/util/containers/ContainerUtil$ImmutableMapBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "put";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

