/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.LocalFileUrl;
import com.intellij.util.Url;
import com.intellij.util.UrlImpl;
import com.intellij.util.UrlsKt;
import com.intellij.util.io.URLUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0007J*\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fJ\u0016\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J(\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\b\b\u0002\u0010\u0010\u001a\u00020\fH\u0007J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0007H\u0007J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u001a\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u0007J$\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u00072\b\u0010\u0005\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0007H\u0007J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0007H\u0007J\u001a\u0010\"\u001a\u00020\u000e2\b\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0007J6\u0010$\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006H\u0007J\"\u0010$\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u0007J0\u0010$\u001a\u00020\u000e2\b\u0010#\u001a\u0004\u0018\u00010\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u00072\b\u0010%\u001a\u0004\u0018\u00010\u0007H\u0007J\u001a\u0010&\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\fH\u0007J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0013\u001a\u00020\u0007H\u0007J\u0012\u0010*\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u0007H\u0007J\u0012\u0010+\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u001aH\u0007J\u0012\u0010,\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u001aH\u0002J\u0010\u0010-\u001a\u00020)2\u0006\u0010\u0013\u001a\u00020\u000eH\u0007\u00a8\u0006."}, d2={"Lcom/intellij/util/Urls;", "", "()V", "encodeParameters", "", "parameters", "", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "equals", "", "url1", "Lcom/intellij/util/Url;", "url2", "caseSensitive", "ignoreParameters", "equalsIgnoreParameters", "url", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "urls", "", "newFromEncoded", "newFromIdea", "", "newFromVirtualFile", "newHttpUrl", "authority", "path", "newLocalFileUrl", "newUnparsable", "string", "newUri", "scheme", "newUrl", "rawParameters", "parse", "asLocalIfNoScheme", "parseAsJavaUriWithoutParameters", "Ljava/net/URI;", "parseEncoded", "parseFromIdea", "parseUrl", "toUriWithoutParameters", "intellij.platform.ide.util.io"})
@NonNls
public final class Urls {
    @NotNull
    public static final Urls INSTANCE;

    @JvmStatic
    @NotNull
    public static final Url newUri(@Nullable String scheme, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new UrlImpl(scheme, null, path);
    }

    @JvmStatic
    @NotNull
    public static final Url newUrl(@Nullable String scheme, @Nullable String authority, @Nullable String path, @Nullable String rawParameters) {
        return new UrlImpl(scheme, authority, path, rawParameters);
    }

    @JvmStatic
    @NotNull
    public static final Url newUrl(@NotNull String scheme, @NotNull String authority, @NotNull String path, @NotNull Map<String, String> parameters) {
        Url url;
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Map<String, String> map2 = parameters;
        boolean bl = false;
        if (!map2.isEmpty()) {
            StringBuilder result;
            StringBuilder stringBuilder = result = new StringBuilder().append('?');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"result");
            Urls.encodeParameters(parameters, stringBuilder);
            url = new UrlImpl(scheme, authority, path, result.toString());
        } else {
            url = new UrlImpl(scheme, authority, path);
        }
        return url;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void encodeParameters(@NotNull Map<String, String> parameters, @NotNull StringBuilder result) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        int initialSize = result.length();
        Object object = parameters;
        boolean bl = false;
        for (Map.Entry<String, String> entry : object.entrySet()) {
            void name;
            Object object2 = entry;
            boolean bl2 = false;
            object = object2.getKey();
            object2 = entry;
            bl2 = false;
            String value = object2.getValue();
            if (result.length() != initialSize) {
                result.append('&');
            }
            result.append(URLUtil.encodeURIComponent((String)name));
            if (value == null) continue;
            object2 = value;
            bl2 = false;
            if (!(object2.length() > 0)) continue;
            result.append('=').append(URLUtil.encodeURIComponent(value));
        }
    }

    @JvmStatic
    @NotNull
    public static final Url newLocalFileUrl(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new LocalFileUrl(FileUtilRt.toSystemIndependentName(path));
    }

    @JvmStatic
    @NotNull
    public static final Url newLocalFileUrl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new LocalFileUrl(file.getPath());
    }

    @JvmStatic
    @NotNull
    public static final Url newFromEncoded(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Url url2 = Urls.parseEncoded(url);
        if (url2 == null) {
            throw (Throwable)new MalformedURLException("Malformed URL: " + url);
        }
        return url2;
    }

    @JvmStatic
    @Nullable
    public static final Url parseEncoded(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return Urls.parse(url, false);
    }

    @JvmStatic
    @NotNull
    public static final Url newHttpUrl(@NotNull String authority, @Nullable String path) {
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        return Urls.newUrl("http", authority, path);
    }

    @JvmStatic
    @NotNull
    public static final Url newHttpUrl(@NotNull String authority, @Nullable String path, @Nullable String parameters) {
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        return new UrlImpl("http", authority, path, parameters);
    }

    @JvmStatic
    @NotNull
    public static final Url newUrl(@NotNull String scheme, @NotNull String authority, @Nullable String path) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        return new UrlImpl(scheme, authority, path);
    }

    @JvmStatic
    @NotNull
    public static final Url newFromIdea(@NotNull CharSequence url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Url url2 = Urls.parseFromIdea(url);
        if (url2 == null) {
            throw (Throwable)new MalformedURLException("Malformed URL: " + url);
        }
        return url2;
    }

    @JvmStatic
    @Nullable
    public static final Url parseFromIdea(@NotNull CharSequence url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CharSequence charSequence = url;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element = charSequence.charAt(i);
            switch (element) {
                case ':': {
                    return INSTANCE.parseUrl(url);
                }
                case '/': 
                case '\\': {
                    return Urls.newLocalFileUrl(((Object)url).toString());
                }
            }
        }
        return Urls.newLocalFileUrl(((Object)url).toString());
    }

    @JvmStatic
    @Nullable
    public static final Url parse(@NotNull String url, boolean asLocalIfNoScheme) {
        Url url2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CharSequence charSequence = url;
        boolean bl = false;
        if (charSequence.length() == 0) {
            url2 = null;
        } else if (asLocalIfNoScheme && !URLUtil.containsScheme(url)) {
            url2 = Urls.newLocalFileUrl(url);
        } else {
            String string = VfsUtilCore.toIdeaUrl((String)url);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.toIdeaUrl(url)");
            url2 = INSTANCE.parseUrl(string);
        }
        return url2;
    }

    @JvmStatic
    @Nullable
    public static final URI parseAsJavaUriWithoutParameters(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Url url2 = INSTANCE.parseUrl(url);
        if (url2 == null) {
            return null;
        }
        Url asUrl = url2;
        try {
            return Urls.toUriWithoutParameters(asUrl);
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(Urls.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.info("Cannot parse: " + url, e);
            return null;
        }
    }

    private final Url parseUrl(CharSequence url) {
        boolean hasUrlSeparator;
        CharSequence urlToParse = StringUtil.startsWith(url, "jar:file://") ? url.subSequence("jar:".length(), url.length()) : url;
        Matcher matcher = UrlsKt.access$getURI_PATTERN$p().matcher(urlToParse);
        if (!matcher.matches()) {
            return null;
        }
        String scheme = matcher.group(1);
        if (urlToParse != url) {
            scheme = "jar:" + scheme;
        }
        String authority = StringUtil.nullize(matcher.group(3));
        String path = StringUtil.nullize(matcher.group(4));
        boolean bl = hasUrlSeparator = !StringUtil.isEmpty(matcher.group(2));
        if (authority == null) {
            if (hasUrlSeparator) {
                authority = "";
            }
        } else if (Intrinsics.areEqual((Object)"file", (Object)scheme) || !hasUrlSeparator) {
            path = path == null ? authority : authority + path;
            String string = authority = hasUrlSeparator ? "" : null;
        }
        if (path != null && (!StringUtil.isEmpty(authority) || Intrinsics.areEqual((Object)"file", (Object)scheme))) {
            path = FileUtil.toCanonicalUriPath(path);
        }
        return new UrlImpl(scheme, authority, path, matcher.group(5));
    }

    @JvmStatic
    @NotNull
    public static final Url newFromVirtualFile(@NotNull VirtualFile file) {
        Url url;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isInLocalFileSystem()) {
            VirtualFileSystem virtualFileSystem = file.getFileSystem();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"file.fileSystem");
            String string = virtualFileSystem.getProtocol();
            String string2 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
            url = Urls.newUri(string, string2);
        } else {
            String string = file.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.url");
            url = INSTANCE.parseUrl(string);
            if (url == null) {
                String string3 = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.path");
                url = Urls.newUnparsable(string3);
            }
        }
        return url;
    }

    @JvmStatic
    @NotNull
    public static final Url newUnparsable(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return new UrlImpl(null, null, string, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean equalsIgnoreParameters(@NotNull Url url, @NotNull Collection<? extends Url> urls, boolean caseSensitive) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(urls, (String)"urls");
            Iterable $this$any$iv = urls;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Url it = (Url)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.equals(url, it, caseSensitive, true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean equalsIgnoreParameters$default(Url url, Collection collection, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return Urls.equalsIgnoreParameters(url, collection, bl);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean equalsIgnoreParameters(@NotNull Url url, @NotNull Collection<? extends Url> urls) {
        return Urls.equalsIgnoreParameters$default(url, urls, false, 4, null);
    }

    public final boolean equalsIgnoreParameters(@NotNull Url url, @NotNull VirtualFile file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isInLocalFileSystem()) {
            bl = url.isInLocalFileSystem() && StringsKt.equals((String)url.getPath(), (String)file.getPath(), (!file.isCaseSensitive() ? 1 : 0) != 0);
        } else if (url.isInLocalFileSystem()) {
            bl = false;
        } else {
            String string = file.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.url");
            Url url2 = this.parseUrl(string);
            bl = url2 != null ? url2.equalsIgnoreParameters(url) : false;
        }
        return bl;
    }

    public final boolean equals(@Nullable Url url1, @Nullable Url url2, boolean caseSensitive, boolean ignoreParameters) {
        if (url1 == null || url2 == null) {
            return url1 == url2;
        }
        Url url = ignoreParameters ? url1.trimParameters() : url1;
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"if (ignoreParameters) ur\u2026rimParameters() else url1");
        Url o1 = url;
        Url url3 = ignoreParameters ? url2.trimParameters() : url2;
        Intrinsics.checkNotNullExpressionValue((Object)url3, (String)"if (ignoreParameters) ur\u2026rimParameters() else url2");
        Url o2 = url3;
        return caseSensitive ? Intrinsics.areEqual((Object)o1, (Object)o2) : o1.equalsIgnoreCase(o2);
    }

    @JvmStatic
    @NotNull
    public static final URI toUriWithoutParameters(@NotNull Url url) {
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            String string;
            String authority;
            boolean inLocalFileSystem = url.isInLocalFileSystem();
            String scheme = inLocalFileSystem ? "file" : url.getScheme();
            String string2 = authority = inLocalFileSystem ? "" : url.getAuthority();
            if (inLocalFileSystem && SystemInfo.isWindows && url.getPath().charAt(0) != '/') {
                string = '/' + url.getPath();
            } else {
                String string3 = url.getPath();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"url.path");
            }
            String externalPath = string;
            uRI = new URI(scheme, authority, externalPath, null, null);
        }
        catch (URISyntaxException e) {
            throw (Throwable)new RuntimeException(e);
        }
        return uRI;
    }

    private Urls() {
    }

    static {
        Urls urls;
        INSTANCE = urls = new Urls();
    }
}

