/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.NullableFunction;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Function<Param, Result> {
    public Result fun(Param var1);

    public static final class FirstInCollection<P>
    implements Function<Collection<P>, P> {
        @Override
        public P fun(Collection<P> ps) {
            return ps.iterator().next();
        }
    }

    public static final class First<P>
    implements Function<P[], P> {
        @Override
        public P fun(P[] ps) {
            return ps[0];
        }
    }

    public static final class InstanceOf<P, R extends P>
    implements NullableFunction<P, R> {
        private final Class<R> myResultClass;

        public InstanceOf(@NotNull Class<R> resultClass) {
            if (resultClass == null) {
                InstanceOf.$$$reportNull$$$0(0);
            }
            this.myResultClass = resultClass;
        }

        @Override
        @Nullable
        public R fun(P p) {
            return this.myResultClass.isInstance(p) ? (R)this.myResultClass.cast(p) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultClass", "com/intellij/util/Function$InstanceOf", "<init>"));
        }
    }

    public static interface Mono<T>
    extends Function<T, T> {
    }
}

