/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.CommandLineUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ReadEnv;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EnvReader
extends EnvironmentUtil.ShellEnvReader {
    public EnvReader() {
    }

    public EnvReader(long timeoutMillis) {
        super(timeoutMillis);
    }

    @NotNull
    public Map<String, String> readShellEnv(@Nullable Path file, @Nullable Map<String, String> additionalEnvironment) throws IOException {
        Map<String, String> map2 = this.doReadShellEnv(file, PathManager.findBinFileWithException("printenv.py"), additionalEnvironment);
        if (map2 == null) {
            EnvReader.$$$reportNull$$$0(0);
        }
        return map2;
    }

    @NotNull
    public Map<String, String> readBatEnv(@Nullable Path batchFile, List<String> args) throws IOException {
        Map map2 = (Map)this.readBatOutputAndEnv((Path)batchFile, args).second;
        if (map2 == null) {
            EnvReader.$$$reportNull$$$0(1);
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Pair<String, Map<String, String>> readBatOutputAndEnv(@Nullable Path batchFile, List<String> args) throws IOException {
        if (batchFile != null && !Files.exists(batchFile, new LinkOption[0])) {
            throw new NoSuchFileException(batchFile.toString());
        }
        Path envFile = Files.createTempFile("intellij-cmd-env.", ".tmp", new FileAttribute[0]);
        ArrayList<String> callArgs = new ArrayList<String>();
        if (batchFile != null) {
            callArgs.add("call");
            callArgs.add(batchFile.toString());
            if (args != null) {
                callArgs.addAll(args);
            }
            callArgs.add("&&");
        }
        callArgs.add((System.getProperty("java.home") + "/bin/java").replace('/', File.separatorChar));
        callArgs.add("-cp");
        callArgs.add(PathManager.getJarPathForClass(ReadEnv.class));
        callArgs.add(ReadEnv.class.getCanonicalName());
        callArgs.add(envFile.toString());
        callArgs.add("||");
        callArgs.add("exit");
        callArgs.add("/B");
        callArgs.add("%ERRORLEVEL%");
        ArrayList<@NonNls String> cl = new ArrayList<String>();
        cl.add("cmd.exe");
        cl.add("/c");
        cl.add(EnvReader.prepareCallArgs(callArgs));
        Pair<String, Map<String, String>> pair = this.runProcessAndReadOutputAndEnvs(cl, batchFile != null ? batchFile.getParent() : null, null, envFile);
        Pair<String, Map<String, String>> pair2 = pair;
        if (pair2 == null) {
            EnvReader.$$$reportNull$$$0(2);
        }
        return pair2;
        finally {
            try {
                Files.delete(envFile);
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException e) {
                Logger.getInstance(EnvironmentUtil.class).warn("Cannot delete temporary file", e);
            }
        }
    }

    @NotNull
    private static String prepareCallArgs(@NotNull List<String> callArgs) {
        if (callArgs == null) {
            EnvReader.$$$reportNull$$$0(3);
        }
        List<String> preparedCallArgs = CommandLineUtil.toCommandLine(callArgs);
        String firstArg = preparedCallArgs.remove(0);
        preparedCallArgs.add(0, CommandLineUtil.escapeParameterOnWindows(firstArg, false));
        String string = "\"" + String.join((CharSequence)" ", preparedCallArgs) + "\"";
        if (string == null) {
            EnvReader.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/EnvReader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "readShellEnv";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readBatEnv";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readBatOutputAndEnv";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/EnvReader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareCallArgs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareCallArgs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

