/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.ThreadLocalCachedByteArray;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.jetbrains.annotations.NotNull;

public final class CompressionUtil {
    private static final int COMPRESSION_THRESHOLD = 64;
    private static final ThreadLocalCachedByteArray spareBufferLocal = new ThreadLocalCachedByteArray();
    private static final AtomicInteger myCompressionRequests = new AtomicInteger();
    private static final AtomicLong myCompressionTime = new AtomicLong();
    private static final AtomicInteger myDecompressionRequests = new AtomicInteger();
    private static final AtomicLong myDecompressionTime = new AtomicLong();
    private static final AtomicLong myDecompressedSize = new AtomicLong();
    private static final AtomicLong mySizeBeforeCompression = new AtomicLong();
    private static final AtomicLong mySizeAfterCompression = new AtomicLong();
    public static final boolean DUMP_COMPRESSION_STATS = SystemProperties.getBooleanProperty("idea.dump.compression.stats", false);
    private static final int STRING_COMPRESSION_THRESHOLD = 1024;

    public static int writeCompressed(@NotNull DataOutput out, byte @NotNull [] bytes, int start, int length) throws IOException {
        byte[] compressedOutputBuffer;
        LZ4Compressor compressor;
        int compressedSize;
        if (out == null) {
            CompressionUtil.$$$reportNull$$$0(0);
        }
        if (bytes == null) {
            CompressionUtil.$$$reportNull$$$0(1);
        }
        if (length > 64 && (compressedSize = (compressor = CompressionUtil.compressor()).compress(bytes, start, length, compressedOutputBuffer = spareBufferLocal.getBuffer(compressor.maxCompressedLength(length)), 0)) < length) {
            DataInputOutputUtil.writeINT(out, -compressedSize);
            DataInputOutputUtil.writeINT(out, length - compressedSize);
            out.write(compressedOutputBuffer, 0, compressedSize);
            return compressedSize;
        }
        DataInputOutputUtil.writeINT(out, length);
        out.write(bytes, start, length);
        return length;
    }

    public static int writeCompressedWithoutOriginalBufferLength(@NotNull DataOutput out, byte @NotNull [] bytes, int length) throws IOException {
        if (out == null) {
            CompressionUtil.$$$reportNull$$$0(2);
        }
        if (bytes == null) {
            CompressionUtil.$$$reportNull$$$0(3);
        }
        long started = DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L;
        LZ4Compressor compressor = CompressionUtil.compressor();
        byte[] compressedOutputBuffer = spareBufferLocal.getBuffer(compressor.maxCompressedLength(length));
        int compressedSize = compressor.compress(bytes, 0, length, compressedOutputBuffer, 0);
        long time = (DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L) - started;
        mySizeAfterCompression.addAndGet(compressedSize);
        mySizeBeforeCompression.addAndGet(length);
        int requests = myCompressionRequests.incrementAndGet();
        long l = myCompressionTime.addAndGet(time);
        if (DUMP_COMPRESSION_STATS && (requests & 0x1FFF) == 0) {
            System.out.println("Compressed " + requests + " times, size:" + mySizeBeforeCompression + "->" + mySizeAfterCompression + " for " + l / 1000000L + "ms");
        }
        DataInputOutputUtil.writeINT(out, compressedSize);
        out.write(compressedOutputBuffer, 0, compressedSize);
        return compressedSize;
    }

    private static LZ4Compressor compressor() {
        return LZ4Factory.fastestJavaInstance().fastCompressor();
    }

    public static byte @NotNull [] readCompressedWithoutOriginalBufferLength(@NotNull DataInput in, int originalBufferLength) throws IOException {
        if (in == null) {
            CompressionUtil.$$$reportNull$$$0(4);
        }
        int size = DataInputOutputUtil.readINT(in);
        byte[] bytes = spareBufferLocal.getBuffer(size);
        in.readFully(bytes, 0, size);
        int decompressedRequests = myDecompressionRequests.incrementAndGet();
        long started = DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L;
        byte[] decompressedResult = CompressionUtil.decompressor().decompress(bytes, 0, originalBufferLength);
        long doneTime = (DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L) - started;
        long decompressedSize = myDecompressedSize.addAndGet(size);
        long decompressedTime = myDecompressionTime.addAndGet(doneTime);
        if (DUMP_COMPRESSION_STATS && (decompressedRequests & 0x1FFF) == 0) {
            System.out.println("Decompressed " + decompressedRequests + " times, size: " + decompressedSize + " for " + decompressedTime / 1000000L + "ms");
        }
        if (decompressedResult == null) {
            CompressionUtil.$$$reportNull$$$0(5);
        }
        return decompressedResult;
    }

    protected static LZ4FastDecompressor decompressor() {
        return LZ4Factory.fastestJavaInstance().fastDecompressor();
    }

    public static byte @NotNull [] readCompressed(@NotNull DataInput in) throws IOException {
        int size;
        if (in == null) {
            CompressionUtil.$$$reportNull$$$0(6);
        }
        if ((size = DataInputOutputUtil.readINT(in)) < 0) {
            size = -size;
            byte[] bytes = spareBufferLocal.getBuffer(size);
            int sizeUncompressed = DataInputOutputUtil.readINT(in) + size;
            in.readFully(bytes, 0, size);
            byte[] result = new byte[sizeUncompressed];
            int decompressed = CompressionUtil.decompressor().decompress(bytes, 0, result, 0, sizeUncompressed);
            assert (decompressed == size);
            if (result == null) {
                CompressionUtil.$$$reportNull$$$0(7);
            }
            return result;
        }
        byte[] bytes = new byte[size];
        in.readFully(bytes);
        if (bytes == null) {
            CompressionUtil.$$$reportNull$$$0(8);
        }
        return bytes;
    }

    @NotNull
    public static Object compressStringRawBytes(@NotNull CharSequence string) {
        Object object;
        int length;
        if (string == null) {
            CompressionUtil.$$$reportNull$$$0(9);
        }
        if ((length = string.length()) < 1024) {
            if (string instanceof CharBuffer && ((CharBuffer)string).capacity() > 1024) {
                string = string.toString();
            }
            CharSequence charSequence = string;
            if (charSequence == null) {
                CompressionUtil.$$$reportNull$$$0(10);
            }
            return charSequence;
        }
        try {
            BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream(length);
            @NotNull DataOutputStream out = new DataOutputStream(bytes);
            for (int i = 0; i < length; ++i) {
                char c = string.charAt(i);
                DataInputOutputUtil.writeINT(out, (int)c);
            }
            LZ4Compressor compressor = CompressionUtil.compressor();
            int bytesWritten = bytes.size();
            ByteBuffer dest = ByteBuffer.wrap(spareBufferLocal.getBuffer(compressor.maxCompressedLength(bytesWritten) + 10));
            DataInputOutputUtil.writeINT(dest, length);
            DataInputOutputUtil.writeINT(dest, bytesWritten - length);
            compressor.compress(ByteBuffer.wrap(bytes.getInternalBuffer(), 0, bytesWritten), dest);
            object = dest.position() < length * 2 ? (Object)Arrays.copyOf(dest.array(), dest.position()) : string;
        }
        catch (IOException e) {
            e.printStackTrace();
            CharSequence charSequence = string;
            if (charSequence == null) {
                CompressionUtil.$$$reportNull$$$0(12);
            }
            return charSequence;
        }
        if (object == null) {
            CompressionUtil.$$$reportNull$$$0(11);
        }
        return object;
    }

    @NotNull
    public static CharSequence uncompressStringRawBytes(@NotNull Object compressed) {
        if (compressed == null) {
            CompressionUtil.$$$reportNull$$$0(13);
        }
        if (compressed instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)compressed;
            if (charSequence == null) {
                CompressionUtil.$$$reportNull$$$0(14);
            }
            return charSequence;
        }
        ByteBuffer buffer = ByteBuffer.wrap((byte[])compressed);
        int len = DataInputOutputUtil.readINT(buffer);
        int uncompressedLength = DataInputOutputUtil.readINT(buffer) + len;
        ByteBuffer dest = ByteBuffer.wrap(spareBufferLocal.getBuffer(uncompressedLength), 0, uncompressedLength);
        CompressionUtil.decompressor().decompress(buffer, dest);
        dest.rewind();
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            int c = DataInputOutputUtil.readINT(dest);
            chars[i] = (char)c;
        }
        return new String(chars);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/CompressionUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compressed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/CompressionUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readCompressedWithoutOriginalBufferLength";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readCompressed";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "compressStringRawBytes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "uncompressStringRawBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeCompressed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeCompressedWithoutOriginalBufferLength";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readCompressedWithoutOriginalBufferLength";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readCompressed";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compressStringRawBytes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "uncompressStringRawBytes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

