/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.svg.ImageValue;
import com.intellij.util.ImageLoader;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.jpountz.xxhash.StreamingXXHash64;
import net.jpountz.xxhash.XXHashFactory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.mvstore.MVMap;
import org.jetbrains.mvstore.MVStore;
import org.jetbrains.mvstore.type.DataType;
import org.jetbrains.mvstore.type.FixedByteArrayDataType;
import org.jetbrains.mvstore.type.KeyableDataType;

@ApiStatus.Internal
public final class SvgCacheManager {
    public static final long HASH_SEED = -1756908916L;
    private static final int[] B_OFFS = new int[]{3, 2, 1, 0};
    private static final int IMAGE_KEY_SIZE = 12;
    private static final ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
    private final MVStore store;
    private final Map<Float, MVMap<byte[], ImageValue>> scaleToMap;
    private final MVMap.Builder<byte[], ImageValue> mapBuilder;

    public SvgCacheManager(@NotNull Path dbFile) {
        if (dbFile == null) {
            SvgCacheManager.$$$reportNull$$$0(0);
        }
        this.scaleToMap = new ConcurrentHashMap<Float, MVMap<byte[], ImageValue>>(2, 0.75f, 2);
        StoreErrorHandler storeErrorHandler = new StoreErrorHandler();
        MVStore.Builder storeBuilder = new MVStore.Builder().backgroundExceptionHandler(storeErrorHandler).autoCommitDelay(60000).compressHigh();
        this.store = storeBuilder.openOrNewOnIoError(dbFile, true, e -> SvgCacheManager.getLogger().debug("Cannot open icon cache database", (Throwable)e));
        storeErrorHandler.isStoreOpened = true;
        MVMap.Builder mapBuilder = new MVMap.Builder();
        mapBuilder.keyType((KeyableDataType)new FixedByteArrayDataType(12));
        mapBuilder.valueType((DataType)new ImageValue.ImageValueSerializer());
        this.mapBuilder = mapBuilder;
    }

    @NotNull
    static Logger getLogger() {
        Logger logger = Logger.getInstance(SvgCacheManager.class);
        if (logger == null) {
            SvgCacheManager.$$$reportNull$$$0(1);
        }
        return logger;
    }

    @NotNull
    public static <K, V> MVMap<K, V> getMap(float scale, boolean isDark, @NotNull Map<Float, MVMap<K, V>> scaleToMap, @NotNull MVStore store, @NotNull MVMap.MapBuilder<MVMap<K, V>, K, V> mapBuilder) {
        if (scaleToMap == null) {
            SvgCacheManager.$$$reportNull$$$0(2);
        }
        if (store == null) {
            SvgCacheManager.$$$reportNull$$$0(3);
        }
        if (mapBuilder == null) {
            SvgCacheManager.$$$reportNull$$$0(4);
        }
        MVMap mVMap = scaleToMap.computeIfAbsent(Float.valueOf(scale + (float)(isDark ? 10000 : 0)), __ -> store.openMap("icons-v1@" + scale + (isDark ? "_d" : ""), mapBuilder));
        if (mVMap == null) {
            SvgCacheManager.$$$reportNull$$$0(5);
        }
        return mVMap;
    }

    public void close() {
        this.store.close();
    }

    public void save() {
        this.store.triggerAutoSave();
    }

    private static byte[] getCacheKey(byte @NotNull [] theme, byte @NotNull [] imageBytes) {
        long contentDigest;
        if (theme == null) {
            SvgCacheManager.$$$reportNull$$$0(6);
        }
        if (imageBytes == null) {
            SvgCacheManager.$$$reportNull$$$0(7);
        }
        XXHashFactory hashFactory = XXHashFactory.fastestJavaInstance();
        if (theme.length == 0) {
            contentDigest = hashFactory.hash64().hash(imageBytes, 0, imageBytes.length, -1756908916L);
        } else {
            StreamingXXHash64 hasher = hashFactory.newStreamingHash64(-1756908916L);
            hasher.update(theme, 0, theme.length);
            hasher.update(imageBytes, 0, imageBytes.length);
            contentDigest = hasher.getValue();
            hasher.close();
        }
        ByteBuffer buffer = ByteBuffer.allocate(12);
        buffer.putInt(imageBytes.length);
        buffer.putLong(contentDigest);
        return buffer.array();
    }

    @Nullable
    public final Image loadFromCache(byte @NotNull [] theme, byte @NotNull [] imageBytes, float scale, boolean isDark, @NotNull ImageLoader.Dimension2DDouble docSize) {
        if (docSize == null) {
            SvgCacheManager.$$$reportNull$$$0(8);
        }
        if (theme == null) {
            SvgCacheManager.$$$reportNull$$$0(9);
        }
        if (imageBytes == null) {
            SvgCacheManager.$$$reportNull$$$0(10);
        }
        byte[] key = SvgCacheManager.getCacheKey(theme, imageBytes);
        MVMap map2 = SvgCacheManager.getMap(scale, isDark, this.scaleToMap, this.store, this.mapBuilder);
        try {
            long start = StartUpMeasurer.getCurrentTimeIfEnabled();
            ImageValue data = (ImageValue)map2.get(key);
            if (data == null) {
                return null;
            }
            Image image = SvgCacheManager.readImage(data, docSize);
            IconLoadMeasurer.svgCacheRead.end(start);
            return image;
        }
        catch (Exception e) {
            SvgCacheManager.getLogger().error(e);
            try {
                map2.remove(key);
            }
            catch (Exception e1) {
                SvgCacheManager.getLogger().error("Cannot remove invalid entry", e1);
            }
            return null;
        }
    }

    public void storeLoadedImage(byte @NotNull [] theme, byte @NotNull [] imageBytes, float scale, @NotNull BufferedImage image, @NotNull ImageLoader.Dimension2DDouble size) {
        if (image == null) {
            SvgCacheManager.$$$reportNull$$$0(11);
        }
        if (size == null) {
            SvgCacheManager.$$$reportNull$$$0(12);
        }
        if (theme == null) {
            SvgCacheManager.$$$reportNull$$$0(13);
        }
        if (imageBytes == null) {
            SvgCacheManager.$$$reportNull$$$0(14);
        }
        byte[] key = SvgCacheManager.getCacheKey(theme, imageBytes);
        SvgCacheManager.getMap(scale, false, this.scaleToMap, this.store, this.mapBuilder).put(key, SvgCacheManager.writeImage(image, size));
    }

    @Nullable
    static Image readImage(@NotNull ImageValue value, @NotNull ImageLoader.Dimension2DDouble docSize) {
        if (value == null) {
            SvgCacheManager.$$$reportNull$$$0(15);
        }
        if (docSize == null) {
            SvgCacheManager.$$$reportNull$$$0(16);
        }
        if (value.actualWidth <= 0 || value.actualHeight <= 0 || value.actualWidth * value.actualHeight <= 0) {
            return null;
        }
        DataBufferByte dataBuffer = new DataBufferByte(value.data, value.actualWidth * 4 * (value.actualHeight - 1) + 4 * value.actualWidth);
        WritableRaster raster = Raster.createInterleavedRaster(dataBuffer, value.actualWidth, value.actualHeight, value.actualWidth * 4, 4, B_OFFS, null);
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        docSize.setSize(value.width, value.height);
        return image;
    }

    @NotNull
    public static ImageValue writeImage(@NotNull BufferedImage image, @NotNull ImageLoader.Dimension2DDouble size) {
        if (image == null) {
            SvgCacheManager.$$$reportNull$$$0(17);
        }
        if (size == null) {
            SvgCacheManager.$$$reportNull$$$0(18);
        }
        int actualWidth = image.getWidth();
        int actualHeight = image.getHeight();
        BufferedImage convertedImage = new BufferedImage(actualWidth, actualHeight, 6);
        Graphics2D g = convertedImage.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        byte[] imageData = ((DataBufferByte)convertedImage.getRaster().getDataBuffer()).getData();
        return new ImageValue(imageData, (float)size.getWidth(), (float)size.getHeight(), actualWidth, actualHeight);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbFile";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/svg/SvgCacheManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scaleToMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "store";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapBuilder";
                break;
            }
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theme";
                break;
            }
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageBytes";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docSize";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/svg/SvgCacheManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCacheKey";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadFromCache";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "storeLoadedImage";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readImage";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "writeImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class StoreErrorHandler
    implements BiConsumer<Throwable, MVStore> {
        private boolean isStoreOpened;

        private StoreErrorHandler() {
        }

        @Override
        public void accept(Throwable e, MVStore store) {
            if (this.isStoreOpened) {
                SvgCacheManager.getLogger().error("Icon Cache Error (db=" + store.getFileStore() + ")", e);
            } else {
                SvgCacheManager.getLogger().warn("Icon Cache will be recreated or previous version of data reused (db=" + store.getFileStore() + ")", e);
            }
        }
    }
}

