/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.StringUtilRt;
import gnu.trove.TIntArrayList;
import gnu.trove.TLongArrayList;
import java.time.Duration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Formats {
    private static final String[] TIME_UNITS = new String[]{"ms", "s", "m", "h", "d"};
    private static final long[] TIME_MULTIPLIERS = new long[]{1L, 1000L, 60L, 60L, 24L};
    private static final String[] PADDED_FORMATS = new String[]{"%03d", "%02d", "%02d", "%02d", "%d"};

    @Contract(pure=true)
    @NotNull
    public static String formatFileSize(long fileSize) {
        String string = StringUtilRt.formatFileSize(fileSize);
        if (string == null) {
            Formats.$$$reportNull$$$0(0);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Contract(pure=true)
    @NotNull
    public static String formatFileSize(long fileSize, @NotNull String string) {
        void unitSeparator;
        if (string == null) {
            Formats.$$$reportNull$$$0(1);
        }
        String string2 = StringUtilRt.formatFileSize(fileSize, (String)unitSeparator);
        if (string2 == null) {
            Formats.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String formatDuration(long duration) {
        return Formats.formatDuration(duration, " ");
    }

    @Contract(pure=true)
    @NotNull
    public static String formatDuration(@NotNull Duration duration) {
        if (duration == null) {
            Formats.$$$reportNull$$$0(3);
        }
        return Formats.formatDuration(duration.toMillis());
    }

    /*
     * WARNING - void declaration
     */
    @Contract(pure=true)
    @NotNull
    public static String formatDuration(long duration, @NotNull String string) {
        void unitSeparator;
        if (string == null) {
            Formats.$$$reportNull$$$0(4);
        }
        return Formats.formatDuration(duration, (String)unitSeparator, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Contract(pure=true)
    @NotNull
    private static String formatDuration(long duration, @NotNull String unitSeparator, int n) {
        void maxFragments;
        long multiplier;
        int i;
        if (unitSeparator == null) {
            Formats.$$$reportNull$$$0(5);
        }
        TLongArrayList unitValues = new TLongArrayList();
        TIntArrayList unitIndices = new TIntArrayList();
        long count = duration;
        for (i = 1; i < TIME_UNITS.length && count > 0L && count >= (multiplier = TIME_MULTIPLIERS[i]); ++i) {
            long remainder = count % multiplier;
            count /= multiplier;
            if (remainder == 0L && unitValues.isEmpty()) continue;
            unitValues.insert(0, remainder);
            unitIndices.insert(0, i - 1);
        }
        unitValues.insert(0, count);
        unitIndices.insert(0, i - 1);
        if (unitValues.size() > maxFragments) {
            int lastUnitIndex = unitIndices.get((int)(maxFragments - true));
            long lastMultiplier = TIME_MULTIPLIERS[lastUnitIndex];
            if (unitValues.get((int)maxFragments) > lastMultiplier / 2L) {
                long increment = lastMultiplier - unitValues.get((int)maxFragments);
                for (int unit = lastUnitIndex - 1; unit > 0; --unit) {
                    increment *= TIME_MULTIPLIERS[unit];
                }
                return Formats.formatDuration(duration + increment, unitSeparator, (int)maxFragments);
            }
        }
        StringBuilder result = new StringBuilder();
        for (i = 0; i < unitValues.size() && i < maxFragments; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            result.append(unitValues.get(i)).append(unitSeparator).append(TIME_UNITS[unitIndices.get(i)]);
        }
        String string = result.toString();
        if (string == null) {
            Formats.$$$reportNull$$$0(6);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static String formatDurationPadded(long millis, @NotNull String string) {
        long multiplier;
        int i;
        if (string == null) {
            Formats.$$$reportNull$$$0(7);
        }
        StringBuilder result = new StringBuilder();
        long millisIn = 1L;
        for (i = 1; i < TIME_MULTIPLIERS.length && millis >= (millisIn *= (multiplier = TIME_MULTIPLIERS[i])); ++i) {
        }
        long d = millis;
        --i;
        while (i >= 0) {
            void unitSeparator;
            String format;
            long multiplier2 = i == TIME_MULTIPLIERS.length - 1 ? 1L : TIME_MULTIPLIERS[i + 1];
            long value = d / (millisIn /= multiplier2);
            d %= millisIn;
            String string2 = format = result.length() == 0 ? "%d" : PADDED_FORMATS[i];
            if (result.length() != 0) {
                result.append(" ");
            }
            result.append(String.format(format, value)).append((String)unitSeparator).append(TIME_UNITS[i]);
            --i;
        }
        String string3 = result.toString();
        if (string3 == null) {
            Formats.$$$reportNull$$$0(8);
        }
        return string3;
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static String formatDurationApproximate(long duration) {
        return Formats.formatDuration(duration, " ", 2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/Formats";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitSeparator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/Formats";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDuration";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDurationPadded";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "formatFileSize";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatDuration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "formatDurationPadded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

