/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class NioFiles {
    private NioFiles() {
    }

    @NotNull
    public static Path createDirectories(@NotNull Path path) throws IOException {
        if (path == null) {
            NioFiles.$$$reportNull$$$0(0);
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
                throw new FileAlreadyExistsException(path.toString(), null, "already exists");
            }
            Path parent = path.getParent();
            if (parent != null) {
                NioFiles.createDirectories(parent);
            }
            Files.createDirectory(path, new FileAttribute[0]);
        }
        Path path2 = path;
        if (path2 == null) {
            NioFiles.$$$reportNull$$$0(1);
        }
        return path2;
    }

    public static void setReadOnly(@NotNull Path path, boolean value) throws IOException {
        PosixFileAttributeView posixView;
        if (path == null) {
            NioFiles.$$$reportNull$$$0(2);
        }
        if ((posixView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0])) != null) {
            boolean modified;
            Set<PosixFilePermission> permissions = posixView.readAttributes().permissions();
            boolean bl = modified = value ? permissions.removeAll(Arrays.asList(PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE)) : permissions.add(PosixFilePermission.OWNER_WRITE);
            if (modified) {
                posixView.setPermissions(permissions);
            }
        } else {
            DosFileAttributeView dosView = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
            if (dosView != null) {
                dosView.setReadOnly(value);
            } else {
                throw new IOException("Not supported: " + path.getFileSystem());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/NioFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/NioFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDirectories";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setReadOnly";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

