/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.jna.JnaLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.io.win32.FileInfo;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.LimitedPool;
import com.intellij.util.system.CpuArch;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileSystemUtil {
    static final String FORCE_USE_NIO2_KEY = "idea.io.use.nio2";
    private static final String COARSE_TIMESTAMP_KEY = "idea.io.coarse.ts";
    @ApiStatus.Internal
    public static final boolean DO_NOT_RESOLVE_SYMLINKS = Boolean.getBoolean("idea.symlinks.no.resolve");
    private static final Logger LOG = Logger.getInstance(FileSystemUtil.class);
    private static final Mediator ourMediator = FileSystemUtil.computeMediator();
    private static volatile boolean ourLibExt2FsPresent = true;

    @NotNull
    static Mediator computeMediator() {
        if (!Boolean.getBoolean(FORCE_USE_NIO2_KEY)) {
            try {
                if (SystemInfo.isWindows && IdeaWin32.isAvailable()) {
                    return FileSystemUtil.check(new IdeaWin32MediatorImpl());
                }
                if ((SystemInfo.isLinux || SystemInfo.isMac && CpuArch.isIntel64() || SystemInfo.isSolaris || SystemInfo.isFreeBSD) && JnaLoader.isLoaded() && JnaLoader.supportsDirectMapping) {
                    return FileSystemUtil.check(new JnaUnixMediatorImpl());
                }
            }
            catch (Throwable t) {
                LOG.warn("Failed to load filesystem access layer: " + SystemInfo.OS_NAME + ", " + SystemInfo.JAVA_VERSION, t);
            }
        }
        return new Nio2MediatorImpl();
    }

    @NotNull
    private static Mediator check(@NotNull Mediator mediator) throws Exception {
        if (mediator == null) {
            FileSystemUtil.$$$reportNull$$$0(0);
        }
        String quickTestPath = SystemInfo.isWindows ? "C:\\" : "/";
        mediator.getAttributes(quickTestPath);
        Mediator mediator2 = mediator;
        if (mediator2 == null) {
            FileSystemUtil.$$$reportNull$$$0(1);
        }
        return mediator2;
    }

    private FileSystemUtil() {
    }

    @Nullable
    public static FileAttributes getAttributes(@NotNull String path) {
        if (path == null) {
            FileSystemUtil.$$$reportNull$$$0(2);
        }
        try {
            if (LOG.isTraceEnabled()) {
                long t = System.nanoTime();
                FileAttributes result = ourMediator.getAttributes(path);
                t = System.nanoTime() - t;
                LOG.trace("getAttributes(" + path + ") = " + result + " in " + TimeUnit.NANOSECONDS.toMicros(t) + " mks");
                return result;
            }
            return ourMediator.getAttributes(path);
        }
        catch (Exception e) {
            LOG.warn("getAttributes(" + path + ")", e);
            return null;
        }
    }

    @Nullable
    public static FileAttributes getAttributes(@NotNull File file) {
        if (file == null) {
            FileSystemUtil.$$$reportNull$$$0(3);
        }
        return FileSystemUtil.getAttributes(file.getPath());
    }

    public static long lastModified(@NotNull File file) {
        FileAttributes attributes;
        if (file == null) {
            FileSystemUtil.$$$reportNull$$$0(4);
        }
        return (attributes = FileSystemUtil.getAttributes(file)) != null ? attributes.lastModified : 0L;
    }

    public static boolean isSymLink(@NotNull String path) {
        FileAttributes attributes;
        if (path == null) {
            FileSystemUtil.$$$reportNull$$$0(5);
        }
        return (attributes = FileSystemUtil.getAttributes(path)) != null && attributes.isSymLink();
    }

    public static boolean isSymLink(@NotNull File file) {
        if (file == null) {
            FileSystemUtil.$$$reportNull$$$0(6);
        }
        return FileSystemUtil.isSymLink(file.getAbsolutePath());
    }

    @Nullable
    public static String resolveSymLink(@NotNull String path) {
        if (path == null) {
            FileSystemUtil.$$$reportNull$$$0(7);
        }
        try {
            String realPath;
            if (LOG.isTraceEnabled()) {
                long t = System.nanoTime();
                realPath = ourMediator.resolveSymLink(path);
                t = System.nanoTime() - t;
                LOG.trace("resolveSymLink(" + path + ") = " + realPath + " in " + TimeUnit.NANOSECONDS.toMicros(t) + " mks");
            } else {
                realPath = ourMediator.resolveSymLink(path);
            }
            if (realPath != null && (SystemInfo.isWindows && realPath.startsWith("\\\\") || new File(realPath).exists())) {
                return realPath;
            }
        }
        catch (Exception e) {
            LOG.warn(e);
        }
        return null;
    }

    @Nullable
    public static String resolveSymLink(@NotNull File file) {
        if (file == null) {
            FileSystemUtil.$$$reportNull$$$0(8);
        }
        return FileSystemUtil.resolveSymLink(file.getAbsolutePath());
    }

    public static boolean clonePermissions(@NotNull String source, @NotNull String target) {
        if (source == null) {
            FileSystemUtil.$$$reportNull$$$0(9);
        }
        if (target == null) {
            FileSystemUtil.$$$reportNull$$$0(10);
        }
        try {
            return ourMediator.clonePermissions(source, target, false);
        }
        catch (Exception e) {
            LOG.warn(e);
            return false;
        }
    }

    public static boolean clonePermissionsToExecute(@NotNull String source, @NotNull String target) {
        if (source == null) {
            FileSystemUtil.$$$reportNull$$$0(11);
        }
        if (target == null) {
            FileSystemUtil.$$$reportNull$$$0(12);
        }
        try {
            return ourMediator.clonePermissions(source, target, true);
        }
        catch (Exception e) {
            LOG.warn(e);
            return false;
        }
    }

    @NotNull
    public static FileAttributes.CaseSensitivity readParentCaseSensitivity(@NotNull File anyChild) {
        FileAttributes.CaseSensitivity detected;
        if (anyChild == null) {
            FileSystemUtil.$$$reportNull$$$0(13);
        }
        if ((detected = FileSystemUtil.readCaseSensitivityByNativeAPI(anyChild)) != FileAttributes.CaseSensitivity.UNKNOWN) {
            FileAttributes.CaseSensitivity caseSensitivity = detected;
            if (caseSensitivity == null) {
                FileSystemUtil.$$$reportNull$$$0(14);
            }
            return caseSensitivity;
        }
        return FileSystemUtil.readParentCaseSensitivityByJavaIO(anyChild);
    }

    @NotNull
    static FileAttributes.CaseSensitivity readParentCaseSensitivityByJavaIO(@NotNull File anyChild) {
        block17: {
            String altPath;
            String name;
            block16: {
                FileAttributes.CaseSensitivity caseSensitivity;
                String altName;
                if (anyChild == null) {
                    FileSystemUtil.$$$reportNull$$$0(15);
                }
                if (!anyChild.exists()) {
                    FileAttributes.CaseSensitivity caseSensitivity2 = FileAttributes.CaseSensitivity.UNKNOWN;
                    if (caseSensitivity2 == null) {
                        FileSystemUtil.$$$reportNull$$$0(16);
                    }
                    return caseSensitivity2;
                }
                File parent = anyChild.getParentFile();
                if (parent == null) {
                    String probe = FileSystemUtil.findCaseToggleableChild(anyChild);
                    if (probe == null) {
                        FileAttributes.CaseSensitivity caseSensitivity3 = FileAttributes.CaseSensitivity.UNKNOWN;
                        if (caseSensitivity3 == null) {
                            FileSystemUtil.$$$reportNull$$$0(17);
                        }
                        return caseSensitivity3;
                    }
                    parent = anyChild;
                    anyChild = new File(parent, probe);
                }
                if ((altName = FileSystemUtil.toggleCase(name = anyChild.getName())).equals(name)) {
                    name = FileSystemUtil.findCaseToggleableChild(parent);
                    if (name == null) {
                        FileAttributes.CaseSensitivity caseSensitivity4 = FileAttributes.CaseSensitivity.UNKNOWN;
                        if (caseSensitivity4 == null) {
                            FileSystemUtil.$$$reportNull$$$0(18);
                        }
                        return caseSensitivity4;
                    }
                    altName = FileSystemUtil.toggleCase(name);
                }
                altPath = parent.getPath() + '/' + altName;
                FileAttributes newAttributes = FileSystemUtil.getAttributes(altPath);
                try {
                    if (newAttributes != null) break block16;
                    caseSensitivity = FileAttributes.CaseSensitivity.SENSITIVE;
                }
                catch (IOException e) {
                    FileAttributes.CaseSensitivity caseSensitivity5 = FileAttributes.CaseSensitivity.UNKNOWN;
                    if (caseSensitivity5 == null) {
                        FileSystemUtil.$$$reportNull$$$0(21);
                    }
                    return caseSensitivity5;
                }
                if (caseSensitivity == null) {
                    FileSystemUtil.$$$reportNull$$$0(19);
                }
                return caseSensitivity;
            }
            File altCanonicalFile = new File(altPath).getCanonicalFile();
            String altCanonicalName = altCanonicalFile.getName();
            if (!altCanonicalName.equals(name) && !altCanonicalName.equals(anyChild.getCanonicalFile().getName())) break block17;
            FileAttributes.CaseSensitivity caseSensitivity = FileAttributes.CaseSensitivity.INSENSITIVE;
            if (caseSensitivity == null) {
                FileSystemUtil.$$$reportNull$$$0(20);
            }
            return caseSensitivity;
        }
        FileAttributes.CaseSensitivity caseSensitivity = FileAttributes.CaseSensitivity.SENSITIVE;
        if (caseSensitivity == null) {
            FileSystemUtil.$$$reportNull$$$0(22);
        }
        return caseSensitivity;
    }

    @NotNull
    static FileAttributes.CaseSensitivity readCaseSensitivityByNativeAPI(@NotNull File anyChild) {
        if (anyChild == null) {
            FileSystemUtil.$$$reportNull$$$0(23);
        }
        FileAttributes.CaseSensitivity detected = FileAttributes.CaseSensitivity.UNKNOWN;
        if (JnaLoader.isLoaded()) {
            File parent = anyChild.getParentFile();
            String path = (parent != null ? parent : anyChild).getAbsolutePath();
            if (SystemInfo.isWin10OrNewer && OSAgnosticPathUtil.isAbsoluteDosPath(path)) {
                detected = FileSystemUtil.getNtfsCaseSensitivity(path);
            } else if (SystemInfo.isMac) {
                detected = FileSystemUtil.getMacOsCaseSensitivity(path);
            } else if (SystemInfo.isLinux) {
                detected = FileSystemUtil.getLinuxCaseSensitivity(path);
            }
        }
        FileAttributes.CaseSensitivity caseSensitivity = detected;
        if (caseSensitivity == null) {
            FileSystemUtil.$$$reportNull$$$0(24);
        }
        return caseSensitivity;
    }

    private static String toggleCase(String name) {
        String altName = name.toUpperCase(Locale.getDefault());
        if (altName.equals(name)) {
            altName = name.toLowerCase(Locale.getDefault());
        }
        return altName;
    }

    public static boolean isCaseToggleable(@NotNull String name) {
        if (name == null) {
            FileSystemUtil.$$$reportNull$$$0(25);
        }
        return !FileSystemUtil.toggleCase(name).equals(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String findCaseToggleableChild(File dir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir.toPath());){
            Path path;
            String name;
            Iterator<Path> iterator = stream.iterator();
            do {
                if (!iterator.hasNext()) return null;
            } while ((name = (path = iterator.next()).getFileName().toString()).toLowerCase(Locale.getDefault()).equals(name.toUpperCase(Locale.getDefault())));
            String string = name;
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static FileAttributes.CaseSensitivity getNtfsCaseSensitivity(String path) {
        try {
            Kernel32 kernel32 = Kernel32.INSTANCE;
            NtOsKrnl ntOsKrnl = NtOsKrnl.INSTANCE;
            String name = "\\\\?\\" + path;
            WinNT.HANDLE handle = kernel32.CreateFile(name, 0, 7, null, 3, 0x2000000, null);
            if (handle == WinBase.INVALID_HANDLE_VALUE) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CreateFile(" + path + "): 0x" + Integer.toHexString(kernel32.GetLastError()));
                }
                return FileAttributes.CaseSensitivity.UNKNOWN;
            }
            NtOsKrnl.FILE_CASE_SENSITIVE_INFORMATION_P fileInformation = new NtOsKrnl.FILE_CASE_SENSITIVE_INFORMATION_P();
            int result = ntOsKrnl.NtQueryInformationFile(handle, new NtOsKrnl.IO_STATUS_BLOCK_P(), fileInformation, fileInformation.size(), 71);
            kernel32.CloseHandle(handle);
            if (result != 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("NtQueryInformationFile(" + path + "): 0x" + Integer.toHexString(result));
                }
            } else {
                if (fileInformation.Flags == 0L) {
                    return FileAttributes.CaseSensitivity.INSENSITIVE;
                }
                if (fileInformation.Flags == 1L) {
                    return FileAttributes.CaseSensitivity.SENSITIVE;
                }
                LOG.warn("NtQueryInformationFile(" + path + "): unexpected 'FileCaseSensitiveInformation' value " + fileInformation.Flags);
            }
        }
        catch (Throwable t) {
            LOG.warn("path: " + path, t);
        }
        return FileAttributes.CaseSensitivity.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static FileAttributes.CaseSensitivity getMacOsCaseSensitivity(String path) {
        try {
            CoreFoundation cf = CoreFoundation.INSTANCE;
            CoreFoundation.CFTypeRef url = cf.CFURLCreateFromFileSystemRepresentation(null, path, path.length(), true);
            try {
                PointerByReference resultPtr = new PointerByReference();
                if (!cf.CFURLCopyResourcePropertyForKey(url, CoreFoundation.kCFURLVolumeSupportsCaseSensitiveNamesKey, resultPtr, null)) {
                    LOG.warn("CFURLCopyResourcePropertyForKey(" + path + "): error");
                    return FileAttributes.CaseSensitivity.UNKNOWN;
                }
                Pointer result = resultPtr.getValue();
                if (result == null) {
                    LOG.info("CFURLCopyResourcePropertyForKey(" + path + "): property not available");
                    return FileAttributes.CaseSensitivity.UNKNOWN;
                }
                boolean value = new CoreFoundation.CFBooleanRef(result).booleanValue();
                FileAttributes.CaseSensitivity caseSensitivity = value ? FileAttributes.CaseSensitivity.SENSITIVE : FileAttributes.CaseSensitivity.INSENSITIVE;
                return caseSensitivity;
            }
            finally {
                url.release();
            }
        }
        catch (Throwable t) {
            LOG.warn("path: " + path, t);
        }
        return FileAttributes.CaseSensitivity.UNKNOWN;
    }

    private static FileAttributes.CaseSensitivity getLinuxCaseSensitivity(String path) {
        block9: {
            try {
                long fs;
                Memory buf = new Memory(256L);
                if (LibC.INSTANCE.statfs(path, buf) != 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("statfs(" + path + "): error");
                    }
                    break block9;
                }
                long l = fs = Native.LONG_SIZE == 4 ? (long)buf.getInt(0L) : buf.getLong(0L);
                if (fs == -1859950530L || fs == 1481003842L) {
                    return FileAttributes.CaseSensitivity.SENSITIVE;
                }
                if (fs == 19780L) {
                    return FileAttributes.CaseSensitivity.INSENSITIVE;
                }
                if (fs != 61267L && fs != -218816496L || !ourLibExt2FsPresent) break block9;
                LongByReference flags = new LongByReference();
                if (E2P.INSTANCE.fgetflags(path, flags) != 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("fgetflags(" + path + "): error");
                    }
                    break block9;
                }
                return (flags.getValue() & 0x40000000L) == 0L ? FileAttributes.CaseSensitivity.SENSITIVE : FileAttributes.CaseSensitivity.INSENSITIVE;
            }
            catch (UnsatisfiedLinkError e) {
                ourLibExt2FsPresent = false;
                LOG.warn(e);
            }
            catch (Throwable t) {
                LOG.warn("path: " + path, t);
            }
        }
        return FileAttributes.CaseSensitivity.UNKNOWN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mediator";
                break;
            }
            case 1: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/FileSystemUtil";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 13: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anyChild";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "check";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "readParentCaseSensitivity";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "readParentCaseSensitivityByJavaIO";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "readCaseSensitivityByNativeAPI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
            case 1: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lastModified";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymLink";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "clonePermissions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "clonePermissionsToExecute";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readParentCaseSensitivity";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readParentCaseSensitivityByJavaIO";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "readCaseSensitivityByNativeAPI";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isCaseToggleable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface E2P
    extends Library {
        public static final E2P INSTANCE = (E2P)Native.load((String)"e2p", E2P.class);
        public static final long EXT4_CASEFOLD_FL = 0x40000000L;

        public int fgetflags(String var1, LongByReference var2);
    }

    private static interface LibC
    extends Library {
        public static final LibC INSTANCE = (LibC)Native.load(LibC.class);

        public int statfs(String var1, Memory var2);
    }

    private static interface CoreFoundation
    extends com.sun.jna.platform.mac.CoreFoundation {
        public static final CoreFoundation INSTANCE = (CoreFoundation)Native.load((String)"CoreFoundation", CoreFoundation.class);
        public static final CoreFoundation.CFStringRef kCFURLVolumeSupportsCaseSensitiveNamesKey = CoreFoundation.CFStringRef.createCFString((String)"NSURLVolumeSupportsCaseSensitiveNamesKey");

        public CoreFoundation.CFTypeRef CFURLCreateFromFileSystemRepresentation(CoreFoundation.CFAllocatorRef var1, String var2, long var3, boolean var5);

        public boolean CFURLCopyResourcePropertyForKey(CoreFoundation.CFTypeRef var1, CoreFoundation.CFStringRef var2, PointerByReference var3, Pointer var4);
    }

    private static interface NtOsKrnl
    extends StdCallLibrary,
    WinNT {
        public static final NtOsKrnl INSTANCE = (NtOsKrnl)Native.load((String)"NtDll", NtOsKrnl.class, (Map)W32APIOptions.UNICODE_OPTIONS);
        public static final int FILE_SHARE_ALL = 7;
        public static final int FileCaseSensitiveInformation = 71;

        public int NtQueryInformationFile(WinNT.HANDLE var1, IO_STATUS_BLOCK_P var2, Structure var3, long var4, int var6);

        @Structure.FieldOrder(value={"Flags"})
        public static class FILE_CASE_SENSITIVE_INFORMATION_P
        extends Structure
        implements Structure.ByReference {
            public long Flags = 0xFFFFFFFFL;
        }

        @Structure.FieldOrder(value={"Pointer", "Information"})
        public static class IO_STATUS_BLOCK_P
        extends Structure
        implements Structure.ByReference {
            public Pointer Pointer;
            public Pointer Information;
        }
    }

    private static class Nio2MediatorImpl
    implements Mediator {
        private final LinkOption[] myNoFollowLinkOptions = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        private final PosixFilePermission[] myExecPermissions = new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE};

        private Nio2MediatorImpl() {
        }

        @Override
        public FileAttributes getAttributes(@NotNull String pathStr) {
            if (pathStr == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(0);
            }
            try {
                boolean isWritable;
                boolean isHidden;
                boolean isSymbolicLink;
                Path path = Paths.get(pathStr, new String[0]);
                Class schema = SystemInfo.isWindows ? DosFileAttributes.class : PosixFileAttributes.class;
                DosFileAttributes attributes = Files.readAttributes(path, schema, this.myNoFollowLinkOptions);
                boolean bl = isSymbolicLink = attributes.isSymbolicLink() || SystemInfo.isWindows && attributes.isOther() && attributes.isDirectory() && path.getParent() != null;
                if (isSymbolicLink) {
                    try {
                        attributes = Files.readAttributes(path, schema, new LinkOption[0]);
                    }
                    catch (NoSuchFileException e) {
                        return FileAttributes.BROKEN_SYMLINK;
                    }
                }
                boolean isDirectory = attributes.isDirectory();
                boolean isOther = attributes.isOther();
                long size = attributes.size();
                long lastModified = attributes.lastModifiedTime().toMillis();
                if (SystemInfo.isWindows) {
                    isHidden = path.getParent() != null && attributes.isHidden();
                    isWritable = isDirectory || !attributes.isReadOnly();
                } else {
                    isHidden = false;
                    try {
                        isWritable = Files.isWritable(path);
                    }
                    catch (SecurityException e) {
                        isWritable = false;
                    }
                }
                return new FileAttributes(isDirectory, isOther, isSymbolicLink, isHidden, size, lastModified, isWritable);
            }
            catch (IOException | InvalidPathException e) {
                LOG.debug(pathStr, e);
                return null;
            }
        }

        @Override
        public String resolveSymLink(@NotNull String path) throws IOException {
            if (path == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(1);
            }
            try {
                return Paths.get(path, new String[0]).toRealPath(new LinkOption[0]).toString();
            }
            catch (NoSuchFileException e) {
                return null;
            }
        }

        @Override
        public boolean clonePermissions(@NotNull String source, @NotNull String target, boolean execOnly) throws IOException {
            Set<PosixFilePermission> newPermissions;
            if (source == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(2);
            }
            if (target == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(3);
            }
            if (!SystemInfo.isUnix) {
                return false;
            }
            Path sourcePath = Paths.get(source, new String[0]);
            Path targetPath = Paths.get(target, new String[0]);
            Set<PosixFilePermission> sourcePermissions = Files.readAttributes(sourcePath, PosixFileAttributes.class, new LinkOption[0]).permissions();
            Set<PosixFilePermission> targetPermissions = Files.readAttributes(targetPath, PosixFileAttributes.class, new LinkOption[0]).permissions();
            if (execOnly) {
                newPermissions = EnumSet.copyOf(targetPermissions);
                for (PosixFilePermission permission : this.myExecPermissions) {
                    if (sourcePermissions.contains((Object)permission)) {
                        newPermissions.add(permission);
                        continue;
                    }
                    newPermissions.remove((Object)permission);
                }
            } else {
                newPermissions = sourcePermissions;
            }
            Files.setAttribute(targetPath, "posix:permissions", newPermissions, new LinkOption[0]);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathStr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil$Nio2MediatorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveSymLink";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clonePermissions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JnaUnixMediatorImpl
    implements Mediator {
        private static final int[] LINUX_32 = new int[]{16, 44, 72, 24, 28};
        private static final int[] LINUX_64 = new int[]{24, 48, 88, 28, 32};
        private static final int[] LNX_PPC32 = new int[]{16, 48, 80, 24, 28};
        private static final int[] LNX_PPC64 = LINUX_64;
        private static final int[] LNX_ARM32 = LNX_PPC32;
        private static final int[] BSD_32 = new int[]{8, 48, 32, 12, 16};
        private static final int[] BSD_64 = new int[]{8, 72, 40, 12, 16};
        private static final int[] BSD_32_12 = new int[]{24, 96, 64, 28, 32};
        private static final int[] BSD_64_12 = new int[]{24, 112, 64, 28, 32};
        private static final int[] SUN_OS_32 = new int[]{20, 48, 64, 28, 32};
        private static final int[] SUN_OS_64 = new int[]{16, 40, 64, 24, 28};
        private static final int STAT_VER = 1;
        private static final int OFF_MODE = 0;
        private static final int OFF_SIZE = 1;
        private static final int OFF_TIME = 2;
        private static final int OFF_UID = 3;
        private static final int OFF_GID = 4;
        private final int[] myOffsets;
        private final int myUid;
        private final int myGid;
        private final boolean myCoarseTs = SystemProperties.getBooleanProperty("idea.io.coarse.ts", false);
        private final LimitedPool<Memory> myMemoryPool = new LimitedPool.Sync<Memory>(10, () -> new Memory(256L));

        JnaUnixMediatorImpl() {
            assert (JnaLoader.supportsDirectMapping) : "Direct mapping not available on " + Platform.RESOURCE_PREFIX;
            if ("linux-x86".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LINUX_32;
            } else if ("linux-x86-64".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LINUX_64;
            } else if ("linux-arm".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LNX_ARM32;
            } else if ("linux-ppc".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LNX_PPC32;
            } else if ("linux-ppc64le".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LNX_PPC64;
            } else if ("darwin".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = BSD_64;
            } else if ("freebsd-x86".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = SystemInfo.isOsVersionAtLeast("12") ? BSD_32_12 : BSD_32;
            } else if ("freebsd-x86-64".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = SystemInfo.isOsVersionAtLeast("12") ? BSD_64_12 : BSD_64;
            } else if ("sunos-x86".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = SUN_OS_32;
            } else if ("sunos-x86-64".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = SUN_OS_64;
            } else {
                throw new IllegalStateException("Unsupported OS/arch: " + SystemInfo.OS_NAME + "/" + SystemInfo.OS_ARCH);
            }
            Map<String, String> options = Collections.singletonMap("string-encoding", CharsetToolkit.getPlatformCharset().name());
            NativeLibrary lib = NativeLibrary.getInstance((String)"c", options);
            Native.register(LibC.class, (NativeLibrary)lib);
            Native.register(SystemInfo.isLinux ? LinuxLibC.class : UnixLibC.class, (NativeLibrary)lib);
            this.myUid = LibC.getuid();
            this.myGid = LibC.getgid();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileAttributes getAttributes(@NotNull String path) {
            if (path == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(0);
            }
            Memory buffer = this.myMemoryPool.alloc();
            try {
                long mTime1;
                boolean isSymlink;
                int res;
                int n = res = SystemInfo.isLinux ? LinuxLibC.__lxstat64(1, path, (Pointer)buffer) : UnixLibC.lstat(path, (Pointer)buffer);
                if (res != 0) {
                    FileAttributes fileAttributes = null;
                    return fileAttributes;
                }
                int mode = this.getModeFlags(buffer) & 0xFFFF;
                boolean bl = isSymlink = (mode & 0xF000) == 40960;
                if (isSymlink) {
                    if (!JnaUnixMediatorImpl.loadFileStatus(path, buffer)) {
                        FileAttributes fileAttributes = FileAttributes.BROKEN_SYMLINK;
                        return fileAttributes;
                    }
                    mode = this.getModeFlags(buffer) & 0xFFFF;
                }
                if (DO_NOT_RESOLVE_SYMLINKS) {
                    isSymlink = false;
                }
                boolean isDirectory = (mode & 0xF000) == 16384;
                boolean isSpecial = !isDirectory && (mode & 0xF000) != 32768;
                long size = buffer.getLong((long)this.myOffsets[1]);
                long l = mTime1 = Native.LONG_SIZE == 4 ? (long)buffer.getInt((long)this.myOffsets[2]) : buffer.getLong((long)this.myOffsets[2]);
                long mTime2 = this.myCoarseTs ? 0L : (Native.LONG_SIZE == 4 ? (long)buffer.getInt((long)(this.myOffsets[2] + 4)) : buffer.getLong((long)(this.myOffsets[2] + 8)));
                long mTime = mTime1 * 1000L + mTime2 / 1000000L;
                boolean writable = this.ownFile(buffer) ? (mode & 0x92) != 0 : LibC.access(path, 2) == 0;
                FileAttributes fileAttributes = new FileAttributes(isDirectory, isSpecial, isSymlink, false, size, mTime, writable);
                return fileAttributes;
            }
            finally {
                this.myMemoryPool.recycle(buffer);
            }
        }

        @Override
        public String resolveSymLink(@NotNull String path) throws IOException {
            if (path == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(1);
            }
            try {
                return DO_NOT_RESOLVE_SYMLINKS ? path : new File(path).getCanonicalPath();
            }
            catch (IOException e) {
                String message = e.getMessage();
                if (message != null && StringUtil.toLowerCase(message).contains("too many levels of symbolic links")) {
                    LOG.debug(e);
                    return null;
                }
                throw new IOException("Cannot resolve '" + path + "'", e);
            }
        }

        @Override
        public boolean clonePermissions(@NotNull String source, @NotNull String target, boolean execOnly) {
            int permissions;
            Memory buffer;
            if (source == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(2);
            }
            if (target == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(3);
            }
            if (!JnaUnixMediatorImpl.loadFileStatus(source, buffer = new Memory(256L))) {
                return false;
            }
            int sourcePermissions = this.getModeFlags(buffer) & 0x1FF;
            if (execOnly) {
                if (!JnaUnixMediatorImpl.loadFileStatus(target, buffer)) {
                    return false;
                }
                int targetPermissions = this.getModeFlags(buffer) & 0x1FF;
                permissions = targetPermissions & 0xFFFFFFB6 | sourcePermissions & 0x49;
            } else {
                permissions = sourcePermissions;
            }
            return LibC.chmod(target, permissions) == 0;
        }

        private static boolean loadFileStatus(@NotNull String path, @NotNull Memory buffer) {
            if (path == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(4);
            }
            if (buffer == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(5);
            }
            return (SystemInfo.isLinux ? LinuxLibC.__xstat64(1, path, (Pointer)buffer) : UnixLibC.stat(path, (Pointer)buffer)) == 0;
        }

        private int getModeFlags(@NotNull Memory buffer) {
            if (buffer == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(6);
            }
            return SystemInfo.isLinux ? buffer.getInt((long)this.myOffsets[0]) : (int)buffer.getShort((long)this.myOffsets[0]);
        }

        private boolean ownFile(@NotNull Memory buffer) {
            if (buffer == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(7);
            }
            return buffer.getInt((long)this.myOffsets[3]) == this.myUid && buffer.getInt((long)this.myOffsets[4]) == this.myGid;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil$JnaUnixMediatorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveSymLink";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clonePermissions";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadFileStatus";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getModeFlags";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "ownFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class LinuxLibC {
            private LinuxLibC() {
            }

            static native int __lxstat64(int var0, String var1, Pointer var2);

            static native int __xstat64(int var0, String var1, Pointer var2);
        }

        private static final class UnixLibC {
            private UnixLibC() {
            }

            static native int lstat(String var0, Pointer var1);

            static native int stat(String var0, Pointer var1);
        }

        private static final class LibC {
            static final int S_MASK = 65535;
            static final int S_IFMT = 61440;
            static final int S_IFLNK = 40960;
            static final int S_IFREG = 32768;
            static final int S_IFDIR = 16384;
            static final int PERM_MASK = 511;
            static final int EXECUTE_MASK = 73;
            static final int WRITE_MASK = 146;
            static final int W_OK = 2;

            private LibC() {
            }

            static native int getuid();

            static native int getgid();

            static native int chmod(String var0, int var1);

            static native int access(String var0, int var1);
        }
    }

    private static class IdeaWin32MediatorImpl
    implements Mediator {
        private final IdeaWin32 myInstance = IdeaWin32.getInstance();

        private IdeaWin32MediatorImpl() {
        }

        @Override
        public FileAttributes getAttributes(@NotNull String path) {
            FileInfo fileInfo;
            if (path == null) {
                IdeaWin32MediatorImpl.$$$reportNull$$$0(0);
            }
            return (fileInfo = this.myInstance.getInfo(path)) != null ? fileInfo.toFileAttributes() : null;
        }

        @Override
        public String resolveSymLink(@NotNull String path) {
            if (path == null) {
                IdeaWin32MediatorImpl.$$$reportNull$$$0(1);
            }
            path = new File(path).getAbsolutePath();
            char drive = Character.toUpperCase(path.charAt(0));
            if (path.length() <= 3 || drive < 'A' || drive > 'Z' || path.charAt(1) != ':' || path.charAt(2) != '\\') {
                return path;
            }
            int remainder = 4;
            while (remainder < path.length()) {
                int next = path.indexOf(92, remainder);
                String subPath = next > 0 ? path.substring(0, next) : path;
                FileAttributes attributes = this.getAttributes(subPath);
                if (attributes == null) {
                    return null;
                }
                if (attributes.isSymLink()) {
                    return this.myInstance.resolveSymLink(path);
                }
                remainder = next > 0 ? next + 1 : path.length();
            }
            return path;
        }

        @Override
        public boolean clonePermissions(@NotNull String source, @NotNull String target, boolean execOnly) {
            if (source == null) {
                IdeaWin32MediatorImpl.$$$reportNull$$$0(2);
            }
            if (target == null) {
                IdeaWin32MediatorImpl.$$$reportNull$$$0(3);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil$IdeaWin32MediatorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveSymLink";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clonePermissions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface Mediator {
        @Nullable
        public FileAttributes getAttributes(@NotNull String var1) throws IOException;

        @Nullable
        public String resolveSymLink(@NotNull String var1) throws IOException;

        public boolean clonePermissions(@NotNull String var1, @NotNull String var2, boolean var3) throws IOException;
    }
}

