/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public abstract class NotNullLazyValue<T> {
    private T myValue;

    @Deprecated
    protected NotNullLazyValue() {
    }

    @NotNull
    protected abstract T compute();

    @NotNull
    public T getValue() {
        T result = this.myValue;
        if (result == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            result = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = result;
            }
        }
        T t = result;
        if (t == null) {
            NotNullLazyValue.$$$reportNull$$$0(0);
        }
        return t;
    }

    public boolean isComputed() {
        return this.myValue != null;
    }

    @NotNull
    public static <T> NotNullLazyValue<T> createConstantValue(@NotNull T value) {
        if (value == null) {
            NotNullLazyValue.$$$reportNull$$$0(1);
        }
        return NotNullLazyValue.lazy(() -> value);
    }

    @NotNull
    public static <T> NotNullLazyValue<T> createValue(@NotNull NotNullFactory<? extends T> value) {
        if (value == null) {
            NotNullLazyValue.$$$reportNull$$$0(2);
        }
        return NotNullLazyValue.lazy(value::create);
    }

    @NotNull
    public static <T> NotNullLazyValue<T> lazy(final @NotNull Supplier<? extends T> value) {
        if (value == null) {
            NotNullLazyValue.$$$reportNull$$$0(3);
        }
        return new NotNullLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                Object t = value.get();
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                return t;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/NotNullLazyValue$1", "compute"));
            }
        };
    }

    @NotNull
    public static <T> NotNullLazyValue<T> atomicLazy(final @NotNull @NotNull Supplier<@NotNull ? extends T> value) {
        if (value == null) {
            NotNullLazyValue.$$$reportNull$$$0(4);
        }
        return new AtomicNotNullLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                Object t = value.get();
                if (t == null) {
                    2.$$$reportNull$$$0(0);
                }
                return t;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/NotNullLazyValue$2", "compute"));
            }
        };
    }

    @NotNull
    public static <T> NotNullLazyValue<T> volatileLazy(final @NotNull @NotNull Supplier<@NotNull ? extends T> value) {
        if (value == null) {
            NotNullLazyValue.$$$reportNull$$$0(5);
        }
        return new VolatileNotNullLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                Object t = value.get();
                if (t == null) {
                    3.$$$reportNull$$$0(0);
                }
                return t;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/NotNullLazyValue$3", "compute"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/NotNullLazyValue";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/NotNullLazyValue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createConstantValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lazy";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "atomicLazy";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "volatileLazy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

