/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ImplementationClassResolver;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.pico.DefaultPicoContainer;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XmlExtensionAdapter
extends ExtensionComponentAdapter {
    @Nullable
    private Element myExtensionElement;
    private volatile Object extensionInstance;
    private boolean initializing;

    XmlExtensionAdapter(@NotNull String implementationClassName, @NotNull PluginDescriptor pluginDescriptor, @Nullable String orderId, @NotNull LoadingOrder order, @Nullable Element extensionElement, @NotNull ImplementationClassResolver implementationClassResolver) {
        if (implementationClassName == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(0);
        }
        if (pluginDescriptor == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(1);
        }
        if (order == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(2);
        }
        if (implementationClassResolver == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(3);
        }
        super(implementationClassName, pluginDescriptor, orderId, order, implementationClassResolver);
        this.myExtensionElement = extensionElement;
    }

    @Override
    final synchronized boolean isInstanceCreated() {
        return this.extensionInstance != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public <T> T createInstance(@NotNull ComponentManager componentManager) {
        Object instance;
        if (componentManager == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(4);
        }
        if ((instance = this.extensionInstance) != null) {
            Object object = instance;
            if (object == null) {
                XmlExtensionAdapter.$$$reportNull$$$0(5);
            }
            return (T)object;
        }
        XmlExtensionAdapter xmlExtensionAdapter = this;
        synchronized (xmlExtensionAdapter) {
            instance = this.extensionInstance;
            if (instance != null) {
                Object object = instance;
                // MONITOREXIT @DISABLED, blocks:[4, 14] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
                if (object == null) {
                    XmlExtensionAdapter.$$$reportNull$$$0(6);
                }
                return (T)object;
            }
            if (this.initializing) {
                throw componentManager.createError("Cyclic extension initialization: " + this, this.pluginDescriptor.getPluginId());
            }
            try {
                Element element;
                Class<?> aClass;
                this.initializing = true;
                try {
                    aClass = this.implementationClassResolver.resolveImplementationClass(componentManager, this);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw componentManager.createError(e, this.pluginDescriptor.getPluginId());
                }
                instance = this.instantiateClass(aClass, componentManager);
                if (instance instanceof PluginAware) {
                    ((PluginAware)instance).setPluginDescriptor(this.pluginDescriptor);
                }
                if ((element = this.myExtensionElement) != null) {
                    XmlSerializer.deserializeInto(instance, element);
                    this.myExtensionElement = null;
                }
                this.extensionInstance = instance;
            }
            finally {
                this.initializing = false;
            }
        }
        Object object = instance;
        if (object == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(7);
        }
        return (T)object;
    }

    @NotNull
    protected <T> T instantiateClass(@NotNull Class<T> aClass, @NotNull ComponentManager componentManager) {
        if (aClass == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(8);
        }
        if (componentManager == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(9);
        }
        T t = componentManager.instantiateClass(aClass, this.pluginDescriptor.getPluginId());
        if (t == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(10);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementationClassName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementationClassResolver";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/XmlExtensionAdapter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/XmlExtensionAdapter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "instantiateClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class SimpleConstructorInjectionAdapter
    extends XmlExtensionAdapter {
        SimpleConstructorInjectionAdapter(@NotNull String implementationClassName, @NotNull PluginDescriptor pluginDescriptor, @Nullable String orderId, @NotNull LoadingOrder order, @Nullable Element extensionElement, @NotNull ImplementationClassResolver implementationClassResolver) {
            if (implementationClassName == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(1);
            }
            if (order == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(2);
            }
            if (implementationClassResolver == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(3);
            }
            super(implementationClassName, pluginDescriptor, orderId, order, extensionElement, implementationClassResolver);
        }

        @Override
        @NotNull
        protected <T> T instantiateClass(@NotNull Class<T> aClass, @NotNull ComponentManager componentManager) {
            if (aClass == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(4);
            }
            if (componentManager == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(5);
            }
            if (((DefaultPicoContainer)componentManager.getPicoContainer()).getParent() == null) {
                T t;
                try {
                    t = super.instantiateClass(aClass, componentManager);
                }
                catch (ExtensionNotApplicableException | ProcessCanceledException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (!(cause instanceof NoSuchMethodException) && !(cause instanceof IllegalArgumentException)) {
                        throw e;
                    }
                    String message = "Cannot create extension without pico container (class=" + aClass.getName() + "), please remove extra constructor parameters";
                    if (this.pluginDescriptor.isBundled()) {
                        ExtensionPointImpl.LOG.error(message, e);
                    }
                    ExtensionPointImpl.LOG.warn(message, e);
                }
                if (t == null) {
                    SimpleConstructorInjectionAdapter.$$$reportNull$$$0(6);
                }
                return t;
            }
            T t = componentManager.instantiateClassWithConstructorInjection(aClass, aClass, this.pluginDescriptor.getPluginId());
            if (t == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(7);
            }
            return t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "implementationClassName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "order";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "implementationClassResolver";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentManager";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/extensions/impl/XmlExtensionAdapter$SimpleConstructorInjectionAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/extensions/impl/XmlExtensionAdapter$SimpleConstructorInjectionAdapter";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "instantiateClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "instantiateClass";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

