/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ExceptionUtil;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LogUtil {
    private LogUtil() {
    }

    public static String objectAndClass(@Nullable Object o) {
        return o != null ? o + " (" + o.getClass().getName() + ")" : "null";
    }

    public static void debug(@NotNull Logger logger, @NonNls @NotNull String format, Object ... args) {
        if (logger == null) {
            LogUtil.$$$reportNull$$$0(0);
        }
        if (format == null) {
            LogUtil.$$$reportNull$$$0(1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format(format, args));
        }
    }

    public static String getProcessList() {
        try {
            String[] stringArray;
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            if (SystemInfo.isWindows) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = System.getenv("windir") + "\\system32\\tasklist.exe";
                stringArray = stringArray2;
                stringArray2[1] = "/v";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "ps";
                stringArray = stringArray3;
                stringArray3[1] = "a";
            }
            Process process2 = processBuilder.command(stringArray).redirectErrorStream(true).start();
            return FileUtil.loadTextAndClose(process2.getInputStream());
        }
        catch (IOException e) {
            return ExceptionUtil.getThrowableText(e);
        }
    }

    public static String getSystemMemoryInfo() {
        try {
            Process process2 = new ProcessBuilder(new String[0]).command(SystemInfo.isWindows ? "systeminfo" : (SystemInfo.isMac ? "vm_stat" : "free")).redirectErrorStream(true).start();
            return FileUtil.loadTextAndClose(process2.getInputStream());
        }
        catch (IOException e) {
            return ExceptionUtil.getThrowableText(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "logger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "format";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/diagnostic/LogUtil";
        objectArray[2] = "debug";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

